/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.util;

import com.google.android.exoplayer2.util.Assertions;
import com.google.android.exoplayer2.util.Log;
import java.util.Arrays;

public abstract class LibraryLoader {
    private static final String TAG = "LibraryLoader";
    private String[] nativeLibraries;
    private boolean loadAttempted;
    private boolean isAvailable;

    public LibraryLoader(String ... libraries) {
        this.nativeLibraries = libraries;
    }

    public synchronized void setLibraries(String ... libraries) {
        Assertions.checkState(!this.loadAttempted, "Cannot set libraries after loading");
        this.nativeLibraries = libraries;
    }

    public synchronized boolean isAvailable() {
        if (this.loadAttempted) {
            return this.isAvailable;
        }
        this.loadAttempted = true;
        try {
            for (String lib : this.nativeLibraries) {
                this.loadLibrary(lib);
            }
            this.isAvailable = true;
        }
        catch (UnsatisfiedLinkError exception) {
            Log.w(TAG, "Failed to load " + Arrays.toString(this.nativeLibraries));
        }
        return this.isAvailable;
    }

    protected abstract void loadLibrary(String var1);
}

