/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2;

import android.os.Bundle;
import androidx.annotation.Nullable;
import com.google.android.exoplayer2.Bundleable;
import com.google.android.exoplayer2.Format;
import com.google.android.exoplayer2.source.TrackGroup;
import com.google.android.exoplayer2.util.Assertions;
import com.google.android.exoplayer2.util.BundleableUtil;
import com.google.android.exoplayer2.util.Util;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.primitives.Booleans;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

@Deprecated
public final class Tracks
implements Bundleable {
    public static final Tracks EMPTY = new Tracks((List<Group>)ImmutableList.of());
    private final ImmutableList<Group> groups;
    private static final String FIELD_TRACK_GROUPS = Util.intToStringMaxRadix(0);
    public static final Bundleable.Creator<Tracks> CREATOR = bundle -> {
        ArrayList groupBundles = bundle.getParcelableArrayList(FIELD_TRACK_GROUPS);
        ImmutableList<Group> groups = groupBundles == null ? ImmutableList.of() : BundleableUtil.fromBundleList(Group.CREATOR, groupBundles);
        return new Tracks((List<Group>)groups);
    };

    public Tracks(List<Group> groups) {
        this.groups = ImmutableList.copyOf(groups);
    }

    public ImmutableList<Group> getGroups() {
        return this.groups;
    }

    public boolean isEmpty() {
        return this.groups.isEmpty();
    }

    public boolean containsType(int trackType) {
        for (int i = 0; i < this.groups.size(); ++i) {
            if (((Group)this.groups.get(i)).getType() != trackType) continue;
            return true;
        }
        return false;
    }

    public boolean isTypeSupported(int trackType) {
        return this.isTypeSupported(trackType, false);
    }

    public boolean isTypeSupported(int trackType, boolean allowExceedsCapabilities) {
        for (int i = 0; i < this.groups.size(); ++i) {
            if (((Group)this.groups.get(i)).getType() != trackType || !((Group)this.groups.get(i)).isSupported(allowExceedsCapabilities)) continue;
            return true;
        }
        return false;
    }

    @Deprecated
    public boolean isTypeSupportedOrEmpty(int trackType) {
        return this.isTypeSupportedOrEmpty(trackType, false);
    }

    @Deprecated
    public boolean isTypeSupportedOrEmpty(int trackType, boolean allowExceedsCapabilities) {
        return !this.containsType(trackType) || this.isTypeSupported(trackType, allowExceedsCapabilities);
    }

    public boolean isTypeSelected(int trackType) {
        for (int i = 0; i < this.groups.size(); ++i) {
            Group group = (Group)this.groups.get(i);
            if (!group.isSelected() || group.getType() != trackType) continue;
            return true;
        }
        return false;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        Tracks that = (Tracks)other;
        return this.groups.equals(that.groups);
    }

    public int hashCode() {
        return this.groups.hashCode();
    }

    @Override
    public Bundle toBundle() {
        Bundle bundle = new Bundle();
        bundle.putParcelableArrayList(FIELD_TRACK_GROUPS, BundleableUtil.toBundleArrayList(this.groups));
        return bundle;
    }

    public static final class Group
    implements Bundleable {
        public final int length;
        private final TrackGroup mediaTrackGroup;
        private final boolean adaptiveSupported;
        private final int[] trackSupport;
        private final boolean[] trackSelected;
        private static final String FIELD_TRACK_GROUP = Util.intToStringMaxRadix(0);
        private static final String FIELD_TRACK_SUPPORT = Util.intToStringMaxRadix(1);
        private static final String FIELD_TRACK_SELECTED = Util.intToStringMaxRadix(3);
        private static final String FIELD_ADAPTIVE_SUPPORTED = Util.intToStringMaxRadix(4);
        public static final Bundleable.Creator<Group> CREATOR = bundle -> {
            TrackGroup trackGroup = TrackGroup.CREATOR.fromBundle(Assertions.checkNotNull(bundle.getBundle(FIELD_TRACK_GROUP)));
            int[] trackSupport = (int[])MoreObjects.firstNonNull((Object)bundle.getIntArray(FIELD_TRACK_SUPPORT), (Object)new int[trackGroup.length]);
            boolean[] selected = (boolean[])MoreObjects.firstNonNull((Object)bundle.getBooleanArray(FIELD_TRACK_SELECTED), (Object)new boolean[trackGroup.length]);
            boolean adaptiveSupported = bundle.getBoolean(FIELD_ADAPTIVE_SUPPORTED, false);
            return new Group(trackGroup, adaptiveSupported, trackSupport, selected);
        };

        public Group(TrackGroup mediaTrackGroup, boolean adaptiveSupported, int[] trackSupport, boolean[] trackSelected) {
            this.length = mediaTrackGroup.length;
            Assertions.checkArgument(this.length == trackSupport.length && this.length == trackSelected.length);
            this.mediaTrackGroup = mediaTrackGroup;
            this.adaptiveSupported = adaptiveSupported && this.length > 1;
            this.trackSupport = (int[])trackSupport.clone();
            this.trackSelected = (boolean[])trackSelected.clone();
        }

        public TrackGroup getMediaTrackGroup() {
            return this.mediaTrackGroup;
        }

        public Format getTrackFormat(int trackIndex) {
            return this.mediaTrackGroup.getFormat(trackIndex);
        }

        public int getTrackSupport(int trackIndex) {
            return this.trackSupport[trackIndex];
        }

        public boolean isTrackSupported(int trackIndex) {
            return this.isTrackSupported(trackIndex, false);
        }

        public boolean isTrackSupported(int trackIndex, boolean allowExceedsCapabilities) {
            return this.trackSupport[trackIndex] == 4 || allowExceedsCapabilities && this.trackSupport[trackIndex] == 3;
        }

        public boolean isSelected() {
            return Booleans.contains((boolean[])this.trackSelected, (boolean)true);
        }

        public boolean isAdaptiveSupported() {
            return this.adaptiveSupported;
        }

        public boolean isSupported() {
            return this.isSupported(false);
        }

        public boolean isSupported(boolean allowExceedsCapabilities) {
            for (int i = 0; i < this.trackSupport.length; ++i) {
                if (!this.isTrackSupported(i, allowExceedsCapabilities)) continue;
                return true;
            }
            return false;
        }

        public boolean isTrackSelected(int trackIndex) {
            return this.trackSelected[trackIndex];
        }

        public int getType() {
            return this.mediaTrackGroup.type;
        }

        public Group copyWithId(String groupId) {
            return new Group(this.mediaTrackGroup.copyWithId(groupId), this.adaptiveSupported, this.trackSupport, this.trackSelected);
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (other == null || this.getClass() != other.getClass()) {
                return false;
            }
            Group that = (Group)other;
            return this.adaptiveSupported == that.adaptiveSupported && this.mediaTrackGroup.equals(that.mediaTrackGroup) && Arrays.equals(this.trackSupport, that.trackSupport) && Arrays.equals(this.trackSelected, that.trackSelected);
        }

        public int hashCode() {
            int result = this.mediaTrackGroup.hashCode();
            result = 31 * result + (this.adaptiveSupported ? 1 : 0);
            result = 31 * result + Arrays.hashCode(this.trackSupport);
            result = 31 * result + Arrays.hashCode(this.trackSelected);
            return result;
        }

        @Override
        public Bundle toBundle() {
            Bundle bundle = new Bundle();
            bundle.putBundle(FIELD_TRACK_GROUP, this.mediaTrackGroup.toBundle());
            bundle.putIntArray(FIELD_TRACK_SUPPORT, this.trackSupport);
            bundle.putBooleanArray(FIELD_TRACK_SELECTED, this.trackSelected);
            bundle.putBoolean(FIELD_ADAPTIVE_SUPPORTED, this.adaptiveSupported);
            return bundle;
        }
    }
}

