/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.audio;

import androidx.annotation.Nullable;
import com.google.android.exoplayer2.audio.AudioProcessor;
import com.google.android.exoplayer2.audio.Sonic;
import com.google.android.exoplayer2.util.Assertions;
import com.google.android.exoplayer2.util.Util;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.ShortBuffer;

public class SonicAudioProcessor
implements AudioProcessor {
    @Deprecated
    public static final int SAMPLE_RATE_NO_CHANGE = -1;
    private static final float CLOSE_THRESHOLD = 1.0E-4f;
    private static final int MIN_BYTES_FOR_DURATION_SCALING_CALCULATION = 1024;
    private int pendingOutputSampleRate = -1;
    private float speed = 1.0f;
    private float pitch = 1.0f;
    private AudioProcessor.AudioFormat pendingInputAudioFormat = AudioProcessor.AudioFormat.NOT_SET;
    private AudioProcessor.AudioFormat pendingOutputAudioFormat = AudioProcessor.AudioFormat.NOT_SET;
    private AudioProcessor.AudioFormat inputAudioFormat = AudioProcessor.AudioFormat.NOT_SET;
    private AudioProcessor.AudioFormat outputAudioFormat = AudioProcessor.AudioFormat.NOT_SET;
    private boolean pendingSonicRecreation;
    @Nullable
    private Sonic sonic;
    private ByteBuffer buffer = EMPTY_BUFFER;
    private ShortBuffer shortBuffer = this.buffer.asShortBuffer();
    private ByteBuffer outputBuffer = EMPTY_BUFFER;
    private long inputBytes;
    private long outputBytes;
    private boolean inputEnded;

    public final void setSpeed(float speed) {
        if (this.speed != speed) {
            this.speed = speed;
            this.pendingSonicRecreation = true;
        }
    }

    public final void setPitch(float pitch) {
        if (this.pitch != pitch) {
            this.pitch = pitch;
            this.pendingSonicRecreation = true;
        }
    }

    public final void setOutputSampleRateHz(int sampleRateHz) {
        this.pendingOutputSampleRate = sampleRateHz;
    }

    public final long getMediaDuration(long playoutDuration) {
        if (this.outputBytes >= 1024L) {
            long processedInputBytes = this.inputBytes - (long)Assertions.checkNotNull(this.sonic).getPendingInputBytes();
            return this.outputAudioFormat.sampleRate == this.inputAudioFormat.sampleRate ? Util.scaleLargeTimestamp(playoutDuration, processedInputBytes, this.outputBytes) : Util.scaleLargeTimestamp(playoutDuration, processedInputBytes * (long)this.outputAudioFormat.sampleRate, this.outputBytes * (long)this.inputAudioFormat.sampleRate);
        }
        return (long)((double)this.speed * (double)playoutDuration);
    }

    @Override
    @CanIgnoreReturnValue
    public final AudioProcessor.AudioFormat configure(AudioProcessor.AudioFormat inputAudioFormat) throws AudioProcessor.UnhandledAudioFormatException {
        if (inputAudioFormat.encoding != 2) {
            throw new AudioProcessor.UnhandledAudioFormatException(inputAudioFormat);
        }
        int outputSampleRateHz = this.pendingOutputSampleRate == -1 ? inputAudioFormat.sampleRate : this.pendingOutputSampleRate;
        this.pendingInputAudioFormat = inputAudioFormat;
        this.pendingOutputAudioFormat = new AudioProcessor.AudioFormat(outputSampleRateHz, inputAudioFormat.channelCount, 2);
        this.pendingSonicRecreation = true;
        return this.pendingOutputAudioFormat;
    }

    @Override
    public final boolean isActive() {
        return this.pendingOutputAudioFormat.sampleRate != -1 && (Math.abs(this.speed - 1.0f) >= 1.0E-4f || Math.abs(this.pitch - 1.0f) >= 1.0E-4f || this.pendingOutputAudioFormat.sampleRate != this.pendingInputAudioFormat.sampleRate);
    }

    @Override
    public final void queueInput(ByteBuffer inputBuffer) {
        if (!inputBuffer.hasRemaining()) {
            return;
        }
        Sonic sonic = Assertions.checkNotNull(this.sonic);
        ShortBuffer shortBuffer = inputBuffer.asShortBuffer();
        int inputSize = inputBuffer.remaining();
        this.inputBytes += (long)inputSize;
        sonic.queueInput(shortBuffer);
        inputBuffer.position(inputBuffer.position() + inputSize);
    }

    @Override
    public final void queueEndOfStream() {
        if (this.sonic != null) {
            this.sonic.queueEndOfStream();
        }
        this.inputEnded = true;
    }

    @Override
    public final ByteBuffer getOutput() {
        int outputSize;
        Sonic sonic = this.sonic;
        if (sonic != null && (outputSize = sonic.getOutputSize()) > 0) {
            if (this.buffer.capacity() < outputSize) {
                this.buffer = ByteBuffer.allocateDirect(outputSize).order(ByteOrder.nativeOrder());
                this.shortBuffer = this.buffer.asShortBuffer();
            } else {
                this.buffer.clear();
                this.shortBuffer.clear();
            }
            sonic.getOutput(this.shortBuffer);
            this.outputBytes += (long)outputSize;
            this.buffer.limit(outputSize);
            this.outputBuffer = this.buffer;
        }
        ByteBuffer outputBuffer = this.outputBuffer;
        this.outputBuffer = EMPTY_BUFFER;
        return outputBuffer;
    }

    @Override
    public final boolean isEnded() {
        return this.inputEnded && (this.sonic == null || this.sonic.getOutputSize() == 0);
    }

    @Override
    public final void flush() {
        if (this.isActive()) {
            this.inputAudioFormat = this.pendingInputAudioFormat;
            this.outputAudioFormat = this.pendingOutputAudioFormat;
            if (this.pendingSonicRecreation) {
                this.sonic = new Sonic(this.inputAudioFormat.sampleRate, this.inputAudioFormat.channelCount, this.speed, this.pitch, this.outputAudioFormat.sampleRate);
            } else if (this.sonic != null) {
                this.sonic.flush();
            }
        }
        this.outputBuffer = EMPTY_BUFFER;
        this.inputBytes = 0L;
        this.outputBytes = 0L;
        this.inputEnded = false;
    }

    @Override
    public final void reset() {
        this.speed = 1.0f;
        this.pitch = 1.0f;
        this.pendingInputAudioFormat = AudioProcessor.AudioFormat.NOT_SET;
        this.pendingOutputAudioFormat = AudioProcessor.AudioFormat.NOT_SET;
        this.inputAudioFormat = AudioProcessor.AudioFormat.NOT_SET;
        this.outputAudioFormat = AudioProcessor.AudioFormat.NOT_SET;
        this.buffer = EMPTY_BUFFER;
        this.shortBuffer = this.buffer.asShortBuffer();
        this.outputBuffer = EMPTY_BUFFER;
        this.pendingOutputSampleRate = -1;
        this.pendingSonicRecreation = false;
        this.sonic = null;
        this.inputBytes = 0L;
        this.outputBytes = 0L;
        this.inputEnded = false;
    }
}

