/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.util;

import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import androidx.annotation.GuardedBy;
import androidx.annotation.Nullable;
import com.google.android.exoplayer2.util.Assertions;
import com.google.android.exoplayer2.util.HandlerWrapper;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.List;

@Deprecated
final class SystemHandlerWrapper
implements HandlerWrapper {
    private static final int MAX_POOL_SIZE = 50;
    @GuardedBy(value="messagePool")
    private static final List<SystemMessage> messagePool = new ArrayList<SystemMessage>(50);
    private final Handler handler;

    public SystemHandlerWrapper(Handler handler) {
        this.handler = handler;
    }

    @Override
    public Looper getLooper() {
        return this.handler.getLooper();
    }

    @Override
    public boolean hasMessages(int what) {
        return this.handler.hasMessages(what);
    }

    @Override
    public HandlerWrapper.Message obtainMessage(int what) {
        return SystemHandlerWrapper.obtainSystemMessage().setMessage(this.handler.obtainMessage(what), this);
    }

    @Override
    public HandlerWrapper.Message obtainMessage(int what, @Nullable Object obj) {
        return SystemHandlerWrapper.obtainSystemMessage().setMessage(this.handler.obtainMessage(what, obj), this);
    }

    @Override
    public HandlerWrapper.Message obtainMessage(int what, int arg1, int arg2) {
        return SystemHandlerWrapper.obtainSystemMessage().setMessage(this.handler.obtainMessage(what, arg1, arg2), this);
    }

    @Override
    public HandlerWrapper.Message obtainMessage(int what, int arg1, int arg2, @Nullable Object obj) {
        return SystemHandlerWrapper.obtainSystemMessage().setMessage(this.handler.obtainMessage(what, arg1, arg2, obj), this);
    }

    @Override
    public boolean sendMessageAtFrontOfQueue(HandlerWrapper.Message message) {
        return ((SystemMessage)message).sendAtFrontOfQueue(this.handler);
    }

    @Override
    public boolean sendEmptyMessage(int what) {
        return this.handler.sendEmptyMessage(what);
    }

    @Override
    public boolean sendEmptyMessageDelayed(int what, int delayMs) {
        return this.handler.sendEmptyMessageDelayed(what, (long)delayMs);
    }

    @Override
    public boolean sendEmptyMessageAtTime(int what, long uptimeMs) {
        return this.handler.sendEmptyMessageAtTime(what, uptimeMs);
    }

    @Override
    public void removeMessages(int what) {
        this.handler.removeMessages(what);
    }

    @Override
    public void removeCallbacksAndMessages(@Nullable Object token) {
        this.handler.removeCallbacksAndMessages(token);
    }

    @Override
    public boolean post(Runnable runnable) {
        return this.handler.post(runnable);
    }

    @Override
    public boolean postDelayed(Runnable runnable, long delayMs) {
        return this.handler.postDelayed(runnable, delayMs);
    }

    @Override
    public boolean postAtFrontOfQueue(Runnable runnable) {
        return this.handler.postAtFrontOfQueue(runnable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static SystemMessage obtainSystemMessage() {
        List<SystemMessage> list = messagePool;
        synchronized (list) {
            return messagePool.isEmpty() ? new SystemMessage() : messagePool.remove(messagePool.size() - 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void recycleMessage(SystemMessage message) {
        List<SystemMessage> list = messagePool;
        synchronized (list) {
            if (messagePool.size() < 50) {
                messagePool.add(message);
            }
        }
    }

    private static final class SystemMessage
    implements HandlerWrapper.Message {
        @Nullable
        private Message message;
        @Nullable
        private SystemHandlerWrapper handler;

        private SystemMessage() {
        }

        @CanIgnoreReturnValue
        public SystemMessage setMessage(Message message, SystemHandlerWrapper handler) {
            this.message = message;
            this.handler = handler;
            return this;
        }

        public boolean sendAtFrontOfQueue(Handler handler) {
            boolean success = handler.sendMessageAtFrontOfQueue(Assertions.checkNotNull(this.message));
            this.recycle();
            return success;
        }

        @Override
        public void sendToTarget() {
            Assertions.checkNotNull(this.message).sendToTarget();
            this.recycle();
        }

        @Override
        public HandlerWrapper getTarget() {
            return Assertions.checkNotNull(this.handler);
        }

        private void recycle() {
            this.message = null;
            this.handler = null;
            SystemHandlerWrapper.recycleMessage(this);
        }
    }
}

