/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.audio;

import android.annotation.SuppressLint;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.media.AudioAttributes;
import android.media.AudioFormat;
import android.media.AudioTrack;
import android.net.Uri;
import android.provider.Settings;
import androidx.annotation.DoNotInline;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import com.google.android.exoplayer2.util.Util;
import com.google.common.collect.ImmutableList;
import com.google.common.primitives.Ints;
import java.util.Arrays;
import java.util.Collection;

public final class AudioCapabilities {
    private static final int DEFAULT_MAX_CHANNEL_COUNT = 8;
    private static final int DEFAULT_SAMPLE_RATE_HZ = 48000;
    public static final AudioCapabilities DEFAULT_AUDIO_CAPABILITIES = new AudioCapabilities(new int[]{2}, 8);
    private static final AudioCapabilities EXTERNAL_SURROUND_SOUND_CAPABILITIES = new AudioCapabilities(new int[]{2, 5, 6}, 8);
    private static final int[] ALL_SURROUND_ENCODINGS = new int[]{5, 6, 18, 17, 14, 7, 8};
    private static final String EXTERNAL_SURROUND_SOUND_KEY = "external_surround_sound_enabled";
    private final int[] supportedEncodings;
    private final int maxChannelCount;

    public static AudioCapabilities getCapabilities(Context context) {
        Intent intent = context.registerReceiver(null, new IntentFilter("android.media.action.HDMI_AUDIO_PLUG"));
        return AudioCapabilities.getCapabilities(context, intent);
    }

    @SuppressLint(value={"InlinedApi"})
    static AudioCapabilities getCapabilities(Context context, @Nullable Intent intent) {
        if (AudioCapabilities.deviceMaySetExternalSurroundSoundGlobalSetting() && Settings.Global.getInt((ContentResolver)context.getContentResolver(), (String)EXTERNAL_SURROUND_SOUND_KEY, (int)0) == 1) {
            return EXTERNAL_SURROUND_SOUND_CAPABILITIES;
        }
        if (Util.SDK_INT >= 29 && (Util.isTv((Context)context) || Util.isAutomotive((Context)context))) {
            return new AudioCapabilities(Api29.getDirectPlaybackSupportedEncodings(), 8);
        }
        if (intent == null || intent.getIntExtra("android.media.extra.AUDIO_PLUG_STATE", 0) == 0) {
            return DEFAULT_AUDIO_CAPABILITIES;
        }
        return new AudioCapabilities(intent.getIntArrayExtra("android.media.extra.ENCODINGS"), intent.getIntExtra("android.media.extra.MAX_CHANNEL_COUNT", 8));
    }

    @Nullable
    static Uri getExternalSurroundSoundGlobalSettingUri() {
        return AudioCapabilities.deviceMaySetExternalSurroundSoundGlobalSetting() ? Settings.Global.getUriFor((String)EXTERNAL_SURROUND_SOUND_KEY) : null;
    }

    public AudioCapabilities(@Nullable int[] supportedEncodings, int maxChannelCount) {
        if (supportedEncodings != null) {
            this.supportedEncodings = Arrays.copyOf(supportedEncodings, supportedEncodings.length);
            Arrays.sort(this.supportedEncodings);
        } else {
            this.supportedEncodings = new int[0];
        }
        this.maxChannelCount = maxChannelCount;
    }

    public boolean supportsEncoding(int encoding) {
        return Arrays.binarySearch(this.supportedEncodings, encoding) >= 0;
    }

    public int getMaxChannelCount() {
        return this.maxChannelCount;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof AudioCapabilities)) {
            return false;
        }
        AudioCapabilities audioCapabilities = (AudioCapabilities)other;
        return Arrays.equals(this.supportedEncodings, audioCapabilities.supportedEncodings) && this.maxChannelCount == audioCapabilities.maxChannelCount;
    }

    public int hashCode() {
        return this.maxChannelCount + 31 * Arrays.hashCode(this.supportedEncodings);
    }

    public String toString() {
        int n = this.maxChannelCount;
        String string = Arrays.toString(this.supportedEncodings);
        return new StringBuilder(67 + String.valueOf(string).length()).append("AudioCapabilities[maxChannelCount=").append(n).append(", supportedEncodings=").append(string).append("]").toString();
    }

    private static boolean deviceMaySetExternalSurroundSoundGlobalSetting() {
        return Util.SDK_INT >= 17 && ("Amazon".equals(Util.MANUFACTURER) || "Xiaomi".equals(Util.MANUFACTURER));
    }

    @RequiresApi(value=29)
    private static final class Api29 {
        private Api29() {
        }

        @DoNotInline
        public static int[] getDirectPlaybackSupportedEncodings() {
            ImmutableList.Builder supportedEncodingsListBuilder = ImmutableList.builder();
            for (int encoding : ALL_SURROUND_ENCODINGS) {
                if (!AudioTrack.isDirectPlaybackSupported((AudioFormat)new AudioFormat.Builder().setChannelMask(12).setEncoding(encoding).setSampleRate(48000).build(), (AudioAttributes)new AudioAttributes.Builder().setUsage(1).setContentType(3).setFlags(0).build())) continue;
                supportedEncodingsListBuilder.add((Object)encoding);
            }
            supportedEncodingsListBuilder.add((Object)2);
            return Ints.toArray((Collection)supportedEncodingsListBuilder.build());
        }
    }
}

