/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.audio;

import android.media.AudioTrack;
import android.os.SystemClock;
import androidx.annotation.Nullable;
import com.google.android.exoplayer2.audio.AudioTimestampPoller;
import com.google.android.exoplayer2.util.Assertions;
import com.google.android.exoplayer2.util.Util;
import java.lang.reflect.Method;

final class AudioTrackPositionTracker {
    private static final int PLAYSTATE_STOPPED = 1;
    private static final int PLAYSTATE_PAUSED = 2;
    private static final int PLAYSTATE_PLAYING = 3;
    private static final long MAX_AUDIO_TIMESTAMP_OFFSET_US = 5000000L;
    private static final long MAX_LATENCY_US = 5000000L;
    private static final long MODE_SWITCH_SMOOTHING_DURATION_US = 1000000L;
    private static final long FORCE_RESET_WORKAROUND_TIMEOUT_MS = 200L;
    private static final int MAX_PLAYHEAD_OFFSET_COUNT = 10;
    private static final int MIN_PLAYHEAD_OFFSET_SAMPLE_INTERVAL_US = 30000;
    private static final int MIN_LATENCY_SAMPLE_INTERVAL_US = 500000;
    private final Listener listener;
    private final long[] playheadOffsets;
    @Nullable
    private AudioTrack audioTrack;
    private int outputPcmFrameSize;
    private int bufferSize;
    @Nullable
    private AudioTimestampPoller audioTimestampPoller;
    private int outputSampleRate;
    private boolean needsPassthroughWorkarounds;
    private long bufferSizeUs;
    private float audioTrackPlaybackSpeed;
    private boolean notifiedPositionIncreasing;
    private long smoothedPlayheadOffsetUs;
    private long lastPlayheadSampleTimeUs;
    @Nullable
    private Method getLatencyMethod;
    private long latencyUs;
    private boolean hasData;
    private boolean isOutputPcm;
    private long lastLatencySampleTimeUs;
    private long lastRawPlaybackHeadPosition;
    private long rawPlaybackHeadWrapCount;
    private long passthroughWorkaroundPauseOffset;
    private int nextPlayheadOffsetIndex;
    private int playheadOffsetCount;
    private long stopTimestampUs;
    private long forceResetWorkaroundTimeMs;
    private long stopPlaybackHeadPosition;
    private long endPlaybackHeadPosition;
    private long lastPositionUs;
    private long lastSystemTimeUs;
    private boolean lastSampleUsedGetTimestampMode;
    private long previousModePositionUs;
    private long previousModeSystemTimeUs;

    public AudioTrackPositionTracker(Listener listener) {
        this.listener = (Listener)Assertions.checkNotNull((Object)listener);
        if (Util.SDK_INT >= 18) {
            try {
                this.getLatencyMethod = AudioTrack.class.getMethod("getLatency", null);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
        this.playheadOffsets = new long[10];
    }

    public void setAudioTrack(AudioTrack audioTrack, boolean isPassthrough, int outputEncoding, int outputPcmFrameSize, int bufferSize) {
        this.audioTrack = audioTrack;
        this.outputPcmFrameSize = outputPcmFrameSize;
        this.bufferSize = bufferSize;
        this.audioTimestampPoller = new AudioTimestampPoller(audioTrack);
        this.outputSampleRate = audioTrack.getSampleRate();
        this.needsPassthroughWorkarounds = isPassthrough && AudioTrackPositionTracker.needsPassthroughWorkarounds(outputEncoding);
        this.isOutputPcm = Util.isEncodingLinearPcm((int)outputEncoding);
        this.bufferSizeUs = this.isOutputPcm ? this.framesToDurationUs(bufferSize / outputPcmFrameSize) : -9223372036854775807L;
        this.lastRawPlaybackHeadPosition = 0L;
        this.rawPlaybackHeadWrapCount = 0L;
        this.passthroughWorkaroundPauseOffset = 0L;
        this.hasData = false;
        this.stopTimestampUs = -9223372036854775807L;
        this.forceResetWorkaroundTimeMs = -9223372036854775807L;
        this.lastLatencySampleTimeUs = 0L;
        this.latencyUs = 0L;
        this.audioTrackPlaybackSpeed = 1.0f;
    }

    public void setAudioTrackPlaybackSpeed(float audioTrackPlaybackSpeed) {
        this.audioTrackPlaybackSpeed = audioTrackPlaybackSpeed;
        if (this.audioTimestampPoller != null) {
            this.audioTimestampPoller.reset();
        }
    }

    public long getCurrentPositionUs(boolean sourceEnded) {
        long elapsedSincePreviousModeUs;
        long positionUs;
        if (((AudioTrack)Assertions.checkNotNull((Object)this.audioTrack)).getPlayState() == 3) {
            this.maybeSampleSyncParams();
        }
        long systemTimeUs = System.nanoTime() / 1000L;
        AudioTimestampPoller audioTimestampPoller = (AudioTimestampPoller)Assertions.checkNotNull((Object)this.audioTimestampPoller);
        boolean useGetTimestampMode = audioTimestampPoller.hasAdvancingTimestamp();
        if (useGetTimestampMode) {
            long timestampPositionFrames = audioTimestampPoller.getTimestampPositionFrames();
            long timestampPositionUs = this.framesToDurationUs(timestampPositionFrames);
            long elapsedSinceTimestampUs = systemTimeUs - audioTimestampPoller.getTimestampSystemTimeUs();
            elapsedSinceTimestampUs = Util.getMediaDurationForPlayoutDuration((long)elapsedSinceTimestampUs, (float)this.audioTrackPlaybackSpeed);
            positionUs = timestampPositionUs + elapsedSinceTimestampUs;
        } else {
            positionUs = this.playheadOffsetCount == 0 ? this.getPlaybackHeadPositionUs() : systemTimeUs + this.smoothedPlayheadOffsetUs;
            if (!sourceEnded) {
                positionUs = Math.max(0L, positionUs - this.latencyUs);
            }
        }
        if (this.lastSampleUsedGetTimestampMode != useGetTimestampMode) {
            this.previousModeSystemTimeUs = this.lastSystemTimeUs;
            this.previousModePositionUs = this.lastPositionUs;
        }
        if ((elapsedSincePreviousModeUs = systemTimeUs - this.previousModeSystemTimeUs) < 1000000L) {
            long previousModeProjectedPositionUs = this.previousModePositionUs + Util.getMediaDurationForPlayoutDuration((long)elapsedSincePreviousModeUs, (float)this.audioTrackPlaybackSpeed);
            long rampPoint = elapsedSincePreviousModeUs * 1000L / 1000000L;
            positionUs *= rampPoint;
            positionUs += (1000L - rampPoint) * previousModeProjectedPositionUs;
            positionUs /= 1000L;
        }
        if (!this.notifiedPositionIncreasing && positionUs > this.lastPositionUs) {
            this.notifiedPositionIncreasing = true;
            long mediaDurationSinceLastPositionUs = Util.usToMs((long)(positionUs - this.lastPositionUs));
            long playoutDurationSinceLastPositionUs = Util.getPlayoutDurationForMediaDuration((long)mediaDurationSinceLastPositionUs, (float)this.audioTrackPlaybackSpeed);
            long playoutStartSystemTimeMs = System.currentTimeMillis() - Util.usToMs((long)playoutDurationSinceLastPositionUs);
            this.listener.onPositionAdvancing(playoutStartSystemTimeMs);
        }
        this.lastSystemTimeUs = systemTimeUs;
        this.lastPositionUs = positionUs;
        this.lastSampleUsedGetTimestampMode = useGetTimestampMode;
        return positionUs;
    }

    public void start() {
        ((AudioTimestampPoller)Assertions.checkNotNull((Object)this.audioTimestampPoller)).reset();
    }

    public boolean isPlaying() {
        return ((AudioTrack)Assertions.checkNotNull((Object)this.audioTrack)).getPlayState() == 3;
    }

    public boolean mayHandleBuffer(long writtenFrames) {
        int playState = ((AudioTrack)Assertions.checkNotNull((Object)this.audioTrack)).getPlayState();
        if (this.needsPassthroughWorkarounds) {
            if (playState == 2) {
                this.hasData = false;
                return false;
            }
            if (playState == 1 && this.getPlaybackHeadPosition() == 0L) {
                return false;
            }
        }
        boolean hadData = this.hasData;
        this.hasData = this.hasPendingData(writtenFrames);
        if (hadData && !this.hasData && playState != 1) {
            this.listener.onUnderrun(this.bufferSize, Util.usToMs((long)this.bufferSizeUs));
        }
        return true;
    }

    public int getAvailableBufferSize(long writtenBytes) {
        int bytesPending = (int)(writtenBytes - this.getPlaybackHeadPosition() * (long)this.outputPcmFrameSize);
        return this.bufferSize - bytesPending;
    }

    public long getPendingBufferDurationMs(long writtenFrames) {
        return Util.usToMs((long)this.framesToDurationUs(writtenFrames - this.getPlaybackHeadPosition()));
    }

    public boolean isStalled(long writtenFrames) {
        return this.forceResetWorkaroundTimeMs != -9223372036854775807L && writtenFrames > 0L && SystemClock.elapsedRealtime() - this.forceResetWorkaroundTimeMs >= 200L;
    }

    public void handleEndOfStream(long writtenFrames) {
        this.stopPlaybackHeadPosition = this.getPlaybackHeadPosition();
        this.stopTimestampUs = SystemClock.elapsedRealtime() * 1000L;
        this.endPlaybackHeadPosition = writtenFrames;
    }

    public boolean hasPendingData(long writtenFrames) {
        return writtenFrames > this.getPlaybackHeadPosition() || this.forceHasPendingData();
    }

    public boolean pause() {
        this.resetSyncParams();
        if (this.stopTimestampUs == -9223372036854775807L) {
            ((AudioTimestampPoller)Assertions.checkNotNull((Object)this.audioTimestampPoller)).reset();
            return true;
        }
        return false;
    }

    public void reset() {
        this.resetSyncParams();
        this.audioTrack = null;
        this.audioTimestampPoller = null;
    }

    private void maybeSampleSyncParams() {
        long playbackPositionUs = this.getPlaybackHeadPositionUs();
        if (playbackPositionUs == 0L) {
            return;
        }
        long systemTimeUs = System.nanoTime() / 1000L;
        if (systemTimeUs - this.lastPlayheadSampleTimeUs >= 30000L) {
            this.playheadOffsets[this.nextPlayheadOffsetIndex] = playbackPositionUs - systemTimeUs;
            this.nextPlayheadOffsetIndex = (this.nextPlayheadOffsetIndex + 1) % 10;
            if (this.playheadOffsetCount < 10) {
                ++this.playheadOffsetCount;
            }
            this.lastPlayheadSampleTimeUs = systemTimeUs;
            this.smoothedPlayheadOffsetUs = 0L;
            for (int i = 0; i < this.playheadOffsetCount; ++i) {
                this.smoothedPlayheadOffsetUs += this.playheadOffsets[i] / (long)this.playheadOffsetCount;
            }
        }
        if (this.needsPassthroughWorkarounds) {
            return;
        }
        this.maybePollAndCheckTimestamp(systemTimeUs, playbackPositionUs);
        this.maybeUpdateLatency(systemTimeUs);
    }

    private void maybePollAndCheckTimestamp(long systemTimeUs, long playbackPositionUs) {
        AudioTimestampPoller audioTimestampPoller = (AudioTimestampPoller)Assertions.checkNotNull((Object)this.audioTimestampPoller);
        if (!audioTimestampPoller.maybePollTimestamp(systemTimeUs)) {
            return;
        }
        long audioTimestampSystemTimeUs = audioTimestampPoller.getTimestampSystemTimeUs();
        long audioTimestampPositionFrames = audioTimestampPoller.getTimestampPositionFrames();
        if (Math.abs(audioTimestampSystemTimeUs - systemTimeUs) > 5000000L) {
            this.listener.onSystemTimeUsMismatch(audioTimestampPositionFrames, audioTimestampSystemTimeUs, systemTimeUs, playbackPositionUs);
            audioTimestampPoller.rejectTimestamp();
        } else if (Math.abs(this.framesToDurationUs(audioTimestampPositionFrames) - playbackPositionUs) > 5000000L) {
            this.listener.onPositionFramesMismatch(audioTimestampPositionFrames, audioTimestampSystemTimeUs, systemTimeUs, playbackPositionUs);
            audioTimestampPoller.rejectTimestamp();
        } else {
            audioTimestampPoller.acceptTimestamp();
        }
    }

    private void maybeUpdateLatency(long systemTimeUs) {
        if (this.isOutputPcm && this.getLatencyMethod != null && systemTimeUs - this.lastLatencySampleTimeUs >= 500000L) {
            try {
                this.latencyUs = (long)((Integer)Util.castNonNull((Object)((Integer)this.getLatencyMethod.invoke(Assertions.checkNotNull((Object)this.audioTrack), new Object[0])))).intValue() * 1000L - this.bufferSizeUs;
                this.latencyUs = Math.max(this.latencyUs, 0L);
                if (this.latencyUs > 5000000L) {
                    this.listener.onInvalidLatency(this.latencyUs);
                    this.latencyUs = 0L;
                }
            }
            catch (Exception e) {
                this.getLatencyMethod = null;
            }
            this.lastLatencySampleTimeUs = systemTimeUs;
        }
    }

    private long framesToDurationUs(long frameCount) {
        return frameCount * 1000000L / (long)this.outputSampleRate;
    }

    private void resetSyncParams() {
        this.smoothedPlayheadOffsetUs = 0L;
        this.playheadOffsetCount = 0;
        this.nextPlayheadOffsetIndex = 0;
        this.lastPlayheadSampleTimeUs = 0L;
        this.lastSystemTimeUs = 0L;
        this.previousModeSystemTimeUs = 0L;
        this.notifiedPositionIncreasing = false;
    }

    private boolean forceHasPendingData() {
        return this.needsPassthroughWorkarounds && ((AudioTrack)Assertions.checkNotNull((Object)this.audioTrack)).getPlayState() == 2 && this.getPlaybackHeadPosition() == 0L;
    }

    private static boolean needsPassthroughWorkarounds(int outputEncoding) {
        return Util.SDK_INT < 23 && (outputEncoding == 5 || outputEncoding == 6);
    }

    private long getPlaybackHeadPositionUs() {
        return this.framesToDurationUs(this.getPlaybackHeadPosition());
    }

    private long getPlaybackHeadPosition() {
        AudioTrack audioTrack = (AudioTrack)Assertions.checkNotNull((Object)this.audioTrack);
        if (this.stopTimestampUs != -9223372036854775807L) {
            long elapsedTimeSinceStopUs = SystemClock.elapsedRealtime() * 1000L - this.stopTimestampUs;
            long framesSinceStop = elapsedTimeSinceStopUs * (long)this.outputSampleRate / 1000000L;
            return Math.min(this.endPlaybackHeadPosition, this.stopPlaybackHeadPosition + framesSinceStop);
        }
        int state = audioTrack.getPlayState();
        if (state == 1) {
            return 0L;
        }
        long rawPlaybackHeadPosition = 0xFFFFFFFFL & (long)audioTrack.getPlaybackHeadPosition();
        if (this.needsPassthroughWorkarounds) {
            if (state == 2 && rawPlaybackHeadPosition == 0L) {
                this.passthroughWorkaroundPauseOffset = this.lastRawPlaybackHeadPosition;
            }
            rawPlaybackHeadPosition += this.passthroughWorkaroundPauseOffset;
        }
        if (Util.SDK_INT <= 29) {
            if (rawPlaybackHeadPosition == 0L && this.lastRawPlaybackHeadPosition > 0L && state == 3) {
                if (this.forceResetWorkaroundTimeMs == -9223372036854775807L) {
                    this.forceResetWorkaroundTimeMs = SystemClock.elapsedRealtime();
                }
                return this.lastRawPlaybackHeadPosition;
            }
            this.forceResetWorkaroundTimeMs = -9223372036854775807L;
        }
        if (this.lastRawPlaybackHeadPosition > rawPlaybackHeadPosition) {
            ++this.rawPlaybackHeadWrapCount;
        }
        this.lastRawPlaybackHeadPosition = rawPlaybackHeadPosition;
        return rawPlaybackHeadPosition + (this.rawPlaybackHeadWrapCount << 32);
    }

    public static interface Listener {
        public void onPositionAdvancing(long var1);

        public void onPositionFramesMismatch(long var1, long var3, long var5, long var7);

        public void onSystemTimeUsMismatch(long var1, long var3, long var5, long var7);

        public void onInvalidLatency(long var1);

        public void onUnderrun(int var1, long var2);
    }
}

