/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.decoder;

import androidx.annotation.Nullable;
import com.google.android.exoplayer2.Format;
import com.google.android.exoplayer2.util.Assertions;
import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

public final class DecoderReuseEvaluation {
    public static final int REUSE_RESULT_NO = 0;
    public static final int REUSE_RESULT_YES_WITH_FLUSH = 1;
    public static final int REUSE_RESULT_YES_WITH_RECONFIGURATION = 2;
    public static final int REUSE_RESULT_YES_WITHOUT_RECONFIGURATION = 3;
    public static final int DISCARD_REASON_REUSE_NOT_IMPLEMENTED = 1;
    public static final int DISCARD_REASON_WORKAROUND = 2;
    public static final int DISCARD_REASON_APP_OVERRIDE = 4;
    public static final int DISCARD_REASON_MIME_TYPE_CHANGED = 8;
    public static final int DISCARD_REASON_OPERATING_RATE_CHANGED = 16;
    public static final int DISCARD_REASON_INITIALIZATION_DATA_CHANGED = 32;
    public static final int DISCARD_REASON_MAX_INPUT_SIZE_EXCEEDED = 64;
    public static final int DISCARD_REASON_DRM_SESSION_CHANGED = 128;
    public static final int DISCARD_REASON_VIDEO_MAX_RESOLUTION_EXCEEDED = 256;
    public static final int DISCARD_REASON_VIDEO_RESOLUTION_CHANGED = 512;
    public static final int DISCARD_REASON_VIDEO_ROTATION_CHANGED = 1024;
    public static final int DISCARD_REASON_VIDEO_COLOR_INFO_CHANGED = 2048;
    public static final int DISCARD_REASON_AUDIO_CHANNEL_COUNT_CHANGED = 4096;
    public static final int DISCARD_REASON_AUDIO_SAMPLE_RATE_CHANGED = 8192;
    public static final int DISCARD_REASON_AUDIO_ENCODING_CHANGED = 16384;
    public final String decoderName;
    public final Format oldFormat;
    public final Format newFormat;
    public final int result;
    public final int discardReasons;

    public DecoderReuseEvaluation(String decoderName, Format oldFormat, Format newFormat, int result, int discardReasons) {
        Assertions.checkArgument((result == 0 || discardReasons == 0 ? 1 : 0) != 0);
        this.decoderName = Assertions.checkNotEmpty((String)decoderName);
        this.oldFormat = (Format)Assertions.checkNotNull((Object)oldFormat);
        this.newFormat = (Format)Assertions.checkNotNull((Object)newFormat);
        this.result = result;
        this.discardReasons = discardReasons;
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        DecoderReuseEvaluation other = (DecoderReuseEvaluation)obj;
        return this.result == other.result && this.discardReasons == other.discardReasons && this.decoderName.equals(other.decoderName) && this.oldFormat.equals((Object)other.oldFormat) && this.newFormat.equals((Object)other.newFormat);
    }

    public int hashCode() {
        int hashCode = 17;
        hashCode = 31 * hashCode + this.result;
        hashCode = 31 * hashCode + this.discardReasons;
        hashCode = 31 * hashCode + this.decoderName.hashCode();
        hashCode = 31 * hashCode + this.oldFormat.hashCode();
        hashCode = 31 * hashCode + this.newFormat.hashCode();
        return hashCode;
    }

    @Documented
    @Retention(value=RetentionPolicy.SOURCE)
    @Target(value={ElementType.TYPE_USE})
    public static @interface DecoderDiscardReasons {
    }

    @Documented
    @Retention(value=RetentionPolicy.SOURCE)
    @Target(value={ElementType.TYPE_USE})
    public static @interface DecoderReuseResult {
    }
}

