/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.drm;

import android.annotation.SuppressLint;
import android.media.NotProvisionedException;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.os.Message;
import android.os.SystemClock;
import android.util.Pair;
import androidx.annotation.GuardedBy;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import com.google.android.exoplayer2.C;
import com.google.android.exoplayer2.analytics.PlayerId;
import com.google.android.exoplayer2.decoder.CryptoConfig;
import com.google.android.exoplayer2.drm.DrmInitData;
import com.google.android.exoplayer2.drm.DrmSession;
import com.google.android.exoplayer2.drm.DrmSessionEventListener;
import com.google.android.exoplayer2.drm.DrmUtil;
import com.google.android.exoplayer2.drm.ExoMediaDrm;
import com.google.android.exoplayer2.drm.KeysExpiredException;
import com.google.android.exoplayer2.drm.MediaDrmCallback;
import com.google.android.exoplayer2.drm.MediaDrmCallbackException;
import com.google.android.exoplayer2.drm.WidevineUtil;
import com.google.android.exoplayer2.source.LoadEventInfo;
import com.google.android.exoplayer2.source.MediaLoadData;
import com.google.android.exoplayer2.upstream.LoadErrorHandlingPolicy;
import com.google.android.exoplayer2.util.Assertions;
import com.google.android.exoplayer2.util.Consumer;
import com.google.android.exoplayer2.util.CopyOnWriteMultiset;
import com.google.android.exoplayer2.util.Log;
import com.google.android.exoplayer2.util.Util;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.checkerframework.checker.nullness.qual.RequiresNonNull;

@RequiresApi(value=18)
class DefaultDrmSession
implements DrmSession {
    private static final String TAG = "DefaultDrmSession";
    private static final int MSG_PROVISION = 0;
    private static final int MSG_KEYS = 1;
    private static final int MAX_LICENSE_DURATION_TO_RENEW_SECONDS = 60;
    @Nullable
    public final List<DrmInitData.SchemeData> schemeDatas;
    private final ExoMediaDrm mediaDrm;
    private final ProvisioningManager provisioningManager;
    private final ReferenceCountListener referenceCountListener;
    private final int mode;
    private final boolean playClearSamplesWithoutKeys;
    private final boolean isPlaceholderSession;
    private final HashMap<String, String> keyRequestParameters;
    private final CopyOnWriteMultiset<DrmSessionEventListener.EventDispatcher> eventDispatchers;
    private final LoadErrorHandlingPolicy loadErrorHandlingPolicy;
    private final PlayerId playerId;
    final MediaDrmCallback callback;
    final UUID uuid;
    final ResponseHandler responseHandler;
    private int state;
    private int referenceCount;
    @Nullable
    private HandlerThread requestHandlerThread;
    @Nullable
    private RequestHandler requestHandler;
    @Nullable
    private CryptoConfig cryptoConfig;
    @Nullable
    private DrmSession.DrmSessionException lastException;
    @Nullable
    private byte[] sessionId;
    private byte @MonotonicNonNull [] offlineLicenseKeySetId;
    @Nullable
    private ExoMediaDrm.KeyRequest currentKeyRequest;
    @Nullable
    private ExoMediaDrm.ProvisionRequest currentProvisionRequest;

    public DefaultDrmSession(UUID uuid, ExoMediaDrm mediaDrm, ProvisioningManager provisioningManager, ReferenceCountListener referenceCountListener, @Nullable List<DrmInitData.SchemeData> schemeDatas, int mode, boolean playClearSamplesWithoutKeys, boolean isPlaceholderSession, @Nullable byte[] offlineLicenseKeySetId, HashMap<String, String> keyRequestParameters, MediaDrmCallback callback, Looper playbackLooper, LoadErrorHandlingPolicy loadErrorHandlingPolicy, PlayerId playerId) {
        if (mode == 1 || mode == 3) {
            Assertions.checkNotNull((Object)offlineLicenseKeySetId);
        }
        this.uuid = uuid;
        this.provisioningManager = provisioningManager;
        this.referenceCountListener = referenceCountListener;
        this.mediaDrm = mediaDrm;
        this.mode = mode;
        this.playClearSamplesWithoutKeys = playClearSamplesWithoutKeys;
        this.isPlaceholderSession = isPlaceholderSession;
        if (offlineLicenseKeySetId != null) {
            this.offlineLicenseKeySetId = offlineLicenseKeySetId;
            this.schemeDatas = null;
        } else {
            this.schemeDatas = Collections.unmodifiableList((List)Assertions.checkNotNull(schemeDatas));
        }
        this.keyRequestParameters = keyRequestParameters;
        this.callback = callback;
        this.eventDispatchers = new CopyOnWriteMultiset();
        this.loadErrorHandlingPolicy = loadErrorHandlingPolicy;
        this.playerId = playerId;
        this.state = 2;
        this.responseHandler = new ResponseHandler(playbackLooper);
    }

    public boolean hasSessionId(byte[] sessionId) {
        return Arrays.equals(this.sessionId, sessionId);
    }

    public void onMediaDrmEvent(int what) {
        switch (what) {
            case 2: {
                this.onKeysRequired();
                break;
            }
        }
    }

    public void provision() {
        this.currentProvisionRequest = this.mediaDrm.getProvisionRequest();
        ((RequestHandler)((Object)Util.castNonNull((Object)((Object)this.requestHandler)))).post(0, Assertions.checkNotNull((Object)this.currentProvisionRequest), true);
    }

    public void onProvisionCompleted() {
        if (this.openInternal()) {
            this.doLicense(true);
        }
    }

    public void onProvisionError(Exception error, boolean thrownByExoMediaDrm) {
        this.onError(error, thrownByExoMediaDrm ? 1 : 3);
    }

    @Override
    public final int getState() {
        return this.state;
    }

    @Override
    public boolean playClearSamplesWithoutKeys() {
        return this.playClearSamplesWithoutKeys;
    }

    @Override
    @Nullable
    public final DrmSession.DrmSessionException getError() {
        return this.state == 1 ? this.lastException : null;
    }

    @Override
    public final UUID getSchemeUuid() {
        return this.uuid;
    }

    @Override
    @Nullable
    public final CryptoConfig getCryptoConfig() {
        return this.cryptoConfig;
    }

    @Override
    @Nullable
    public Map<String, String> queryKeyStatus() {
        return this.sessionId == null ? null : this.mediaDrm.queryKeyStatus(this.sessionId);
    }

    @Override
    @Nullable
    public byte[] getOfflineLicenseKeySetId() {
        return this.offlineLicenseKeySetId;
    }

    @Override
    public boolean requiresSecureDecoder(String mimeType) {
        return this.mediaDrm.requiresSecureDecoder((byte[])Assertions.checkStateNotNull((Object)this.sessionId), mimeType);
    }

    @Override
    public void acquire(@Nullable DrmSessionEventListener.EventDispatcher eventDispatcher) {
        if (this.referenceCount < 0) {
            int n = this.referenceCount;
            Log.e((String)TAG, (String)new StringBuilder(51).append("Session reference count less than zero: ").append(n).toString());
            this.referenceCount = 0;
        }
        if (eventDispatcher != null) {
            this.eventDispatchers.add((Object)eventDispatcher);
        }
        if (++this.referenceCount == 1) {
            Assertions.checkState((this.state == 2 ? 1 : 0) != 0);
            this.requestHandlerThread = new HandlerThread("ExoPlayer:DrmRequestHandler");
            this.requestHandlerThread.start();
            this.requestHandler = new RequestHandler(this.requestHandlerThread.getLooper());
            if (this.openInternal()) {
                this.doLicense(true);
            }
        } else if (eventDispatcher != null && this.isOpen() && this.eventDispatchers.count((Object)eventDispatcher) == 1) {
            eventDispatcher.drmSessionAcquired(this.state);
        }
        this.referenceCountListener.onReferenceCountIncremented(this, this.referenceCount);
    }

    @Override
    public void release(@Nullable DrmSessionEventListener.EventDispatcher eventDispatcher) {
        if (this.referenceCount <= 0) {
            Log.e((String)TAG, (String)"release() called on a session that's already fully released.");
            return;
        }
        if (--this.referenceCount == 0) {
            this.state = 0;
            ((ResponseHandler)((Object)Util.castNonNull((Object)((Object)this.responseHandler)))).removeCallbacksAndMessages(null);
            ((RequestHandler)((Object)Util.castNonNull((Object)((Object)this.requestHandler)))).release();
            this.requestHandler = null;
            ((HandlerThread)Util.castNonNull((Object)this.requestHandlerThread)).quit();
            this.requestHandlerThread = null;
            this.cryptoConfig = null;
            this.lastException = null;
            this.currentKeyRequest = null;
            this.currentProvisionRequest = null;
            if (this.sessionId != null) {
                this.mediaDrm.closeSession(this.sessionId);
                this.sessionId = null;
            }
        }
        if (eventDispatcher != null) {
            this.eventDispatchers.remove((Object)eventDispatcher);
            if (this.eventDispatchers.count((Object)eventDispatcher) == 0) {
                eventDispatcher.drmSessionReleased();
            }
        }
        this.referenceCountListener.onReferenceCountDecremented(this, this.referenceCount);
    }

    @EnsuresNonNullIf(result=true, expression={"sessionId"})
    private boolean openInternal() {
        if (this.isOpen()) {
            return true;
        }
        try {
            this.sessionId = this.mediaDrm.openSession();
            this.mediaDrm.setPlayerIdForSession(this.sessionId, this.playerId);
            this.cryptoConfig = this.mediaDrm.createCryptoConfig(this.sessionId);
            int localState = this.state = 3;
            this.dispatchEvent((Consumer<DrmSessionEventListener.EventDispatcher>)((Consumer)eventDispatcher -> eventDispatcher.drmSessionAcquired(localState)));
            Assertions.checkNotNull((Object)this.sessionId);
            return true;
        }
        catch (NotProvisionedException e) {
            this.provisioningManager.provisionRequired(this);
        }
        catch (Exception e) {
            this.onError(e, 1);
        }
        return false;
    }

    private void onProvisionResponse(Object request, Object response) {
        if (request != this.currentProvisionRequest || this.state != 2 && !this.isOpen()) {
            return;
        }
        this.currentProvisionRequest = null;
        if (response instanceof Exception) {
            this.provisioningManager.onProvisionError((Exception)response, false);
            return;
        }
        try {
            this.mediaDrm.provideProvisionResponse((byte[])response);
        }
        catch (Exception e) {
            this.provisioningManager.onProvisionError(e, true);
            return;
        }
        this.provisioningManager.onProvisionCompleted();
    }

    @RequiresNonNull(value={"sessionId"})
    private void doLicense(boolean allowRetry) {
        if (this.isPlaceholderSession) {
            return;
        }
        byte[] sessionId = (byte[])Util.castNonNull((Object)this.sessionId);
        switch (this.mode) {
            case 0: 
            case 1: {
                if (this.offlineLicenseKeySetId == null) {
                    this.postKeyRequest(sessionId, 1, allowRetry);
                    break;
                }
                if (this.state != 4 && !this.restoreKeys()) break;
                long licenseDurationRemainingSec = this.getLicenseDurationRemainingSec();
                if (this.mode == 0 && licenseDurationRemainingSec <= 60L) {
                    Log.d((String)TAG, (String)new StringBuilder(88).append("Offline license has expired or will expire soon. Remaining seconds: ").append(licenseDurationRemainingSec).toString());
                    this.postKeyRequest(sessionId, 2, allowRetry);
                    break;
                }
                if (licenseDurationRemainingSec <= 0L) {
                    this.onError(new KeysExpiredException(), 2);
                    break;
                }
                this.state = 4;
                this.dispatchEvent((Consumer<DrmSessionEventListener.EventDispatcher>)((Consumer)DrmSessionEventListener.EventDispatcher::drmKeysRestored));
                break;
            }
            case 2: {
                if (this.offlineLicenseKeySetId != null && !this.restoreKeys()) break;
                this.postKeyRequest(sessionId, 2, allowRetry);
                break;
            }
            case 3: {
                Assertions.checkNotNull((Object)this.offlineLicenseKeySetId);
                Assertions.checkNotNull((Object)this.sessionId);
                this.postKeyRequest(this.offlineLicenseKeySetId, 3, allowRetry);
                break;
            }
        }
    }

    @RequiresNonNull(value={"sessionId", "offlineLicenseKeySetId"})
    private boolean restoreKeys() {
        try {
            this.mediaDrm.restoreKeys(this.sessionId, this.offlineLicenseKeySetId);
            return true;
        }
        catch (Exception e) {
            this.onError(e, 1);
            return false;
        }
    }

    private long getLicenseDurationRemainingSec() {
        if (!C.WIDEVINE_UUID.equals(this.uuid)) {
            return Long.MAX_VALUE;
        }
        Pair pair = (Pair)Assertions.checkNotNull(WidevineUtil.getLicenseDurationRemainingSec(this));
        return Math.min((Long)pair.first, (Long)pair.second);
    }

    private void postKeyRequest(byte[] scope, int type, boolean allowRetry) {
        try {
            this.currentKeyRequest = this.mediaDrm.getKeyRequest(scope, this.schemeDatas, type, this.keyRequestParameters);
            ((RequestHandler)((Object)Util.castNonNull((Object)((Object)this.requestHandler)))).post(1, Assertions.checkNotNull((Object)this.currentKeyRequest), allowRetry);
        }
        catch (Exception e) {
            this.onKeysError(e, true);
        }
    }

    private void onKeyResponse(Object request, Object response) {
        if (request != this.currentKeyRequest || !this.isOpen()) {
            return;
        }
        this.currentKeyRequest = null;
        if (response instanceof Exception) {
            this.onKeysError((Exception)response, false);
            return;
        }
        try {
            byte[] responseData = (byte[])response;
            if (this.mode == 3) {
                this.mediaDrm.provideKeyResponse((byte[])Util.castNonNull((Object)this.offlineLicenseKeySetId), responseData);
                this.dispatchEvent((Consumer<DrmSessionEventListener.EventDispatcher>)((Consumer)DrmSessionEventListener.EventDispatcher::drmKeysRemoved));
            } else {
                byte[] keySetId = this.mediaDrm.provideKeyResponse(this.sessionId, responseData);
                if ((this.mode == 2 || this.mode == 0 && this.offlineLicenseKeySetId != null) && keySetId != null && keySetId.length != 0) {
                    this.offlineLicenseKeySetId = keySetId;
                }
                this.state = 4;
                this.dispatchEvent((Consumer<DrmSessionEventListener.EventDispatcher>)((Consumer)DrmSessionEventListener.EventDispatcher::drmKeysLoaded));
            }
        }
        catch (Exception e) {
            this.onKeysError(e, true);
        }
    }

    private void onKeysRequired() {
        if (this.mode == 0 && this.state == 4) {
            Util.castNonNull((Object)this.sessionId);
            this.doLicense(false);
        }
    }

    private void onKeysError(Exception e, boolean thrownByExoMediaDrm) {
        if (e instanceof NotProvisionedException) {
            this.provisioningManager.provisionRequired(this);
        } else {
            this.onError(e, thrownByExoMediaDrm ? 1 : 2);
        }
    }

    private void onError(Exception e, int errorSource) {
        this.lastException = new DrmSession.DrmSessionException(e, DrmUtil.getErrorCodeForMediaDrmException(e, errorSource));
        Log.e((String)TAG, (String)"DRM session error", (Throwable)e);
        this.dispatchEvent((Consumer<DrmSessionEventListener.EventDispatcher>)((Consumer)eventDispatcher -> eventDispatcher.drmSessionManagerError(e)));
        if (this.state != 4) {
            this.state = 1;
        }
    }

    @EnsuresNonNullIf(result=true, expression={"sessionId"})
    private boolean isOpen() {
        return this.state == 3 || this.state == 4;
    }

    private void dispatchEvent(Consumer<DrmSessionEventListener.EventDispatcher> event) {
        for (DrmSessionEventListener.EventDispatcher eventDispatcher : this.eventDispatchers.elementSet()) {
            event.accept((Object)eventDispatcher);
        }
    }

    private static final class RequestTask {
        public final long taskId;
        public final boolean allowRetry;
        public final long startTimeMs;
        public final Object request;
        public int errorCount;

        public RequestTask(long taskId, boolean allowRetry, long startTimeMs, Object request) {
            this.taskId = taskId;
            this.allowRetry = allowRetry;
            this.startTimeMs = startTimeMs;
            this.request = request;
        }
    }

    @SuppressLint(value={"HandlerLeak"})
    private class RequestHandler
    extends Handler {
        @GuardedBy(value="this")
        private boolean isReleased;

        public RequestHandler(Looper backgroundLooper) {
            super(backgroundLooper);
        }

        void post(int what, Object request, boolean allowRetry) {
            RequestTask requestTask = new RequestTask(LoadEventInfo.getNewId(), allowRetry, SystemClock.elapsedRealtime(), request);
            this.obtainMessage(what, requestTask).sendToTarget();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleMessage(Message msg) {
            Object response;
            RequestTask requestTask = (RequestTask)msg.obj;
            try {
                switch (msg.what) {
                    case 0: {
                        response = DefaultDrmSession.this.callback.executeProvisionRequest(DefaultDrmSession.this.uuid, (ExoMediaDrm.ProvisionRequest)requestTask.request);
                        break;
                    }
                    case 1: {
                        response = DefaultDrmSession.this.callback.executeKeyRequest(DefaultDrmSession.this.uuid, (ExoMediaDrm.KeyRequest)requestTask.request);
                        break;
                    }
                    default: {
                        throw new RuntimeException();
                    }
                }
            }
            catch (MediaDrmCallbackException e) {
                if (this.maybeRetryRequest(msg, e)) {
                    return;
                }
                response = e;
            }
            catch (Exception e) {
                Log.w((String)DefaultDrmSession.TAG, (String)"Key/provisioning request produced an unexpected exception. Not retrying.", (Throwable)e);
                response = e;
            }
            DefaultDrmSession.this.loadErrorHandlingPolicy.onLoadTaskConcluded(requestTask.taskId);
            RequestHandler requestHandler = this;
            synchronized (requestHandler) {
                if (!this.isReleased) {
                    DefaultDrmSession.this.responseHandler.obtainMessage(msg.what, Pair.create((Object)requestTask.request, (Object)response)).sendToTarget();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean maybeRetryRequest(Message originalMsg, MediaDrmCallbackException exception) {
            RequestTask requestTask = (RequestTask)originalMsg.obj;
            if (!requestTask.allowRetry) {
                return false;
            }
            ++requestTask.errorCount;
            if (requestTask.errorCount > DefaultDrmSession.this.loadErrorHandlingPolicy.getMinimumLoadableRetryCount(3)) {
                return false;
            }
            LoadEventInfo loadEventInfo = new LoadEventInfo(requestTask.taskId, exception.dataSpec, exception.uriAfterRedirects, exception.responseHeaders, SystemClock.elapsedRealtime(), SystemClock.elapsedRealtime() - requestTask.startTimeMs, exception.bytesLoaded);
            MediaLoadData mediaLoadData = new MediaLoadData(3);
            IOException loadErrorCause = exception.getCause() instanceof IOException ? (IOException)exception.getCause() : new UnexpectedDrmSessionException(exception.getCause());
            long retryDelayMs = DefaultDrmSession.this.loadErrorHandlingPolicy.getRetryDelayMsFor(new LoadErrorHandlingPolicy.LoadErrorInfo(loadEventInfo, mediaLoadData, loadErrorCause, requestTask.errorCount));
            if (retryDelayMs == -9223372036854775807L) {
                return false;
            }
            RequestHandler requestHandler = this;
            synchronized (requestHandler) {
                if (!this.isReleased) {
                    this.sendMessageDelayed(Message.obtain((Message)originalMsg), retryDelayMs);
                    return true;
                }
            }
            return false;
        }

        public synchronized void release() {
            this.removeCallbacksAndMessages(null);
            this.isReleased = true;
        }
    }

    @SuppressLint(value={"HandlerLeak"})
    private class ResponseHandler
    extends Handler {
        public ResponseHandler(Looper looper) {
            super(looper);
        }

        public void handleMessage(Message msg) {
            Pair requestAndResponse = (Pair)msg.obj;
            Object request = requestAndResponse.first;
            Object response = requestAndResponse.second;
            switch (msg.what) {
                case 0: {
                    DefaultDrmSession.this.onProvisionResponse(request, response);
                    break;
                }
                case 1: {
                    DefaultDrmSession.this.onKeyResponse(request, response);
                    break;
                }
            }
        }
    }

    public static interface ReferenceCountListener {
        public void onReferenceCountIncremented(DefaultDrmSession var1, int var2);

        public void onReferenceCountDecremented(DefaultDrmSession var1, int var2);
    }

    public static interface ProvisioningManager {
        public void provisionRequired(DefaultDrmSession var1);

        public void onProvisionError(Exception var1, boolean var2);

        public void onProvisionCompleted();
    }

    public static final class UnexpectedDrmSessionException
    extends IOException {
        public UnexpectedDrmSessionException(@Nullable Throwable cause) {
            super(cause);
        }
    }
}

