/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.drm;

import androidx.annotation.GuardedBy;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import com.google.android.exoplayer2.MediaItem;
import com.google.android.exoplayer2.drm.DefaultDrmSessionManager;
import com.google.android.exoplayer2.drm.DrmSessionManager;
import com.google.android.exoplayer2.drm.DrmSessionManagerProvider;
import com.google.android.exoplayer2.drm.FrameworkMediaDrm;
import com.google.android.exoplayer2.drm.HttpMediaDrmCallback;
import com.google.android.exoplayer2.upstream.DefaultHttpDataSource;
import com.google.android.exoplayer2.upstream.HttpDataSource;
import com.google.android.exoplayer2.util.Assertions;
import com.google.android.exoplayer2.util.Util;
import com.google.common.primitives.Ints;
import java.util.Collection;
import java.util.Map;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;

public final class DefaultDrmSessionManagerProvider
implements DrmSessionManagerProvider {
    private final Object lock = new Object();
    @GuardedBy(value="lock")
    private // Could not load outer class - annotation placement on inner may be incorrect
    @MonotonicNonNull MediaItem.DrmConfiguration drmConfiguration;
    @GuardedBy(value="lock")
    private @MonotonicNonNull DrmSessionManager manager;
    @Nullable
    private HttpDataSource.Factory drmHttpDataSourceFactory;
    @Nullable
    private String userAgent;

    public void setDrmHttpDataSourceFactory(@Nullable HttpDataSource.Factory drmHttpDataSourceFactory) {
        this.drmHttpDataSourceFactory = drmHttpDataSourceFactory;
    }

    public void setDrmUserAgent(@Nullable String userAgent) {
        this.userAgent = userAgent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DrmSessionManager get(MediaItem mediaItem) {
        Assertions.checkNotNull((Object)mediaItem.localConfiguration);
        MediaItem.DrmConfiguration drmConfiguration = mediaItem.localConfiguration.drmConfiguration;
        if (drmConfiguration == null || Util.SDK_INT < 18) {
            return DrmSessionManager.DRM_UNSUPPORTED;
        }
        Object object = this.lock;
        synchronized (object) {
            if (!Util.areEqual((Object)drmConfiguration, (Object)this.drmConfiguration)) {
                this.drmConfiguration = drmConfiguration;
                this.manager = this.createManager(drmConfiguration);
            }
            return (DrmSessionManager)Assertions.checkNotNull((Object)this.manager);
        }
    }

    @RequiresApi(value=18)
    private DrmSessionManager createManager(MediaItem.DrmConfiguration drmConfiguration) {
        HttpDataSource.Factory dataSourceFactory = this.drmHttpDataSourceFactory != null ? this.drmHttpDataSourceFactory : new DefaultHttpDataSource.Factory().setUserAgent(this.userAgent);
        HttpMediaDrmCallback httpDrmCallback = new HttpMediaDrmCallback(drmConfiguration.licenseUri == null ? null : drmConfiguration.licenseUri.toString(), drmConfiguration.forceDefaultLicenseUri, dataSourceFactory);
        for (Map.Entry entry : drmConfiguration.licenseRequestHeaders.entrySet()) {
            httpDrmCallback.setKeyRequestProperty((String)entry.getKey(), (String)entry.getValue());
        }
        DefaultDrmSessionManager drmSessionManager = new DefaultDrmSessionManager.Builder().setUuidAndExoMediaDrmProvider(drmConfiguration.scheme, FrameworkMediaDrm.DEFAULT_PROVIDER).setMultiSession(drmConfiguration.multiSession).setPlayClearSamplesWithoutKeys(drmConfiguration.playClearContentWithoutKey).setUseDrmSessionsForClearContent(Ints.toArray((Collection)drmConfiguration.forcedSessionTrackTypes)).build(httpDrmCallback);
        drmSessionManager.setMode(0, drmConfiguration.getKeySetId());
        return drmSessionManager;
    }
}

