/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.mediacodec;

import android.media.MediaCodec;
import android.media.MediaCrypto;
import android.media.MediaFormat;
import android.os.Bundle;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.PersistableBundle;
import android.view.Surface;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.annotation.VisibleForTesting;
import com.google.android.exoplayer2.decoder.CryptoInfo;
import com.google.android.exoplayer2.mediacodec.AsynchronousMediaCodecBufferEnqueuer;
import com.google.android.exoplayer2.mediacodec.AsynchronousMediaCodecCallback;
import com.google.android.exoplayer2.mediacodec.MediaCodecAdapter;
import com.google.android.exoplayer2.util.TraceUtil;
import com.google.common.base.Supplier;
import java.io.IOException;
import java.nio.ByteBuffer;

@RequiresApi(value=23)
final class AsynchronousMediaCodecAdapter
implements MediaCodecAdapter {
    private static final int STATE_CREATED = 0;
    private static final int STATE_INITIALIZED = 1;
    private static final int STATE_SHUT_DOWN = 2;
    private final MediaCodec codec;
    private final AsynchronousMediaCodecCallback asynchronousMediaCodecCallback;
    private final AsynchronousMediaCodecBufferEnqueuer bufferEnqueuer;
    private final boolean synchronizeCodecInteractionsWithQueueing;
    private final boolean enableImmediateCodecStartAfterFlush;
    private boolean codecReleased;
    private int state;

    private AsynchronousMediaCodecAdapter(MediaCodec codec, HandlerThread callbackThread, HandlerThread enqueueingThread, boolean synchronizeCodecInteractionsWithQueueing, boolean enableImmediateCodecStartAfterFlush) {
        this.codec = codec;
        this.asynchronousMediaCodecCallback = new AsynchronousMediaCodecCallback(callbackThread);
        this.bufferEnqueuer = new AsynchronousMediaCodecBufferEnqueuer(codec, enqueueingThread);
        this.synchronizeCodecInteractionsWithQueueing = synchronizeCodecInteractionsWithQueueing;
        this.enableImmediateCodecStartAfterFlush = enableImmediateCodecStartAfterFlush;
        this.state = 0;
    }

    private void initialize(@Nullable MediaFormat mediaFormat, @Nullable Surface surface, @Nullable MediaCrypto crypto, int flags) {
        this.asynchronousMediaCodecCallback.initialize(this.codec);
        TraceUtil.beginSection((String)"configureCodec");
        this.codec.configure(mediaFormat, surface, crypto, flags);
        TraceUtil.endSection();
        this.bufferEnqueuer.start();
        TraceUtil.beginSection((String)"startCodec");
        this.codec.start();
        TraceUtil.endSection();
        this.state = 1;
    }

    @Override
    public boolean needsReconfiguration() {
        return false;
    }

    @Override
    public void queueInputBuffer(int index, int offset, int size, long presentationTimeUs, int flags) {
        this.bufferEnqueuer.queueInputBuffer(index, offset, size, presentationTimeUs, flags);
    }

    @Override
    public void queueSecureInputBuffer(int index, int offset, CryptoInfo info, long presentationTimeUs, int flags) {
        this.bufferEnqueuer.queueSecureInputBuffer(index, offset, info, presentationTimeUs, flags);
    }

    @Override
    public void releaseOutputBuffer(int index, boolean render) {
        this.codec.releaseOutputBuffer(index, render);
    }

    @Override
    public void releaseOutputBuffer(int index, long renderTimeStampNs) {
        this.codec.releaseOutputBuffer(index, renderTimeStampNs);
    }

    @Override
    public int dequeueInputBufferIndex() {
        return this.asynchronousMediaCodecCallback.dequeueInputBufferIndex();
    }

    @Override
    public int dequeueOutputBufferIndex(MediaCodec.BufferInfo bufferInfo) {
        return this.asynchronousMediaCodecCallback.dequeueOutputBufferIndex(bufferInfo);
    }

    @Override
    public MediaFormat getOutputFormat() {
        return this.asynchronousMediaCodecCallback.getOutputFormat();
    }

    @Override
    @Nullable
    public ByteBuffer getInputBuffer(int index) {
        return this.codec.getInputBuffer(index);
    }

    @Override
    @Nullable
    public ByteBuffer getOutputBuffer(int index) {
        return this.codec.getOutputBuffer(index);
    }

    @Override
    public void flush() {
        this.bufferEnqueuer.flush();
        this.codec.flush();
        if (this.enableImmediateCodecStartAfterFlush) {
            this.asynchronousMediaCodecCallback.flush(null);
            this.codec.start();
        } else {
            this.asynchronousMediaCodecCallback.flush(this.codec);
        }
    }

    @Override
    public void release() {
        try {
            if (this.state == 1) {
                this.bufferEnqueuer.shutdown();
                this.asynchronousMediaCodecCallback.shutdown();
            }
            this.state = 2;
        }
        finally {
            if (!this.codecReleased) {
                this.codec.release();
                this.codecReleased = true;
            }
        }
    }

    @Override
    public void setOnFrameRenderedListener(MediaCodecAdapter.OnFrameRenderedListener listener, Handler handler) {
        this.maybeBlockOnQueueing();
        this.codec.setOnFrameRenderedListener((codec, presentationTimeUs, nanoTime) -> listener.onFrameRendered(this, presentationTimeUs, nanoTime), handler);
    }

    @Override
    public void setOutputSurface(Surface surface) {
        this.maybeBlockOnQueueing();
        this.codec.setOutputSurface(surface);
    }

    @Override
    public void setParameters(Bundle params) {
        this.maybeBlockOnQueueing();
        this.codec.setParameters(params);
    }

    @Override
    public void setVideoScalingMode(int scalingMode) {
        this.maybeBlockOnQueueing();
        this.codec.setVideoScalingMode(scalingMode);
    }

    @Override
    @RequiresApi(value=26)
    public PersistableBundle getMetrics() {
        this.maybeBlockOnQueueing();
        return this.codec.getMetrics();
    }

    @VisibleForTesting
    void onError(MediaCodec.CodecException error) {
        this.asynchronousMediaCodecCallback.onError(this.codec, error);
    }

    @VisibleForTesting
    void onOutputFormatChanged(MediaFormat format) {
        this.asynchronousMediaCodecCallback.onOutputFormatChanged(this.codec, format);
    }

    private void maybeBlockOnQueueing() {
        if (this.synchronizeCodecInteractionsWithQueueing) {
            try {
                this.bufferEnqueuer.waitUntilQueueingComplete();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new IllegalStateException(e);
            }
        }
    }

    private static String createCallbackThreadLabel(int trackType) {
        return AsynchronousMediaCodecAdapter.createThreadLabel(trackType, "ExoPlayer:MediaCodecAsyncAdapter:");
    }

    private static String createQueueingThreadLabel(int trackType) {
        return AsynchronousMediaCodecAdapter.createThreadLabel(trackType, "ExoPlayer:MediaCodecQueueingThread:");
    }

    private static String createThreadLabel(int trackType, String prefix) {
        StringBuilder labelBuilder = new StringBuilder(prefix);
        if (trackType == 1) {
            labelBuilder.append("Audio");
        } else if (trackType == 2) {
            labelBuilder.append("Video");
        } else {
            labelBuilder.append("Unknown(").append(trackType).append(")");
        }
        return labelBuilder.toString();
    }

    public static final class Factory
    implements MediaCodecAdapter.Factory {
        private final Supplier<HandlerThread> callbackThreadSupplier;
        private final Supplier<HandlerThread> queueingThreadSupplier;
        private final boolean synchronizeCodecInteractionsWithQueueing;
        private final boolean enableImmediateCodecStartAfterFlush;

        public Factory(int trackType, boolean synchronizeCodecInteractionsWithQueueing, boolean enableImmediateCodecStartAfterFlush) {
            this((Supplier<HandlerThread>)((Supplier)() -> new HandlerThread(AsynchronousMediaCodecAdapter.createCallbackThreadLabel(trackType))), (Supplier<HandlerThread>)((Supplier)() -> new HandlerThread(AsynchronousMediaCodecAdapter.createQueueingThreadLabel(trackType))), synchronizeCodecInteractionsWithQueueing, enableImmediateCodecStartAfterFlush);
        }

        @VisibleForTesting
        Factory(Supplier<HandlerThread> callbackThreadSupplier, Supplier<HandlerThread> queueingThreadSupplier, boolean synchronizeCodecInteractionsWithQueueing, boolean enableImmediateCodecStartAfterFlush) {
            this.callbackThreadSupplier = callbackThreadSupplier;
            this.queueingThreadSupplier = queueingThreadSupplier;
            this.synchronizeCodecInteractionsWithQueueing = synchronizeCodecInteractionsWithQueueing;
            this.enableImmediateCodecStartAfterFlush = enableImmediateCodecStartAfterFlush;
        }

        @Override
        public AsynchronousMediaCodecAdapter createAdapter(MediaCodecAdapter.Configuration configuration) throws IOException {
            String codecName = configuration.codecInfo.name;
            AsynchronousMediaCodecAdapter codecAdapter = null;
            MediaCodec codec = null;
            try {
                String string = String.valueOf(codecName);
                TraceUtil.beginSection((String)(string.length() != 0 ? "createCodec:".concat(string) : new String("createCodec:")));
                codec = MediaCodec.createByCodecName((String)codecName);
                codecAdapter = new AsynchronousMediaCodecAdapter(codec, (HandlerThread)this.callbackThreadSupplier.get(), (HandlerThread)this.queueingThreadSupplier.get(), this.synchronizeCodecInteractionsWithQueueing, this.enableImmediateCodecStartAfterFlush);
                TraceUtil.endSection();
                codecAdapter.initialize(configuration.mediaFormat, configuration.surface, configuration.crypto, configuration.flags);
                return codecAdapter;
            }
            catch (Exception e) {
                if (codecAdapter != null) {
                    codecAdapter.release();
                } else if (codec != null) {
                    codec.release();
                }
                throw e;
            }
        }
    }
}

