/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.mediacodec;

import android.annotation.TargetApi;
import android.media.MediaCodec;
import android.media.MediaCrypto;
import android.media.MediaCryptoException;
import android.media.MediaFormat;
import android.media.metrics.LogSessionId;
import android.os.Bundle;
import android.os.SystemClock;
import androidx.annotation.CallSuper;
import androidx.annotation.CheckResult;
import androidx.annotation.DoNotInline;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import com.google.android.exoplayer2.BaseRenderer;
import com.google.android.exoplayer2.C;
import com.google.android.exoplayer2.ExoPlaybackException;
import com.google.android.exoplayer2.Format;
import com.google.android.exoplayer2.FormatHolder;
import com.google.android.exoplayer2.analytics.PlayerId;
import com.google.android.exoplayer2.decoder.CryptoConfig;
import com.google.android.exoplayer2.decoder.DecoderCounters;
import com.google.android.exoplayer2.decoder.DecoderInputBuffer;
import com.google.android.exoplayer2.decoder.DecoderReuseEvaluation;
import com.google.android.exoplayer2.drm.DrmSession;
import com.google.android.exoplayer2.drm.FrameworkCryptoConfig;
import com.google.android.exoplayer2.mediacodec.BatchBuffer;
import com.google.android.exoplayer2.mediacodec.C2Mp3TimestampTracker;
import com.google.android.exoplayer2.mediacodec.MediaCodecAdapter;
import com.google.android.exoplayer2.mediacodec.MediaCodecDecoderException;
import com.google.android.exoplayer2.mediacodec.MediaCodecInfo;
import com.google.android.exoplayer2.mediacodec.MediaCodecSelector;
import com.google.android.exoplayer2.mediacodec.MediaCodecUtil;
import com.google.android.exoplayer2.util.Assertions;
import com.google.android.exoplayer2.util.Log;
import com.google.android.exoplayer2.util.NalUnitUtil;
import com.google.android.exoplayer2.util.TimedValueQueue;
import com.google.android.exoplayer2.util.TraceUtil;
import com.google.android.exoplayer2.util.Util;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;

public abstract class MediaCodecRenderer
extends BaseRenderer {
    protected static final float CODEC_OPERATING_RATE_UNSET = -1.0f;
    private static final String TAG = "MediaCodecRenderer";
    private static final long MAX_CODEC_HOTSWAP_TIME_MS = 1000L;
    private static final int MAX_PENDING_OUTPUT_STREAM_OFFSET_COUNT = 10;
    private static final int RECONFIGURATION_STATE_NONE = 0;
    private static final int RECONFIGURATION_STATE_WRITE_PENDING = 1;
    private static final int RECONFIGURATION_STATE_QUEUE_PENDING = 2;
    private static final int DRAIN_STATE_NONE = 0;
    private static final int DRAIN_STATE_SIGNAL_END_OF_STREAM = 1;
    private static final int DRAIN_STATE_WAIT_END_OF_STREAM = 2;
    private static final int DRAIN_ACTION_NONE = 0;
    private static final int DRAIN_ACTION_FLUSH = 1;
    private static final int DRAIN_ACTION_FLUSH_AND_UPDATE_DRM_SESSION = 2;
    private static final int DRAIN_ACTION_REINITIALIZE = 3;
    private static final int ADAPTATION_WORKAROUND_MODE_NEVER = 0;
    private static final int ADAPTATION_WORKAROUND_MODE_SAME_RESOLUTION = 1;
    private static final int ADAPTATION_WORKAROUND_MODE_ALWAYS = 2;
    private static final byte[] ADAPTATION_WORKAROUND_BUFFER = new byte[]{0, 0, 1, 103, 66, -64, 11, -38, 37, -112, 0, 0, 1, 104, -50, 15, 19, 32, 0, 0, 1, 101, -120, -124, 13, -50, 113, 24, -96, 0, 47, -65, 28, 49, -61, 39, 93, 120};
    private static final int ADAPTATION_WORKAROUND_SLICE_WIDTH_HEIGHT = 32;
    private final MediaCodecAdapter.Factory codecAdapterFactory;
    private final MediaCodecSelector mediaCodecSelector;
    private final boolean enableDecoderFallback;
    private final float assumedMinimumCodecOperatingRate;
    private final DecoderInputBuffer noDataBuffer;
    private final DecoderInputBuffer buffer;
    private final DecoderInputBuffer bypassSampleBuffer;
    private final BatchBuffer bypassBatchBuffer;
    private final TimedValueQueue<Format> formatQueue;
    private final ArrayList<Long> decodeOnlyPresentationTimestamps;
    private final MediaCodec.BufferInfo outputBufferInfo;
    private final long[] pendingOutputStreamStartPositionsUs;
    private final long[] pendingOutputStreamOffsetsUs;
    private final long[] pendingOutputStreamSwitchTimesUs;
    @Nullable
    private Format inputFormat;
    @Nullable
    private Format outputFormat;
    @Nullable
    private DrmSession codecDrmSession;
    @Nullable
    private DrmSession sourceDrmSession;
    @Nullable
    private MediaCrypto mediaCrypto;
    private boolean mediaCryptoRequiresSecureDecoder;
    private long renderTimeLimitMs;
    private float currentPlaybackSpeed;
    private float targetPlaybackSpeed;
    @Nullable
    private MediaCodecAdapter codec;
    @Nullable
    private Format codecInputFormat;
    @Nullable
    private MediaFormat codecOutputMediaFormat;
    private boolean codecOutputMediaFormatChanged;
    private float codecOperatingRate;
    @Nullable
    private ArrayDeque<MediaCodecInfo> availableCodecInfos;
    @Nullable
    private DecoderInitializationException preferredDecoderInitializationException;
    @Nullable
    private MediaCodecInfo codecInfo;
    private int codecAdaptationWorkaroundMode;
    private boolean codecNeedsDiscardToSpsWorkaround;
    private boolean codecNeedsFlushWorkaround;
    private boolean codecNeedsSosFlushWorkaround;
    private boolean codecNeedsEosFlushWorkaround;
    private boolean codecNeedsEosOutputExceptionWorkaround;
    private boolean codecNeedsEosBufferTimestampWorkaround;
    private boolean codecNeedsMonoChannelCountWorkaround;
    private boolean codecNeedsAdaptationWorkaroundBuffer;
    private boolean shouldSkipAdaptationWorkaroundOutputBuffer;
    private boolean codecNeedsEosPropagation;
    @Nullable
    private C2Mp3TimestampTracker c2Mp3TimestampTracker;
    private long codecHotswapDeadlineMs;
    private int inputIndex;
    private int outputIndex;
    @Nullable
    private ByteBuffer outputBuffer;
    private boolean isDecodeOnlyOutputBuffer;
    private boolean isLastOutputBuffer;
    private boolean bypassEnabled;
    private boolean bypassSampleBufferPending;
    private boolean bypassDrainAndReinitialize;
    private boolean codecReconfigured;
    private int codecReconfigurationState;
    private int codecDrainState;
    private int codecDrainAction;
    private boolean codecReceivedBuffers;
    private boolean codecReceivedEos;
    private boolean codecHasOutputMediaFormat;
    private long largestQueuedPresentationTimeUs;
    private long lastBufferInStreamPresentationTimeUs;
    private boolean inputStreamEnded;
    private boolean outputStreamEnded;
    private boolean waitingForFirstSampleInFormat;
    private boolean pendingOutputEndOfStream;
    @Nullable
    private ExoPlaybackException pendingPlaybackException;
    protected DecoderCounters decoderCounters;
    private long outputStreamStartPositionUs;
    private long outputStreamOffsetUs;
    private int pendingOutputStreamOffsetCount;

    public MediaCodecRenderer(int trackType, MediaCodecAdapter.Factory codecAdapterFactory, MediaCodecSelector mediaCodecSelector, boolean enableDecoderFallback, float assumedMinimumCodecOperatingRate) {
        super(trackType);
        this.codecAdapterFactory = codecAdapterFactory;
        this.mediaCodecSelector = (MediaCodecSelector)Assertions.checkNotNull((Object)mediaCodecSelector);
        this.enableDecoderFallback = enableDecoderFallback;
        this.assumedMinimumCodecOperatingRate = assumedMinimumCodecOperatingRate;
        this.noDataBuffer = DecoderInputBuffer.newNoDataInstance();
        this.buffer = new DecoderInputBuffer(0);
        this.bypassSampleBuffer = new DecoderInputBuffer(2);
        this.bypassBatchBuffer = new BatchBuffer();
        this.formatQueue = new TimedValueQueue();
        this.decodeOnlyPresentationTimestamps = new ArrayList();
        this.outputBufferInfo = new MediaCodec.BufferInfo();
        this.currentPlaybackSpeed = 1.0f;
        this.targetPlaybackSpeed = 1.0f;
        this.renderTimeLimitMs = -9223372036854775807L;
        this.pendingOutputStreamStartPositionsUs = new long[10];
        this.pendingOutputStreamOffsetsUs = new long[10];
        this.pendingOutputStreamSwitchTimesUs = new long[10];
        this.outputStreamStartPositionUs = -9223372036854775807L;
        this.outputStreamOffsetUs = -9223372036854775807L;
        this.bypassBatchBuffer.ensureSpaceForWrite(0);
        this.bypassBatchBuffer.data.order(ByteOrder.nativeOrder());
        this.codecOperatingRate = -1.0f;
        this.codecAdaptationWorkaroundMode = 0;
        this.codecReconfigurationState = 0;
        this.inputIndex = -1;
        this.outputIndex = -1;
        this.codecHotswapDeadlineMs = -9223372036854775807L;
        this.largestQueuedPresentationTimeUs = -9223372036854775807L;
        this.lastBufferInStreamPresentationTimeUs = -9223372036854775807L;
        this.codecDrainState = 0;
        this.codecDrainAction = 0;
    }

    public void setRenderTimeLimitMs(long renderTimeLimitMs) {
        this.renderTimeLimitMs = renderTimeLimitMs;
    }

    @Override
    public final int supportsMixedMimeTypeAdaptation() {
        return 8;
    }

    @Override
    public final int supportsFormat(Format format) throws ExoPlaybackException {
        try {
            return this.supportsFormat(this.mediaCodecSelector, format);
        }
        catch (MediaCodecUtil.DecoderQueryException e) {
            throw this.createRendererException(e, format, 4002);
        }
    }

    protected abstract int supportsFormat(MediaCodecSelector var1, Format var2) throws MediaCodecUtil.DecoderQueryException;

    protected abstract List<MediaCodecInfo> getDecoderInfos(MediaCodecSelector var1, Format var2, boolean var3) throws MediaCodecUtil.DecoderQueryException;

    protected abstract MediaCodecAdapter.Configuration getMediaCodecConfiguration(MediaCodecInfo var1, Format var2, @Nullable MediaCrypto var3, float var4);

    protected final void maybeInitCodecOrBypass() throws ExoPlaybackException {
        if (this.codec != null || this.bypassEnabled || this.inputFormat == null) {
            return;
        }
        if (this.sourceDrmSession == null && this.shouldUseBypass(this.inputFormat)) {
            this.initBypass(this.inputFormat);
            return;
        }
        this.setCodecDrmSession(this.sourceDrmSession);
        String mimeType = this.inputFormat.sampleMimeType;
        if (this.codecDrmSession != null) {
            if (this.mediaCrypto == null) {
                FrameworkCryptoConfig sessionCryptoConfig = this.getFrameworkCryptoConfig(this.codecDrmSession);
                if (sessionCryptoConfig == null) {
                    DrmSession.DrmSessionException drmError = this.codecDrmSession.getError();
                    if (drmError == null) {
                        return;
                    }
                } else {
                    try {
                        this.mediaCrypto = new MediaCrypto(sessionCryptoConfig.uuid, sessionCryptoConfig.sessionId);
                    }
                    catch (MediaCryptoException e) {
                        throw this.createRendererException(e, this.inputFormat, 6006);
                    }
                    boolean bl = this.mediaCryptoRequiresSecureDecoder = !sessionCryptoConfig.forceAllowInsecureDecoderComponents && this.mediaCrypto.requiresSecureDecoderComponent(mimeType);
                }
            }
            if (FrameworkCryptoConfig.WORKAROUND_DEVICE_NEEDS_KEYS_TO_CONFIGURE_CODEC) {
                int drmSessionState = this.codecDrmSession.getState();
                if (drmSessionState == 1) {
                    DrmSession.DrmSessionException drmSessionException = (DrmSession.DrmSessionException)Assertions.checkNotNull((Object)this.codecDrmSession.getError());
                    throw this.createRendererException(drmSessionException, this.inputFormat, drmSessionException.errorCode);
                }
                if (drmSessionState != 4) {
                    return;
                }
            }
        }
        try {
            this.maybeInitCodecWithFallback(this.mediaCrypto, this.mediaCryptoRequiresSecureDecoder);
        }
        catch (DecoderInitializationException e) {
            throw this.createRendererException(e, this.inputFormat, 4001);
        }
    }

    protected boolean shouldUseBypass(Format format) {
        return false;
    }

    protected boolean shouldInitCodec(MediaCodecInfo codecInfo) {
        return true;
    }

    protected boolean shouldReinitCodec() {
        return false;
    }

    protected boolean getCodecNeedsEosPropagation() {
        return false;
    }

    protected final void setPendingPlaybackException(ExoPlaybackException exception) {
        this.pendingPlaybackException = exception;
    }

    protected final void updateOutputFormatForTime(long presentationTimeUs) throws ExoPlaybackException {
        boolean outputFormatChanged = false;
        Format format = (Format)this.formatQueue.pollFloor(presentationTimeUs);
        if (format == null && this.codecOutputMediaFormatChanged) {
            format = (Format)this.formatQueue.pollFirst();
        }
        if (format != null) {
            this.outputFormat = format;
            outputFormatChanged = true;
        }
        if (outputFormatChanged || this.codecOutputMediaFormatChanged && this.outputFormat != null) {
            this.onOutputFormatChanged(this.outputFormat, this.codecOutputMediaFormat);
            this.codecOutputMediaFormatChanged = false;
        }
    }

    @Nullable
    protected final MediaCodecAdapter getCodec() {
        return this.codec;
    }

    @Nullable
    protected final MediaFormat getCodecOutputMediaFormat() {
        return this.codecOutputMediaFormat;
    }

    @Nullable
    protected final MediaCodecInfo getCodecInfo() {
        return this.codecInfo;
    }

    @Override
    protected void onEnabled(boolean joining, boolean mayRenderStartOfStream) throws ExoPlaybackException {
        this.decoderCounters = new DecoderCounters();
    }

    @Override
    protected void onStreamChanged(Format[] formats, long startPositionUs, long offsetUs) throws ExoPlaybackException {
        if (this.outputStreamOffsetUs == -9223372036854775807L) {
            Assertions.checkState((this.outputStreamStartPositionUs == -9223372036854775807L ? 1 : 0) != 0);
            this.outputStreamStartPositionUs = startPositionUs;
            this.outputStreamOffsetUs = offsetUs;
        } else {
            if (this.pendingOutputStreamOffsetCount == this.pendingOutputStreamOffsetsUs.length) {
                long l = this.pendingOutputStreamOffsetsUs[this.pendingOutputStreamOffsetCount - 1];
                Log.w((String)TAG, (String)new StringBuilder(65).append("Too many stream changes, so dropping offset: ").append(l).toString());
            } else {
                ++this.pendingOutputStreamOffsetCount;
            }
            this.pendingOutputStreamStartPositionsUs[this.pendingOutputStreamOffsetCount - 1] = startPositionUs;
            this.pendingOutputStreamOffsetsUs[this.pendingOutputStreamOffsetCount - 1] = offsetUs;
            this.pendingOutputStreamSwitchTimesUs[this.pendingOutputStreamOffsetCount - 1] = this.largestQueuedPresentationTimeUs;
        }
    }

    @Override
    protected void onPositionReset(long positionUs, boolean joining) throws ExoPlaybackException {
        this.inputStreamEnded = false;
        this.outputStreamEnded = false;
        this.pendingOutputEndOfStream = false;
        if (this.bypassEnabled) {
            this.bypassBatchBuffer.clear();
            this.bypassSampleBuffer.clear();
            this.bypassSampleBufferPending = false;
        } else {
            this.flushOrReinitializeCodec();
        }
        if (this.formatQueue.size() > 0) {
            this.waitingForFirstSampleInFormat = true;
        }
        this.formatQueue.clear();
        if (this.pendingOutputStreamOffsetCount != 0) {
            this.outputStreamOffsetUs = this.pendingOutputStreamOffsetsUs[this.pendingOutputStreamOffsetCount - 1];
            this.outputStreamStartPositionUs = this.pendingOutputStreamStartPositionsUs[this.pendingOutputStreamOffsetCount - 1];
            this.pendingOutputStreamOffsetCount = 0;
        }
    }

    @Override
    public void setPlaybackSpeed(float currentPlaybackSpeed, float targetPlaybackSpeed) throws ExoPlaybackException {
        this.currentPlaybackSpeed = currentPlaybackSpeed;
        this.targetPlaybackSpeed = targetPlaybackSpeed;
        this.updateCodecOperatingRate(this.codecInputFormat);
    }

    @Override
    protected void onDisabled() {
        this.inputFormat = null;
        this.outputStreamStartPositionUs = -9223372036854775807L;
        this.outputStreamOffsetUs = -9223372036854775807L;
        this.pendingOutputStreamOffsetCount = 0;
        this.flushOrReleaseCodec();
    }

    @Override
    protected void onReset() {
        try {
            this.disableBypass();
            this.releaseCodec();
        }
        finally {
            this.setSourceDrmSession(null);
        }
    }

    private void disableBypass() {
        this.bypassDrainAndReinitialize = false;
        this.bypassBatchBuffer.clear();
        this.bypassSampleBuffer.clear();
        this.bypassSampleBufferPending = false;
        this.bypassEnabled = false;
    }

    protected void releaseCodec() {
        try {
            if (this.codec != null) {
                this.codec.release();
                ++this.decoderCounters.decoderReleaseCount;
                this.onCodecReleased(this.codecInfo.name);
            }
        }
        finally {
            this.codec = null;
            try {
                if (this.mediaCrypto != null) {
                    this.mediaCrypto.release();
                }
            }
            finally {
                this.mediaCrypto = null;
                this.setCodecDrmSession(null);
                this.resetCodecStateForRelease();
            }
        }
    }

    @Override
    protected void onStarted() {
    }

    @Override
    protected void onStopped() {
    }

    @Override
    public void render(long positionUs, long elapsedRealtimeUs) throws ExoPlaybackException {
        if (this.pendingOutputEndOfStream) {
            this.pendingOutputEndOfStream = false;
            this.processEndOfStream();
        }
        if (this.pendingPlaybackException != null) {
            ExoPlaybackException playbackException = this.pendingPlaybackException;
            this.pendingPlaybackException = null;
            throw playbackException;
        }
        try {
            if (this.outputStreamEnded) {
                this.renderToEndOfStream();
                return;
            }
            if (this.inputFormat == null && !this.readSourceOmittingSampleData(2)) {
                return;
            }
            this.maybeInitCodecOrBypass();
            if (this.bypassEnabled) {
                TraceUtil.beginSection((String)"bypassRender");
                while (this.bypassRender(positionUs, elapsedRealtimeUs)) {
                }
                TraceUtil.endSection();
            } else if (this.codec != null) {
                long renderStartTimeMs = SystemClock.elapsedRealtime();
                TraceUtil.beginSection((String)"drainAndFeed");
                while (this.drainOutputBuffer(positionUs, elapsedRealtimeUs) && this.shouldContinueRendering(renderStartTimeMs)) {
                }
                while (this.feedInputBuffer() && this.shouldContinueRendering(renderStartTimeMs)) {
                }
                TraceUtil.endSection();
            } else {
                this.decoderCounters.skippedInputBufferCount += this.skipSource(positionUs);
                this.readSourceOmittingSampleData(1);
            }
            this.decoderCounters.ensureUpdated();
        }
        catch (IllegalStateException e) {
            if (MediaCodecRenderer.isMediaCodecException(e)) {
                boolean isRecoverable;
                this.onCodecError(e);
                boolean bl = isRecoverable = Util.SDK_INT >= 21 && MediaCodecRenderer.isRecoverableMediaCodecExceptionV21(e);
                if (isRecoverable) {
                    this.releaseCodec();
                }
                throw this.createRendererException((Throwable)((Object)this.createDecoderException(e, this.getCodecInfo())), this.inputFormat, isRecoverable, 4003);
            }
            throw e;
        }
    }

    protected final boolean flushOrReinitializeCodec() throws ExoPlaybackException {
        boolean released = this.flushOrReleaseCodec();
        if (released) {
            this.maybeInitCodecOrBypass();
        }
        return released;
    }

    protected boolean flushOrReleaseCodec() {
        if (this.codec == null) {
            return false;
        }
        if (this.codecDrainAction == 3 || this.codecNeedsFlushWorkaround || this.codecNeedsSosFlushWorkaround && !this.codecHasOutputMediaFormat || this.codecNeedsEosFlushWorkaround && this.codecReceivedEos) {
            this.releaseCodec();
            return true;
        }
        this.flushCodec();
        return false;
    }

    private void flushCodec() {
        try {
            this.codec.flush();
        }
        finally {
            this.resetCodecStateForFlush();
        }
    }

    @CallSuper
    protected void resetCodecStateForFlush() {
        this.resetInputBuffer();
        this.resetOutputBuffer();
        this.codecHotswapDeadlineMs = -9223372036854775807L;
        this.codecReceivedEos = false;
        this.codecReceivedBuffers = false;
        this.codecNeedsAdaptationWorkaroundBuffer = false;
        this.shouldSkipAdaptationWorkaroundOutputBuffer = false;
        this.isDecodeOnlyOutputBuffer = false;
        this.isLastOutputBuffer = false;
        this.decodeOnlyPresentationTimestamps.clear();
        this.largestQueuedPresentationTimeUs = -9223372036854775807L;
        this.lastBufferInStreamPresentationTimeUs = -9223372036854775807L;
        if (this.c2Mp3TimestampTracker != null) {
            this.c2Mp3TimestampTracker.reset();
        }
        this.codecDrainState = 0;
        this.codecDrainAction = 0;
        this.codecReconfigurationState = this.codecReconfigured ? 1 : 0;
    }

    @CallSuper
    protected void resetCodecStateForRelease() {
        this.resetCodecStateForFlush();
        this.pendingPlaybackException = null;
        this.c2Mp3TimestampTracker = null;
        this.availableCodecInfos = null;
        this.codecInfo = null;
        this.codecInputFormat = null;
        this.codecOutputMediaFormat = null;
        this.codecOutputMediaFormatChanged = false;
        this.codecHasOutputMediaFormat = false;
        this.codecOperatingRate = -1.0f;
        this.codecAdaptationWorkaroundMode = 0;
        this.codecNeedsDiscardToSpsWorkaround = false;
        this.codecNeedsFlushWorkaround = false;
        this.codecNeedsSosFlushWorkaround = false;
        this.codecNeedsEosFlushWorkaround = false;
        this.codecNeedsEosOutputExceptionWorkaround = false;
        this.codecNeedsEosBufferTimestampWorkaround = false;
        this.codecNeedsMonoChannelCountWorkaround = false;
        this.codecNeedsEosPropagation = false;
        this.codecReconfigured = false;
        this.codecReconfigurationState = 0;
        this.mediaCryptoRequiresSecureDecoder = false;
    }

    protected MediaCodecDecoderException createDecoderException(Throwable cause, @Nullable MediaCodecInfo codecInfo) {
        return new MediaCodecDecoderException(cause, codecInfo);
    }

    private boolean readSourceOmittingSampleData(int readFlags) throws ExoPlaybackException {
        FormatHolder formatHolder = this.getFormatHolder();
        this.noDataBuffer.clear();
        int result = this.readSource(formatHolder, this.noDataBuffer, readFlags | 4);
        if (result == -5) {
            this.onInputFormatChanged(formatHolder);
            return true;
        }
        if (result == -4 && this.noDataBuffer.isEndOfStream()) {
            this.inputStreamEnded = true;
            this.processEndOfStream();
        }
        return false;
    }

    private void maybeInitCodecWithFallback(MediaCrypto crypto, boolean mediaCryptoRequiresSecureDecoder) throws DecoderInitializationException {
        if (this.availableCodecInfos == null) {
            try {
                List<MediaCodecInfo> allAvailableCodecInfos = this.getAvailableCodecInfos(mediaCryptoRequiresSecureDecoder);
                this.availableCodecInfos = new ArrayDeque();
                if (this.enableDecoderFallback) {
                    this.availableCodecInfos.addAll(allAvailableCodecInfos);
                } else if (!allAvailableCodecInfos.isEmpty()) {
                    this.availableCodecInfos.add(allAvailableCodecInfos.get(0));
                }
                this.preferredDecoderInitializationException = null;
            }
            catch (MediaCodecUtil.DecoderQueryException e) {
                throw new DecoderInitializationException(this.inputFormat, (Throwable)e, mediaCryptoRequiresSecureDecoder, -49998);
            }
        }
        if (this.availableCodecInfos.isEmpty()) {
            throw new DecoderInitializationException(this.inputFormat, null, mediaCryptoRequiresSecureDecoder, -49999);
        }
        MediaCodecInfo preferredCodecInfo = this.availableCodecInfos.peekFirst();
        while (this.codec == null) {
            MediaCodecInfo codecInfo = this.availableCodecInfos.peekFirst();
            if (!this.shouldInitCodec(codecInfo)) {
                return;
            }
            try {
                try {
                    this.initCodec(codecInfo, crypto);
                }
                catch (Exception e) {
                    if (codecInfo == preferredCodecInfo) {
                        Log.w((String)TAG, (String)"Preferred decoder instantiation failed. Sleeping for 50ms then retrying.");
                        Thread.sleep(50L);
                        this.initCodec(codecInfo, crypto);
                        continue;
                    }
                    throw e;
                }
            }
            catch (Exception e) {
                String string = String.valueOf(codecInfo);
                Log.w((String)TAG, (String)new StringBuilder(30 + String.valueOf(string).length()).append("Failed to initialize decoder: ").append(string).toString(), (Throwable)e);
                this.availableCodecInfos.removeFirst();
                DecoderInitializationException exception = new DecoderInitializationException(this.inputFormat, (Throwable)e, mediaCryptoRequiresSecureDecoder, codecInfo);
                this.onCodecError(exception);
                this.preferredDecoderInitializationException = this.preferredDecoderInitializationException == null ? exception : this.preferredDecoderInitializationException.copyWithFallbackException(exception);
                if (!this.availableCodecInfos.isEmpty()) continue;
                throw this.preferredDecoderInitializationException;
            }
        }
        this.availableCodecInfos = null;
    }

    private List<MediaCodecInfo> getAvailableCodecInfos(boolean mediaCryptoRequiresSecureDecoder) throws MediaCodecUtil.DecoderQueryException {
        List<MediaCodecInfo> codecInfos = this.getDecoderInfos(this.mediaCodecSelector, this.inputFormat, mediaCryptoRequiresSecureDecoder);
        if (codecInfos.isEmpty() && mediaCryptoRequiresSecureDecoder && !(codecInfos = this.getDecoderInfos(this.mediaCodecSelector, this.inputFormat, false)).isEmpty()) {
            String string = this.inputFormat.sampleMimeType;
            String string2 = String.valueOf(codecInfos);
            Log.w((String)TAG, (String)new StringBuilder(99 + String.valueOf(string).length() + String.valueOf(string2).length()).append("Drm session requires secure decoder for ").append(string).append(", but no secure decoder available. Trying to proceed with ").append(string2).append(".").toString());
        }
        return codecInfos;
    }

    private void initBypass(Format format) {
        this.disableBypass();
        String mimeType = format.sampleMimeType;
        if (!("audio/mp4a-latm".equals(mimeType) || "audio/mpeg".equals(mimeType) || "audio/opus".equals(mimeType))) {
            this.bypassBatchBuffer.setMaxSampleCount(1);
        } else {
            this.bypassBatchBuffer.setMaxSampleCount(32);
        }
        this.bypassEnabled = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initCodec(MediaCodecInfo codecInfo, MediaCrypto crypto) throws Exception {
        float codecOperatingRate;
        String codecName = codecInfo.name;
        float f = codecOperatingRate = Util.SDK_INT < 23 ? -1.0f : this.getCodecOperatingRateV23(this.targetPlaybackSpeed, this.inputFormat, this.getStreamFormats());
        if (codecOperatingRate <= this.assumedMinimumCodecOperatingRate) {
            codecOperatingRate = -1.0f;
        }
        long codecInitializingTimestamp = SystemClock.elapsedRealtime();
        MediaCodecAdapter.Configuration configuration = this.getMediaCodecConfiguration(codecInfo, this.inputFormat, crypto, codecOperatingRate);
        if (Util.SDK_INT >= 31) {
            Api31.setLogSessionIdToMediaCodecFormat(configuration, this.getPlayerId());
        }
        try {
            String string = String.valueOf(codecName);
            TraceUtil.beginSection((String)(string.length() != 0 ? "createCodec:".concat(string) : new String("createCodec:")));
            this.codec = this.codecAdapterFactory.createAdapter(configuration);
        }
        finally {
            TraceUtil.endSection();
        }
        long codecInitializedTimestamp = SystemClock.elapsedRealtime();
        this.codecInfo = codecInfo;
        this.codecOperatingRate = codecOperatingRate;
        this.codecInputFormat = this.inputFormat;
        this.codecAdaptationWorkaroundMode = this.codecAdaptationWorkaroundMode(codecName);
        this.codecNeedsDiscardToSpsWorkaround = MediaCodecRenderer.codecNeedsDiscardToSpsWorkaround(codecName, this.codecInputFormat);
        this.codecNeedsFlushWorkaround = MediaCodecRenderer.codecNeedsFlushWorkaround(codecName);
        this.codecNeedsSosFlushWorkaround = MediaCodecRenderer.codecNeedsSosFlushWorkaround(codecName);
        this.codecNeedsEosFlushWorkaround = MediaCodecRenderer.codecNeedsEosFlushWorkaround(codecName);
        this.codecNeedsEosOutputExceptionWorkaround = MediaCodecRenderer.codecNeedsEosOutputExceptionWorkaround(codecName);
        this.codecNeedsEosBufferTimestampWorkaround = MediaCodecRenderer.codecNeedsEosBufferTimestampWorkaround(codecName);
        this.codecNeedsMonoChannelCountWorkaround = MediaCodecRenderer.codecNeedsMonoChannelCountWorkaround(codecName, this.codecInputFormat);
        boolean bl = this.codecNeedsEosPropagation = MediaCodecRenderer.codecNeedsEosPropagationWorkaround(codecInfo) || this.getCodecNeedsEosPropagation();
        if (this.codec.needsReconfiguration()) {
            this.codecReconfigured = true;
            this.codecReconfigurationState = 1;
            boolean bl2 = this.codecNeedsAdaptationWorkaroundBuffer = this.codecAdaptationWorkaroundMode != 0;
        }
        if ("c2.android.mp3.decoder".equals(codecInfo.name)) {
            this.c2Mp3TimestampTracker = new C2Mp3TimestampTracker();
        }
        if (this.getState() == 2) {
            this.codecHotswapDeadlineMs = SystemClock.elapsedRealtime() + 1000L;
        }
        ++this.decoderCounters.decoderInitCount;
        long elapsed = codecInitializedTimestamp - codecInitializingTimestamp;
        this.onCodecInitialized(codecName, configuration, codecInitializedTimestamp, elapsed);
    }

    private boolean shouldContinueRendering(long renderStartTimeMs) {
        return this.renderTimeLimitMs == -9223372036854775807L || SystemClock.elapsedRealtime() - renderStartTimeMs < this.renderTimeLimitMs;
    }

    private boolean hasOutputBuffer() {
        return this.outputIndex >= 0;
    }

    private void resetInputBuffer() {
        this.inputIndex = -1;
        this.buffer.data = null;
    }

    private void resetOutputBuffer() {
        this.outputIndex = -1;
        this.outputBuffer = null;
    }

    private void setSourceDrmSession(@Nullable DrmSession session) {
        DrmSession.replaceSession(this.sourceDrmSession, session);
        this.sourceDrmSession = session;
    }

    private void setCodecDrmSession(@Nullable DrmSession session) {
        DrmSession.replaceSession(this.codecDrmSession, session);
        this.codecDrmSession = session;
    }

    private boolean feedInputBuffer() throws ExoPlaybackException {
        int result;
        if (this.codec == null || this.codecDrainState == 2 || this.inputStreamEnded) {
            return false;
        }
        if (this.codecDrainState == 0 && this.shouldReinitCodec()) {
            this.drainAndReinitializeCodec();
        }
        if (this.inputIndex < 0) {
            this.inputIndex = this.codec.dequeueInputBufferIndex();
            if (this.inputIndex < 0) {
                return false;
            }
            this.buffer.data = this.codec.getInputBuffer(this.inputIndex);
            this.buffer.clear();
        }
        if (this.codecDrainState == 1) {
            if (!this.codecNeedsEosPropagation) {
                this.codecReceivedEos = true;
                this.codec.queueInputBuffer(this.inputIndex, 0, 0, 0L, 4);
                this.resetInputBuffer();
            }
            this.codecDrainState = 2;
            return false;
        }
        if (this.codecNeedsAdaptationWorkaroundBuffer) {
            this.codecNeedsAdaptationWorkaroundBuffer = false;
            this.buffer.data.put(ADAPTATION_WORKAROUND_BUFFER);
            this.codec.queueInputBuffer(this.inputIndex, 0, ADAPTATION_WORKAROUND_BUFFER.length, 0L, 0);
            this.resetInputBuffer();
            this.codecReceivedBuffers = true;
            return true;
        }
        if (this.codecReconfigurationState == 1) {
            for (int i = 0; i < this.codecInputFormat.initializationData.size(); ++i) {
                byte[] data = (byte[])this.codecInputFormat.initializationData.get(i);
                this.buffer.data.put(data);
            }
            this.codecReconfigurationState = 2;
        }
        int adaptiveReconfigurationBytes = this.buffer.data.position();
        FormatHolder formatHolder = this.getFormatHolder();
        try {
            result = this.readSource(formatHolder, this.buffer, 0);
        }
        catch (DecoderInputBuffer.InsufficientCapacityException e) {
            this.onCodecError((Exception)((Object)e));
            this.readSourceOmittingSampleData(0);
            this.flushCodec();
            return true;
        }
        if (this.hasReadStreamToEnd()) {
            this.lastBufferInStreamPresentationTimeUs = this.largestQueuedPresentationTimeUs;
        }
        if (result == -3) {
            return false;
        }
        if (result == -5) {
            if (this.codecReconfigurationState == 2) {
                this.buffer.clear();
                this.codecReconfigurationState = 1;
            }
            this.onInputFormatChanged(formatHolder);
            return true;
        }
        if (this.buffer.isEndOfStream()) {
            if (this.codecReconfigurationState == 2) {
                this.buffer.clear();
                this.codecReconfigurationState = 1;
            }
            this.inputStreamEnded = true;
            if (!this.codecReceivedBuffers) {
                this.processEndOfStream();
                return false;
            }
            try {
                if (!this.codecNeedsEosPropagation) {
                    this.codecReceivedEos = true;
                    this.codec.queueInputBuffer(this.inputIndex, 0, 0, 0L, 4);
                    this.resetInputBuffer();
                }
            }
            catch (MediaCodec.CryptoException e) {
                throw this.createRendererException(e, this.inputFormat, Util.getErrorCodeForMediaDrmErrorCode((int)e.getErrorCode()));
            }
            return false;
        }
        if (!this.codecReceivedBuffers && !this.buffer.isKeyFrame()) {
            this.buffer.clear();
            if (this.codecReconfigurationState == 2) {
                this.codecReconfigurationState = 1;
            }
            return true;
        }
        boolean bufferEncrypted = this.buffer.isEncrypted();
        if (bufferEncrypted) {
            this.buffer.cryptoInfo.increaseClearDataFirstSubSampleBy(adaptiveReconfigurationBytes);
        }
        if (this.codecNeedsDiscardToSpsWorkaround && !bufferEncrypted) {
            NalUnitUtil.discardToSps((ByteBuffer)this.buffer.data);
            if (this.buffer.data.position() == 0) {
                return true;
            }
            this.codecNeedsDiscardToSpsWorkaround = false;
        }
        long presentationTimeUs = this.buffer.timeUs;
        if (this.c2Mp3TimestampTracker != null) {
            presentationTimeUs = this.c2Mp3TimestampTracker.updateAndGetPresentationTimeUs(this.inputFormat, this.buffer);
            this.largestQueuedPresentationTimeUs = Math.max(this.largestQueuedPresentationTimeUs, this.c2Mp3TimestampTracker.getLastOutputBufferPresentationTimeUs(this.inputFormat));
        }
        if (this.buffer.isDecodeOnly()) {
            this.decodeOnlyPresentationTimestamps.add(presentationTimeUs);
        }
        if (this.waitingForFirstSampleInFormat) {
            this.formatQueue.add(presentationTimeUs, (Object)this.inputFormat);
            this.waitingForFirstSampleInFormat = false;
        }
        this.largestQueuedPresentationTimeUs = Math.max(this.largestQueuedPresentationTimeUs, presentationTimeUs);
        this.buffer.flip();
        if (this.buffer.hasSupplementalData()) {
            this.handleInputBufferSupplementalData(this.buffer);
        }
        this.onQueueInputBuffer(this.buffer);
        try {
            if (bufferEncrypted) {
                this.codec.queueSecureInputBuffer(this.inputIndex, 0, this.buffer.cryptoInfo, presentationTimeUs, 0);
            } else {
                this.codec.queueInputBuffer(this.inputIndex, 0, this.buffer.data.limit(), presentationTimeUs, 0);
            }
        }
        catch (MediaCodec.CryptoException e) {
            throw this.createRendererException(e, this.inputFormat, Util.getErrorCodeForMediaDrmErrorCode((int)e.getErrorCode()));
        }
        this.resetInputBuffer();
        this.codecReceivedBuffers = true;
        this.codecReconfigurationState = 0;
        ++this.decoderCounters.queuedInputBufferCount;
        return true;
    }

    protected void onCodecInitialized(String name, MediaCodecAdapter.Configuration configuration, long initializedTimestampMs, long initializationDurationMs) {
    }

    protected void onCodecReleased(String name) {
    }

    protected void onCodecError(Exception codecError) {
    }

    @CallSuper
    @Nullable
    protected DecoderReuseEvaluation onInputFormatChanged(FormatHolder formatHolder) throws ExoPlaybackException {
        this.waitingForFirstSampleInFormat = true;
        Format newFormat = (Format)Assertions.checkNotNull((Object)formatHolder.format);
        if (newFormat.sampleMimeType == null) {
            throw this.createRendererException(new IllegalArgumentException(), newFormat, 4005);
        }
        this.setSourceDrmSession(formatHolder.drmSession);
        this.inputFormat = newFormat;
        if (this.bypassEnabled) {
            this.bypassDrainAndReinitialize = true;
            return null;
        }
        if (this.codec == null) {
            this.availableCodecInfos = null;
            this.maybeInitCodecOrBypass();
            return null;
        }
        MediaCodecAdapter codec = this.codec;
        MediaCodecInfo codecInfo = this.codecInfo;
        Format oldFormat = this.codecInputFormat;
        if (this.drmNeedsCodecReinitialization(codecInfo, newFormat, this.codecDrmSession, this.sourceDrmSession)) {
            this.drainAndReinitializeCodec();
            return new DecoderReuseEvaluation(codecInfo.name, oldFormat, newFormat, 0, 128);
        }
        boolean drainAndUpdateCodecDrmSession = this.sourceDrmSession != this.codecDrmSession;
        Assertions.checkState((!drainAndUpdateCodecDrmSession || Util.SDK_INT >= 23 ? 1 : 0) != 0);
        DecoderReuseEvaluation evaluation = this.canReuseCodec(codecInfo, oldFormat, newFormat);
        int overridingDiscardReasons = 0;
        switch (evaluation.result) {
            case 0: {
                this.drainAndReinitializeCodec();
                break;
            }
            case 1: {
                if (!this.updateCodecOperatingRate(newFormat)) {
                    overridingDiscardReasons |= 0x10;
                    break;
                }
                this.codecInputFormat = newFormat;
                if (drainAndUpdateCodecDrmSession) {
                    if (this.drainAndUpdateCodecDrmSessionV23()) break;
                    overridingDiscardReasons |= 2;
                    break;
                }
                if (this.drainAndFlushCodec()) break;
                overridingDiscardReasons |= 2;
                break;
            }
            case 2: {
                if (!this.updateCodecOperatingRate(newFormat)) {
                    overridingDiscardReasons |= 0x10;
                    break;
                }
                this.codecReconfigured = true;
                this.codecReconfigurationState = 1;
                this.codecNeedsAdaptationWorkaroundBuffer = this.codecAdaptationWorkaroundMode == 2 || this.codecAdaptationWorkaroundMode == 1 && newFormat.width == oldFormat.width && newFormat.height == oldFormat.height;
                this.codecInputFormat = newFormat;
                if (!drainAndUpdateCodecDrmSession || this.drainAndUpdateCodecDrmSessionV23()) break;
                overridingDiscardReasons |= 2;
                break;
            }
            case 3: {
                if (!this.updateCodecOperatingRate(newFormat)) {
                    overridingDiscardReasons |= 0x10;
                    break;
                }
                this.codecInputFormat = newFormat;
                if (!drainAndUpdateCodecDrmSession || this.drainAndUpdateCodecDrmSessionV23()) break;
                overridingDiscardReasons |= 2;
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        if (evaluation.result != 0 && (this.codec != codec || this.codecDrainAction == 3)) {
            return new DecoderReuseEvaluation(codecInfo.name, oldFormat, newFormat, 0, overridingDiscardReasons);
        }
        return evaluation;
    }

    protected void onOutputFormatChanged(Format format, @Nullable MediaFormat mediaFormat) throws ExoPlaybackException {
    }

    protected void handleInputBufferSupplementalData(DecoderInputBuffer buffer) throws ExoPlaybackException {
    }

    protected void onQueueInputBuffer(DecoderInputBuffer buffer) throws ExoPlaybackException {
    }

    @CallSuper
    protected void onProcessedOutputBuffer(long presentationTimeUs) {
        while (this.pendingOutputStreamOffsetCount != 0 && presentationTimeUs >= this.pendingOutputStreamSwitchTimesUs[0]) {
            this.outputStreamStartPositionUs = this.pendingOutputStreamStartPositionsUs[0];
            this.outputStreamOffsetUs = this.pendingOutputStreamOffsetsUs[0];
            --this.pendingOutputStreamOffsetCount;
            System.arraycopy(this.pendingOutputStreamStartPositionsUs, 1, this.pendingOutputStreamStartPositionsUs, 0, this.pendingOutputStreamOffsetCount);
            System.arraycopy(this.pendingOutputStreamOffsetsUs, 1, this.pendingOutputStreamOffsetsUs, 0, this.pendingOutputStreamOffsetCount);
            System.arraycopy(this.pendingOutputStreamSwitchTimesUs, 1, this.pendingOutputStreamSwitchTimesUs, 0, this.pendingOutputStreamOffsetCount);
            this.onProcessedStreamChange();
        }
    }

    protected void onProcessedStreamChange() {
    }

    protected DecoderReuseEvaluation canReuseCodec(MediaCodecInfo codecInfo, Format oldFormat, Format newFormat) {
        return new DecoderReuseEvaluation(codecInfo.name, oldFormat, newFormat, 0, 1);
    }

    @Override
    public boolean isEnded() {
        return this.outputStreamEnded;
    }

    @Override
    public boolean isReady() {
        return this.inputFormat != null && (this.isSourceReady() || this.hasOutputBuffer() || this.codecHotswapDeadlineMs != -9223372036854775807L && SystemClock.elapsedRealtime() < this.codecHotswapDeadlineMs);
    }

    protected float getPlaybackSpeed() {
        return this.currentPlaybackSpeed;
    }

    protected float getCodecOperatingRate() {
        return this.codecOperatingRate;
    }

    protected float getCodecOperatingRateV23(float targetPlaybackSpeed, Format format, Format[] streamFormats) {
        return -1.0f;
    }

    protected final boolean updateCodecOperatingRate() throws ExoPlaybackException {
        return this.updateCodecOperatingRate(this.codecInputFormat);
    }

    private boolean updateCodecOperatingRate(Format format) throws ExoPlaybackException {
        if (Util.SDK_INT < 23) {
            return true;
        }
        if (this.codec == null || this.codecDrainAction == 3 || this.getState() == 0) {
            return true;
        }
        float newCodecOperatingRate = this.getCodecOperatingRateV23(this.targetPlaybackSpeed, format, this.getStreamFormats());
        if (this.codecOperatingRate == newCodecOperatingRate) {
            return true;
        }
        if (newCodecOperatingRate == -1.0f) {
            this.drainAndReinitializeCodec();
            return false;
        }
        if (this.codecOperatingRate != -1.0f || newCodecOperatingRate > this.assumedMinimumCodecOperatingRate) {
            Bundle codecParameters = new Bundle();
            codecParameters.putFloat("operating-rate", newCodecOperatingRate);
            this.codec.setParameters(codecParameters);
            this.codecOperatingRate = newCodecOperatingRate;
            return true;
        }
        return true;
    }

    private boolean drainAndFlushCodec() {
        if (this.codecReceivedBuffers) {
            this.codecDrainState = 1;
            if (this.codecNeedsFlushWorkaround || this.codecNeedsEosFlushWorkaround) {
                this.codecDrainAction = 3;
                return false;
            }
            this.codecDrainAction = 1;
        }
        return true;
    }

    @TargetApi(value=23)
    private boolean drainAndUpdateCodecDrmSessionV23() throws ExoPlaybackException {
        if (this.codecReceivedBuffers) {
            this.codecDrainState = 1;
            if (this.codecNeedsFlushWorkaround || this.codecNeedsEosFlushWorkaround) {
                this.codecDrainAction = 3;
                return false;
            }
            this.codecDrainAction = 2;
        } else {
            this.updateDrmSessionV23();
        }
        return true;
    }

    private void drainAndReinitializeCodec() throws ExoPlaybackException {
        if (this.codecReceivedBuffers) {
            this.codecDrainState = 1;
            this.codecDrainAction = 3;
        } else {
            this.reinitializeCodec();
        }
    }

    private boolean drainOutputBuffer(long positionUs, long elapsedRealtimeUs) throws ExoPlaybackException {
        boolean processedOutputBuffer;
        if (!this.hasOutputBuffer()) {
            int outputIndex;
            if (this.codecNeedsEosOutputExceptionWorkaround && this.codecReceivedEos) {
                try {
                    outputIndex = this.codec.dequeueOutputBufferIndex(this.outputBufferInfo);
                }
                catch (IllegalStateException e) {
                    this.processEndOfStream();
                    if (this.outputStreamEnded) {
                        this.releaseCodec();
                    }
                    return false;
                }
            } else {
                outputIndex = this.codec.dequeueOutputBufferIndex(this.outputBufferInfo);
            }
            if (outputIndex < 0) {
                if (outputIndex == -2) {
                    this.processOutputMediaFormatChanged();
                    return true;
                }
                if (this.codecNeedsEosPropagation && (this.inputStreamEnded || this.codecDrainState == 2)) {
                    this.processEndOfStream();
                }
                return false;
            }
            if (this.shouldSkipAdaptationWorkaroundOutputBuffer) {
                this.shouldSkipAdaptationWorkaroundOutputBuffer = false;
                this.codec.releaseOutputBuffer(outputIndex, false);
                return true;
            }
            if (this.outputBufferInfo.size == 0 && (this.outputBufferInfo.flags & 4) != 0) {
                this.processEndOfStream();
                return false;
            }
            this.outputIndex = outputIndex;
            this.outputBuffer = this.codec.getOutputBuffer(outputIndex);
            if (this.outputBuffer != null) {
                this.outputBuffer.position(this.outputBufferInfo.offset);
                this.outputBuffer.limit(this.outputBufferInfo.offset + this.outputBufferInfo.size);
            }
            if (this.codecNeedsEosBufferTimestampWorkaround && this.outputBufferInfo.presentationTimeUs == 0L && (this.outputBufferInfo.flags & 4) != 0 && this.largestQueuedPresentationTimeUs != -9223372036854775807L) {
                this.outputBufferInfo.presentationTimeUs = this.largestQueuedPresentationTimeUs;
            }
            this.isDecodeOnlyOutputBuffer = this.isDecodeOnlyBuffer(this.outputBufferInfo.presentationTimeUs);
            this.isLastOutputBuffer = this.lastBufferInStreamPresentationTimeUs == this.outputBufferInfo.presentationTimeUs;
            this.updateOutputFormatForTime(this.outputBufferInfo.presentationTimeUs);
        }
        if (this.codecNeedsEosOutputExceptionWorkaround && this.codecReceivedEos) {
            try {
                processedOutputBuffer = this.processOutputBuffer(positionUs, elapsedRealtimeUs, this.codec, this.outputBuffer, this.outputIndex, this.outputBufferInfo.flags, 1, this.outputBufferInfo.presentationTimeUs, this.isDecodeOnlyOutputBuffer, this.isLastOutputBuffer, this.outputFormat);
            }
            catch (IllegalStateException e) {
                this.processEndOfStream();
                if (this.outputStreamEnded) {
                    this.releaseCodec();
                }
                return false;
            }
        } else {
            processedOutputBuffer = this.processOutputBuffer(positionUs, elapsedRealtimeUs, this.codec, this.outputBuffer, this.outputIndex, this.outputBufferInfo.flags, 1, this.outputBufferInfo.presentationTimeUs, this.isDecodeOnlyOutputBuffer, this.isLastOutputBuffer, this.outputFormat);
        }
        if (processedOutputBuffer) {
            this.onProcessedOutputBuffer(this.outputBufferInfo.presentationTimeUs);
            boolean isEndOfStream = (this.outputBufferInfo.flags & 4) != 0;
            this.resetOutputBuffer();
            if (!isEndOfStream) {
                return true;
            }
            this.processEndOfStream();
        }
        return false;
    }

    private void processOutputMediaFormatChanged() {
        this.codecHasOutputMediaFormat = true;
        MediaFormat mediaFormat = this.codec.getOutputFormat();
        if (this.codecAdaptationWorkaroundMode != 0 && mediaFormat.getInteger("width") == 32 && mediaFormat.getInteger("height") == 32) {
            this.shouldSkipAdaptationWorkaroundOutputBuffer = true;
            return;
        }
        if (this.codecNeedsMonoChannelCountWorkaround) {
            mediaFormat.setInteger("channel-count", 1);
        }
        this.codecOutputMediaFormat = mediaFormat;
        this.codecOutputMediaFormatChanged = true;
    }

    protected abstract boolean processOutputBuffer(long var1, long var3, @Nullable MediaCodecAdapter var5, @Nullable ByteBuffer var6, int var7, int var8, int var9, long var10, boolean var12, boolean var13, Format var14) throws ExoPlaybackException;

    protected void renderToEndOfStream() throws ExoPlaybackException {
    }

    @TargetApi(value=23)
    private void processEndOfStream() throws ExoPlaybackException {
        switch (this.codecDrainAction) {
            case 3: {
                this.reinitializeCodec();
                break;
            }
            case 2: {
                this.flushCodec();
                this.updateDrmSessionV23();
                break;
            }
            case 1: {
                this.flushCodec();
                break;
            }
            default: {
                this.outputStreamEnded = true;
                this.renderToEndOfStream();
            }
        }
    }

    protected final void setPendingOutputEndOfStream() {
        this.pendingOutputEndOfStream = true;
    }

    protected final long getOutputStreamOffsetUs() {
        return this.outputStreamOffsetUs;
    }

    protected static boolean supportsFormatDrm(Format format) {
        return format.cryptoType == 0 || format.cryptoType == 2;
    }

    private boolean drmNeedsCodecReinitialization(MediaCodecInfo codecInfo, Format newFormat, @Nullable DrmSession oldSession, @Nullable DrmSession newSession) throws ExoPlaybackException {
        if (oldSession == newSession) {
            return false;
        }
        if (newSession == null || oldSession == null) {
            return true;
        }
        if (Util.SDK_INT < 23) {
            return true;
        }
        if (C.PLAYREADY_UUID.equals(oldSession.getSchemeUuid()) || C.PLAYREADY_UUID.equals(newSession.getSchemeUuid())) {
            return true;
        }
        FrameworkCryptoConfig newCryptoConfig = this.getFrameworkCryptoConfig(newSession);
        if (newCryptoConfig == null) {
            return true;
        }
        boolean requiresSecureDecoder = newCryptoConfig.forceAllowInsecureDecoderComponents ? false : newSession.requiresSecureDecoder(newFormat.sampleMimeType);
        return !codecInfo.secure && requiresSecureDecoder;
    }

    private void reinitializeCodec() throws ExoPlaybackException {
        this.releaseCodec();
        this.maybeInitCodecOrBypass();
    }

    private boolean isDecodeOnlyBuffer(long presentationTimeUs) {
        int size = this.decodeOnlyPresentationTimestamps.size();
        for (int i = 0; i < size; ++i) {
            if (this.decodeOnlyPresentationTimestamps.get(i) != presentationTimeUs) continue;
            this.decodeOnlyPresentationTimestamps.remove(i);
            return true;
        }
        return false;
    }

    @RequiresApi(value=23)
    private void updateDrmSessionV23() throws ExoPlaybackException {
        try {
            this.mediaCrypto.setMediaDrmSession(this.getFrameworkCryptoConfig((DrmSession)this.sourceDrmSession).sessionId);
        }
        catch (MediaCryptoException e) {
            throw this.createRendererException(e, this.inputFormat, 6006);
        }
        this.setCodecDrmSession(this.sourceDrmSession);
        this.codecDrainState = 0;
        this.codecDrainAction = 0;
    }

    @Nullable
    private FrameworkCryptoConfig getFrameworkCryptoConfig(DrmSession drmSession) throws ExoPlaybackException {
        CryptoConfig cryptoConfig = drmSession.getCryptoConfig();
        if (cryptoConfig != null && !(cryptoConfig instanceof FrameworkCryptoConfig)) {
            String string = String.valueOf(cryptoConfig);
            throw this.createRendererException(new IllegalArgumentException(new StringBuilder(43 + String.valueOf(string).length()).append("Expecting FrameworkCryptoConfig but found: ").append(string).toString()), this.inputFormat, 6001);
        }
        return (FrameworkCryptoConfig)cryptoConfig;
    }

    private boolean bypassRender(long positionUs, long elapsedRealtimeUs) throws ExoPlaybackException {
        Assertions.checkState((!this.outputStreamEnded ? 1 : 0) != 0);
        if (this.bypassBatchBuffer.hasSamples()) {
            if (this.processOutputBuffer(positionUs, elapsedRealtimeUs, null, this.bypassBatchBuffer.data, this.outputIndex, 0, this.bypassBatchBuffer.getSampleCount(), this.bypassBatchBuffer.getFirstSampleTimeUs(), this.bypassBatchBuffer.isDecodeOnly(), this.bypassBatchBuffer.isEndOfStream(), this.outputFormat)) {
                this.onProcessedOutputBuffer(this.bypassBatchBuffer.getLastSampleTimeUs());
                this.bypassBatchBuffer.clear();
            } else {
                return false;
            }
        }
        if (this.inputStreamEnded) {
            this.outputStreamEnded = true;
            return false;
        }
        if (this.bypassSampleBufferPending) {
            Assertions.checkState((boolean)this.bypassBatchBuffer.append(this.bypassSampleBuffer));
            this.bypassSampleBufferPending = false;
        }
        if (this.bypassDrainAndReinitialize) {
            if (this.bypassBatchBuffer.hasSamples()) {
                return true;
            }
            this.disableBypass();
            this.bypassDrainAndReinitialize = false;
            this.maybeInitCodecOrBypass();
            if (!this.bypassEnabled) {
                return false;
            }
        }
        this.bypassRead();
        if (this.bypassBatchBuffer.hasSamples()) {
            this.bypassBatchBuffer.flip();
        }
        return this.bypassBatchBuffer.hasSamples() || this.inputStreamEnded || this.bypassDrainAndReinitialize;
    }

    private void bypassRead() throws ExoPlaybackException {
        Assertions.checkState((!this.inputStreamEnded ? 1 : 0) != 0);
        FormatHolder formatHolder = this.getFormatHolder();
        this.bypassSampleBuffer.clear();
        block5: while (true) {
            this.bypassSampleBuffer.clear();
            int result = this.readSource(formatHolder, this.bypassSampleBuffer, 0);
            switch (result) {
                case -5: {
                    this.onInputFormatChanged(formatHolder);
                    return;
                }
                case -3: {
                    return;
                }
                case -4: {
                    if (this.bypassSampleBuffer.isEndOfStream()) {
                        this.inputStreamEnded = true;
                        return;
                    }
                    if (this.waitingForFirstSampleInFormat) {
                        this.outputFormat = (Format)Assertions.checkNotNull((Object)this.inputFormat);
                        this.onOutputFormatChanged(this.outputFormat, null);
                        this.waitingForFirstSampleInFormat = false;
                    }
                    this.bypassSampleBuffer.flip();
                    if (this.bypassBatchBuffer.append(this.bypassSampleBuffer)) continue block5;
                    this.bypassSampleBufferPending = true;
                    return;
                }
            }
            break;
        }
        throw new IllegalStateException();
    }

    private static boolean isMediaCodecException(IllegalStateException error) {
        if (Util.SDK_INT >= 21 && MediaCodecRenderer.isMediaCodecExceptionV21(error)) {
            return true;
        }
        StackTraceElement[] stackTrace = error.getStackTrace();
        return stackTrace.length > 0 && stackTrace[0].getClassName().equals("android.media.MediaCodec");
    }

    @RequiresApi(value=21)
    private static boolean isMediaCodecExceptionV21(IllegalStateException error) {
        return error instanceof MediaCodec.CodecException;
    }

    @RequiresApi(value=21)
    private static boolean isRecoverableMediaCodecExceptionV21(IllegalStateException error) {
        if (error instanceof MediaCodec.CodecException) {
            return ((MediaCodec.CodecException)error).isRecoverable();
        }
        return false;
    }

    private static boolean codecNeedsFlushWorkaround(String name) {
        return Util.SDK_INT < 18 || Util.SDK_INT == 18 && ("OMX.SEC.avc.dec".equals(name) || "OMX.SEC.avc.dec.secure".equals(name)) || Util.SDK_INT == 19 && Util.MODEL.startsWith("SM-G800") && ("OMX.Exynos.avc.dec".equals(name) || "OMX.Exynos.avc.dec.secure".equals(name));
    }

    private int codecAdaptationWorkaroundMode(String name) {
        if (Util.SDK_INT <= 25 && "OMX.Exynos.avc.dec.secure".equals(name) && (Util.MODEL.startsWith("SM-T585") || Util.MODEL.startsWith("SM-A510") || Util.MODEL.startsWith("SM-A520") || Util.MODEL.startsWith("SM-J700"))) {
            return 2;
        }
        if (Util.SDK_INT < 24 && ("OMX.Nvidia.h264.decode".equals(name) || "OMX.Nvidia.h264.decode.secure".equals(name)) && ("flounder".equals(Util.DEVICE) || "flounder_lte".equals(Util.DEVICE) || "grouper".equals(Util.DEVICE) || "tilapia".equals(Util.DEVICE))) {
            return 1;
        }
        return 0;
    }

    private static boolean codecNeedsDiscardToSpsWorkaround(String name, Format format) {
        return Util.SDK_INT < 21 && format.initializationData.isEmpty() && "OMX.MTK.VIDEO.DECODER.AVC".equals(name);
    }

    private static boolean codecNeedsSosFlushWorkaround(String name) {
        return Util.SDK_INT == 29 && "c2.android.aac.decoder".equals(name);
    }

    private static boolean codecNeedsEosPropagationWorkaround(MediaCodecInfo codecInfo) {
        String name = codecInfo.name;
        return Util.SDK_INT <= 25 && "OMX.rk.video_decoder.avc".equals(name) || Util.SDK_INT <= 17 && "OMX.allwinner.video.decoder.avc".equals(name) || Util.SDK_INT <= 29 && ("OMX.broadcom.video_decoder.tunnel".equals(name) || "OMX.broadcom.video_decoder.tunnel.secure".equals(name)) || "Amazon".equals(Util.MANUFACTURER) && "AFTS".equals(Util.MODEL) && codecInfo.secure;
    }

    private static boolean codecNeedsEosFlushWorkaround(String name) {
        return Util.SDK_INT <= 23 && "OMX.google.vorbis.decoder".equals(name) || Util.SDK_INT <= 19 && ("hb2000".equals(Util.DEVICE) || "stvm8".equals(Util.DEVICE)) && ("OMX.amlogic.avc.decoder.awesome".equals(name) || "OMX.amlogic.avc.decoder.awesome.secure".equals(name));
    }

    private static boolean codecNeedsEosBufferTimestampWorkaround(String codecName) {
        return Util.SDK_INT < 21 && "OMX.SEC.mp3.dec".equals(codecName) && "samsung".equals(Util.MANUFACTURER) && (Util.DEVICE.startsWith("baffin") || Util.DEVICE.startsWith("grand") || Util.DEVICE.startsWith("fortuna") || Util.DEVICE.startsWith("gprimelte") || Util.DEVICE.startsWith("j2y18lte") || Util.DEVICE.startsWith("ms01"));
    }

    private static boolean codecNeedsEosOutputExceptionWorkaround(String name) {
        return Util.SDK_INT == 21 && "OMX.google.aac.decoder".equals(name);
    }

    private static boolean codecNeedsMonoChannelCountWorkaround(String name, Format format) {
        return Util.SDK_INT <= 18 && format.channelCount == 1 && "OMX.MTK.AUDIO.DECODER.MP3".equals(name);
    }

    @RequiresApi(value=31)
    private static final class Api31 {
        private Api31() {
        }

        @DoNotInline
        public static void setLogSessionIdToMediaCodecFormat(MediaCodecAdapter.Configuration codecConfiguration, PlayerId playerId) {
            LogSessionId logSessionId = playerId.getLogSessionId();
            if (!logSessionId.equals((Object)LogSessionId.LOG_SESSION_ID_NONE)) {
                codecConfiguration.mediaFormat.setString("log-session-id", logSessionId.getStringId());
            }
        }
    }

    public static class DecoderInitializationException
    extends Exception {
        private static final int CUSTOM_ERROR_CODE_BASE = -50000;
        private static final int NO_SUITABLE_DECODER_ERROR = -49999;
        private static final int DECODER_QUERY_ERROR = -49998;
        public final String mimeType;
        public final boolean secureDecoderRequired;
        @Nullable
        public final MediaCodecInfo codecInfo;
        @Nullable
        public final String diagnosticInfo;
        @Nullable
        public final DecoderInitializationException fallbackDecoderInitializationException;

        public DecoderInitializationException(Format format, @Nullable Throwable cause, boolean secureDecoderRequired, int errorCode) {
            String string = String.valueOf(format);
            this(new StringBuilder(36 + String.valueOf(string).length()).append("Decoder init failed: [").append(errorCode).append("], ").append(string).toString(), cause, format.sampleMimeType, secureDecoderRequired, null, DecoderInitializationException.buildCustomDiagnosticInfo(errorCode), null);
        }

        public DecoderInitializationException(Format format, @Nullable Throwable cause, boolean secureDecoderRequired, MediaCodecInfo mediaCodecInfo) {
            String string = mediaCodecInfo.name;
            String string2 = String.valueOf(format);
            this(new StringBuilder(23 + String.valueOf(string).length() + String.valueOf(string2).length()).append("Decoder init failed: ").append(string).append(", ").append(string2).toString(), cause, format.sampleMimeType, secureDecoderRequired, mediaCodecInfo, Util.SDK_INT >= 21 ? DecoderInitializationException.getDiagnosticInfoV21(cause) : null, null);
        }

        private DecoderInitializationException(String message, @Nullable Throwable cause, String mimeType, boolean secureDecoderRequired, @Nullable MediaCodecInfo mediaCodecInfo, @Nullable String diagnosticInfo, @Nullable DecoderInitializationException fallbackDecoderInitializationException) {
            super(message, cause);
            this.mimeType = mimeType;
            this.secureDecoderRequired = secureDecoderRequired;
            this.codecInfo = mediaCodecInfo;
            this.diagnosticInfo = diagnosticInfo;
            this.fallbackDecoderInitializationException = fallbackDecoderInitializationException;
        }

        @CheckResult
        private DecoderInitializationException copyWithFallbackException(DecoderInitializationException fallbackException) {
            return new DecoderInitializationException(this.getMessage(), this.getCause(), this.mimeType, this.secureDecoderRequired, this.codecInfo, this.diagnosticInfo, fallbackException);
        }

        @RequiresApi(value=21)
        @Nullable
        private static String getDiagnosticInfoV21(@Nullable Throwable cause) {
            if (cause instanceof MediaCodec.CodecException) {
                return ((MediaCodec.CodecException)cause).getDiagnosticInfo();
            }
            return null;
        }

        private static String buildCustomDiagnosticInfo(int errorCode) {
            String sign = errorCode < 0 ? "neg_" : "";
            int n = Math.abs(errorCode);
            return new StringBuilder(71 + String.valueOf(sign).length()).append("com.google.android.exoplayer2.mediacodec.MediaCodecRenderer_").append(sign).append(n).toString();
        }
    }
}

