/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.source;

import android.net.Uri;
import androidx.annotation.Nullable;
import com.google.android.exoplayer2.upstream.DataSource;
import com.google.android.exoplayer2.upstream.DataSpec;
import com.google.android.exoplayer2.upstream.TransferListener;
import com.google.android.exoplayer2.util.Assertions;
import com.google.android.exoplayer2.util.ParsableByteArray;
import java.io.IOException;
import java.util.List;
import java.util.Map;

final class IcyDataSource
implements DataSource {
    private final DataSource upstream;
    private final int metadataIntervalBytes;
    private final Listener listener;
    private final byte[] metadataLengthByteHolder;
    private int bytesUntilMetadata;

    public IcyDataSource(DataSource upstream, int metadataIntervalBytes, Listener listener) {
        Assertions.checkArgument((metadataIntervalBytes > 0 ? 1 : 0) != 0);
        this.upstream = upstream;
        this.metadataIntervalBytes = metadataIntervalBytes;
        this.listener = listener;
        this.metadataLengthByteHolder = new byte[1];
        this.bytesUntilMetadata = metadataIntervalBytes;
    }

    public void addTransferListener(TransferListener transferListener) {
        Assertions.checkNotNull((Object)transferListener);
        this.upstream.addTransferListener(transferListener);
    }

    public long open(DataSpec dataSpec) {
        throw new UnsupportedOperationException();
    }

    public int read(byte[] buffer, int offset, int length) throws IOException {
        int bytesRead;
        if (this.bytesUntilMetadata == 0) {
            if (this.readMetadata()) {
                this.bytesUntilMetadata = this.metadataIntervalBytes;
            } else {
                return -1;
            }
        }
        if ((bytesRead = this.upstream.read(buffer, offset, Math.min(this.bytesUntilMetadata, length))) != -1) {
            this.bytesUntilMetadata -= bytesRead;
        }
        return bytesRead;
    }

    @Nullable
    public Uri getUri() {
        return this.upstream.getUri();
    }

    public Map<String, List<String>> getResponseHeaders() {
        return this.upstream.getResponseHeaders();
    }

    public void close() {
        throw new UnsupportedOperationException();
    }

    private boolean readMetadata() throws IOException {
        int bytesRead = this.upstream.read(this.metadataLengthByteHolder, 0, 1);
        if (bytesRead == -1) {
            return false;
        }
        int metadataLength = (this.metadataLengthByteHolder[0] & 0xFF) << 4;
        if (metadataLength == 0) {
            return true;
        }
        int offset = 0;
        byte[] metadata = new byte[metadataLength];
        for (int lengthRemaining = metadataLength; lengthRemaining > 0; lengthRemaining -= bytesRead) {
            bytesRead = this.upstream.read(metadata, offset, lengthRemaining);
            if (bytesRead == -1) {
                return false;
            }
            offset += bytesRead;
        }
        while (metadataLength > 0 && metadata[metadataLength - 1] == 0) {
            --metadataLength;
        }
        if (metadataLength > 0) {
            this.listener.onIcyMetadata(new ParsableByteArray(metadata, metadataLength));
        }
        return true;
    }

    public static interface Listener {
        public void onIcyMetadata(ParsableByteArray var1);
    }
}

