/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.source;

import android.net.Uri;
import android.os.Handler;
import androidx.annotation.Nullable;
import com.google.android.exoplayer2.Format;
import com.google.android.exoplayer2.FormatHolder;
import com.google.android.exoplayer2.ParserException;
import com.google.android.exoplayer2.SeekParameters;
import com.google.android.exoplayer2.decoder.DecoderInputBuffer;
import com.google.android.exoplayer2.drm.DrmSessionEventListener;
import com.google.android.exoplayer2.drm.DrmSessionManager;
import com.google.android.exoplayer2.extractor.ExtractorOutput;
import com.google.android.exoplayer2.extractor.PositionHolder;
import com.google.android.exoplayer2.extractor.SeekMap;
import com.google.android.exoplayer2.extractor.TrackOutput;
import com.google.android.exoplayer2.metadata.Metadata;
import com.google.android.exoplayer2.metadata.icy.IcyHeaders;
import com.google.android.exoplayer2.source.IcyDataSource;
import com.google.android.exoplayer2.source.LoadEventInfo;
import com.google.android.exoplayer2.source.MediaLoadData;
import com.google.android.exoplayer2.source.MediaPeriod;
import com.google.android.exoplayer2.source.MediaSourceEventListener;
import com.google.android.exoplayer2.source.ProgressiveMediaExtractor;
import com.google.android.exoplayer2.source.SampleQueue;
import com.google.android.exoplayer2.source.SampleStream;
import com.google.android.exoplayer2.source.TrackGroup;
import com.google.android.exoplayer2.source.TrackGroupArray;
import com.google.android.exoplayer2.trackselection.ExoTrackSelection;
import com.google.android.exoplayer2.upstream.Allocator;
import com.google.android.exoplayer2.upstream.DataReader;
import com.google.android.exoplayer2.upstream.DataSource;
import com.google.android.exoplayer2.upstream.DataSourceUtil;
import com.google.android.exoplayer2.upstream.DataSpec;
import com.google.android.exoplayer2.upstream.LoadErrorHandlingPolicy;
import com.google.android.exoplayer2.upstream.Loader;
import com.google.android.exoplayer2.upstream.StatsDataSource;
import com.google.android.exoplayer2.util.Assertions;
import com.google.android.exoplayer2.util.ConditionVariable;
import com.google.android.exoplayer2.util.MimeTypes;
import com.google.android.exoplayer2.util.ParsableByteArray;
import com.google.android.exoplayer2.util.Util;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.checkerframework.checker.nullness.compatqual.NullableType;
import org.checkerframework.checker.nullness.qual.EnsuresNonNull;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;

final class ProgressiveMediaPeriod
implements MediaPeriod,
ExtractorOutput,
Loader.Callback<ExtractingLoadable>,
Loader.ReleaseCallback,
SampleQueue.UpstreamFormatChangedListener {
    private static final long DEFAULT_LAST_SAMPLE_DURATION_US = 10000L;
    private static final Map<String, String> ICY_METADATA_HEADERS = ProgressiveMediaPeriod.createIcyMetadataHeaders();
    private static final Format ICY_FORMAT = new Format.Builder().setId("icy").setSampleMimeType("application/x-icy").build();
    private final Uri uri;
    private final DataSource dataSource;
    private final DrmSessionManager drmSessionManager;
    private final LoadErrorHandlingPolicy loadErrorHandlingPolicy;
    private final MediaSourceEventListener.EventDispatcher mediaSourceEventDispatcher;
    private final DrmSessionEventListener.EventDispatcher drmEventDispatcher;
    private final Listener listener;
    private final Allocator allocator;
    @Nullable
    private final String customCacheKey;
    private final long continueLoadingCheckIntervalBytes;
    private final Loader loader;
    private final ProgressiveMediaExtractor progressiveMediaExtractor;
    private final ConditionVariable loadCondition;
    private final Runnable maybeFinishPrepareRunnable;
    private final Runnable onContinueLoadingRequestedRunnable;
    private final Handler handler;
    @Nullable
    private MediaPeriod.Callback callback;
    @Nullable
    private IcyHeaders icyHeaders;
    private SampleQueue[] sampleQueues;
    private TrackId[] sampleQueueTrackIds;
    private boolean sampleQueuesBuilt;
    private boolean prepared;
    private boolean haveAudioVideoTracks;
    private @MonotonicNonNull TrackState trackState;
    private @MonotonicNonNull SeekMap seekMap;
    private long durationUs;
    private boolean isLive;
    private int dataType;
    private boolean seenFirstTrackSelection;
    private boolean notifyDiscontinuity;
    private int enabledTrackCount;
    private long length;
    private long lastSeekPositionUs;
    private long pendingResetPositionUs;
    private boolean pendingDeferredRetry;
    private int extractedSamplesCountAtStartOfLoad;
    private boolean loadingFinished;
    private boolean released;

    public ProgressiveMediaPeriod(Uri uri, DataSource dataSource, ProgressiveMediaExtractor progressiveMediaExtractor, DrmSessionManager drmSessionManager, DrmSessionEventListener.EventDispatcher drmEventDispatcher, LoadErrorHandlingPolicy loadErrorHandlingPolicy, MediaSourceEventListener.EventDispatcher mediaSourceEventDispatcher, Listener listener, Allocator allocator, @Nullable String customCacheKey, int continueLoadingCheckIntervalBytes) {
        this.uri = uri;
        this.dataSource = dataSource;
        this.drmSessionManager = drmSessionManager;
        this.drmEventDispatcher = drmEventDispatcher;
        this.loadErrorHandlingPolicy = loadErrorHandlingPolicy;
        this.mediaSourceEventDispatcher = mediaSourceEventDispatcher;
        this.listener = listener;
        this.allocator = allocator;
        this.customCacheKey = customCacheKey;
        this.continueLoadingCheckIntervalBytes = continueLoadingCheckIntervalBytes;
        this.loader = new Loader("ProgressiveMediaPeriod");
        this.progressiveMediaExtractor = progressiveMediaExtractor;
        this.loadCondition = new ConditionVariable();
        this.maybeFinishPrepareRunnable = this::maybeFinishPrepare;
        this.onContinueLoadingRequestedRunnable = () -> {
            if (!this.released) {
                ((MediaPeriod.Callback)Assertions.checkNotNull((Object)this.callback)).onContinueLoadingRequested(this);
            }
        };
        this.handler = Util.createHandlerForCurrentLooper();
        this.sampleQueueTrackIds = new TrackId[0];
        this.sampleQueues = new SampleQueue[0];
        this.pendingResetPositionUs = -9223372036854775807L;
        this.length = -1L;
        this.durationUs = -9223372036854775807L;
        this.dataType = 1;
    }

    public void release() {
        if (this.prepared) {
            for (SampleQueue sampleQueue : this.sampleQueues) {
                sampleQueue.preRelease();
            }
        }
        this.loader.release(this);
        this.handler.removeCallbacksAndMessages(null);
        this.callback = null;
        this.released = true;
    }

    @Override
    public void onLoaderReleased() {
        for (SampleQueue sampleQueue : this.sampleQueues) {
            sampleQueue.release();
        }
        this.progressiveMediaExtractor.release();
    }

    @Override
    public void prepare(MediaPeriod.Callback callback, long positionUs) {
        this.callback = callback;
        this.loadCondition.open();
        this.startLoading();
    }

    @Override
    public void maybeThrowPrepareError() throws IOException {
        this.maybeThrowError();
        if (this.loadingFinished && !this.prepared) {
            throw ParserException.createForMalformedContainer((String)"Loading finished before preparation is complete.", null);
        }
    }

    @Override
    public TrackGroupArray getTrackGroups() {
        this.assertPrepared();
        return this.trackState.tracks;
    }

    @Override
    public long selectTracks(@NullableType ExoTrackSelection[] selections, boolean[] mayRetainStreamFlags, @NullableType SampleStream[] streams, boolean[] streamResetFlags, long positionUs) {
        int i;
        this.assertPrepared();
        TrackGroupArray tracks = this.trackState.tracks;
        boolean[] trackEnabledStates = this.trackState.trackEnabledStates;
        int oldEnabledTrackCount = this.enabledTrackCount;
        for (int i2 = 0; i2 < selections.length; ++i2) {
            if (streams[i2] == null || selections[i2] != null && mayRetainStreamFlags[i2]) continue;
            int track = ((SampleStreamImpl)streams[i2]).track;
            Assertions.checkState((boolean)trackEnabledStates[track]);
            --this.enabledTrackCount;
            trackEnabledStates[track] = false;
            streams[i2] = null;
        }
        boolean seekRequired = this.seenFirstTrackSelection ? oldEnabledTrackCount == 0 : positionUs != 0L;
        for (i = 0; i < selections.length; ++i) {
            if (streams[i] != null || selections[i] == null) continue;
            ExoTrackSelection selection = selections[i];
            Assertions.checkState((selection.length() == 1 ? 1 : 0) != 0);
            Assertions.checkState((selection.getIndexInTrackGroup(0) == 0 ? 1 : 0) != 0);
            int track = tracks.indexOf(selection.getTrackGroup());
            Assertions.checkState((!trackEnabledStates[track] ? 1 : 0) != 0);
            ++this.enabledTrackCount;
            trackEnabledStates[track] = true;
            streams[i] = new SampleStreamImpl(track);
            streamResetFlags[i] = true;
            if (seekRequired) continue;
            SampleQueue sampleQueue = this.sampleQueues[track];
            seekRequired = !sampleQueue.seekTo(positionUs, true) && sampleQueue.getReadIndex() != 0;
        }
        if (this.enabledTrackCount == 0) {
            this.pendingDeferredRetry = false;
            this.notifyDiscontinuity = false;
            if (this.loader.isLoading()) {
                for (SampleQueue sampleQueue : this.sampleQueues) {
                    sampleQueue.discardToEnd();
                }
                this.loader.cancelLoading();
            } else {
                for (SampleQueue sampleQueue : this.sampleQueues) {
                    sampleQueue.reset();
                }
            }
        } else if (seekRequired) {
            positionUs = this.seekToUs(positionUs);
            for (i = 0; i < streams.length; ++i) {
                if (streams[i] == null) continue;
                streamResetFlags[i] = true;
            }
        }
        this.seenFirstTrackSelection = true;
        return positionUs;
    }

    @Override
    public void discardBuffer(long positionUs, boolean toKeyframe) {
        this.assertPrepared();
        if (this.isPendingReset()) {
            return;
        }
        boolean[] trackEnabledStates = this.trackState.trackEnabledStates;
        int trackCount = this.sampleQueues.length;
        for (int i = 0; i < trackCount; ++i) {
            this.sampleQueues[i].discardTo(positionUs, toKeyframe, trackEnabledStates[i]);
        }
    }

    @Override
    public void reevaluateBuffer(long positionUs) {
    }

    @Override
    public boolean continueLoading(long playbackPositionUs) {
        if (this.loadingFinished || this.loader.hasFatalError() || this.pendingDeferredRetry || this.prepared && this.enabledTrackCount == 0) {
            return false;
        }
        boolean continuedLoading = this.loadCondition.open();
        if (!this.loader.isLoading()) {
            this.startLoading();
            continuedLoading = true;
        }
        return continuedLoading;
    }

    @Override
    public boolean isLoading() {
        return this.loader.isLoading() && this.loadCondition.isOpen();
    }

    @Override
    public long getNextLoadPositionUs() {
        return this.enabledTrackCount == 0 ? Long.MIN_VALUE : this.getBufferedPositionUs();
    }

    @Override
    public long readDiscontinuity() {
        if (this.notifyDiscontinuity && (this.loadingFinished || this.getExtractedSamplesCount() > this.extractedSamplesCountAtStartOfLoad)) {
            this.notifyDiscontinuity = false;
            return this.lastSeekPositionUs;
        }
        return -9223372036854775807L;
    }

    @Override
    public long getBufferedPositionUs() {
        this.assertPrepared();
        boolean[] trackIsAudioVideoFlags = this.trackState.trackIsAudioVideoFlags;
        if (this.loadingFinished) {
            return Long.MIN_VALUE;
        }
        if (this.isPendingReset()) {
            return this.pendingResetPositionUs;
        }
        long largestQueuedTimestampUs = Long.MAX_VALUE;
        if (this.haveAudioVideoTracks) {
            int trackCount = this.sampleQueues.length;
            for (int i = 0; i < trackCount; ++i) {
                if (!trackIsAudioVideoFlags[i] || this.sampleQueues[i].isLastSampleQueued()) continue;
                largestQueuedTimestampUs = Math.min(largestQueuedTimestampUs, this.sampleQueues[i].getLargestQueuedTimestampUs());
            }
        }
        if (largestQueuedTimestampUs == Long.MAX_VALUE) {
            largestQueuedTimestampUs = this.getLargestQueuedTimestampUs();
        }
        return largestQueuedTimestampUs == Long.MIN_VALUE ? this.lastSeekPositionUs : largestQueuedTimestampUs;
    }

    @Override
    public long seekToUs(long positionUs) {
        this.assertPrepared();
        boolean[] trackIsAudioVideoFlags = this.trackState.trackIsAudioVideoFlags;
        positionUs = this.seekMap.isSeekable() ? positionUs : 0L;
        this.notifyDiscontinuity = false;
        this.lastSeekPositionUs = positionUs;
        if (this.isPendingReset()) {
            this.pendingResetPositionUs = positionUs;
            return positionUs;
        }
        if (this.dataType != 7 && this.seekInsideBufferUs(trackIsAudioVideoFlags, positionUs)) {
            return positionUs;
        }
        this.pendingDeferredRetry = false;
        this.pendingResetPositionUs = positionUs;
        this.loadingFinished = false;
        if (this.loader.isLoading()) {
            for (SampleQueue sampleQueue : this.sampleQueues) {
                sampleQueue.discardToEnd();
            }
            this.loader.cancelLoading();
        } else {
            this.loader.clearFatalError();
            for (SampleQueue sampleQueue : this.sampleQueues) {
                sampleQueue.reset();
            }
        }
        return positionUs;
    }

    @Override
    public long getAdjustedSeekPositionUs(long positionUs, SeekParameters seekParameters) {
        this.assertPrepared();
        if (!this.seekMap.isSeekable()) {
            return 0L;
        }
        SeekMap.SeekPoints seekPoints = this.seekMap.getSeekPoints(positionUs);
        return seekParameters.resolveSeekPositionUs(positionUs, seekPoints.first.timeUs, seekPoints.second.timeUs);
    }

    boolean isReady(int track) {
        return !this.suppressRead() && this.sampleQueues[track].isReady(this.loadingFinished);
    }

    void maybeThrowError(int sampleQueueIndex) throws IOException {
        this.sampleQueues[sampleQueueIndex].maybeThrowError();
        this.maybeThrowError();
    }

    void maybeThrowError() throws IOException {
        this.loader.maybeThrowError(this.loadErrorHandlingPolicy.getMinimumLoadableRetryCount(this.dataType));
    }

    int readData(int sampleQueueIndex, FormatHolder formatHolder, DecoderInputBuffer buffer, int readFlags) {
        if (this.suppressRead()) {
            return -3;
        }
        this.maybeNotifyDownstreamFormat(sampleQueueIndex);
        int result = this.sampleQueues[sampleQueueIndex].read(formatHolder, buffer, readFlags, this.loadingFinished);
        if (result == -3) {
            this.maybeStartDeferredRetry(sampleQueueIndex);
        }
        return result;
    }

    int skipData(int track, long positionUs) {
        if (this.suppressRead()) {
            return 0;
        }
        this.maybeNotifyDownstreamFormat(track);
        SampleQueue sampleQueue = this.sampleQueues[track];
        int skipCount = sampleQueue.getSkipCount(positionUs, this.loadingFinished);
        sampleQueue.skip(skipCount);
        if (skipCount == 0) {
            this.maybeStartDeferredRetry(track);
        }
        return skipCount;
    }

    private void maybeNotifyDownstreamFormat(int track) {
        this.assertPrepared();
        boolean[] trackNotifiedDownstreamFormats = this.trackState.trackNotifiedDownstreamFormats;
        if (!trackNotifiedDownstreamFormats[track]) {
            Format trackFormat = this.trackState.tracks.get(track).getFormat(0);
            this.mediaSourceEventDispatcher.downstreamFormatChanged(MimeTypes.getTrackType((String)trackFormat.sampleMimeType), trackFormat, 0, null, this.lastSeekPositionUs);
            trackNotifiedDownstreamFormats[track] = true;
        }
    }

    private void maybeStartDeferredRetry(int track) {
        this.assertPrepared();
        boolean[] trackIsAudioVideoFlags = this.trackState.trackIsAudioVideoFlags;
        if (!this.pendingDeferredRetry || !trackIsAudioVideoFlags[track] || this.sampleQueues[track].isReady(false)) {
            return;
        }
        this.pendingResetPositionUs = 0L;
        this.pendingDeferredRetry = false;
        this.notifyDiscontinuity = true;
        this.lastSeekPositionUs = 0L;
        this.extractedSamplesCountAtStartOfLoad = 0;
        for (SampleQueue sampleQueue : this.sampleQueues) {
            sampleQueue.reset();
        }
        ((MediaPeriod.Callback)Assertions.checkNotNull((Object)this.callback)).onContinueLoadingRequested(this);
    }

    private boolean suppressRead() {
        return this.notifyDiscontinuity || this.isPendingReset();
    }

    @Override
    public void onLoadCompleted(ExtractingLoadable loadable, long elapsedRealtimeMs, long loadDurationMs) {
        if (this.durationUs == -9223372036854775807L && this.seekMap != null) {
            boolean isSeekable = this.seekMap.isSeekable();
            long largestQueuedTimestampUs = this.getLargestQueuedTimestampUs();
            this.durationUs = largestQueuedTimestampUs == Long.MIN_VALUE ? 0L : largestQueuedTimestampUs + 10000L;
            this.listener.onSourceInfoRefreshed(this.durationUs, isSeekable, this.isLive);
        }
        StatsDataSource dataSource = loadable.dataSource;
        LoadEventInfo loadEventInfo = new LoadEventInfo(loadable.loadTaskId, loadable.dataSpec, dataSource.getLastOpenedUri(), dataSource.getLastResponseHeaders(), elapsedRealtimeMs, loadDurationMs, dataSource.getBytesRead());
        this.loadErrorHandlingPolicy.onLoadTaskConcluded(loadable.loadTaskId);
        this.mediaSourceEventDispatcher.loadCompleted(loadEventInfo, 1, -1, null, 0, null, loadable.seekTimeUs, this.durationUs);
        this.copyLengthFromLoader(loadable);
        this.loadingFinished = true;
        ((MediaPeriod.Callback)Assertions.checkNotNull((Object)this.callback)).onContinueLoadingRequested(this);
    }

    @Override
    public void onLoadCanceled(ExtractingLoadable loadable, long elapsedRealtimeMs, long loadDurationMs, boolean released) {
        StatsDataSource dataSource = loadable.dataSource;
        LoadEventInfo loadEventInfo = new LoadEventInfo(loadable.loadTaskId, loadable.dataSpec, dataSource.getLastOpenedUri(), dataSource.getLastResponseHeaders(), elapsedRealtimeMs, loadDurationMs, dataSource.getBytesRead());
        this.loadErrorHandlingPolicy.onLoadTaskConcluded(loadable.loadTaskId);
        this.mediaSourceEventDispatcher.loadCanceled(loadEventInfo, 1, -1, null, 0, null, loadable.seekTimeUs, this.durationUs);
        if (!released) {
            this.copyLengthFromLoader(loadable);
            for (SampleQueue sampleQueue : this.sampleQueues) {
                sampleQueue.reset();
            }
            if (this.enabledTrackCount > 0) {
                ((MediaPeriod.Callback)Assertions.checkNotNull((Object)this.callback)).onContinueLoadingRequested(this);
            }
        }
    }

    @Override
    public Loader.LoadErrorAction onLoadError(ExtractingLoadable loadable, long elapsedRealtimeMs, long loadDurationMs, IOException error, int errorCount) {
        Loader.LoadErrorAction loadErrorAction;
        this.copyLengthFromLoader(loadable);
        StatsDataSource dataSource = loadable.dataSource;
        LoadEventInfo loadEventInfo = new LoadEventInfo(loadable.loadTaskId, loadable.dataSpec, dataSource.getLastOpenedUri(), dataSource.getLastResponseHeaders(), elapsedRealtimeMs, loadDurationMs, dataSource.getBytesRead());
        MediaLoadData mediaLoadData = new MediaLoadData(1, -1, null, 0, null, Util.usToMs((long)loadable.seekTimeUs), Util.usToMs((long)this.durationUs));
        long retryDelayMs = this.loadErrorHandlingPolicy.getRetryDelayMsFor(new LoadErrorHandlingPolicy.LoadErrorInfo(loadEventInfo, mediaLoadData, error, errorCount));
        if (retryDelayMs == -9223372036854775807L) {
            loadErrorAction = Loader.DONT_RETRY_FATAL;
        } else {
            int extractedSamplesCount = this.getExtractedSamplesCount();
            boolean madeProgress = extractedSamplesCount > this.extractedSamplesCountAtStartOfLoad;
            loadErrorAction = this.configureRetry(loadable, extractedSamplesCount) ? Loader.createRetryAction(madeProgress, retryDelayMs) : Loader.DONT_RETRY;
        }
        boolean wasCanceled = !loadErrorAction.isRetry();
        this.mediaSourceEventDispatcher.loadError(loadEventInfo, 1, -1, null, 0, null, loadable.seekTimeUs, this.durationUs, error, wasCanceled);
        if (wasCanceled) {
            this.loadErrorHandlingPolicy.onLoadTaskConcluded(loadable.loadTaskId);
        }
        return loadErrorAction;
    }

    public TrackOutput track(int id, int type) {
        return this.prepareTrackOutput(new TrackId(id, false));
    }

    public void endTracks() {
        this.sampleQueuesBuilt = true;
        this.handler.post(this.maybeFinishPrepareRunnable);
    }

    public void seekMap(SeekMap seekMap) {
        this.handler.post(() -> this.setSeekMap(seekMap));
    }

    TrackOutput icyTrack() {
        return this.prepareTrackOutput(new TrackId(0, true));
    }

    @Override
    public void onUpstreamFormatChanged(Format format) {
        this.handler.post(this.maybeFinishPrepareRunnable);
    }

    private TrackOutput prepareTrackOutput(TrackId id) {
        int trackCount = this.sampleQueues.length;
        for (int i = 0; i < trackCount; ++i) {
            if (!id.equals(this.sampleQueueTrackIds[i])) continue;
            return this.sampleQueues[i];
        }
        SampleQueue trackOutput = SampleQueue.createWithDrm(this.allocator, this.drmSessionManager, this.drmEventDispatcher);
        trackOutput.setUpstreamFormatChangeListener(this);
        @NullableType Object[] sampleQueueTrackIds = Arrays.copyOf(this.sampleQueueTrackIds, trackCount + 1);
        sampleQueueTrackIds[trackCount] = id;
        this.sampleQueueTrackIds = (TrackId[])Util.castNonNullTypeArray((Object[])sampleQueueTrackIds);
        @NullableType Object[] sampleQueues = Arrays.copyOf(this.sampleQueues, trackCount + 1);
        sampleQueues[trackCount] = trackOutput;
        this.sampleQueues = (SampleQueue[])Util.castNonNullTypeArray((Object[])sampleQueues);
        return trackOutput;
    }

    private void setSeekMap(SeekMap seekMap) {
        this.seekMap = this.icyHeaders == null ? seekMap : new SeekMap.Unseekable(-9223372036854775807L);
        this.durationUs = seekMap.getDurationUs();
        this.isLive = this.length == -1L && seekMap.getDurationUs() == -9223372036854775807L;
        this.dataType = this.isLive ? 7 : 1;
        this.listener.onSourceInfoRefreshed(this.durationUs, seekMap.isSeekable(), this.isLive);
        if (!this.prepared) {
            this.maybeFinishPrepare();
        }
    }

    private void maybeFinishPrepare() {
        if (this.released || this.prepared || !this.sampleQueuesBuilt || this.seekMap == null) {
            return;
        }
        for (SampleQueue sampleQueue : this.sampleQueues) {
            if (sampleQueue.getUpstreamFormat() != null) continue;
            return;
        }
        this.loadCondition.close();
        int trackCount = this.sampleQueues.length;
        TrackGroup[] trackArray = new TrackGroup[trackCount];
        boolean[] trackIsAudioVideoFlags = new boolean[trackCount];
        for (int i = 0; i < trackCount; ++i) {
            boolean isAudioVideo;
            Format trackFormat = (Format)Assertions.checkNotNull((Object)this.sampleQueues[i].getUpstreamFormat());
            String mimeType = trackFormat.sampleMimeType;
            boolean isAudio = MimeTypes.isAudio((String)mimeType);
            trackIsAudioVideoFlags[i] = isAudioVideo = isAudio || MimeTypes.isVideo((String)mimeType);
            this.haveAudioVideoTracks |= isAudioVideo;
            IcyHeaders icyHeaders = this.icyHeaders;
            if (icyHeaders != null) {
                if (isAudio || this.sampleQueueTrackIds[i].isIcyTrack) {
                    Metadata metadata = trackFormat.metadata;
                    metadata = metadata == null ? new Metadata(new Metadata.Entry[]{icyHeaders}) : metadata.copyWithAppendedEntries(new Metadata.Entry[]{icyHeaders});
                    trackFormat = trackFormat.buildUpon().setMetadata(metadata).build();
                }
                if (isAudio && trackFormat.averageBitrate == -1 && trackFormat.peakBitrate == -1 && icyHeaders.bitrate != -1) {
                    trackFormat = trackFormat.buildUpon().setAverageBitrate(icyHeaders.bitrate).build();
                }
            }
            trackFormat = trackFormat.copyWithCryptoType(this.drmSessionManager.getCryptoType(trackFormat));
            trackArray[i] = new TrackGroup(Integer.toString(i), new Format[]{trackFormat});
        }
        this.trackState = new TrackState(new TrackGroupArray(trackArray), trackIsAudioVideoFlags);
        this.prepared = true;
        ((MediaPeriod.Callback)Assertions.checkNotNull((Object)this.callback)).onPrepared(this);
    }

    private void copyLengthFromLoader(ExtractingLoadable loadable) {
        if (this.length == -1L) {
            this.length = loadable.length;
        }
    }

    private void startLoading() {
        ExtractingLoadable loadable = new ExtractingLoadable(this.uri, this.dataSource, this.progressiveMediaExtractor, this, this.loadCondition);
        if (this.prepared) {
            Assertions.checkState((boolean)this.isPendingReset());
            if (this.durationUs != -9223372036854775807L && this.pendingResetPositionUs > this.durationUs) {
                this.loadingFinished = true;
                this.pendingResetPositionUs = -9223372036854775807L;
                return;
            }
            loadable.setLoadPosition(((SeekMap)Assertions.checkNotNull((Object)this.seekMap)).getSeekPoints((long)this.pendingResetPositionUs).first.position, this.pendingResetPositionUs);
            for (SampleQueue sampleQueue : this.sampleQueues) {
                sampleQueue.setStartTimeUs(this.pendingResetPositionUs);
            }
            this.pendingResetPositionUs = -9223372036854775807L;
        }
        this.extractedSamplesCountAtStartOfLoad = this.getExtractedSamplesCount();
        long elapsedRealtimeMs = this.loader.startLoading(loadable, this, this.loadErrorHandlingPolicy.getMinimumLoadableRetryCount(this.dataType));
        DataSpec dataSpec = loadable.dataSpec;
        this.mediaSourceEventDispatcher.loadStarted(new LoadEventInfo(loadable.loadTaskId, dataSpec, elapsedRealtimeMs), 1, -1, null, 0, null, loadable.seekTimeUs, this.durationUs);
    }

    private boolean configureRetry(ExtractingLoadable loadable, int currentExtractedSampleCount) {
        if (this.length != -1L || this.seekMap != null && this.seekMap.getDurationUs() != -9223372036854775807L) {
            this.extractedSamplesCountAtStartOfLoad = currentExtractedSampleCount;
            return true;
        }
        if (this.prepared && !this.suppressRead()) {
            this.pendingDeferredRetry = true;
            return false;
        }
        this.notifyDiscontinuity = this.prepared;
        this.lastSeekPositionUs = 0L;
        this.extractedSamplesCountAtStartOfLoad = 0;
        for (SampleQueue sampleQueue : this.sampleQueues) {
            sampleQueue.reset();
        }
        loadable.setLoadPosition(0L, 0L);
        return true;
    }

    private boolean seekInsideBufferUs(boolean[] trackIsAudioVideoFlags, long positionUs) {
        int trackCount = this.sampleQueues.length;
        for (int i = 0; i < trackCount; ++i) {
            SampleQueue sampleQueue = this.sampleQueues[i];
            boolean seekInsideQueue = sampleQueue.seekTo(positionUs, false);
            if (seekInsideQueue || !trackIsAudioVideoFlags[i] && this.haveAudioVideoTracks) continue;
            return false;
        }
        return true;
    }

    private int getExtractedSamplesCount() {
        int extractedSamplesCount = 0;
        for (SampleQueue sampleQueue : this.sampleQueues) {
            extractedSamplesCount += sampleQueue.getWriteIndex();
        }
        return extractedSamplesCount;
    }

    private long getLargestQueuedTimestampUs() {
        long largestQueuedTimestampUs = Long.MIN_VALUE;
        for (SampleQueue sampleQueue : this.sampleQueues) {
            largestQueuedTimestampUs = Math.max(largestQueuedTimestampUs, sampleQueue.getLargestQueuedTimestampUs());
        }
        return largestQueuedTimestampUs;
    }

    private boolean isPendingReset() {
        return this.pendingResetPositionUs != -9223372036854775807L;
    }

    @EnsuresNonNull(value={"trackState", "seekMap"})
    private void assertPrepared() {
        Assertions.checkState((boolean)this.prepared);
        Assertions.checkNotNull((Object)this.trackState);
        Assertions.checkNotNull((Object)this.seekMap);
    }

    private static Map<String, String> createIcyMetadataHeaders() {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Icy-MetaData", "1");
        return Collections.unmodifiableMap(headers);
    }

    private static final class TrackId {
        public final int id;
        public final boolean isIcyTrack;

        public TrackId(int id, boolean isIcyTrack) {
            this.id = id;
            this.isIcyTrack = isIcyTrack;
        }

        public boolean equals(@Nullable Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            TrackId other = (TrackId)obj;
            return this.id == other.id && this.isIcyTrack == other.isIcyTrack;
        }

        public int hashCode() {
            return 31 * this.id + (this.isIcyTrack ? 1 : 0);
        }
    }

    private static final class TrackState {
        public final TrackGroupArray tracks;
        public final boolean[] trackIsAudioVideoFlags;
        public final boolean[] trackEnabledStates;
        public final boolean[] trackNotifiedDownstreamFormats;

        public TrackState(TrackGroupArray tracks, boolean[] trackIsAudioVideoFlags) {
            this.tracks = tracks;
            this.trackIsAudioVideoFlags = trackIsAudioVideoFlags;
            this.trackEnabledStates = new boolean[tracks.length];
            this.trackNotifiedDownstreamFormats = new boolean[tracks.length];
        }
    }

    final class ExtractingLoadable
    implements Loader.Loadable,
    IcyDataSource.Listener {
        private final long loadTaskId;
        private final Uri uri;
        private final StatsDataSource dataSource;
        private final ProgressiveMediaExtractor progressiveMediaExtractor;
        private final ExtractorOutput extractorOutput;
        private final ConditionVariable loadCondition;
        private final PositionHolder positionHolder;
        private volatile boolean loadCanceled;
        private boolean pendingExtractorSeek;
        private long seekTimeUs;
        private DataSpec dataSpec;
        private long length;
        @Nullable
        private TrackOutput icyTrackOutput;
        private boolean seenIcyMetadata;

        public ExtractingLoadable(Uri uri, DataSource dataSource, ProgressiveMediaExtractor progressiveMediaExtractor, ExtractorOutput extractorOutput, ConditionVariable loadCondition) {
            this.uri = uri;
            this.dataSource = new StatsDataSource(dataSource);
            this.progressiveMediaExtractor = progressiveMediaExtractor;
            this.extractorOutput = extractorOutput;
            this.loadCondition = loadCondition;
            this.positionHolder = new PositionHolder();
            this.pendingExtractorSeek = true;
            this.length = -1L;
            this.loadTaskId = LoadEventInfo.getNewId();
            this.dataSpec = this.buildDataSpec(0L);
        }

        @Override
        public void cancelLoad() {
            this.loadCanceled = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void load() throws IOException {
            int result = 0;
            while (result == 0 && !this.loadCanceled) {
                try {
                    long position = this.positionHolder.position;
                    this.dataSpec = this.buildDataSpec(position);
                    this.length = this.dataSource.open(this.dataSpec);
                    if (this.length != -1L) {
                        this.length += position;
                    }
                    ProgressiveMediaPeriod.this.icyHeaders = IcyHeaders.parse((Map)this.dataSource.getResponseHeaders());
                    Object extractorDataSource = this.dataSource;
                    if (ProgressiveMediaPeriod.this.icyHeaders != null && ((ProgressiveMediaPeriod)ProgressiveMediaPeriod.this).icyHeaders.metadataInterval != -1) {
                        extractorDataSource = new IcyDataSource((DataSource)this.dataSource, ((ProgressiveMediaPeriod)ProgressiveMediaPeriod.this).icyHeaders.metadataInterval, this);
                        this.icyTrackOutput = ProgressiveMediaPeriod.this.icyTrack();
                        this.icyTrackOutput.format(ICY_FORMAT);
                    }
                    this.progressiveMediaExtractor.init((DataReader)extractorDataSource, this.uri, this.dataSource.getResponseHeaders(), position, this.length, this.extractorOutput);
                    if (ProgressiveMediaPeriod.this.icyHeaders != null) {
                        this.progressiveMediaExtractor.disableSeekingOnMp3Streams();
                    }
                    if (this.pendingExtractorSeek) {
                        this.progressiveMediaExtractor.seek(position, this.seekTimeUs);
                        this.pendingExtractorSeek = false;
                    }
                    while (result == 0 && !this.loadCanceled) {
                        try {
                            this.loadCondition.block();
                        }
                        catch (InterruptedException e) {
                            throw new InterruptedIOException();
                        }
                        result = this.progressiveMediaExtractor.read(this.positionHolder);
                        long currentInputPosition = this.progressiveMediaExtractor.getCurrentInputPosition();
                        if (currentInputPosition <= position + ProgressiveMediaPeriod.this.continueLoadingCheckIntervalBytes) continue;
                        position = currentInputPosition;
                        this.loadCondition.close();
                        ProgressiveMediaPeriod.this.handler.post(ProgressiveMediaPeriod.this.onContinueLoadingRequestedRunnable);
                    }
                }
                finally {
                    if (result == 1) {
                        result = 0;
                    } else if (this.progressiveMediaExtractor.getCurrentInputPosition() != -1L) {
                        this.positionHolder.position = this.progressiveMediaExtractor.getCurrentInputPosition();
                    }
                    DataSourceUtil.closeQuietly((DataSource)this.dataSource);
                }
            }
        }

        @Override
        public void onIcyMetadata(ParsableByteArray metadata) {
            long timeUs = !this.seenIcyMetadata ? this.seekTimeUs : Math.max(ProgressiveMediaPeriod.this.getLargestQueuedTimestampUs(), this.seekTimeUs);
            int length = metadata.bytesLeft();
            TrackOutput icyTrackOutput = (TrackOutput)Assertions.checkNotNull((Object)this.icyTrackOutput);
            icyTrackOutput.sampleData(metadata, length);
            icyTrackOutput.sampleMetadata(timeUs, 1, length, 0, null);
            this.seenIcyMetadata = true;
        }

        private DataSpec buildDataSpec(long position) {
            return new DataSpec.Builder().setUri(this.uri).setPosition(position).setKey(ProgressiveMediaPeriod.this.customCacheKey).setFlags(6).setHttpRequestHeaders(ICY_METADATA_HEADERS).build();
        }

        private void setLoadPosition(long position, long timeUs) {
            this.positionHolder.position = position;
            this.seekTimeUs = timeUs;
            this.pendingExtractorSeek = true;
            this.seenIcyMetadata = false;
        }
    }

    private final class SampleStreamImpl
    implements SampleStream {
        private final int track;

        public SampleStreamImpl(int track) {
            this.track = track;
        }

        @Override
        public boolean isReady() {
            return ProgressiveMediaPeriod.this.isReady(this.track);
        }

        @Override
        public void maybeThrowError() throws IOException {
            ProgressiveMediaPeriod.this.maybeThrowError(this.track);
        }

        @Override
        public int readData(FormatHolder formatHolder, DecoderInputBuffer buffer, int readFlags) {
            return ProgressiveMediaPeriod.this.readData(this.track, formatHolder, buffer, readFlags);
        }

        @Override
        public int skipData(long positionUs) {
            return ProgressiveMediaPeriod.this.skipData(this.track, positionUs);
        }
    }

    static interface Listener {
        public void onSourceInfoRefreshed(long var1, boolean var3, boolean var4);
    }
}

