/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.source;

import android.net.Uri;
import androidx.annotation.IntRange;
import androidx.annotation.Nullable;
import com.google.android.exoplayer2.Format;
import com.google.android.exoplayer2.FormatHolder;
import com.google.android.exoplayer2.MediaItem;
import com.google.android.exoplayer2.SeekParameters;
import com.google.android.exoplayer2.decoder.DecoderInputBuffer;
import com.google.android.exoplayer2.source.BaseMediaSource;
import com.google.android.exoplayer2.source.MediaPeriod;
import com.google.android.exoplayer2.source.MediaSource;
import com.google.android.exoplayer2.source.SampleStream;
import com.google.android.exoplayer2.source.SinglePeriodTimeline;
import com.google.android.exoplayer2.source.TrackGroup;
import com.google.android.exoplayer2.source.TrackGroupArray;
import com.google.android.exoplayer2.trackselection.ExoTrackSelection;
import com.google.android.exoplayer2.upstream.Allocator;
import com.google.android.exoplayer2.upstream.TransferListener;
import com.google.android.exoplayer2.util.Assertions;
import com.google.android.exoplayer2.util.Util;
import java.util.ArrayList;
import org.checkerframework.checker.nullness.compatqual.NullableType;

public final class SilenceMediaSource
extends BaseMediaSource {
    public static final String MEDIA_ID = "SilenceMediaSource";
    private static final int SAMPLE_RATE_HZ = 44100;
    private static final int PCM_ENCODING = 2;
    private static final int CHANNEL_COUNT = 2;
    private static final Format FORMAT = new Format.Builder().setSampleMimeType("audio/raw").setChannelCount(2).setSampleRate(44100).setPcmEncoding(2).build();
    private static final MediaItem MEDIA_ITEM = new MediaItem.Builder().setMediaId("SilenceMediaSource").setUri(Uri.EMPTY).setMimeType(SilenceMediaSource.FORMAT.sampleMimeType).build();
    private static final byte[] SILENCE_SAMPLE = new byte[Util.getPcmFrameSize((int)2, (int)2) * 1024];
    private final long durationUs;
    private final MediaItem mediaItem;

    public SilenceMediaSource(long durationUs) {
        this(durationUs, MEDIA_ITEM);
    }

    private SilenceMediaSource(long durationUs, MediaItem mediaItem) {
        Assertions.checkArgument((durationUs >= 0L ? 1 : 0) != 0);
        this.durationUs = durationUs;
        this.mediaItem = mediaItem;
    }

    @Override
    protected void prepareSourceInternal(@Nullable TransferListener mediaTransferListener) {
        this.refreshSourceInfo(new SinglePeriodTimeline(this.durationUs, true, false, false, (Object)null, this.mediaItem));
    }

    @Override
    public void maybeThrowSourceInfoRefreshError() {
    }

    @Override
    public MediaPeriod createPeriod(MediaSource.MediaPeriodId id, Allocator allocator, long startPositionUs) {
        return new SilenceMediaPeriod(this.durationUs);
    }

    @Override
    public void releasePeriod(MediaPeriod mediaPeriod) {
    }

    @Override
    public MediaItem getMediaItem() {
        return this.mediaItem;
    }

    @Override
    protected void releaseSourceInternal() {
    }

    private static long getAudioByteCount(long durationUs) {
        long audioSampleCount = durationUs * 44100L / 1000000L;
        return (long)Util.getPcmFrameSize((int)2, (int)2) * audioSampleCount;
    }

    private static long getAudioPositionUs(long bytes) {
        long audioSampleCount = bytes / (long)Util.getPcmFrameSize((int)2, (int)2);
        return audioSampleCount * 1000000L / 44100L;
    }

    private static final class SilenceSampleStream
    implements SampleStream {
        private final long durationBytes;
        private boolean sentFormat;
        private long positionBytes;

        public SilenceSampleStream(long durationUs) {
            this.durationBytes = SilenceMediaSource.getAudioByteCount(durationUs);
            this.seekTo(0L);
        }

        public void seekTo(long positionUs) {
            this.positionBytes = Util.constrainValue((long)SilenceMediaSource.getAudioByteCount(positionUs), (long)0L, (long)this.durationBytes);
        }

        @Override
        public boolean isReady() {
            return true;
        }

        @Override
        public void maybeThrowError() {
        }

        @Override
        public int readData(FormatHolder formatHolder, DecoderInputBuffer buffer, int readFlags) {
            if (!this.sentFormat || (readFlags & 2) != 0) {
                formatHolder.format = FORMAT;
                this.sentFormat = true;
                return -5;
            }
            long bytesRemaining = this.durationBytes - this.positionBytes;
            if (bytesRemaining == 0L) {
                buffer.addFlag(4);
                return -4;
            }
            buffer.timeUs = SilenceMediaSource.getAudioPositionUs(this.positionBytes);
            buffer.addFlag(1);
            int bytesToWrite = (int)Math.min((long)SILENCE_SAMPLE.length, bytesRemaining);
            if ((readFlags & 4) == 0) {
                buffer.ensureSpaceForWrite(bytesToWrite);
                buffer.data.put(SILENCE_SAMPLE, 0, bytesToWrite);
            }
            if ((readFlags & 1) == 0) {
                this.positionBytes += (long)bytesToWrite;
            }
            return -4;
        }

        @Override
        public int skipData(long positionUs) {
            long oldPositionBytes = this.positionBytes;
            this.seekTo(positionUs);
            return (int)((this.positionBytes - oldPositionBytes) / (long)SILENCE_SAMPLE.length);
        }
    }

    private static final class SilenceMediaPeriod
    implements MediaPeriod {
        private static final TrackGroupArray TRACKS = new TrackGroupArray(new TrackGroup[]{new TrackGroup(new Format[]{SilenceMediaSource.access$200()})});
        private final long durationUs;
        private final ArrayList<SampleStream> sampleStreams;

        public SilenceMediaPeriod(long durationUs) {
            this.durationUs = durationUs;
            this.sampleStreams = new ArrayList();
        }

        @Override
        public void prepare(MediaPeriod.Callback callback, long positionUs) {
            callback.onPrepared(this);
        }

        @Override
        public void maybeThrowPrepareError() {
        }

        @Override
        public TrackGroupArray getTrackGroups() {
            return TRACKS;
        }

        @Override
        public long selectTracks(@NullableType ExoTrackSelection[] selections, boolean[] mayRetainStreamFlags, @NullableType SampleStream[] streams, boolean[] streamResetFlags, long positionUs) {
            positionUs = this.constrainSeekPosition(positionUs);
            for (int i = 0; i < selections.length; ++i) {
                if (!(streams[i] == null || selections[i] != null && mayRetainStreamFlags[i])) {
                    this.sampleStreams.remove(streams[i]);
                    streams[i] = null;
                }
                if (streams[i] != null || selections[i] == null) continue;
                SilenceSampleStream stream = new SilenceSampleStream(this.durationUs);
                stream.seekTo(positionUs);
                this.sampleStreams.add(stream);
                streams[i] = stream;
                streamResetFlags[i] = true;
            }
            return positionUs;
        }

        @Override
        public void discardBuffer(long positionUs, boolean toKeyframe) {
        }

        @Override
        public long readDiscontinuity() {
            return -9223372036854775807L;
        }

        @Override
        public long seekToUs(long positionUs) {
            positionUs = this.constrainSeekPosition(positionUs);
            for (int i = 0; i < this.sampleStreams.size(); ++i) {
                ((SilenceSampleStream)this.sampleStreams.get(i)).seekTo(positionUs);
            }
            return positionUs;
        }

        @Override
        public long getAdjustedSeekPositionUs(long positionUs, SeekParameters seekParameters) {
            return this.constrainSeekPosition(positionUs);
        }

        @Override
        public long getBufferedPositionUs() {
            return Long.MIN_VALUE;
        }

        @Override
        public long getNextLoadPositionUs() {
            return Long.MIN_VALUE;
        }

        @Override
        public boolean continueLoading(long positionUs) {
            return false;
        }

        @Override
        public boolean isLoading() {
            return false;
        }

        @Override
        public void reevaluateBuffer(long positionUs) {
        }

        private long constrainSeekPosition(long positionUs) {
            return Util.constrainValue((long)positionUs, (long)0L, (long)this.durationUs);
        }
    }

    public static final class Factory {
        private long durationUs;
        @Nullable
        private Object tag;

        public Factory setDurationUs(@IntRange(from=1L) long durationUs) {
            this.durationUs = durationUs;
            return this;
        }

        public Factory setTag(@Nullable Object tag) {
            this.tag = tag;
            return this;
        }

        public SilenceMediaSource createMediaSource() {
            Assertions.checkState((this.durationUs > 0L ? 1 : 0) != 0);
            return new SilenceMediaSource(this.durationUs, MEDIA_ITEM.buildUpon().setTag(this.tag).build());
        }
    }
}

