/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.source.chunk;

import androidx.annotation.Nullable;
import com.google.android.exoplayer2.Format;
import com.google.android.exoplayer2.extractor.DefaultExtractorInput;
import com.google.android.exoplayer2.extractor.ExtractorInput;
import com.google.android.exoplayer2.source.chunk.BaseMediaChunk;
import com.google.android.exoplayer2.source.chunk.BaseMediaChunkOutput;
import com.google.android.exoplayer2.source.chunk.ChunkExtractor;
import com.google.android.exoplayer2.upstream.DataReader;
import com.google.android.exoplayer2.upstream.DataSource;
import com.google.android.exoplayer2.upstream.DataSourceUtil;
import com.google.android.exoplayer2.upstream.DataSpec;
import java.io.IOException;

public class ContainerMediaChunk
extends BaseMediaChunk {
    private final int chunkCount;
    private final long sampleOffsetUs;
    private final ChunkExtractor chunkExtractor;
    private long nextLoadPosition;
    private volatile boolean loadCanceled;
    private boolean loadCompleted;

    public ContainerMediaChunk(DataSource dataSource, DataSpec dataSpec, Format trackFormat, int trackSelectionReason, @Nullable Object trackSelectionData, long startTimeUs, long endTimeUs, long clippedStartTimeUs, long clippedEndTimeUs, long chunkIndex, int chunkCount, long sampleOffsetUs, ChunkExtractor chunkExtractor) {
        super(dataSource, dataSpec, trackFormat, trackSelectionReason, trackSelectionData, startTimeUs, endTimeUs, clippedStartTimeUs, clippedEndTimeUs, chunkIndex);
        this.chunkCount = chunkCount;
        this.sampleOffsetUs = sampleOffsetUs;
        this.chunkExtractor = chunkExtractor;
    }

    @Override
    public long getNextChunkIndex() {
        return this.chunkIndex + (long)this.chunkCount;
    }

    @Override
    public boolean isLoadCompleted() {
        return this.loadCompleted;
    }

    @Override
    public final void cancelLoad() {
        this.loadCanceled = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void load() throws IOException {
        if (this.nextLoadPosition == 0L) {
            BaseMediaChunkOutput output = this.getOutput();
            output.setSampleOffsetUs(this.sampleOffsetUs);
            this.chunkExtractor.init(this.getTrackOutputProvider(output), this.clippedStartTimeUs == -9223372036854775807L ? -9223372036854775807L : this.clippedStartTimeUs - this.sampleOffsetUs, this.clippedEndTimeUs == -9223372036854775807L ? -9223372036854775807L : this.clippedEndTimeUs - this.sampleOffsetUs);
        }
        try {
            DataSpec loadDataSpec = this.dataSpec.subrange(this.nextLoadPosition);
            DefaultExtractorInput input = new DefaultExtractorInput((DataReader)this.dataSource, loadDataSpec.position, this.dataSource.open(loadDataSpec));
            try {
                while (!this.loadCanceled && this.chunkExtractor.read((ExtractorInput)input)) {
                }
            }
            finally {
                this.nextLoadPosition = input.getPosition() - this.dataSpec.position;
            }
        }
        finally {
            DataSourceUtil.closeQuietly((DataSource)this.dataSource);
        }
        this.loadCompleted = !this.loadCanceled;
    }

    protected ChunkExtractor.TrackOutputProvider getTrackOutputProvider(BaseMediaChunkOutput baseMediaChunkOutput) {
        return baseMediaChunkOutput;
    }
}

