/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.source.chunk;

import android.annotation.SuppressLint;
import android.media.MediaFormat;
import android.media.MediaParser;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import com.google.android.exoplayer2.Format;
import com.google.android.exoplayer2.analytics.PlayerId;
import com.google.android.exoplayer2.extractor.ChunkIndex;
import com.google.android.exoplayer2.extractor.DummyTrackOutput;
import com.google.android.exoplayer2.extractor.ExtractorInput;
import com.google.android.exoplayer2.extractor.ExtractorOutput;
import com.google.android.exoplayer2.extractor.SeekMap;
import com.google.android.exoplayer2.extractor.TrackOutput;
import com.google.android.exoplayer2.source.chunk.ChunkExtractor;
import com.google.android.exoplayer2.source.mediaparser.InputReaderAdapterV30;
import com.google.android.exoplayer2.source.mediaparser.MediaParserUtil;
import com.google.android.exoplayer2.source.mediaparser.OutputConsumerAdapterV30;
import com.google.android.exoplayer2.upstream.DataReader;
import com.google.android.exoplayer2.util.Assertions;
import com.google.android.exoplayer2.util.Log;
import com.google.android.exoplayer2.util.MimeTypes;
import com.google.android.exoplayer2.util.Util;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

@RequiresApi(value=30)
public final class MediaParserChunkExtractor
implements ChunkExtractor {
    private static final String TAG = "MediaPrsrChunkExtractor";
    public static final ChunkExtractor.Factory FACTORY = (primaryTrackType, format, enableEventMessageTrack, closedCaptionFormats, playerEmsgTrackOutput, playerId) -> {
        if (!MimeTypes.isText((String)format.containerMimeType)) {
            return new MediaParserChunkExtractor(primaryTrackType, format, closedCaptionFormats, playerId);
        }
        Log.w((String)TAG, (String)"Ignoring an unsupported text track.");
        return null;
    };
    private final OutputConsumerAdapterV30 outputConsumerAdapter;
    private final InputReaderAdapterV30 inputReaderAdapter;
    private final MediaParser mediaParser;
    private final TrackOutputProviderAdapter trackOutputProviderAdapter;
    private final DummyTrackOutput dummyTrackOutput;
    private long pendingSeekUs;
    @Nullable
    private ChunkExtractor.TrackOutputProvider trackOutputProvider;
    @Nullable
    private Format[] sampleFormats;

    @SuppressLint(value={"WrongConstant"})
    public MediaParserChunkExtractor(int primaryTrackType, Format manifestFormat, List<Format> closedCaptionFormats, PlayerId playerId) {
        this.outputConsumerAdapter = new OutputConsumerAdapterV30(manifestFormat, primaryTrackType, true);
        this.inputReaderAdapter = new InputReaderAdapterV30();
        String mimeType = (String)Assertions.checkNotNull((Object)manifestFormat.containerMimeType);
        String parserName = MimeTypes.isMatroska((String)mimeType) ? "android.media.mediaparser.MatroskaParser" : "android.media.mediaparser.FragmentedMp4Parser";
        this.outputConsumerAdapter.setSelectedParserName(parserName);
        this.mediaParser = MediaParser.createByName((String)parserName, (MediaParser.OutputConsumer)this.outputConsumerAdapter);
        this.mediaParser.setParameter("android.media.mediaparser.matroska.disableCuesSeeking", (Object)true);
        this.mediaParser.setParameter("android.media.mediaparser.inBandCryptoInfo", (Object)true);
        this.mediaParser.setParameter("android.media.mediaparser.includeSupplementalData", (Object)true);
        this.mediaParser.setParameter("android.media.mediaparser.eagerlyExposeTrackType", (Object)true);
        this.mediaParser.setParameter("android.media.mediaparser.exposeDummySeekMap", (Object)true);
        this.mediaParser.setParameter("android.media.mediaParser.exposeChunkIndexAsMediaFormat", (Object)true);
        this.mediaParser.setParameter("android.media.mediaParser.overrideInBandCaptionDeclarations", (Object)true);
        ArrayList<MediaFormat> closedCaptionMediaFormats = new ArrayList<MediaFormat>();
        for (int i = 0; i < closedCaptionFormats.size(); ++i) {
            closedCaptionMediaFormats.add(MediaParserUtil.toCaptionsMediaFormat(closedCaptionFormats.get(i)));
        }
        this.mediaParser.setParameter("android.media.mediaParser.exposeCaptionFormats", closedCaptionMediaFormats);
        if (Util.SDK_INT >= 31) {
            MediaParserUtil.setLogSessionIdOnMediaParser(this.mediaParser, playerId);
        }
        this.outputConsumerAdapter.setMuxedCaptionFormats(closedCaptionFormats);
        this.trackOutputProviderAdapter = new TrackOutputProviderAdapter();
        this.dummyTrackOutput = new DummyTrackOutput();
        this.pendingSeekUs = -9223372036854775807L;
    }

    @Override
    public void init(@Nullable ChunkExtractor.TrackOutputProvider trackOutputProvider, long startTimeUs, long endTimeUs) {
        this.trackOutputProvider = trackOutputProvider;
        this.outputConsumerAdapter.setSampleTimestampUpperLimitFilterUs(endTimeUs);
        this.outputConsumerAdapter.setExtractorOutput(this.trackOutputProviderAdapter);
        this.pendingSeekUs = startTimeUs;
    }

    @Override
    public void release() {
        this.mediaParser.release();
    }

    @Override
    public boolean read(ExtractorInput input) throws IOException {
        this.maybeExecutePendingSeek();
        this.inputReaderAdapter.setDataReader((DataReader)input, input.getLength());
        return this.mediaParser.advance((MediaParser.SeekableInputReader)this.inputReaderAdapter);
    }

    @Override
    @Nullable
    public ChunkIndex getChunkIndex() {
        return this.outputConsumerAdapter.getChunkIndex();
    }

    @Override
    @Nullable
    public Format[] getSampleFormats() {
        return this.sampleFormats;
    }

    private void maybeExecutePendingSeek() {
        MediaParser.SeekMap dummySeekMap = this.outputConsumerAdapter.getDummySeekMap();
        if (this.pendingSeekUs != -9223372036854775807L && dummySeekMap != null) {
            this.mediaParser.seek((MediaParser.SeekPoint)dummySeekMap.getSeekPoints((long)this.pendingSeekUs).first);
            this.pendingSeekUs = -9223372036854775807L;
        }
    }

    static /* synthetic */ Format[] access$302(MediaParserChunkExtractor x0, Format[] x1) {
        x0.sampleFormats = x1;
        return x1;
    }

    private class TrackOutputProviderAdapter
    implements ExtractorOutput {
        private TrackOutputProviderAdapter() {
        }

        public TrackOutput track(int id, int type) {
            return MediaParserChunkExtractor.this.trackOutputProvider != null ? MediaParserChunkExtractor.this.trackOutputProvider.track(id, type) : MediaParserChunkExtractor.this.dummyTrackOutput;
        }

        public void endTracks() {
            MediaParserChunkExtractor.access$302(MediaParserChunkExtractor.this, MediaParserChunkExtractor.this.outputConsumerAdapter.getSampleFormats());
        }

        public void seekMap(SeekMap seekMap) {
        }
    }
}

