/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.trackselection;

import android.os.SystemClock;
import androidx.annotation.Nullable;
import com.google.android.exoplayer2.source.TrackGroupArray;
import com.google.android.exoplayer2.trackselection.DefaultTrackSelector;
import com.google.android.exoplayer2.trackselection.ExoTrackSelection;
import com.google.android.exoplayer2.trackselection.FixedTrackSelection;
import com.google.android.exoplayer2.upstream.LoadErrorHandlingPolicy;
import org.checkerframework.checker.nullness.compatqual.NullableType;

public final class TrackSelectionUtil {
    private TrackSelectionUtil() {
    }

    public static @NullableType ExoTrackSelection[] createTrackSelectionsForDefinitions(@NullableType ExoTrackSelection.Definition[] definitions, AdaptiveTrackSelectionFactory adaptiveTrackSelectionFactory) {
        ExoTrackSelection[] selections = new ExoTrackSelection[definitions.length];
        boolean createdAdaptiveTrackSelection = false;
        for (int i = 0; i < definitions.length; ++i) {
            ExoTrackSelection.Definition definition = definitions[i];
            if (definition == null) continue;
            if (definition.tracks.length > 1 && !createdAdaptiveTrackSelection) {
                createdAdaptiveTrackSelection = true;
                selections[i] = adaptiveTrackSelectionFactory.createAdaptiveTrackSelection(definition);
                continue;
            }
            selections[i] = new FixedTrackSelection(definition.group, definition.tracks[0], definition.type);
        }
        return selections;
    }

    public static DefaultTrackSelector.Parameters updateParametersWithOverride(DefaultTrackSelector.Parameters parameters, int rendererIndex, TrackGroupArray trackGroupArray, boolean isDisabled, @Nullable DefaultTrackSelector.SelectionOverride override) {
        DefaultTrackSelector.ParametersBuilder builder = parameters.buildUpon().clearSelectionOverrides(rendererIndex).setRendererDisabled(rendererIndex, isDisabled);
        if (override != null) {
            builder.setSelectionOverride(rendererIndex, trackGroupArray, override);
        }
        return builder.build();
    }

    public static LoadErrorHandlingPolicy.FallbackOptions createFallbackOptions(ExoTrackSelection trackSelection) {
        long nowMs = SystemClock.elapsedRealtime();
        int numberOfTracks = trackSelection.length();
        int numberOfExcludedTracks = 0;
        for (int i = 0; i < numberOfTracks; ++i) {
            if (!trackSelection.isBlacklisted(i, nowMs)) continue;
            ++numberOfExcludedTracks;
        }
        return new LoadErrorHandlingPolicy.FallbackOptions(1, 0, numberOfTracks, numberOfExcludedTracks);
    }

    public static interface AdaptiveTrackSelectionFactory {
        public ExoTrackSelection createAdaptiveTrackSelection(ExoTrackSelection.Definition var1);
    }
}

