/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.util;

import android.annotation.SuppressLint;
import android.os.Looper;
import android.widget.TextView;
import com.google.android.exoplayer2.ExoPlayer;
import com.google.android.exoplayer2.Format;
import com.google.android.exoplayer2.Player;
import com.google.android.exoplayer2.decoder.DecoderCounters;
import com.google.android.exoplayer2.util.Assertions;
import java.util.Locale;

public class DebugTextViewHelper
implements Player.Listener,
Runnable {
    private static final int REFRESH_INTERVAL_MS = 1000;
    private final ExoPlayer player;
    private final TextView textView;
    private boolean started;

    public DebugTextViewHelper(ExoPlayer player, TextView textView) {
        Assertions.checkArgument((player.getApplicationLooper() == Looper.getMainLooper() ? 1 : 0) != 0);
        this.player = player;
        this.textView = textView;
    }

    public final void start() {
        if (this.started) {
            return;
        }
        this.started = true;
        this.player.addListener(this);
        this.updateAndPost();
    }

    public final void stop() {
        if (!this.started) {
            return;
        }
        this.started = false;
        this.player.removeListener(this);
        this.textView.removeCallbacks((Runnable)this);
    }

    public final void onPlaybackStateChanged(int playbackState) {
        this.updateAndPost();
    }

    public final void onPlayWhenReadyChanged(boolean playWhenReady, int reason) {
        this.updateAndPost();
    }

    public final void onPositionDiscontinuity(Player.PositionInfo oldPosition, Player.PositionInfo newPosition, int reason) {
        this.updateAndPost();
    }

    @Override
    public final void run() {
        this.updateAndPost();
    }

    @SuppressLint(value={"SetTextI18n"})
    protected final void updateAndPost() {
        this.textView.setText((CharSequence)this.getDebugString());
        this.textView.removeCallbacks((Runnable)this);
        this.textView.postDelayed((Runnable)this, 1000L);
    }

    protected String getDebugString() {
        String string2 = this.getPlayerStateString();
        String string3 = this.getVideoString();
        String string4 = this.getAudioString();
        return new StringBuilder(String.valueOf(string2).length() + String.valueOf(string3).length() + String.valueOf(string4).length()).append(string2).append(string3).append(string4).toString();
    }

    protected String getPlayerStateString() {
        String playbackStateString;
        switch (this.player.getPlaybackState()) {
            case 2: {
                playbackStateString = "buffering";
                break;
            }
            case 4: {
                playbackStateString = "ended";
                break;
            }
            case 1: {
                playbackStateString = "idle";
                break;
            }
            case 3: {
                playbackStateString = "ready";
                break;
            }
            default: {
                playbackStateString = "unknown";
            }
        }
        return String.format("playWhenReady:%s playbackState:%s item:%s", this.player.getPlayWhenReady(), playbackStateString, this.player.getCurrentMediaItemIndex());
    }

    protected String getVideoString() {
        Format format = this.player.getVideoFormat();
        DecoderCounters decoderCounters = this.player.getVideoDecoderCounters();
        if (format == null || decoderCounters == null) {
            return "";
        }
        String string2 = format.sampleMimeType;
        String string3 = format.id;
        int n = format.width;
        int n2 = format.height;
        String string4 = DebugTextViewHelper.getPixelAspectRatioString(format.pixelWidthHeightRatio);
        String string5 = DebugTextViewHelper.getDecoderCountersBufferCountString(decoderCounters);
        String string6 = DebugTextViewHelper.getVideoFrameProcessingOffsetAverageString(decoderCounters.totalVideoFrameProcessingOffsetUs, decoderCounters.videoFrameProcessingOffsetCount);
        return new StringBuilder(39 + String.valueOf(string2).length() + String.valueOf(string3).length() + String.valueOf(string4).length() + String.valueOf(string5).length() + String.valueOf(string6).length()).append("\n").append(string2).append("(id:").append(string3).append(" r:").append(n).append("x").append(n2).append(string4).append(string5).append(" vfpo: ").append(string6).append(")").toString();
    }

    protected String getAudioString() {
        Format format = this.player.getAudioFormat();
        DecoderCounters decoderCounters = this.player.getAudioDecoderCounters();
        if (format == null || decoderCounters == null) {
            return "";
        }
        String string2 = format.sampleMimeType;
        String string3 = format.id;
        int n = format.sampleRate;
        int n2 = format.channelCount;
        String string4 = DebugTextViewHelper.getDecoderCountersBufferCountString(decoderCounters);
        return new StringBuilder(36 + String.valueOf(string2).length() + String.valueOf(string3).length() + String.valueOf(string4).length()).append("\n").append(string2).append("(id:").append(string3).append(" hz:").append(n).append(" ch:").append(n2).append(string4).append(")").toString();
    }

    private static String getDecoderCountersBufferCountString(DecoderCounters counters) {
        if (counters == null) {
            return "";
        }
        counters.ensureUpdated();
        int n = counters.skippedInputBufferCount;
        int n2 = counters.skippedOutputBufferCount;
        int n3 = counters.renderedOutputBufferCount;
        int n4 = counters.droppedBufferCount;
        int n5 = counters.maxConsecutiveDroppedBufferCount;
        int n6 = counters.droppedToKeyframeCount;
        return new StringBuilder(93).append(" sib:").append(n).append(" sb:").append(n2).append(" rb:").append(n3).append(" db:").append(n4).append(" mcdb:").append(n5).append(" dk:").append(n6).toString();
    }

    private static String getPixelAspectRatioString(float pixelAspectRatio) {
        String string2;
        if (pixelAspectRatio == -1.0f || pixelAspectRatio == 1.0f) {
            string2 = "";
        } else {
            String string3 = String.valueOf(String.format(Locale.US, "%.02f", Float.valueOf(pixelAspectRatio)));
            string2 = string3.length() != 0 ? " par:".concat(string3) : new String(" par:");
        }
        return string2;
    }

    private static String getVideoFrameProcessingOffsetAverageString(long totalOffsetUs, int frameCount) {
        if (frameCount == 0) {
            return "N/A";
        }
        long averageUs = (long)((double)totalOffsetUs / (double)frameCount);
        return String.valueOf(averageUs);
    }
}

