/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.util;

import android.os.SystemClock;
import android.text.TextUtils;
import androidx.annotation.Nullable;
import com.google.android.exoplayer2.Format;
import com.google.android.exoplayer2.MediaItem;
import com.google.android.exoplayer2.PlaybackException;
import com.google.android.exoplayer2.PlaybackParameters;
import com.google.android.exoplayer2.Player;
import com.google.android.exoplayer2.RendererCapabilities;
import com.google.android.exoplayer2.Timeline;
import com.google.android.exoplayer2.analytics.AnalyticsListener;
import com.google.android.exoplayer2.audio.AudioAttributes;
import com.google.android.exoplayer2.decoder.DecoderCounters;
import com.google.android.exoplayer2.decoder.DecoderReuseEvaluation;
import com.google.android.exoplayer2.metadata.Metadata;
import com.google.android.exoplayer2.source.LoadEventInfo;
import com.google.android.exoplayer2.source.MediaLoadData;
import com.google.android.exoplayer2.source.TrackGroup;
import com.google.android.exoplayer2.source.TrackGroupArray;
import com.google.android.exoplayer2.trackselection.MappingTrackSelector;
import com.google.android.exoplayer2.trackselection.TrackSelection;
import com.google.android.exoplayer2.trackselection.TrackSelectionArray;
import com.google.android.exoplayer2.util.Log;
import com.google.android.exoplayer2.util.Util;
import com.google.android.exoplayer2.video.VideoSize;
import java.io.IOException;
import java.text.NumberFormat;
import java.util.Locale;

public class EventLogger
implements AnalyticsListener {
    private static final String DEFAULT_TAG = "EventLogger";
    private static final int MAX_TIMELINE_ITEM_LINES = 3;
    private static final NumberFormat TIME_FORMAT = NumberFormat.getInstance(Locale.US);
    @Nullable
    private final MappingTrackSelector trackSelector;
    private final String tag;
    private final Timeline.Window window;
    private final Timeline.Period period;
    private final long startTimeMs;

    public EventLogger(@Nullable MappingTrackSelector trackSelector) {
        this(trackSelector, DEFAULT_TAG);
    }

    public EventLogger(@Nullable MappingTrackSelector trackSelector, String tag) {
        this.trackSelector = trackSelector;
        this.tag = tag;
        this.window = new Timeline.Window();
        this.period = new Timeline.Period();
        this.startTimeMs = SystemClock.elapsedRealtime();
    }

    @Override
    public void onIsLoadingChanged(AnalyticsListener.EventTime eventTime, boolean isLoading) {
        this.logd(eventTime, "loading", Boolean.toString(isLoading));
    }

    @Override
    public void onPlaybackStateChanged(AnalyticsListener.EventTime eventTime, int state) {
        this.logd(eventTime, "state", EventLogger.getStateString(state));
    }

    @Override
    public void onPlayWhenReadyChanged(AnalyticsListener.EventTime eventTime, boolean playWhenReady, int reason) {
        String string2 = EventLogger.getPlayWhenReadyChangeReasonString(reason);
        this.logd(eventTime, "playWhenReady", new StringBuilder(7 + String.valueOf(string2).length()).append(playWhenReady).append(", ").append(string2).toString());
    }

    @Override
    public void onPlaybackSuppressionReasonChanged(AnalyticsListener.EventTime eventTime, int playbackSuppressionReason) {
        this.logd(eventTime, "playbackSuppressionReason", EventLogger.getPlaybackSuppressionReasonString(playbackSuppressionReason));
    }

    @Override
    public void onIsPlayingChanged(AnalyticsListener.EventTime eventTime, boolean isPlaying) {
        this.logd(eventTime, "isPlaying", Boolean.toString(isPlaying));
    }

    @Override
    public void onRepeatModeChanged(AnalyticsListener.EventTime eventTime, int repeatMode) {
        this.logd(eventTime, "repeatMode", EventLogger.getRepeatModeString(repeatMode));
    }

    @Override
    public void onShuffleModeChanged(AnalyticsListener.EventTime eventTime, boolean shuffleModeEnabled) {
        this.logd(eventTime, "shuffleModeEnabled", Boolean.toString(shuffleModeEnabled));
    }

    @Override
    public void onPositionDiscontinuity(AnalyticsListener.EventTime eventTime, Player.PositionInfo oldPosition, Player.PositionInfo newPosition, int reason) {
        StringBuilder builder = new StringBuilder();
        builder.append("reason=").append(EventLogger.getDiscontinuityReasonString(reason)).append(", PositionInfo:old [").append("mediaItem=").append(oldPosition.mediaItemIndex).append(", period=").append(oldPosition.periodIndex).append(", pos=").append(oldPosition.positionMs);
        if (oldPosition.adGroupIndex != -1) {
            builder.append(", contentPos=").append(oldPosition.contentPositionMs).append(", adGroup=").append(oldPosition.adGroupIndex).append(", ad=").append(oldPosition.adIndexInAdGroup);
        }
        builder.append("], PositionInfo:new [").append("mediaItem=").append(newPosition.mediaItemIndex).append(", period=").append(newPosition.periodIndex).append(", pos=").append(newPosition.positionMs);
        if (newPosition.adGroupIndex != -1) {
            builder.append(", contentPos=").append(newPosition.contentPositionMs).append(", adGroup=").append(newPosition.adGroupIndex).append(", ad=").append(newPosition.adIndexInAdGroup);
        }
        builder.append("]");
        this.logd(eventTime, "positionDiscontinuity", builder.toString());
    }

    @Override
    public void onPlaybackParametersChanged(AnalyticsListener.EventTime eventTime, PlaybackParameters playbackParameters) {
        this.logd(eventTime, "playbackParameters", playbackParameters.toString());
    }

    @Override
    public void onTimelineChanged(AnalyticsListener.EventTime eventTime, int reason) {
        int i;
        int periodCount = eventTime.timeline.getPeriodCount();
        int windowCount = eventTime.timeline.getWindowCount();
        String string2 = this.getEventTimeString(eventTime);
        String string3 = EventLogger.getTimelineChangeReasonString(reason);
        this.logd(new StringBuilder(69 + String.valueOf(string2).length() + String.valueOf(string3).length()).append("timeline [").append(string2).append(", periodCount=").append(periodCount).append(", windowCount=").append(windowCount).append(", reason=").append(string3).toString());
        for (i = 0; i < Math.min(periodCount, 3); ++i) {
            eventTime.timeline.getPeriod(i, this.period);
            string3 = EventLogger.getTimeString(this.period.getDurationMs());
            this.logd(new StringBuilder(11 + String.valueOf(string3).length()).append("  period [").append(string3).append("]").toString());
        }
        if (periodCount > 3) {
            this.logd("  ...");
        }
        for (i = 0; i < Math.min(windowCount, 3); ++i) {
            eventTime.timeline.getWindow(i, this.window);
            string3 = EventLogger.getTimeString(this.window.getDurationMs());
            boolean bl = this.window.isSeekable;
            boolean bl2 = this.window.isDynamic;
            this.logd(new StringBuilder(42 + String.valueOf(string3).length()).append("  window [").append(string3).append(", seekable=").append(bl).append(", dynamic=").append(bl2).append("]").toString());
        }
        if (windowCount > 3) {
            this.logd("  ...");
        }
        this.logd("]");
    }

    @Override
    public void onMediaItemTransition(AnalyticsListener.EventTime eventTime, @Nullable MediaItem mediaItem, int reason) {
        String string2 = this.getEventTimeString(eventTime);
        String string3 = EventLogger.getMediaItemTransitionReasonString(reason);
        this.logd(new StringBuilder(21 + String.valueOf(string2).length() + String.valueOf(string3).length()).append("mediaItem [").append(string2).append(", reason=").append(string3).append("]").toString());
    }

    @Override
    public void onPlayerError(AnalyticsListener.EventTime eventTime, PlaybackException error) {
        this.loge(eventTime, "playerFailed", (Throwable)error);
    }

    @Override
    public void onTracksChanged(AnalyticsListener.EventTime eventTime, TrackGroupArray trackGroups, TrackSelectionArray trackSelections) {
        MappingTrackSelector.MappedTrackInfo mappedTrackInfo;
        MappingTrackSelector.MappedTrackInfo mappedTrackInfo2 = mappedTrackInfo = this.trackSelector != null ? this.trackSelector.getCurrentMappedTrackInfo() : null;
        if (mappedTrackInfo == null) {
            this.logd(eventTime, "tracks", "[]");
            return;
        }
        String string2 = String.valueOf(this.getEventTimeString(eventTime));
        this.logd(string2.length() != 0 ? "tracks [".concat(string2) : new String("tracks ["));
        int rendererCount = mappedTrackInfo.getRendererCount();
        for (int rendererIndex = 0; rendererIndex < rendererCount; ++rendererIndex) {
            String string3;
            TrackGroupArray rendererTrackGroups = mappedTrackInfo.getTrackGroups(rendererIndex);
            TrackSelection trackSelection = trackSelections.get(rendererIndex);
            if (rendererTrackGroups.length == 0) {
                string3 = mappedTrackInfo.getRendererName(rendererIndex);
                this.logd(new StringBuilder(5 + String.valueOf(string3).length()).append("  ").append(string3).append(" []").toString());
                continue;
            }
            string3 = mappedTrackInfo.getRendererName(rendererIndex);
            this.logd(new StringBuilder(4 + String.valueOf(string3).length()).append("  ").append(string3).append(" [").toString());
            for (int groupIndex = 0; groupIndex < rendererTrackGroups.length; ++groupIndex) {
                TrackGroup trackGroup = rendererTrackGroups.get(groupIndex);
                String adaptiveSupport = EventLogger.getAdaptiveSupportString(trackGroup.length, mappedTrackInfo.getAdaptiveSupport(rendererIndex, groupIndex, false));
                String string4 = trackGroup.id;
                this.logd(new StringBuilder(33 + String.valueOf(string4).length() + String.valueOf(adaptiveSupport).length()).append("    Group:").append(string4).append(", adaptive_supported=").append(adaptiveSupport).append(" [").toString());
                for (int trackIndex = 0; trackIndex < trackGroup.length; ++trackIndex) {
                    String status = EventLogger.getTrackStatusString(trackSelection, trackGroup, trackIndex);
                    int capabilities = mappedTrackInfo.getCapabilities(rendererIndex, groupIndex, trackIndex);
                    String formatSupport = Util.getFormatSupportString((int)RendererCapabilities.getFormatSupport(capabilities));
                    String hardwareAccelerationSupport = RendererCapabilities.getHardwareAccelerationSupport(capabilities) == 64 ? ", accelerated=YES" : "";
                    String decoderSupport = RendererCapabilities.getDecoderSupport(capabilities) == 0 ? ", fallback=YES" : "";
                    int n = trackIndex;
                    String string5 = Format.toLogString((Format)trackGroup.getFormat(trackIndex));
                    this.logd(new StringBuilder(38 + String.valueOf(status).length() + String.valueOf(string5).length() + String.valueOf(formatSupport).length() + String.valueOf(hardwareAccelerationSupport).length() + String.valueOf(decoderSupport).length()).append("      ").append(status).append(" Track:").append(n).append(", ").append(string5).append(", supported=").append(formatSupport).append(hardwareAccelerationSupport).append(decoderSupport).toString());
                }
                this.logd("    ]");
            }
            if (trackSelection != null) {
                for (int selectionIndex = 0; selectionIndex < trackSelection.length(); ++selectionIndex) {
                    Metadata metadata = trackSelection.getFormat((int)selectionIndex).metadata;
                    if (metadata == null) continue;
                    this.logd("    Metadata [");
                    this.printMetadata(metadata, "      ");
                    this.logd("    ]");
                    break;
                }
            }
            this.logd("  ]");
        }
        TrackGroupArray unassociatedTrackGroups = mappedTrackInfo.getUnmappedTrackGroups();
        if (unassociatedTrackGroups.length > 0) {
            this.logd("  Unmapped [");
            for (int groupIndex = 0; groupIndex < unassociatedTrackGroups.length; ++groupIndex) {
                int trackSelection = groupIndex;
                this.logd(new StringBuilder(23).append("    Group:").append(trackSelection).append(" [").toString());
                TrackGroup trackGroup = unassociatedTrackGroups.get(groupIndex);
                for (int trackIndex = 0; trackIndex < trackGroup.length; ++trackIndex) {
                    String status = EventLogger.getTrackStatusString(false);
                    String formatSupport = Util.getFormatSupportString((int)0);
                    int n = trackIndex;
                    String string6 = Format.toLogString((Format)trackGroup.getFormat(trackIndex));
                    this.logd(new StringBuilder(38 + String.valueOf(status).length() + String.valueOf(string6).length() + String.valueOf(formatSupport).length()).append("      ").append(status).append(" Track:").append(n).append(", ").append(string6).append(", supported=").append(formatSupport).toString());
                }
                this.logd("    ]");
            }
            this.logd("  ]");
        }
        this.logd("]");
    }

    @Override
    public void onMetadata(AnalyticsListener.EventTime eventTime, Metadata metadata) {
        String string2 = String.valueOf(this.getEventTimeString(eventTime));
        this.logd(string2.length() != 0 ? "metadata [".concat(string2) : new String("metadata ["));
        this.printMetadata(metadata, "  ");
        this.logd("]");
    }

    @Override
    public void onAudioEnabled(AnalyticsListener.EventTime eventTime, DecoderCounters decoderCounters) {
        this.logd(eventTime, "audioEnabled");
    }

    @Override
    public void onAudioDecoderInitialized(AnalyticsListener.EventTime eventTime, String decoderName, long initializationDurationMs) {
        this.logd(eventTime, "audioDecoderInitialized", decoderName);
    }

    @Override
    public void onAudioInputFormatChanged(AnalyticsListener.EventTime eventTime, Format format, @Nullable DecoderReuseEvaluation decoderReuseEvaluation) {
        this.logd(eventTime, "audioInputFormat", Format.toLogString((Format)format));
    }

    @Override
    public void onAudioUnderrun(AnalyticsListener.EventTime eventTime, int bufferSize, long bufferSizeMs, long elapsedSinceLastFeedMs) {
        this.loge(eventTime, "audioTrackUnderrun", new StringBuilder(55).append(bufferSize).append(", ").append(bufferSizeMs).append(", ").append(elapsedSinceLastFeedMs).toString(), null);
    }

    @Override
    public void onAudioDecoderReleased(AnalyticsListener.EventTime eventTime, String decoderName) {
        this.logd(eventTime, "audioDecoderReleased", decoderName);
    }

    @Override
    public void onAudioDisabled(AnalyticsListener.EventTime eventTime, DecoderCounters decoderCounters) {
        this.logd(eventTime, "audioDisabled");
    }

    @Override
    public void onAudioSessionIdChanged(AnalyticsListener.EventTime eventTime, int audioSessionId) {
        this.logd(eventTime, "audioSessionId", Integer.toString(audioSessionId));
    }

    @Override
    public void onAudioAttributesChanged(AnalyticsListener.EventTime eventTime, AudioAttributes audioAttributes) {
        int n = audioAttributes.contentType;
        int n2 = audioAttributes.flags;
        int n3 = audioAttributes.usage;
        int n4 = audioAttributes.allowedCapturePolicy;
        this.logd(eventTime, "audioAttributes", new StringBuilder(47).append(n).append(",").append(n2).append(",").append(n3).append(",").append(n4).toString());
    }

    @Override
    public void onSkipSilenceEnabledChanged(AnalyticsListener.EventTime eventTime, boolean skipSilenceEnabled) {
        this.logd(eventTime, "skipSilenceEnabled", Boolean.toString(skipSilenceEnabled));
    }

    @Override
    public void onVolumeChanged(AnalyticsListener.EventTime eventTime, float volume) {
        this.logd(eventTime, "volume", Float.toString(volume));
    }

    @Override
    public void onVideoEnabled(AnalyticsListener.EventTime eventTime, DecoderCounters decoderCounters) {
        this.logd(eventTime, "videoEnabled");
    }

    @Override
    public void onVideoDecoderInitialized(AnalyticsListener.EventTime eventTime, String decoderName, long initializationDurationMs) {
        this.logd(eventTime, "videoDecoderInitialized", decoderName);
    }

    @Override
    public void onVideoInputFormatChanged(AnalyticsListener.EventTime eventTime, Format format, @Nullable DecoderReuseEvaluation decoderReuseEvaluation) {
        this.logd(eventTime, "videoInputFormat", Format.toLogString((Format)format));
    }

    @Override
    public void onDroppedVideoFrames(AnalyticsListener.EventTime eventTime, int droppedFrames, long elapsedMs) {
        this.logd(eventTime, "droppedFrames", Integer.toString(droppedFrames));
    }

    @Override
    public void onVideoDecoderReleased(AnalyticsListener.EventTime eventTime, String decoderName) {
        this.logd(eventTime, "videoDecoderReleased", decoderName);
    }

    @Override
    public void onVideoDisabled(AnalyticsListener.EventTime eventTime, DecoderCounters decoderCounters) {
        this.logd(eventTime, "videoDisabled");
    }

    @Override
    public void onRenderedFirstFrame(AnalyticsListener.EventTime eventTime, Object output, long renderTimeMs) {
        this.logd(eventTime, "renderedFirstFrame", String.valueOf(output));
    }

    @Override
    public void onVideoSizeChanged(AnalyticsListener.EventTime eventTime, VideoSize videoSize) {
        int n = videoSize.width;
        int n2 = videoSize.height;
        this.logd(eventTime, "videoSize", new StringBuilder(24).append(n).append(", ").append(n2).toString());
    }

    @Override
    public void onLoadStarted(AnalyticsListener.EventTime eventTime, LoadEventInfo loadEventInfo, MediaLoadData mediaLoadData) {
    }

    @Override
    public void onLoadError(AnalyticsListener.EventTime eventTime, LoadEventInfo loadEventInfo, MediaLoadData mediaLoadData, IOException error, boolean wasCanceled) {
        this.printInternalError(eventTime, "loadError", error);
    }

    @Override
    public void onLoadCanceled(AnalyticsListener.EventTime eventTime, LoadEventInfo loadEventInfo, MediaLoadData mediaLoadData) {
    }

    @Override
    public void onLoadCompleted(AnalyticsListener.EventTime eventTime, LoadEventInfo loadEventInfo, MediaLoadData mediaLoadData) {
    }

    @Override
    public void onBandwidthEstimate(AnalyticsListener.EventTime eventTime, int totalLoadTimeMs, long totalBytesLoaded, long bitrateEstimate) {
    }

    @Override
    public void onSurfaceSizeChanged(AnalyticsListener.EventTime eventTime, int width, int height) {
        this.logd(eventTime, "surfaceSize", new StringBuilder(24).append(width).append(", ").append(height).toString());
    }

    @Override
    public void onUpstreamDiscarded(AnalyticsListener.EventTime eventTime, MediaLoadData mediaLoadData) {
        this.logd(eventTime, "upstreamDiscarded", Format.toLogString((Format)mediaLoadData.trackFormat));
    }

    @Override
    public void onDownstreamFormatChanged(AnalyticsListener.EventTime eventTime, MediaLoadData mediaLoadData) {
        this.logd(eventTime, "downstreamFormat", Format.toLogString((Format)mediaLoadData.trackFormat));
    }

    @Override
    public void onDrmSessionAcquired(AnalyticsListener.EventTime eventTime, int state) {
        this.logd(eventTime, "drmSessionAcquired", new StringBuilder(17).append("state=").append(state).toString());
    }

    @Override
    public void onDrmSessionManagerError(AnalyticsListener.EventTime eventTime, Exception error) {
        this.printInternalError(eventTime, "drmSessionManagerError", error);
    }

    @Override
    public void onDrmKeysRestored(AnalyticsListener.EventTime eventTime) {
        this.logd(eventTime, "drmKeysRestored");
    }

    @Override
    public void onDrmKeysRemoved(AnalyticsListener.EventTime eventTime) {
        this.logd(eventTime, "drmKeysRemoved");
    }

    @Override
    public void onDrmKeysLoaded(AnalyticsListener.EventTime eventTime) {
        this.logd(eventTime, "drmKeysLoaded");
    }

    @Override
    public void onDrmSessionReleased(AnalyticsListener.EventTime eventTime) {
        this.logd(eventTime, "drmSessionReleased");
    }

    protected void logd(String msg) {
        Log.d((String)this.tag, (String)msg);
    }

    protected void loge(String msg) {
        Log.e((String)this.tag, (String)msg);
    }

    private void logd(AnalyticsListener.EventTime eventTime, String eventName) {
        this.logd(this.getEventString(eventTime, eventName, null, null));
    }

    private void logd(AnalyticsListener.EventTime eventTime, String eventName, String eventDescription) {
        this.logd(this.getEventString(eventTime, eventName, eventDescription, null));
    }

    private void loge(AnalyticsListener.EventTime eventTime, String eventName, @Nullable Throwable throwable) {
        this.loge(this.getEventString(eventTime, eventName, null, throwable));
    }

    private void loge(AnalyticsListener.EventTime eventTime, String eventName, String eventDescription, @Nullable Throwable throwable) {
        this.loge(this.getEventString(eventTime, eventName, eventDescription, throwable));
    }

    private void printInternalError(AnalyticsListener.EventTime eventTime, String type, Exception e) {
        this.loge(eventTime, "internalError", type, e);
    }

    private void printMetadata(Metadata metadata, String prefix) {
        for (int i = 0; i < metadata.length(); ++i) {
            String string2 = String.valueOf(metadata.get(i));
            this.logd(new StringBuilder(String.valueOf(prefix).length() + String.valueOf(string2).length()).append(prefix).append(string2).toString());
        }
    }

    private String getEventString(AnalyticsListener.EventTime eventTime, String eventName, @Nullable String eventDescription, @Nullable Throwable throwable) {
        String throwableString;
        String string2;
        String string3 = this.getEventTimeString(eventTime);
        String eventString = new StringBuilder(2 + String.valueOf(eventName).length() + String.valueOf(string3).length()).append(eventName).append(" [").append(string3).toString();
        if (throwable instanceof PlaybackException) {
            string3 = String.valueOf(eventString);
            string2 = ((PlaybackException)throwable).getErrorCodeName();
            eventString = new StringBuilder(12 + String.valueOf(string3).length() + String.valueOf(string2).length()).append(string3).append(", errorCode=").append(string2).toString();
        }
        if (eventDescription != null) {
            string3 = String.valueOf(eventString);
            eventString = new StringBuilder(2 + String.valueOf(string3).length() + String.valueOf(eventDescription).length()).append(string3).append(", ").append(eventDescription).toString();
        }
        if (!TextUtils.isEmpty((CharSequence)(throwableString = Log.getThrowableString((Throwable)throwable)))) {
            string2 = String.valueOf(eventString);
            String string4 = throwableString.replace("\n", "\n  ");
            eventString = new StringBuilder(4 + String.valueOf(string2).length() + String.valueOf(string4).length()).append(string2).append("\n  ").append(string4).append('\n').toString();
        }
        eventString = String.valueOf(eventString).concat("]");
        return eventString;
    }

    private String getEventTimeString(AnalyticsListener.EventTime eventTime) {
        int n = eventTime.windowIndex;
        String windowPeriodString = new StringBuilder(18).append("window=").append(n).toString();
        if (eventTime.mediaPeriodId != null) {
            String string2 = String.valueOf(windowPeriodString);
            int n2 = eventTime.timeline.getIndexOfPeriod(eventTime.mediaPeriodId.periodUid);
            windowPeriodString = new StringBuilder(20 + String.valueOf(string2).length()).append(string2).append(", period=").append(n2).toString();
            if (eventTime.mediaPeriodId.isAd()) {
                string2 = String.valueOf(windowPeriodString);
                n2 = eventTime.mediaPeriodId.adGroupIndex;
                windowPeriodString = new StringBuilder(21 + String.valueOf(string2).length()).append(string2).append(", adGroup=").append(n2).toString();
                string2 = String.valueOf(windowPeriodString);
                n2 = eventTime.mediaPeriodId.adIndexInAdGroup;
                windowPeriodString = new StringBuilder(16 + String.valueOf(string2).length()).append(string2).append(", ad=").append(n2).toString();
            }
        }
        String string3 = EventLogger.getTimeString(eventTime.realtimeMs - this.startTimeMs);
        String string4 = EventLogger.getTimeString(eventTime.eventPlaybackPositionMs);
        String string5 = windowPeriodString;
        return new StringBuilder(23 + String.valueOf(string3).length() + String.valueOf(string4).length() + String.valueOf(string5).length()).append("eventTime=").append(string3).append(", mediaPos=").append(string4).append(", ").append(string5).toString();
    }

    private static String getTimeString(long timeMs) {
        return timeMs == -9223372036854775807L ? "?" : TIME_FORMAT.format((float)timeMs / 1000.0f);
    }

    private static String getStateString(int state) {
        switch (state) {
            case 2: {
                return "BUFFERING";
            }
            case 4: {
                return "ENDED";
            }
            case 1: {
                return "IDLE";
            }
            case 3: {
                return "READY";
            }
        }
        return "?";
    }

    private static String getAdaptiveSupportString(int trackCount, int adaptiveSupport) {
        if (trackCount < 2) {
            return "N/A";
        }
        switch (adaptiveSupport) {
            case 16: {
                return "YES";
            }
            case 8: {
                return "YES_NOT_SEAMLESS";
            }
            case 0: {
                return "NO";
            }
        }
        throw new IllegalStateException();
    }

    private static String getTrackStatusString(@Nullable TrackSelection selection, TrackGroup group, int trackIndex) {
        return EventLogger.getTrackStatusString(selection != null && selection.getTrackGroup().equals((Object)group) && selection.indexOf(trackIndex) != -1);
    }

    private static String getTrackStatusString(boolean enabled) {
        return enabled ? "[X]" : "[ ]";
    }

    private static String getRepeatModeString(int repeatMode) {
        switch (repeatMode) {
            case 0: {
                return "OFF";
            }
            case 1: {
                return "ONE";
            }
            case 2: {
                return "ALL";
            }
        }
        return "?";
    }

    private static String getDiscontinuityReasonString(int reason) {
        switch (reason) {
            case 0: {
                return "AUTO_TRANSITION";
            }
            case 1: {
                return "SEEK";
            }
            case 2: {
                return "SEEK_ADJUSTMENT";
            }
            case 4: {
                return "REMOVE";
            }
            case 3: {
                return "SKIP";
            }
            case 5: {
                return "INTERNAL";
            }
        }
        return "?";
    }

    private static String getTimelineChangeReasonString(int reason) {
        switch (reason) {
            case 1: {
                return "SOURCE_UPDATE";
            }
            case 0: {
                return "PLAYLIST_CHANGED";
            }
        }
        return "?";
    }

    private static String getMediaItemTransitionReasonString(int reason) {
        switch (reason) {
            case 1: {
                return "AUTO";
            }
            case 3: {
                return "PLAYLIST_CHANGED";
            }
            case 0: {
                return "REPEAT";
            }
            case 2: {
                return "SEEK";
            }
        }
        return "?";
    }

    private static String getPlaybackSuppressionReasonString(int playbackSuppressionReason) {
        switch (playbackSuppressionReason) {
            case 0: {
                return "NONE";
            }
            case 1: {
                return "TRANSIENT_AUDIO_FOCUS_LOSS";
            }
        }
        return "?";
    }

    private static String getPlayWhenReadyChangeReasonString(int reason) {
        switch (reason) {
            case 3: {
                return "AUDIO_BECOMING_NOISY";
            }
            case 2: {
                return "AUDIO_FOCUS_LOSS";
            }
            case 4: {
                return "REMOTE";
            }
            case 1: {
                return "USER_REQUEST";
            }
            case 5: {
                return "END_OF_MEDIA_ITEM";
            }
        }
        return "?";
    }

    static {
        TIME_FORMAT.setMinimumFractionDigits(2);
        TIME_FORMAT.setMaximumFractionDigits(2);
        TIME_FORMAT.setGroupingUsed(false);
    }
}

