/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.video;

import android.content.Context;
import android.graphics.SurfaceTexture;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Message;
import android.view.Surface;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import com.google.android.exoplayer2.util.Assertions;
import com.google.android.exoplayer2.util.EGLSurfaceTexture;
import com.google.android.exoplayer2.util.GlUtil;
import com.google.android.exoplayer2.util.Log;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;

@RequiresApi(value=17)
public final class DummySurface
extends Surface {
    private static final String TAG = "DummySurface";
    public final boolean secure;
    private static int secureMode;
    private static boolean secureModeInitialized;
    private final DummySurfaceThread thread;
    private boolean threadReleased;

    public static synchronized boolean isSecureSupported(Context context) {
        if (!secureModeInitialized) {
            secureMode = DummySurface.getSecureMode(context);
            secureModeInitialized = true;
        }
        return secureMode != 0;
    }

    public static DummySurface newInstanceV17(Context context, boolean secure) {
        Assertions.checkState((!secure || DummySurface.isSecureSupported(context) ? 1 : 0) != 0);
        DummySurfaceThread thread = new DummySurfaceThread();
        return thread.init(secure ? secureMode : 0);
    }

    private DummySurface(DummySurfaceThread thread, SurfaceTexture surfaceTexture, boolean secure) {
        super(surfaceTexture);
        this.thread = thread;
        this.secure = secure;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release() {
        super.release();
        DummySurfaceThread dummySurfaceThread = this.thread;
        synchronized (dummySurfaceThread) {
            if (!this.threadReleased) {
                this.thread.release();
                this.threadReleased = true;
            }
        }
    }

    private static int getSecureMode(Context context) {
        if (GlUtil.isProtectedContentExtensionSupported((Context)context)) {
            if (GlUtil.isSurfacelessContextExtensionSupported()) {
                return 1;
            }
            return 2;
        }
        return 0;
    }

    private static class DummySurfaceThread
    extends HandlerThread
    implements Handler.Callback {
        private static final int MSG_INIT = 1;
        private static final int MSG_RELEASE = 2;
        private @MonotonicNonNull EGLSurfaceTexture eglSurfaceTexture;
        private @MonotonicNonNull Handler handler;
        @Nullable
        private Error initError;
        @Nullable
        private RuntimeException initException;
        @Nullable
        private DummySurface surface;

        public DummySurfaceThread() {
            super("ExoPlayer:DummySurface");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public DummySurface init(int secureMode) {
            this.start();
            this.handler = new Handler(this.getLooper(), (Handler.Callback)this);
            this.eglSurfaceTexture = new EGLSurfaceTexture(this.handler);
            boolean wasInterrupted = false;
            DummySurfaceThread dummySurfaceThread = this;
            synchronized (dummySurfaceThread) {
                this.handler.obtainMessage(1, secureMode, 0).sendToTarget();
                while (this.surface == null && this.initException == null && this.initError == null) {
                    try {
                        ((Object)((Object)this)).wait();
                    }
                    catch (InterruptedException e) {
                        wasInterrupted = true;
                    }
                }
            }
            if (wasInterrupted) {
                Thread.currentThread().interrupt();
            }
            if (this.initException != null) {
                throw this.initException;
            }
            if (this.initError != null) {
                throw this.initError;
            }
            return (DummySurface)((Object)Assertions.checkNotNull((Object)((Object)this.surface)));
        }

        public void release() {
            Assertions.checkNotNull((Object)this.handler);
            this.handler.sendEmptyMessage(2);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean handleMessage(Message msg) {
            switch (msg.what) {
                case 1: {
                    try {
                        this.initInternal(msg.arg1);
                    }
                    catch (RuntimeException e) {
                        Log.e((String)DummySurface.TAG, (String)"Failed to initialize dummy surface", (Throwable)e);
                        this.initException = e;
                    }
                    catch (Error e) {
                        Log.e((String)DummySurface.TAG, (String)"Failed to initialize dummy surface", (Throwable)e);
                        this.initError = e;
                    }
                    finally {
                        DummySurfaceThread e = this;
                        synchronized (e) {
                            ((Object)((Object)this)).notify();
                        }
                    }
                    return true;
                }
                case 2: {
                    try {
                        this.releaseInternal();
                    }
                    catch (Throwable e) {
                        Log.e((String)DummySurface.TAG, (String)"Failed to release dummy surface", (Throwable)e);
                    }
                    finally {
                        this.quit();
                    }
                    return true;
                }
            }
            return true;
        }

        private void initInternal(int secureMode) {
            Assertions.checkNotNull((Object)this.eglSurfaceTexture);
            this.eglSurfaceTexture.init(secureMode);
            this.surface = new DummySurface(this, this.eglSurfaceTexture.getSurfaceTexture(), secureMode != 0);
        }

        private void releaseInternal() {
            Assertions.checkNotNull((Object)this.eglSurfaceTexture);
            this.eglSurfaceTexture.release();
        }
    }
}

