/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.upstream.cache;

import android.annotation.SuppressLint;
import android.content.ContentValues;
import android.database.Cursor;
import android.database.SQLException;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteException;
import android.util.SparseArray;
import android.util.SparseBooleanArray;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import androidx.annotation.WorkerThread;
import com.google.android.exoplayer2.database.DatabaseIOException;
import com.google.android.exoplayer2.database.DatabaseProvider;
import com.google.android.exoplayer2.database.VersionTable;
import com.google.android.exoplayer2.upstream.cache.CachedContent;
import com.google.android.exoplayer2.upstream.cache.ContentMetadata;
import com.google.android.exoplayer2.upstream.cache.ContentMetadataMutations;
import com.google.android.exoplayer2.upstream.cache.DefaultContentMetadata;
import com.google.android.exoplayer2.upstream.cache.ReusableBufferedOutputStream;
import com.google.android.exoplayer2.util.Assertions;
import com.google.android.exoplayer2.util.AtomicFile;
import com.google.android.exoplayer2.util.Util;
import com.google.common.collect.ImmutableSet;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.CipherOutputStream;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.checkerframework.checker.nullness.compatqual.NullableType;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;

@Deprecated
class CachedContentIndex {
    static final String FILE_NAME_ATOMIC = "cached_content_index.exi";
    private static final int INCREMENTAL_METADATA_READ_LENGTH = 0xA00000;
    private final HashMap<String, CachedContent> keyToContent;
    private final SparseArray<@NullableType String> idToKey;
    private final SparseBooleanArray removedIds;
    private final SparseBooleanArray newIds;
    private Storage storage;
    @Nullable
    private Storage previousStorage;

    public static boolean isIndexFile(String fileName) {
        return fileName.startsWith(FILE_NAME_ATOMIC);
    }

    @WorkerThread
    public static void delete(DatabaseProvider databaseProvider, long uid) throws DatabaseIOException {
        DatabaseStorage.delete(databaseProvider, uid);
    }

    public CachedContentIndex(DatabaseProvider databaseProvider) {
        this(databaseProvider, null, null, false, false);
    }

    public CachedContentIndex(@Nullable DatabaseProvider databaseProvider, @Nullable File legacyStorageDir, @Nullable byte[] legacyStorageSecretKey, boolean legacyStorageEncrypt, boolean preferLegacyStorage) {
        LegacyStorage legacyStorage;
        Assertions.checkState((databaseProvider != null || legacyStorageDir != null ? 1 : 0) != 0);
        this.keyToContent = new HashMap();
        this.idToKey = new SparseArray();
        this.removedIds = new SparseBooleanArray();
        this.newIds = new SparseBooleanArray();
        DatabaseStorage databaseStorage = databaseProvider != null ? new DatabaseStorage(databaseProvider) : null;
        LegacyStorage legacyStorage2 = legacyStorage = legacyStorageDir != null ? new LegacyStorage(new File(legacyStorageDir, FILE_NAME_ATOMIC), legacyStorageSecretKey, legacyStorageEncrypt) : null;
        if (databaseStorage == null || legacyStorage != null && preferLegacyStorage) {
            this.storage = (Storage)Util.castNonNull((Object)legacyStorage);
            this.previousStorage = databaseStorage;
        } else {
            this.storage = databaseStorage;
            this.previousStorage = legacyStorage;
        }
    }

    @WorkerThread
    public void initialize(long uid) throws IOException {
        this.storage.initialize(uid);
        if (this.previousStorage != null) {
            this.previousStorage.initialize(uid);
        }
        if (!this.storage.exists() && this.previousStorage != null && this.previousStorage.exists()) {
            this.previousStorage.load(this.keyToContent, this.idToKey);
            this.storage.storeFully(this.keyToContent);
        } else {
            this.storage.load(this.keyToContent, this.idToKey);
        }
        if (this.previousStorage != null) {
            this.previousStorage.delete();
            this.previousStorage = null;
        }
    }

    @WorkerThread
    public void store() throws IOException {
        this.storage.storeIncremental(this.keyToContent);
        int removedIdCount = this.removedIds.size();
        for (int i = 0; i < removedIdCount; ++i) {
            this.idToKey.remove(this.removedIds.keyAt(i));
        }
        this.removedIds.clear();
        this.newIds.clear();
    }

    public CachedContent getOrAdd(String key) {
        CachedContent cachedContent = this.keyToContent.get(key);
        return cachedContent == null ? this.addNew(key) : cachedContent;
    }

    @Nullable
    public CachedContent get(String key) {
        return this.keyToContent.get(key);
    }

    public Collection<CachedContent> getAll() {
        return Collections.unmodifiableCollection(this.keyToContent.values());
    }

    public int assignIdForKey(String key) {
        return this.getOrAdd((String)key).id;
    }

    @Nullable
    public String getKeyForId(int id) {
        return (String)this.idToKey.get(id);
    }

    public void maybeRemove(String key) {
        CachedContent cachedContent = this.keyToContent.get(key);
        if (cachedContent != null && cachedContent.isEmpty() && cachedContent.isFullyUnlocked()) {
            this.keyToContent.remove(key);
            int id = cachedContent.id;
            boolean neverStored = this.newIds.get(id);
            this.storage.onRemove(cachedContent, neverStored);
            if (neverStored) {
                this.idToKey.remove(id);
                this.newIds.delete(id);
            } else {
                this.idToKey.put(id, null);
                this.removedIds.put(id, true);
            }
        }
    }

    public void removeEmpty() {
        for (String key : ImmutableSet.copyOf(this.keyToContent.keySet())) {
            this.maybeRemove(key);
        }
    }

    public Set<String> getKeys() {
        return this.keyToContent.keySet();
    }

    public void applyContentMetadataMutations(String key, ContentMetadataMutations mutations) {
        CachedContent cachedContent = this.getOrAdd(key);
        if (cachedContent.applyMetadataMutations(mutations)) {
            this.storage.onUpdate(cachedContent);
        }
    }

    public ContentMetadata getContentMetadata(String key) {
        CachedContent cachedContent = this.get(key);
        return cachedContent != null ? cachedContent.getMetadata() : DefaultContentMetadata.EMPTY;
    }

    private CachedContent addNew(String key) {
        int id = CachedContentIndex.getNewId(this.idToKey);
        CachedContent cachedContent = new CachedContent(id, key);
        this.keyToContent.put(key, cachedContent);
        this.idToKey.put(id, (Object)key);
        this.newIds.put(id, true);
        this.storage.onUpdate(cachedContent);
        return cachedContent;
    }

    @SuppressLint(value={"GetInstance"})
    private static Cipher getCipher() throws NoSuchPaddingException, NoSuchAlgorithmException {
        if (Util.SDK_INT == 18) {
            try {
                return Cipher.getInstance("AES/CBC/PKCS5PADDING", "BC");
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return Cipher.getInstance("AES/CBC/PKCS5PADDING");
    }

    @VisibleForTesting
    static int getNewId(SparseArray<@NullableType String> idToKey) {
        int id;
        int size = idToKey.size();
        int n = id = size == 0 ? 0 : idToKey.keyAt(size - 1) + 1;
        if (id < 0) {
            for (id = 0; id < size && id == idToKey.keyAt(id); ++id) {
            }
        }
        return id;
    }

    private static DefaultContentMetadata readContentMetadata(DataInputStream input) throws IOException {
        int size = input.readInt();
        HashMap<String, byte[]> metadata = new HashMap<String, byte[]>();
        for (int i = 0; i < size; ++i) {
            String name = input.readUTF();
            int valueSize = input.readInt();
            if (valueSize < 0) {
                throw new IOException("Invalid value size: " + valueSize);
            }
            int bytesRead = 0;
            int nextBytesToRead = Math.min(valueSize, 0xA00000);
            byte[] value = Util.EMPTY_BYTE_ARRAY;
            while (bytesRead != valueSize) {
                value = Arrays.copyOf(value, bytesRead + nextBytesToRead);
                input.readFully(value, bytesRead, nextBytesToRead);
                nextBytesToRead = Math.min(valueSize - (bytesRead += nextBytesToRead), 0xA00000);
            }
            metadata.put(name, value);
        }
        return new DefaultContentMetadata(metadata);
    }

    private static void writeContentMetadata(DefaultContentMetadata metadata, DataOutputStream output) throws IOException {
        Set<Map.Entry<String, byte[]>> entrySet = metadata.entrySet();
        output.writeInt(entrySet.size());
        for (Map.Entry<String, byte[]> entry : entrySet) {
            output.writeUTF(entry.getKey());
            byte[] value = entry.getValue();
            output.writeInt(value.length);
            output.write(value);
        }
    }

    private static final class DatabaseStorage
    implements Storage {
        private static final String TABLE_PREFIX = "ExoPlayerCacheIndex";
        private static final int TABLE_VERSION = 1;
        private static final String COLUMN_ID = "id";
        private static final String COLUMN_KEY = "key";
        private static final String COLUMN_METADATA = "metadata";
        private static final int COLUMN_INDEX_ID = 0;
        private static final int COLUMN_INDEX_KEY = 1;
        private static final int COLUMN_INDEX_METADATA = 2;
        private static final String WHERE_ID_EQUALS = "id = ?";
        private static final String[] COLUMNS = new String[]{"id", "key", "metadata"};
        private static final String TABLE_SCHEMA = "(id INTEGER PRIMARY KEY NOT NULL,key TEXT NOT NULL,metadata BLOB NOT NULL)";
        private final DatabaseProvider databaseProvider;
        private final SparseArray<@NullableType CachedContent> pendingUpdates;
        private @MonotonicNonNull String hexUid;
        private @MonotonicNonNull String tableName;

        public static void delete(DatabaseProvider databaseProvider, long uid) throws DatabaseIOException {
            DatabaseStorage.delete(databaseProvider, Long.toHexString(uid));
        }

        public DatabaseStorage(DatabaseProvider databaseProvider) {
            this.databaseProvider = databaseProvider;
            this.pendingUpdates = new SparseArray();
        }

        @Override
        public void initialize(long uid) {
            this.hexUid = Long.toHexString(uid);
            this.tableName = DatabaseStorage.getTableName(this.hexUid);
        }

        @Override
        public boolean exists() throws DatabaseIOException {
            try {
                return VersionTable.getVersion((SQLiteDatabase)this.databaseProvider.getReadableDatabase(), (int)1, (String)((String)Assertions.checkNotNull((Object)this.hexUid))) != -1;
            }
            catch (SQLException e) {
                throw new DatabaseIOException(e);
            }
        }

        @Override
        public void delete() throws DatabaseIOException {
            DatabaseStorage.delete(this.databaseProvider, (String)Assertions.checkNotNull((Object)this.hexUid));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void load(HashMap<String, CachedContent> content, SparseArray<@NullableType String> idToKey) throws IOException {
            Assertions.checkState((this.pendingUpdates.size() == 0 ? 1 : 0) != 0);
            try {
                int version = VersionTable.getVersion((SQLiteDatabase)this.databaseProvider.getReadableDatabase(), (int)1, (String)((String)Assertions.checkNotNull((Object)this.hexUid)));
                if (version != 1) {
                    SQLiteDatabase writableDatabase = this.databaseProvider.getWritableDatabase();
                    writableDatabase.beginTransactionNonExclusive();
                    try {
                        this.initializeTable(writableDatabase);
                        writableDatabase.setTransactionSuccessful();
                    }
                    finally {
                        writableDatabase.endTransaction();
                    }
                }
                try (Cursor cursor = this.getCursor();){
                    while (cursor.moveToNext()) {
                        int id = cursor.getInt(0);
                        String key = (String)Assertions.checkNotNull((Object)cursor.getString(1));
                        byte[] metadataBytes = cursor.getBlob(2);
                        ByteArrayInputStream inputStream = new ByteArrayInputStream(metadataBytes);
                        DataInputStream input = new DataInputStream(inputStream);
                        DefaultContentMetadata metadata = CachedContentIndex.readContentMetadata(input);
                        CachedContent cachedContent = new CachedContent(id, key, metadata);
                        content.put(cachedContent.key, cachedContent);
                        idToKey.put(cachedContent.id, (Object)cachedContent.key);
                    }
                }
            }
            catch (SQLiteException e) {
                content.clear();
                idToKey.clear();
                throw new DatabaseIOException((SQLException)((Object)e));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void storeFully(HashMap<String, CachedContent> content) throws IOException {
            try {
                SQLiteDatabase writableDatabase = this.databaseProvider.getWritableDatabase();
                writableDatabase.beginTransactionNonExclusive();
                try {
                    this.initializeTable(writableDatabase);
                    for (CachedContent cachedContent : content.values()) {
                        this.addOrUpdateRow(writableDatabase, cachedContent);
                    }
                    writableDatabase.setTransactionSuccessful();
                    this.pendingUpdates.clear();
                }
                finally {
                    writableDatabase.endTransaction();
                }
            }
            catch (SQLException e) {
                throw new DatabaseIOException(e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void storeIncremental(HashMap<String, CachedContent> content) throws IOException {
            if (this.pendingUpdates.size() == 0) {
                return;
            }
            try {
                SQLiteDatabase writableDatabase = this.databaseProvider.getWritableDatabase();
                writableDatabase.beginTransactionNonExclusive();
                try {
                    for (int i = 0; i < this.pendingUpdates.size(); ++i) {
                        CachedContent cachedContent = (CachedContent)this.pendingUpdates.valueAt(i);
                        if (cachedContent == null) {
                            this.deleteRow(writableDatabase, this.pendingUpdates.keyAt(i));
                            continue;
                        }
                        this.addOrUpdateRow(writableDatabase, cachedContent);
                    }
                    writableDatabase.setTransactionSuccessful();
                    this.pendingUpdates.clear();
                }
                finally {
                    writableDatabase.endTransaction();
                }
            }
            catch (SQLException e) {
                throw new DatabaseIOException(e);
            }
        }

        @Override
        public void onUpdate(CachedContent cachedContent) {
            this.pendingUpdates.put(cachedContent.id, (Object)cachedContent);
        }

        @Override
        public void onRemove(CachedContent cachedContent, boolean neverStored) {
            if (neverStored) {
                this.pendingUpdates.delete(cachedContent.id);
            } else {
                this.pendingUpdates.put(cachedContent.id, null);
            }
        }

        private Cursor getCursor() {
            return this.databaseProvider.getReadableDatabase().query((String)Assertions.checkNotNull((Object)this.tableName), COLUMNS, null, null, null, null, null);
        }

        private void initializeTable(SQLiteDatabase writableDatabase) throws DatabaseIOException {
            VersionTable.setVersion((SQLiteDatabase)writableDatabase, (int)1, (String)((String)Assertions.checkNotNull((Object)this.hexUid)), (int)1);
            DatabaseStorage.dropTable(writableDatabase, (String)Assertions.checkNotNull((Object)this.tableName));
            writableDatabase.execSQL("CREATE TABLE " + this.tableName + " " + TABLE_SCHEMA);
        }

        private void deleteRow(SQLiteDatabase writableDatabase, int key) {
            writableDatabase.delete((String)Assertions.checkNotNull((Object)this.tableName), WHERE_ID_EQUALS, new String[]{Integer.toString(key)});
        }

        private void addOrUpdateRow(SQLiteDatabase writableDatabase, CachedContent cachedContent) throws IOException {
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            CachedContentIndex.writeContentMetadata(cachedContent.getMetadata(), new DataOutputStream(outputStream));
            byte[] data = outputStream.toByteArray();
            ContentValues values = new ContentValues();
            values.put(COLUMN_ID, Integer.valueOf(cachedContent.id));
            values.put(COLUMN_KEY, cachedContent.key);
            values.put(COLUMN_METADATA, data);
            writableDatabase.replaceOrThrow((String)Assertions.checkNotNull((Object)this.tableName), null, values);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static void delete(DatabaseProvider databaseProvider, String hexUid) throws DatabaseIOException {
            try {
                String tableName = DatabaseStorage.getTableName(hexUid);
                SQLiteDatabase writableDatabase = databaseProvider.getWritableDatabase();
                writableDatabase.beginTransactionNonExclusive();
                try {
                    VersionTable.removeVersion((SQLiteDatabase)writableDatabase, (int)1, (String)hexUid);
                    DatabaseStorage.dropTable(writableDatabase, tableName);
                    writableDatabase.setTransactionSuccessful();
                }
                finally {
                    writableDatabase.endTransaction();
                }
            }
            catch (SQLException e) {
                throw new DatabaseIOException(e);
            }
        }

        private static void dropTable(SQLiteDatabase writableDatabase, String tableName) {
            writableDatabase.execSQL("DROP TABLE IF EXISTS " + tableName);
        }

        private static String getTableName(String hexUid) {
            return TABLE_PREFIX + hexUid;
        }
    }

    private static class LegacyStorage
    implements Storage {
        private static final int VERSION = 2;
        private static final int VERSION_METADATA_INTRODUCED = 2;
        private static final int FLAG_ENCRYPTED_INDEX = 1;
        private final boolean encrypt;
        @Nullable
        private final Cipher cipher;
        @Nullable
        private final SecretKeySpec secretKeySpec;
        @Nullable
        private final SecureRandom random;
        private final AtomicFile atomicFile;
        private boolean changed;
        @Nullable
        private ReusableBufferedOutputStream bufferedOutputStream;

        public LegacyStorage(File file, @Nullable byte[] secretKey, boolean encrypt) {
            Assertions.checkState((secretKey != null || !encrypt ? 1 : 0) != 0);
            Cipher cipher = null;
            SecretKeySpec secretKeySpec = null;
            if (secretKey != null) {
                Assertions.checkArgument((secretKey.length == 16 ? 1 : 0) != 0);
                try {
                    cipher = CachedContentIndex.getCipher();
                    secretKeySpec = new SecretKeySpec(secretKey, "AES");
                }
                catch (NoSuchAlgorithmException | NoSuchPaddingException e) {
                    throw new IllegalStateException(e);
                }
            } else {
                Assertions.checkArgument((!encrypt ? 1 : 0) != 0);
            }
            this.encrypt = encrypt;
            this.cipher = cipher;
            this.secretKeySpec = secretKeySpec;
            this.random = encrypt ? new SecureRandom() : null;
            this.atomicFile = new AtomicFile(file);
        }

        @Override
        public void initialize(long uid) {
        }

        @Override
        public boolean exists() {
            return this.atomicFile.exists();
        }

        @Override
        public void delete() {
            this.atomicFile.delete();
        }

        @Override
        public void load(HashMap<String, CachedContent> content, SparseArray<@NullableType String> idToKey) {
            Assertions.checkState((!this.changed ? 1 : 0) != 0);
            if (!this.readFile(content, idToKey)) {
                content.clear();
                idToKey.clear();
                this.atomicFile.delete();
            }
        }

        @Override
        public void storeFully(HashMap<String, CachedContent> content) throws IOException {
            this.writeFile(content);
            this.changed = false;
        }

        @Override
        public void storeIncremental(HashMap<String, CachedContent> content) throws IOException {
            if (!this.changed) {
                return;
            }
            this.storeFully(content);
        }

        @Override
        public void onUpdate(CachedContent cachedContent) {
            this.changed = true;
        }

        @Override
        public void onRemove(CachedContent cachedContent, boolean neverStored) {
            this.changed = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private boolean readFile(HashMap<String, CachedContent> content, SparseArray<@NullableType String> idToKey) {
            DataInputStream input;
            block21: {
                boolean bl;
                block20: {
                    boolean bl2;
                    block19: {
                        boolean bl3;
                        block18: {
                            if (!this.atomicFile.exists()) {
                                return true;
                            }
                            input = null;
                            try {
                                boolean isEOF;
                                CachedContent cachedContent;
                                BufferedInputStream inputStream = new BufferedInputStream(this.atomicFile.openRead());
                                input = new DataInputStream(inputStream);
                                int version = input.readInt();
                                if (version < 0 || version > 2) {
                                    bl3 = false;
                                    if (input == null) return bl3;
                                    break block18;
                                }
                                int flags = input.readInt();
                                if ((flags & 1) != 0) {
                                    if (this.cipher == null) {
                                        bl2 = false;
                                        if (input == null) return bl2;
                                        break block19;
                                    }
                                    byte[] initializationVector = new byte[16];
                                    input.readFully(initializationVector);
                                    IvParameterSpec ivParameterSpec = new IvParameterSpec(initializationVector);
                                    try {
                                        this.cipher.init(2, (Key)Util.castNonNull((Object)this.secretKeySpec), ivParameterSpec);
                                    }
                                    catch (InvalidAlgorithmParameterException | InvalidKeyException e) {
                                        throw new IllegalStateException(e);
                                    }
                                    input = new DataInputStream(new CipherInputStream(inputStream, this.cipher));
                                } else if (this.encrypt) {
                                    this.changed = true;
                                }
                                int count = input.readInt();
                                int hashCode = 0;
                                for (int i = 0; i < count; hashCode += this.hashCachedContent(cachedContent, version), ++i) {
                                    cachedContent = this.readCachedContent(version, input);
                                    content.put(cachedContent.key, cachedContent);
                                    idToKey.put(cachedContent.id, (Object)cachedContent.key);
                                }
                                int fileHashCode = input.readInt();
                                boolean bl4 = isEOF = input.read() == -1;
                                if (fileHashCode != hashCode || !isEOF) {
                                    bl = false;
                                    if (input == null) return bl;
                                    break block20;
                                }
                                if (input == null) return true;
                                break block21;
                            }
                            catch (IOException e) {
                                boolean bl5 = false;
                                return bl5;
                            }
                        }
                        Util.closeQuietly((Closeable)input);
                        return bl3;
                    }
                    Util.closeQuietly((Closeable)input);
                    return bl2;
                }
                Util.closeQuietly((Closeable)input);
                return bl;
            }
            Util.closeQuietly((Closeable)input);
            return true;
            finally {
                if (input != null) {
                    Util.closeQuietly(input);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void writeFile(HashMap<String, CachedContent> content) throws IOException {
            DataOutputStream output = null;
            try {
                OutputStream outputStream = this.atomicFile.startWrite();
                if (this.bufferedOutputStream == null) {
                    this.bufferedOutputStream = new ReusableBufferedOutputStream(outputStream);
                } else {
                    this.bufferedOutputStream.reset(outputStream);
                }
                ReusableBufferedOutputStream bufferedOutputStream = this.bufferedOutputStream;
                output = new DataOutputStream(bufferedOutputStream);
                output.writeInt(2);
                int flags = this.encrypt ? 1 : 0;
                output.writeInt(flags);
                if (this.encrypt) {
                    byte[] initializationVector = new byte[16];
                    ((SecureRandom)Util.castNonNull((Object)this.random)).nextBytes(initializationVector);
                    output.write(initializationVector);
                    IvParameterSpec ivParameterSpec = new IvParameterSpec(initializationVector);
                    try {
                        ((Cipher)Util.castNonNull((Object)this.cipher)).init(1, (Key)Util.castNonNull((Object)this.secretKeySpec), ivParameterSpec);
                    }
                    catch (InvalidAlgorithmParameterException | InvalidKeyException e) {
                        throw new IllegalStateException(e);
                    }
                    output.flush();
                    output = new DataOutputStream(new CipherOutputStream(bufferedOutputStream, this.cipher));
                }
                output.writeInt(content.size());
                int hashCode = 0;
                for (CachedContent cachedContent : content.values()) {
                    this.writeCachedContent(cachedContent, output);
                    hashCode += this.hashCachedContent(cachedContent, 2);
                }
                output.writeInt(hashCode);
                this.atomicFile.endWrite((OutputStream)output);
                output = null;
            }
            catch (Throwable throwable) {
                Util.closeQuietly(output);
                throw throwable;
            }
            Util.closeQuietly((Closeable)output);
        }

        private int hashCachedContent(CachedContent cachedContent, int version) {
            int result = cachedContent.id;
            result = 31 * result + cachedContent.key.hashCode();
            if (version < 2) {
                long length = ContentMetadata.getContentLength(cachedContent.getMetadata());
                result = 31 * result + (int)(length ^ length >>> 32);
            } else {
                result = 31 * result + cachedContent.getMetadata().hashCode();
            }
            return result;
        }

        private CachedContent readCachedContent(int version, DataInputStream input) throws IOException {
            DefaultContentMetadata metadata;
            int id = input.readInt();
            String key = input.readUTF();
            if (version < 2) {
                long length = input.readLong();
                ContentMetadataMutations mutations = new ContentMetadataMutations();
                ContentMetadataMutations.setContentLength(mutations, length);
                metadata = DefaultContentMetadata.EMPTY.copyWithMutationsApplied(mutations);
            } else {
                metadata = CachedContentIndex.readContentMetadata(input);
            }
            return new CachedContent(id, key, metadata);
        }

        private void writeCachedContent(CachedContent cachedContent, DataOutputStream output) throws IOException {
            output.writeInt(cachedContent.id);
            output.writeUTF(cachedContent.key);
            CachedContentIndex.writeContentMetadata(cachedContent.getMetadata(), output);
        }
    }

    private static interface Storage {
        public void initialize(long var1);

        public boolean exists() throws IOException;

        public void delete() throws IOException;

        public void load(HashMap<String, CachedContent> var1, SparseArray<@NullableType String> var2) throws IOException;

        public void storeFully(HashMap<String, CachedContent> var1) throws IOException;

        public void storeIncremental(HashMap<String, CachedContent> var1) throws IOException;

        public void onUpdate(CachedContent var1);

        public void onRemove(CachedContent var1, boolean var2);
    }
}

