/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.extractor.wav;

import android.util.Pair;
import com.google.android.exoplayer2.ParserException;
import com.google.android.exoplayer2.extractor.ExtractorInput;
import com.google.android.exoplayer2.extractor.wav.WavFormat;
import com.google.android.exoplayer2.util.Assertions;
import com.google.android.exoplayer2.util.Log;
import com.google.android.exoplayer2.util.ParsableByteArray;
import com.google.android.exoplayer2.util.Util;
import java.io.IOException;

final class WavHeaderReader {
    private static final String TAG = "WavHeaderReader";

    public static boolean checkFileType(ExtractorInput input) throws IOException {
        ParsableByteArray scratch = new ParsableByteArray(8);
        ChunkHeader chunkHeader = ChunkHeader.peek(input, scratch);
        if (chunkHeader.id != 1380533830 && chunkHeader.id != 1380333108) {
            return false;
        }
        input.peekFully(scratch.getData(), 0, 4);
        scratch.setPosition(0);
        int formType = scratch.readInt();
        if (formType != 1463899717) {
            Log.e((String)TAG, (String)new StringBuilder(34).append("Unsupported form type: ").append(formType).toString());
            return false;
        }
        return true;
    }

    public static long readRf64SampleDataSize(ExtractorInput input) throws IOException {
        ParsableByteArray scratch = new ParsableByteArray(8);
        ChunkHeader chunkHeader = ChunkHeader.peek(input, scratch);
        if (chunkHeader.id != 1685272116) {
            input.resetPeekPosition();
            return -1L;
        }
        input.advancePeekPosition(8);
        scratch.setPosition(0);
        input.peekFully(scratch.getData(), 0, 8);
        long sampleDataSize = scratch.readLittleEndianLong();
        input.skipFully(8 + (int)chunkHeader.size);
        return sampleDataSize;
    }

    public static WavFormat readFormat(ExtractorInput input) throws IOException {
        byte[] extraData;
        ParsableByteArray scratch = new ParsableByteArray(16);
        ChunkHeader chunkHeader = WavHeaderReader.skipToChunk(1718449184, input, scratch);
        Assertions.checkState((chunkHeader.size >= 16L ? 1 : 0) != 0);
        input.peekFully(scratch.getData(), 0, 16);
        scratch.setPosition(0);
        int audioFormatType = scratch.readLittleEndianUnsignedShort();
        int numChannels = scratch.readLittleEndianUnsignedShort();
        int frameRateHz = scratch.readLittleEndianUnsignedIntToInt();
        int averageBytesPerSecond = scratch.readLittleEndianUnsignedIntToInt();
        int blockSize = scratch.readLittleEndianUnsignedShort();
        int bitsPerSample = scratch.readLittleEndianUnsignedShort();
        int bytesLeft = (int)chunkHeader.size - 16;
        if (bytesLeft > 0) {
            extraData = new byte[bytesLeft];
            input.peekFully(extraData, 0, bytesLeft);
        } else {
            extraData = Util.EMPTY_BYTE_ARRAY;
        }
        input.skipFully((int)(input.getPeekPosition() - input.getPosition()));
        return new WavFormat(audioFormatType, numChannels, frameRateHz, averageBytesPerSecond, blockSize, bitsPerSample, extraData);
    }

    public static Pair<Long, Long> skipToSampleData(ExtractorInput input) throws IOException {
        input.resetPeekPosition();
        ParsableByteArray scratch = new ParsableByteArray(8);
        ChunkHeader chunkHeader = WavHeaderReader.skipToChunk(1684108385, input, scratch);
        input.skipFully(8);
        long dataStartPosition = input.getPosition();
        return Pair.create((Object)dataStartPosition, (Object)chunkHeader.size);
    }

    private static ChunkHeader skipToChunk(int chunkId, ExtractorInput input, ParsableByteArray scratch) throws IOException {
        ChunkHeader chunkHeader = ChunkHeader.peek(input, scratch);
        while (chunkHeader.id != chunkId) {
            int n = chunkHeader.id;
            Log.w((String)TAG, (String)new StringBuilder(39).append("Ignoring unknown WAV chunk: ").append(n).toString());
            long bytesToSkip = 8L + chunkHeader.size;
            if (bytesToSkip > Integer.MAX_VALUE) {
                int n2 = chunkHeader.id;
                throw ParserException.createForUnsupportedContainerFeature((String)new StringBuilder(51).append("Chunk is too large (~2GB+) to skip; id: ").append(n2).toString());
            }
            input.skipFully((int)bytesToSkip);
            chunkHeader = ChunkHeader.peek(input, scratch);
        }
        return chunkHeader;
    }

    private WavHeaderReader() {
    }

    private static final class ChunkHeader {
        public static final int SIZE_IN_BYTES = 8;
        public final int id;
        public final long size;

        private ChunkHeader(int id, long size) {
            this.id = id;
            this.size = size;
        }

        public static ChunkHeader peek(ExtractorInput input, ParsableByteArray scratch) throws IOException {
            input.peekFully(scratch.getData(), 0, 8);
            scratch.setPosition(0);
            int id = scratch.readInt();
            long size = scratch.readLittleEndianUnsignedInt();
            return new ChunkHeader(id, size);
        }
    }
}

