/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.extractor.avi;

import androidx.annotation.Nullable;
import com.google.android.exoplayer2.Format;
import com.google.android.exoplayer2.extractor.avi.AviChunk;
import com.google.android.exoplayer2.util.Log;
import com.google.android.exoplayer2.util.ParsableByteArray;
import com.google.android.exoplayer2.util.Util;
import com.google.common.collect.ImmutableList;
import java.util.List;

final class StreamFormatChunk
implements AviChunk {
    private static final String TAG = "StreamFormatChunk";
    public final Format format;

    @Nullable
    public static AviChunk parseFrom(int trackType, ParsableByteArray body) {
        if (trackType == 2) {
            return StreamFormatChunk.parseBitmapInfoHeader(body);
        }
        if (trackType == 1) {
            return StreamFormatChunk.parseWaveFormatEx(body);
        }
        Log.w((String)TAG, (String)("Ignoring strf box for unsupported track type: " + Util.getTrackTypeString((int)trackType)));
        return null;
    }

    public StreamFormatChunk(Format format) {
        this.format = format;
    }

    @Override
    public int getType() {
        return 1718776947;
    }

    @Nullable
    private static AviChunk parseBitmapInfoHeader(ParsableByteArray body) {
        body.skipBytes(4);
        int width = body.readLittleEndianInt();
        int height = body.readLittleEndianInt();
        body.skipBytes(4);
        int compression = body.readLittleEndianInt();
        String mimeType = StreamFormatChunk.getMimeTypeFromCompression(compression);
        if (mimeType == null) {
            Log.w((String)TAG, (String)("Ignoring track with unsupported compression " + compression));
            return null;
        }
        Format.Builder formatBuilder = new Format.Builder();
        formatBuilder.setWidth(width).setHeight(height).setSampleMimeType(mimeType);
        return new StreamFormatChunk(formatBuilder.build());
    }

    @Nullable
    private static AviChunk parseWaveFormatEx(ParsableByteArray body) {
        int formatTag = body.readLittleEndianUnsignedShort();
        String mimeType = StreamFormatChunk.getMimeTypeFromTag(formatTag);
        if (mimeType == null) {
            Log.w((String)TAG, (String)("Ignoring track with unsupported format tag " + formatTag));
            return null;
        }
        int channelCount = body.readLittleEndianUnsignedShort();
        int samplesPerSecond = body.readLittleEndianInt();
        body.skipBytes(6);
        int bitsPerSample = body.readUnsignedShort();
        int pcmEncoding = Util.getPcmEncoding((int)bitsPerSample);
        int cbSize = body.readLittleEndianUnsignedShort();
        byte[] codecData = new byte[cbSize];
        body.readBytes(codecData, 0, codecData.length);
        Format.Builder formatBuilder = new Format.Builder();
        formatBuilder.setSampleMimeType(mimeType).setChannelCount(channelCount).setSampleRate(samplesPerSecond);
        if ("audio/raw".equals(mimeType) && pcmEncoding != 0) {
            formatBuilder.setPcmEncoding(pcmEncoding);
        }
        if ("audio/mp4a-latm".equals(mimeType) && codecData.length > 0) {
            formatBuilder.setInitializationData((List)ImmutableList.of((Object)codecData));
        }
        return new StreamFormatChunk(formatBuilder.build());
    }

    @Nullable
    private static String getMimeTypeFromTag(int tag) {
        switch (tag) {
            case 1: {
                return "audio/raw";
            }
            case 85: {
                return "audio/mpeg";
            }
            case 255: {
                return "audio/mp4a-latm";
            }
            case 8192: {
                return "audio/ac3";
            }
            case 8193: {
                return "audio/vnd.dts";
            }
        }
        return null;
    }

    @Nullable
    private static String getMimeTypeFromCompression(int compression) {
        switch (compression) {
            case 842289229: {
                return "video/mp42";
            }
            case 859066445: {
                return "video/mp43";
            }
            case 826496577: 
            case 828601953: 
            case 875967048: {
                return "video/avc";
            }
            case 808802372: 
            case 877677894: 
            case 1145656883: 
            case 1145656920: 
            case 1482049860: 
            case 1684633208: 
            case 2021026148: {
                return "video/mp4v-es";
            }
            case 1196444237: 
            case 1735420525: {
                return "video/mjpeg";
            }
        }
        return null;
    }
}

