/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.extractor.mkv;

import android.util.Pair;
import android.util.SparseArray;
import androidx.annotation.CallSuper;
import androidx.annotation.Nullable;
import com.google.android.exoplayer2.C;
import com.google.android.exoplayer2.Format;
import com.google.android.exoplayer2.ParserException;
import com.google.android.exoplayer2.audio.AacUtil;
import com.google.android.exoplayer2.drm.DrmInitData;
import com.google.android.exoplayer2.extractor.ChunkIndex;
import com.google.android.exoplayer2.extractor.Extractor;
import com.google.android.exoplayer2.extractor.ExtractorInput;
import com.google.android.exoplayer2.extractor.ExtractorOutput;
import com.google.android.exoplayer2.extractor.ExtractorsFactory;
import com.google.android.exoplayer2.extractor.PositionHolder;
import com.google.android.exoplayer2.extractor.SeekMap;
import com.google.android.exoplayer2.extractor.TrackOutput;
import com.google.android.exoplayer2.extractor.TrueHdSampleRechunker;
import com.google.android.exoplayer2.extractor.mkv.DefaultEbmlReader;
import com.google.android.exoplayer2.extractor.mkv.EbmlProcessor;
import com.google.android.exoplayer2.extractor.mkv.EbmlReader;
import com.google.android.exoplayer2.extractor.mkv.Sniffer;
import com.google.android.exoplayer2.extractor.mkv.VarintReader;
import com.google.android.exoplayer2.util.Assertions;
import com.google.android.exoplayer2.util.Log;
import com.google.android.exoplayer2.util.LongArray;
import com.google.android.exoplayer2.util.MimeTypes;
import com.google.android.exoplayer2.util.NalUnitUtil;
import com.google.android.exoplayer2.util.ParsableByteArray;
import com.google.android.exoplayer2.util.Util;
import com.google.android.exoplayer2.video.AvcConfig;
import com.google.android.exoplayer2.video.ColorInfo;
import com.google.android.exoplayer2.video.DolbyVisionConfig;
import com.google.android.exoplayer2.video.HevcConfig;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import org.checkerframework.checker.nullness.compatqual.NullableType;
import org.checkerframework.checker.nullness.qual.EnsuresNonNull;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.checkerframework.checker.nullness.qual.RequiresNonNull;

public class MatroskaExtractor
implements Extractor {
    public static final ExtractorsFactory FACTORY = () -> new Extractor[]{new MatroskaExtractor()};
    public static final int FLAG_DISABLE_SEEK_FOR_CUES = 1;
    private static final String TAG = "MatroskaExtractor";
    private static final int UNSET_ENTRY_ID = -1;
    private static final int BLOCK_STATE_START = 0;
    private static final int BLOCK_STATE_HEADER = 1;
    private static final int BLOCK_STATE_DATA = 2;
    private static final String DOC_TYPE_MATROSKA = "matroska";
    private static final String DOC_TYPE_WEBM = "webm";
    private static final String CODEC_ID_VP8 = "V_VP8";
    private static final String CODEC_ID_VP9 = "V_VP9";
    private static final String CODEC_ID_AV1 = "V_AV1";
    private static final String CODEC_ID_MPEG2 = "V_MPEG2";
    private static final String CODEC_ID_MPEG4_SP = "V_MPEG4/ISO/SP";
    private static final String CODEC_ID_MPEG4_ASP = "V_MPEG4/ISO/ASP";
    private static final String CODEC_ID_MPEG4_AP = "V_MPEG4/ISO/AP";
    private static final String CODEC_ID_H264 = "V_MPEG4/ISO/AVC";
    private static final String CODEC_ID_H265 = "V_MPEGH/ISO/HEVC";
    private static final String CODEC_ID_FOURCC = "V_MS/VFW/FOURCC";
    private static final String CODEC_ID_THEORA = "V_THEORA";
    private static final String CODEC_ID_VORBIS = "A_VORBIS";
    private static final String CODEC_ID_OPUS = "A_OPUS";
    private static final String CODEC_ID_AAC = "A_AAC";
    private static final String CODEC_ID_MP2 = "A_MPEG/L2";
    private static final String CODEC_ID_MP3 = "A_MPEG/L3";
    private static final String CODEC_ID_AC3 = "A_AC3";
    private static final String CODEC_ID_E_AC3 = "A_EAC3";
    private static final String CODEC_ID_TRUEHD = "A_TRUEHD";
    private static final String CODEC_ID_DTS = "A_DTS";
    private static final String CODEC_ID_DTS_EXPRESS = "A_DTS/EXPRESS";
    private static final String CODEC_ID_DTS_LOSSLESS = "A_DTS/LOSSLESS";
    private static final String CODEC_ID_FLAC = "A_FLAC";
    private static final String CODEC_ID_ACM = "A_MS/ACM";
    private static final String CODEC_ID_PCM_INT_LIT = "A_PCM/INT/LIT";
    private static final String CODEC_ID_PCM_INT_BIG = "A_PCM/INT/BIG";
    private static final String CODEC_ID_PCM_FLOAT = "A_PCM/FLOAT/IEEE";
    private static final String CODEC_ID_SUBRIP = "S_TEXT/UTF8";
    private static final String CODEC_ID_ASS = "S_TEXT/ASS";
    private static final String CODEC_ID_VTT = "S_TEXT/WEBVTT";
    private static final String CODEC_ID_VOBSUB = "S_VOBSUB";
    private static final String CODEC_ID_PGS = "S_HDMV/PGS";
    private static final String CODEC_ID_DVBSUB = "S_DVBSUB";
    private static final int VORBIS_MAX_INPUT_SIZE = 8192;
    private static final int OPUS_MAX_INPUT_SIZE = 5760;
    private static final int ENCRYPTION_IV_SIZE = 8;
    private static final int TRACK_TYPE_AUDIO = 2;
    private static final int ID_EBML = 440786851;
    private static final int ID_EBML_READ_VERSION = 17143;
    private static final int ID_DOC_TYPE = 17026;
    private static final int ID_DOC_TYPE_READ_VERSION = 17029;
    private static final int ID_SEGMENT = 408125543;
    private static final int ID_SEGMENT_INFO = 357149030;
    private static final int ID_SEEK_HEAD = 290298740;
    private static final int ID_SEEK = 19899;
    private static final int ID_SEEK_ID = 21419;
    private static final int ID_SEEK_POSITION = 21420;
    private static final int ID_INFO = 357149030;
    private static final int ID_TIMECODE_SCALE = 2807729;
    private static final int ID_DURATION = 17545;
    private static final int ID_CLUSTER = 524531317;
    private static final int ID_TIME_CODE = 231;
    private static final int ID_SIMPLE_BLOCK = 163;
    private static final int ID_BLOCK_GROUP = 160;
    private static final int ID_BLOCK = 161;
    private static final int ID_BLOCK_DURATION = 155;
    private static final int ID_BLOCK_ADDITIONS = 30113;
    private static final int ID_BLOCK_MORE = 166;
    private static final int ID_BLOCK_ADD_ID = 238;
    private static final int ID_BLOCK_ADDITIONAL = 165;
    private static final int ID_REFERENCE_BLOCK = 251;
    private static final int ID_TRACKS = 374648427;
    private static final int ID_TRACK_ENTRY = 174;
    private static final int ID_TRACK_NUMBER = 215;
    private static final int ID_TRACK_TYPE = 131;
    private static final int ID_FLAG_DEFAULT = 136;
    private static final int ID_FLAG_FORCED = 21930;
    private static final int ID_DEFAULT_DURATION = 2352003;
    private static final int ID_MAX_BLOCK_ADDITION_ID = 21998;
    private static final int ID_BLOCK_ADDITION_MAPPING = 16868;
    private static final int ID_BLOCK_ADD_ID_TYPE = 16871;
    private static final int ID_BLOCK_ADD_ID_EXTRA_DATA = 16877;
    private static final int ID_NAME = 21358;
    private static final int ID_CODEC_ID = 134;
    private static final int ID_CODEC_PRIVATE = 25506;
    private static final int ID_CODEC_DELAY = 22186;
    private static final int ID_SEEK_PRE_ROLL = 22203;
    private static final int ID_DISCARD_PADDING = 30114;
    private static final int ID_VIDEO = 224;
    private static final int ID_PIXEL_WIDTH = 176;
    private static final int ID_PIXEL_HEIGHT = 186;
    private static final int ID_DISPLAY_WIDTH = 21680;
    private static final int ID_DISPLAY_HEIGHT = 21690;
    private static final int ID_DISPLAY_UNIT = 21682;
    private static final int ID_AUDIO = 225;
    private static final int ID_CHANNELS = 159;
    private static final int ID_AUDIO_BIT_DEPTH = 25188;
    private static final int ID_SAMPLING_FREQUENCY = 181;
    private static final int ID_CONTENT_ENCODINGS = 28032;
    private static final int ID_CONTENT_ENCODING = 25152;
    private static final int ID_CONTENT_ENCODING_ORDER = 20529;
    private static final int ID_CONTENT_ENCODING_SCOPE = 20530;
    private static final int ID_CONTENT_COMPRESSION = 20532;
    private static final int ID_CONTENT_COMPRESSION_ALGORITHM = 16980;
    private static final int ID_CONTENT_COMPRESSION_SETTINGS = 16981;
    private static final int ID_CONTENT_ENCRYPTION = 20533;
    private static final int ID_CONTENT_ENCRYPTION_ALGORITHM = 18401;
    private static final int ID_CONTENT_ENCRYPTION_KEY_ID = 18402;
    private static final int ID_CONTENT_ENCRYPTION_AES_SETTINGS = 18407;
    private static final int ID_CONTENT_ENCRYPTION_AES_SETTINGS_CIPHER_MODE = 18408;
    private static final int ID_CUES = 475249515;
    private static final int ID_CUE_POINT = 187;
    private static final int ID_CUE_TIME = 179;
    private static final int ID_CUE_TRACK_POSITIONS = 183;
    private static final int ID_CUE_CLUSTER_POSITION = 241;
    private static final int ID_LANGUAGE = 2274716;
    private static final int ID_PROJECTION = 30320;
    private static final int ID_PROJECTION_TYPE = 30321;
    private static final int ID_PROJECTION_PRIVATE = 30322;
    private static final int ID_PROJECTION_POSE_YAW = 30323;
    private static final int ID_PROJECTION_POSE_PITCH = 30324;
    private static final int ID_PROJECTION_POSE_ROLL = 30325;
    private static final int ID_STEREO_MODE = 21432;
    private static final int ID_COLOUR = 21936;
    private static final int ID_COLOUR_RANGE = 21945;
    private static final int ID_COLOUR_TRANSFER = 21946;
    private static final int ID_COLOUR_PRIMARIES = 21947;
    private static final int ID_MAX_CLL = 21948;
    private static final int ID_MAX_FALL = 21949;
    private static final int ID_MASTERING_METADATA = 21968;
    private static final int ID_PRIMARY_R_CHROMATICITY_X = 21969;
    private static final int ID_PRIMARY_R_CHROMATICITY_Y = 21970;
    private static final int ID_PRIMARY_G_CHROMATICITY_X = 21971;
    private static final int ID_PRIMARY_G_CHROMATICITY_Y = 21972;
    private static final int ID_PRIMARY_B_CHROMATICITY_X = 21973;
    private static final int ID_PRIMARY_B_CHROMATICITY_Y = 21974;
    private static final int ID_WHITE_POINT_CHROMATICITY_X = 21975;
    private static final int ID_WHITE_POINT_CHROMATICITY_Y = 21976;
    private static final int ID_LUMNINANCE_MAX = 21977;
    private static final int ID_LUMNINANCE_MIN = 21978;
    private static final int BLOCK_ADDITIONAL_ID_VP9_ITU_T_35 = 4;
    private static final int BLOCK_ADD_ID_TYPE_DVCC = 1685480259;
    private static final int BLOCK_ADD_ID_TYPE_DVVC = 1685485123;
    private static final int LACING_NONE = 0;
    private static final int LACING_XIPH = 1;
    private static final int LACING_FIXED_SIZE = 2;
    private static final int LACING_EBML = 3;
    private static final int FOURCC_COMPRESSION_DIVX = 1482049860;
    private static final int FOURCC_COMPRESSION_H263 = 859189832;
    private static final int FOURCC_COMPRESSION_VC1 = 826496599;
    private static final byte[] SUBRIP_PREFIX = new byte[]{49, 10, 48, 48, 58, 48, 48, 58, 48, 48, 44, 48, 48, 48, 32, 45, 45, 62, 32, 48, 48, 58, 48, 48, 58, 48, 48, 44, 48, 48, 48, 10};
    private static final int SUBRIP_PREFIX_END_TIMECODE_OFFSET = 19;
    private static final long SUBRIP_TIMECODE_LAST_VALUE_SCALING_FACTOR = 1000L;
    private static final String SUBRIP_TIMECODE_FORMAT = "%02d:%02d:%02d,%03d";
    private static final byte[] SSA_DIALOGUE_FORMAT = Util.getUtf8Bytes((String)"Format: Start, End, ReadOrder, Layer, Style, Name, MarginL, MarginR, MarginV, Effect, Text");
    private static final byte[] SSA_PREFIX = new byte[]{68, 105, 97, 108, 111, 103, 117, 101, 58, 32, 48, 58, 48, 48, 58, 48, 48, 58, 48, 48, 44, 48, 58, 48, 48, 58, 48, 48, 58, 48, 48, 44};
    private static final int SSA_PREFIX_END_TIMECODE_OFFSET = 21;
    private static final long SSA_TIMECODE_LAST_VALUE_SCALING_FACTOR = 10000L;
    private static final String SSA_TIMECODE_FORMAT = "%01d:%02d:%02d:%02d";
    private static final byte[] VTT_PREFIX = new byte[]{87, 69, 66, 86, 84, 84, 10, 10, 48, 48, 58, 48, 48, 58, 48, 48, 46, 48, 48, 48, 32, 45, 45, 62, 32, 48, 48, 58, 48, 48, 58, 48, 48, 46, 48, 48, 48, 10};
    private static final int VTT_PREFIX_END_TIMECODE_OFFSET = 25;
    private static final long VTT_TIMECODE_LAST_VALUE_SCALING_FACTOR = 1000L;
    private static final String VTT_TIMECODE_FORMAT = "%02d:%02d:%02d.%03d";
    private static final int WAVE_FORMAT_SIZE = 18;
    private static final int WAVE_FORMAT_EXTENSIBLE = 65534;
    private static final int WAVE_FORMAT_PCM = 1;
    private static final UUID WAVE_SUBFORMAT_PCM = new UUID(0x100000000001000L, -9223371306706625679L);
    private static final Map<String, Integer> TRACK_NAME_TO_ROTATION_DEGREES;
    private final EbmlReader reader;
    private final VarintReader varintReader;
    private final SparseArray<Track> tracks;
    private final boolean seekForCuesEnabled;
    private final ParsableByteArray nalStartCode;
    private final ParsableByteArray nalLength;
    private final ParsableByteArray scratch;
    private final ParsableByteArray vorbisNumPageSamples;
    private final ParsableByteArray seekEntryIdBytes;
    private final ParsableByteArray sampleStrippedBytes;
    private final ParsableByteArray subtitleSample;
    private final ParsableByteArray encryptionInitializationVector;
    private final ParsableByteArray encryptionSubsampleData;
    private final ParsableByteArray supplementalData;
    private @MonotonicNonNull ByteBuffer encryptionSubsampleDataBuffer;
    private long segmentContentSize;
    private long segmentContentPosition = -1L;
    private long timecodeScale = -9223372036854775807L;
    private long durationTimecode = -9223372036854775807L;
    private long durationUs = -9223372036854775807L;
    @Nullable
    private Track currentTrack;
    private boolean sentSeekMap;
    private int seekEntryId;
    private long seekEntryPosition;
    private boolean seekForCues;
    private long cuesContentPosition = -1L;
    private long seekPositionAfterBuildingCues = -1L;
    private long clusterTimecodeUs = -9223372036854775807L;
    @Nullable
    private LongArray cueTimesUs;
    @Nullable
    private LongArray cueClusterPositions;
    private boolean seenClusterPositionForCurrentCuePoint;
    private boolean haveOutputSample;
    private int blockState;
    private long blockTimeUs;
    private long blockDurationUs;
    private int blockSampleIndex;
    private int blockSampleCount;
    private int[] blockSampleSizes;
    private int blockTrackNumber;
    private int blockTrackNumberLength;
    private int blockFlags;
    private int blockAdditionalId;
    private boolean blockHasReferenceBlock;
    private long blockGroupDiscardPaddingNs;
    private int sampleBytesRead;
    private int sampleBytesWritten;
    private int sampleCurrentNalBytesRemaining;
    private boolean sampleEncodingHandled;
    private boolean sampleSignalByteRead;
    private boolean samplePartitionCountRead;
    private int samplePartitionCount;
    private byte sampleSignalByte;
    private boolean sampleInitializationVectorRead;
    private @MonotonicNonNull ExtractorOutput extractorOutput;

    public MatroskaExtractor() {
        this(0);
    }

    public MatroskaExtractor(int flags) {
        this(new DefaultEbmlReader(), flags);
    }

    MatroskaExtractor(EbmlReader reader, int flags) {
        this.reader = reader;
        this.reader.init(new InnerEbmlProcessor());
        this.seekForCuesEnabled = (flags & 1) == 0;
        this.varintReader = new VarintReader();
        this.tracks = new SparseArray();
        this.scratch = new ParsableByteArray(4);
        this.vorbisNumPageSamples = new ParsableByteArray(ByteBuffer.allocate(4).putInt(-1).array());
        this.seekEntryIdBytes = new ParsableByteArray(4);
        this.nalStartCode = new ParsableByteArray(NalUnitUtil.NAL_START_CODE);
        this.nalLength = new ParsableByteArray(4);
        this.sampleStrippedBytes = new ParsableByteArray();
        this.subtitleSample = new ParsableByteArray();
        this.encryptionInitializationVector = new ParsableByteArray(8);
        this.encryptionSubsampleData = new ParsableByteArray();
        this.supplementalData = new ParsableByteArray();
        this.blockSampleSizes = new int[1];
    }

    @Override
    public final boolean sniff(ExtractorInput input) throws IOException {
        return new Sniffer().sniff(input);
    }

    @Override
    public final void init(ExtractorOutput output) {
        this.extractorOutput = output;
    }

    @Override
    @CallSuper
    public void seek(long position, long timeUs) {
        this.clusterTimecodeUs = -9223372036854775807L;
        this.blockState = 0;
        this.reader.reset();
        this.varintReader.reset();
        this.resetWriteSampleData();
        for (int i = 0; i < this.tracks.size(); ++i) {
            ((Track)this.tracks.valueAt(i)).reset();
        }
    }

    @Override
    public final void release() {
    }

    @Override
    public final int read(ExtractorInput input, PositionHolder seekPosition) throws IOException {
        this.haveOutputSample = false;
        boolean continueReading = true;
        while (continueReading && !this.haveOutputSample) {
            continueReading = this.reader.read(input);
            if (!continueReading || !this.maybeSeekForCues(seekPosition, input.getPosition())) continue;
            return 1;
        }
        if (!continueReading) {
            for (int i = 0; i < this.tracks.size(); ++i) {
                Track track = (Track)this.tracks.valueAt(i);
                track.assertOutputInitialized();
                track.outputPendingSampleMetadata();
            }
            return -1;
        }
        return 0;
    }

    @CallSuper
    protected int getElementType(int id) {
        switch (id) {
            case 160: 
            case 166: 
            case 174: 
            case 183: 
            case 187: 
            case 224: 
            case 225: 
            case 16868: 
            case 18407: 
            case 19899: 
            case 20532: 
            case 20533: 
            case 21936: 
            case 21968: 
            case 25152: 
            case 28032: 
            case 30113: 
            case 30320: 
            case 290298740: 
            case 357149030: 
            case 374648427: 
            case 408125543: 
            case 440786851: 
            case 475249515: 
            case 524531317: {
                return 1;
            }
            case 131: 
            case 136: 
            case 155: 
            case 159: 
            case 176: 
            case 179: 
            case 186: 
            case 215: 
            case 231: 
            case 238: 
            case 241: 
            case 251: 
            case 16871: 
            case 16980: 
            case 17029: 
            case 17143: 
            case 18401: 
            case 18408: 
            case 20529: 
            case 20530: 
            case 21420: 
            case 21432: 
            case 21680: 
            case 21682: 
            case 21690: 
            case 21930: 
            case 21945: 
            case 21946: 
            case 21947: 
            case 21948: 
            case 21949: 
            case 21998: 
            case 22186: 
            case 22203: 
            case 25188: 
            case 30114: 
            case 30321: 
            case 2352003: 
            case 2807729: {
                return 2;
            }
            case 134: 
            case 17026: 
            case 21358: 
            case 2274716: {
                return 3;
            }
            case 161: 
            case 163: 
            case 165: 
            case 16877: 
            case 16981: 
            case 18402: 
            case 21419: 
            case 25506: 
            case 30322: {
                return 4;
            }
            case 181: 
            case 17545: 
            case 21969: 
            case 21970: 
            case 21971: 
            case 21972: 
            case 21973: 
            case 21974: 
            case 21975: 
            case 21976: 
            case 21977: 
            case 21978: 
            case 30323: 
            case 30324: 
            case 30325: {
                return 5;
            }
        }
        return 0;
    }

    @CallSuper
    protected boolean isLevel1Element(int id) {
        return id == 357149030 || id == 524531317 || id == 475249515 || id == 374648427;
    }

    @CallSuper
    protected void startMasterElement(int id, long contentPosition, long contentSize) throws ParserException {
        this.assertInitialized();
        switch (id) {
            case 408125543: {
                if (this.segmentContentPosition != -1L && this.segmentContentPosition != contentPosition) {
                    throw ParserException.createForMalformedContainer((String)"Multiple Segment elements not supported", null);
                }
                this.segmentContentPosition = contentPosition;
                this.segmentContentSize = contentSize;
                break;
            }
            case 19899: {
                this.seekEntryId = -1;
                this.seekEntryPosition = -1L;
                break;
            }
            case 475249515: {
                this.cueTimesUs = new LongArray();
                this.cueClusterPositions = new LongArray();
                break;
            }
            case 187: {
                this.seenClusterPositionForCurrentCuePoint = false;
                break;
            }
            case 524531317: {
                if (this.sentSeekMap) break;
                if (this.seekForCuesEnabled && this.cuesContentPosition != -1L) {
                    this.seekForCues = true;
                    break;
                }
                this.extractorOutput.seekMap(new SeekMap.Unseekable(this.durationUs));
                this.sentSeekMap = true;
                break;
            }
            case 160: {
                this.blockHasReferenceBlock = false;
                this.blockGroupDiscardPaddingNs = 0L;
                break;
            }
            case 25152: {
                break;
            }
            case 20533: {
                this.getCurrentTrack((int)id).hasContentEncryption = true;
                break;
            }
            case 174: {
                this.currentTrack = new Track();
                break;
            }
            case 21968: {
                this.getCurrentTrack((int)id).hasColorInfo = true;
                break;
            }
        }
    }

    @CallSuper
    protected void endMasterElement(int id) throws ParserException {
        this.assertInitialized();
        switch (id) {
            case 357149030: {
                if (this.timecodeScale == -9223372036854775807L) {
                    this.timecodeScale = 1000000L;
                }
                if (this.durationTimecode == -9223372036854775807L) break;
                this.durationUs = this.scaleTimecodeToUs(this.durationTimecode);
                break;
            }
            case 19899: {
                if (this.seekEntryId == -1 || this.seekEntryPosition == -1L) {
                    throw ParserException.createForMalformedContainer((String)"Mandatory element SeekID or SeekPosition not found", null);
                }
                if (this.seekEntryId != 475249515) break;
                this.cuesContentPosition = this.seekEntryPosition;
                break;
            }
            case 475249515: {
                if (!this.sentSeekMap) {
                    this.extractorOutput.seekMap(this.buildSeekMap(this.cueTimesUs, this.cueClusterPositions));
                    this.sentSeekMap = true;
                }
                this.cueTimesUs = null;
                this.cueClusterPositions = null;
                break;
            }
            case 160: {
                int i;
                if (this.blockState != 2) {
                    return;
                }
                Track track = (Track)this.tracks.get(this.blockTrackNumber);
                track.assertOutputInitialized();
                if (this.blockGroupDiscardPaddingNs > 0L && CODEC_ID_OPUS.equals(track.codecId)) {
                    this.supplementalData.reset(ByteBuffer.allocate(8).order(ByteOrder.LITTLE_ENDIAN).putLong(this.blockGroupDiscardPaddingNs).array());
                }
                int sampleOffset = 0;
                for (i = 0; i < this.blockSampleCount; ++i) {
                    sampleOffset += this.blockSampleSizes[i];
                }
                for (i = 0; i < this.blockSampleCount; ++i) {
                    long sampleTimeUs = this.blockTimeUs + (long)(i * track.defaultSampleDurationNs / 1000);
                    int sampleFlags = this.blockFlags;
                    if (i == 0 && !this.blockHasReferenceBlock) {
                        sampleFlags |= 1;
                    }
                    int sampleSize = this.blockSampleSizes[i];
                    this.commitSampleToOutput(track, sampleTimeUs, sampleFlags, sampleSize, sampleOffset -= sampleSize);
                }
                this.blockState = 0;
                break;
            }
            case 25152: {
                this.assertInTrackEntry(id);
                if (!this.currentTrack.hasContentEncryption) break;
                if (this.currentTrack.cryptoData == null) {
                    throw ParserException.createForMalformedContainer((String)"Encrypted Track found but ContentEncKeyID was not found", null);
                }
                this.currentTrack.drmInitData = new DrmInitData(new DrmInitData.SchemeData[]{new DrmInitData.SchemeData(C.UUID_NIL, "video/webm", this.currentTrack.cryptoData.encryptionKey)});
                break;
            }
            case 28032: {
                this.assertInTrackEntry(id);
                if (!this.currentTrack.hasContentEncryption || this.currentTrack.sampleStrippedBytes == null) break;
                throw ParserException.createForMalformedContainer((String)"Combining encryption and compression is not supported", null);
            }
            case 174: {
                Track currentTrack = (Track)Assertions.checkStateNotNull((Object)this.currentTrack);
                if (currentTrack.codecId == null) {
                    throw ParserException.createForMalformedContainer((String)"CodecId is missing in TrackEntry element", null);
                }
                if (MatroskaExtractor.isCodecSupported(currentTrack.codecId)) {
                    currentTrack.initializeOutput(this.extractorOutput, currentTrack.number);
                    this.tracks.put(currentTrack.number, (Object)currentTrack);
                }
                this.currentTrack = null;
                break;
            }
            case 374648427: {
                if (this.tracks.size() == 0) {
                    throw ParserException.createForMalformedContainer((String)"No valid tracks were found", null);
                }
                this.extractorOutput.endTracks();
                break;
            }
        }
    }

    @CallSuper
    protected void integerElement(int id, long value) throws ParserException {
        block0 : switch (id) {
            case 17143: {
                if (value == 1L) break;
                throw ParserException.createForMalformedContainer((String)("EBMLReadVersion " + value + " not supported"), null);
            }
            case 17029: {
                if (value >= 1L && value <= 2L) break;
                throw ParserException.createForMalformedContainer((String)("DocTypeReadVersion " + value + " not supported"), null);
            }
            case 21420: {
                this.seekEntryPosition = value + this.segmentContentPosition;
                break;
            }
            case 2807729: {
                this.timecodeScale = value;
                break;
            }
            case 176: {
                this.getCurrentTrack((int)id).width = (int)value;
                break;
            }
            case 186: {
                this.getCurrentTrack((int)id).height = (int)value;
                break;
            }
            case 21680: {
                this.getCurrentTrack((int)id).displayWidth = (int)value;
                break;
            }
            case 21690: {
                this.getCurrentTrack((int)id).displayHeight = (int)value;
                break;
            }
            case 21682: {
                this.getCurrentTrack((int)id).displayUnit = (int)value;
                break;
            }
            case 215: {
                this.getCurrentTrack((int)id).number = (int)value;
                break;
            }
            case 136: {
                this.getCurrentTrack((int)id).flagDefault = value == 1L;
                break;
            }
            case 21930: {
                this.getCurrentTrack((int)id).flagForced = value == 1L;
                break;
            }
            case 131: {
                this.getCurrentTrack((int)id).type = (int)value;
                break;
            }
            case 2352003: {
                this.getCurrentTrack((int)id).defaultSampleDurationNs = (int)value;
                break;
            }
            case 21998: {
                this.getCurrentTrack((int)id).maxBlockAdditionId = (int)value;
                break;
            }
            case 16871: {
                this.getCurrentTrack(id).blockAddIdType = (int)value;
                break;
            }
            case 22186: {
                this.getCurrentTrack((int)id).codecDelayNs = value;
                break;
            }
            case 22203: {
                this.getCurrentTrack((int)id).seekPreRollNs = value;
                break;
            }
            case 30114: {
                this.blockGroupDiscardPaddingNs = value;
                break;
            }
            case 159: {
                this.getCurrentTrack((int)id).channelCount = (int)value;
                break;
            }
            case 25188: {
                this.getCurrentTrack((int)id).audioBitDepth = (int)value;
                break;
            }
            case 251: {
                this.blockHasReferenceBlock = true;
                break;
            }
            case 20529: {
                if (value == 0L) break;
                throw ParserException.createForMalformedContainer((String)("ContentEncodingOrder " + value + " not supported"), null);
            }
            case 20530: {
                if (value == 1L) break;
                throw ParserException.createForMalformedContainer((String)("ContentEncodingScope " + value + " not supported"), null);
            }
            case 16980: {
                if (value == 3L) break;
                throw ParserException.createForMalformedContainer((String)("ContentCompAlgo " + value + " not supported"), null);
            }
            case 18401: {
                if (value == 5L) break;
                throw ParserException.createForMalformedContainer((String)("ContentEncAlgo " + value + " not supported"), null);
            }
            case 18408: {
                if (value == 1L) break;
                throw ParserException.createForMalformedContainer((String)("AESSettingsCipherMode " + value + " not supported"), null);
            }
            case 179: {
                this.assertInCues(id);
                this.cueTimesUs.add(this.scaleTimecodeToUs(value));
                break;
            }
            case 241: {
                if (this.seenClusterPositionForCurrentCuePoint) break;
                this.assertInCues(id);
                this.cueClusterPositions.add(value);
                this.seenClusterPositionForCurrentCuePoint = true;
                break;
            }
            case 231: {
                this.clusterTimecodeUs = this.scaleTimecodeToUs(value);
                break;
            }
            case 155: {
                this.blockDurationUs = this.scaleTimecodeToUs(value);
                break;
            }
            case 21432: {
                int layout = (int)value;
                this.assertInTrackEntry(id);
                switch (layout) {
                    case 0: {
                        this.currentTrack.stereoMode = 0;
                        break block0;
                    }
                    case 1: {
                        this.currentTrack.stereoMode = 2;
                        break block0;
                    }
                    case 3: {
                        this.currentTrack.stereoMode = 1;
                        break block0;
                    }
                    case 15: {
                        this.currentTrack.stereoMode = 3;
                        break block0;
                    }
                }
                break;
            }
            case 21947: {
                this.assertInTrackEntry(id);
                this.currentTrack.hasColorInfo = true;
                int colorSpace = ColorInfo.isoColorPrimariesToColorSpace((int)((int)value));
                if (colorSpace == -1) break;
                this.currentTrack.colorSpace = colorSpace;
                break;
            }
            case 21946: {
                this.assertInTrackEntry(id);
                int colorTransfer = ColorInfo.isoTransferCharacteristicsToColorTransfer((int)((int)value));
                if (colorTransfer == -1) break;
                this.currentTrack.colorTransfer = colorTransfer;
                break;
            }
            case 21945: {
                this.assertInTrackEntry(id);
                switch ((int)value) {
                    case 1: {
                        this.currentTrack.colorRange = 2;
                        break block0;
                    }
                    case 2: {
                        this.currentTrack.colorRange = 1;
                        break block0;
                    }
                }
                break;
            }
            case 21948: {
                this.getCurrentTrack((int)id).maxContentLuminance = (int)value;
                break;
            }
            case 21949: {
                this.getCurrentTrack((int)id).maxFrameAverageLuminance = (int)value;
                break;
            }
            case 30321: {
                this.assertInTrackEntry(id);
                switch ((int)value) {
                    case 0: {
                        this.currentTrack.projectionType = 0;
                        break block0;
                    }
                    case 1: {
                        this.currentTrack.projectionType = 1;
                        break block0;
                    }
                    case 2: {
                        this.currentTrack.projectionType = 2;
                        break block0;
                    }
                    case 3: {
                        this.currentTrack.projectionType = 3;
                        break block0;
                    }
                }
                break;
            }
            case 238: {
                this.blockAdditionalId = (int)value;
                break;
            }
        }
    }

    @CallSuper
    protected void floatElement(int id, double value) throws ParserException {
        switch (id) {
            case 17545: {
                this.durationTimecode = (long)value;
                break;
            }
            case 181: {
                this.getCurrentTrack((int)id).sampleRate = (int)value;
                break;
            }
            case 21969: {
                this.getCurrentTrack((int)id).primaryRChromaticityX = (float)value;
                break;
            }
            case 21970: {
                this.getCurrentTrack((int)id).primaryRChromaticityY = (float)value;
                break;
            }
            case 21971: {
                this.getCurrentTrack((int)id).primaryGChromaticityX = (float)value;
                break;
            }
            case 21972: {
                this.getCurrentTrack((int)id).primaryGChromaticityY = (float)value;
                break;
            }
            case 21973: {
                this.getCurrentTrack((int)id).primaryBChromaticityX = (float)value;
                break;
            }
            case 21974: {
                this.getCurrentTrack((int)id).primaryBChromaticityY = (float)value;
                break;
            }
            case 21975: {
                this.getCurrentTrack((int)id).whitePointChromaticityX = (float)value;
                break;
            }
            case 21976: {
                this.getCurrentTrack((int)id).whitePointChromaticityY = (float)value;
                break;
            }
            case 21977: {
                this.getCurrentTrack((int)id).maxMasteringLuminance = (float)value;
                break;
            }
            case 21978: {
                this.getCurrentTrack((int)id).minMasteringLuminance = (float)value;
                break;
            }
            case 30323: {
                this.getCurrentTrack((int)id).projectionPoseYaw = (float)value;
                break;
            }
            case 30324: {
                this.getCurrentTrack((int)id).projectionPosePitch = (float)value;
                break;
            }
            case 30325: {
                this.getCurrentTrack((int)id).projectionPoseRoll = (float)value;
                break;
            }
        }
    }

    @CallSuper
    protected void stringElement(int id, String value) throws ParserException {
        switch (id) {
            case 17026: {
                if (DOC_TYPE_WEBM.equals(value) || DOC_TYPE_MATROSKA.equals(value)) break;
                throw ParserException.createForMalformedContainer((String)("DocType " + value + " not supported"), null);
            }
            case 21358: {
                this.getCurrentTrack((int)id).name = value;
                break;
            }
            case 134: {
                this.getCurrentTrack((int)id).codecId = value;
                break;
            }
            case 2274716: {
                this.getCurrentTrack(id).language = value;
                break;
            }
        }
    }

    @CallSuper
    protected void binaryElement(int id, int contentSize, ExtractorInput input) throws IOException {
        switch (id) {
            case 21419: {
                Arrays.fill(this.seekEntryIdBytes.getData(), (byte)0);
                input.readFully(this.seekEntryIdBytes.getData(), 4 - contentSize, contentSize);
                this.seekEntryIdBytes.setPosition(0);
                this.seekEntryId = (int)this.seekEntryIdBytes.readUnsignedInt();
                break;
            }
            case 16877: {
                this.handleBlockAddIDExtraData(this.getCurrentTrack(id), input, contentSize);
                break;
            }
            case 25506: {
                this.assertInTrackEntry(id);
                this.currentTrack.codecPrivate = new byte[contentSize];
                input.readFully(this.currentTrack.codecPrivate, 0, contentSize);
                break;
            }
            case 30322: {
                this.assertInTrackEntry(id);
                this.currentTrack.projectionData = new byte[contentSize];
                input.readFully(this.currentTrack.projectionData, 0, contentSize);
                break;
            }
            case 16981: {
                this.assertInTrackEntry(id);
                this.currentTrack.sampleStrippedBytes = new byte[contentSize];
                input.readFully(this.currentTrack.sampleStrippedBytes, 0, contentSize);
                break;
            }
            case 18402: {
                byte[] encryptionKey = new byte[contentSize];
                input.readFully(encryptionKey, 0, contentSize);
                this.getCurrentTrack((int)id).cryptoData = new TrackOutput.CryptoData(1, encryptionKey, 0, 0);
                break;
            }
            case 161: 
            case 163: {
                Track track;
                if (this.blockState == 0) {
                    this.blockTrackNumber = (int)this.varintReader.readUnsignedVarint(input, false, true, 8);
                    this.blockTrackNumberLength = this.varintReader.getLastLength();
                    this.blockDurationUs = -9223372036854775807L;
                    this.blockState = 1;
                    this.scratch.reset(0);
                }
                if ((track = (Track)this.tracks.get(this.blockTrackNumber)) == null) {
                    input.skipFully(contentSize - this.blockTrackNumberLength);
                    this.blockState = 0;
                    return;
                }
                track.assertOutputInitialized();
                if (this.blockState == 1) {
                    this.readScratch(input, 3);
                    int lacing = (this.scratch.getData()[2] & 6) >> 1;
                    if (lacing == 0) {
                        this.blockSampleCount = 1;
                        this.blockSampleSizes = MatroskaExtractor.ensureArrayCapacity(this.blockSampleSizes, 1);
                        this.blockSampleSizes[0] = contentSize - this.blockTrackNumberLength - 3;
                    } else {
                        int sampleIndex;
                        int headerSize;
                        int totalSamplesSize;
                        this.readScratch(input, 4);
                        this.blockSampleCount = (this.scratch.getData()[3] & 0xFF) + 1;
                        this.blockSampleSizes = MatroskaExtractor.ensureArrayCapacity(this.blockSampleSizes, this.blockSampleCount);
                        if (lacing == 2) {
                            int blockLacingSampleSize = (contentSize - this.blockTrackNumberLength - 4) / this.blockSampleCount;
                            Arrays.fill(this.blockSampleSizes, 0, this.blockSampleCount, blockLacingSampleSize);
                        } else if (lacing == 1) {
                            totalSamplesSize = 0;
                            headerSize = 4;
                            for (sampleIndex = 0; sampleIndex < this.blockSampleCount - 1; ++sampleIndex) {
                                int byteValue;
                                this.blockSampleSizes[sampleIndex] = 0;
                                do {
                                    this.readScratch(input, ++headerSize);
                                    byteValue = this.scratch.getData()[headerSize - 1] & 0xFF;
                                    int n = sampleIndex;
                                    this.blockSampleSizes[n] = this.blockSampleSizes[n] + byteValue;
                                } while (byteValue == 255);
                                totalSamplesSize += this.blockSampleSizes[sampleIndex];
                            }
                            this.blockSampleSizes[this.blockSampleCount - 1] = contentSize - this.blockTrackNumberLength - headerSize - totalSamplesSize;
                        } else if (lacing == 3) {
                            totalSamplesSize = 0;
                            headerSize = 4;
                            for (sampleIndex = 0; sampleIndex < this.blockSampleCount - 1; ++sampleIndex) {
                                this.blockSampleSizes[sampleIndex] = 0;
                                this.readScratch(input, ++headerSize);
                                if (this.scratch.getData()[headerSize - 1] == 0) {
                                    throw ParserException.createForMalformedContainer((String)"No valid varint length mask found", null);
                                }
                                long readValue = 0L;
                                for (int i = 0; i < 8; ++i) {
                                    int lengthMask = 1 << 7 - i;
                                    if ((this.scratch.getData()[headerSize - 1] & lengthMask) == 0) continue;
                                    int readPosition = headerSize - 1;
                                    this.readScratch(input, headerSize += i);
                                    readValue = this.scratch.getData()[readPosition++] & 0xFF & ~lengthMask;
                                    while (readPosition < headerSize) {
                                        readValue <<= 8;
                                        readValue |= (long)(this.scratch.getData()[readPosition++] & 0xFF);
                                    }
                                    if (sampleIndex <= 0) break;
                                    readValue -= (1L << 6 + i * 7) - 1L;
                                    break;
                                }
                                if (readValue < Integer.MIN_VALUE || readValue > Integer.MAX_VALUE) {
                                    throw ParserException.createForMalformedContainer((String)"EBML lacing sample size out of range.", null);
                                }
                                int intReadValue = (int)readValue;
                                this.blockSampleSizes[sampleIndex] = sampleIndex == 0 ? intReadValue : this.blockSampleSizes[sampleIndex - 1] + intReadValue;
                                totalSamplesSize += this.blockSampleSizes[sampleIndex];
                            }
                            this.blockSampleSizes[this.blockSampleCount - 1] = contentSize - this.blockTrackNumberLength - headerSize - totalSamplesSize;
                        } else {
                            throw ParserException.createForMalformedContainer((String)("Unexpected lacing value: " + lacing), null);
                        }
                    }
                    int timecode = this.scratch.getData()[0] << 8 | this.scratch.getData()[1] & 0xFF;
                    this.blockTimeUs = this.clusterTimecodeUs + this.scaleTimecodeToUs(timecode);
                    boolean isKeyframe = track.type == 2 || id == 163 && (this.scratch.getData()[2] & 0x80) == 128;
                    this.blockFlags = isKeyframe ? 1 : 0;
                    this.blockState = 2;
                    this.blockSampleIndex = 0;
                }
                if (id == 163) {
                    while (this.blockSampleIndex < this.blockSampleCount) {
                        int sampleSize = this.writeSampleData(input, track, this.blockSampleSizes[this.blockSampleIndex], false);
                        long sampleTimeUs = this.blockTimeUs + (long)(this.blockSampleIndex * track.defaultSampleDurationNs / 1000);
                        this.commitSampleToOutput(track, sampleTimeUs, this.blockFlags, sampleSize, 0);
                        ++this.blockSampleIndex;
                    }
                    this.blockState = 0;
                    break;
                }
                while (this.blockSampleIndex < this.blockSampleCount) {
                    this.blockSampleSizes[this.blockSampleIndex] = this.writeSampleData(input, track, this.blockSampleSizes[this.blockSampleIndex], true);
                    ++this.blockSampleIndex;
                }
                break;
            }
            case 165: {
                if (this.blockState != 2) {
                    return;
                }
                this.handleBlockAdditionalData((Track)this.tracks.get(this.blockTrackNumber), this.blockAdditionalId, input, contentSize);
                break;
            }
            default: {
                throw ParserException.createForMalformedContainer((String)("Unexpected id: " + id), null);
            }
        }
    }

    protected void handleBlockAddIDExtraData(Track track, ExtractorInput input, int contentSize) throws IOException {
        if (track.blockAddIdType == 1685485123 || track.blockAddIdType == 1685480259) {
            track.dolbyVisionConfigBytes = new byte[contentSize];
            input.readFully(track.dolbyVisionConfigBytes, 0, contentSize);
        } else {
            input.skipFully(contentSize);
        }
    }

    protected void handleBlockAdditionalData(Track track, int blockAdditionalId, ExtractorInput input, int contentSize) throws IOException {
        if (blockAdditionalId == 4 && CODEC_ID_VP9.equals(track.codecId)) {
            this.supplementalData.reset(contentSize);
            input.readFully(this.supplementalData.getData(), 0, contentSize);
        } else {
            input.skipFully(contentSize);
        }
    }

    @EnsuresNonNull(value={"currentTrack"})
    private void assertInTrackEntry(int id) throws ParserException {
        if (this.currentTrack == null) {
            throw ParserException.createForMalformedContainer((String)("Element " + id + " must be in a TrackEntry"), null);
        }
    }

    @EnsuresNonNull(value={"cueTimesUs", "cueClusterPositions"})
    private void assertInCues(int id) throws ParserException {
        if (this.cueTimesUs == null || this.cueClusterPositions == null) {
            throw ParserException.createForMalformedContainer((String)("Element " + id + " must be in a Cues"), null);
        }
    }

    protected Track getCurrentTrack(int currentElementId) throws ParserException {
        this.assertInTrackEntry(currentElementId);
        return this.currentTrack;
    }

    @RequiresNonNull(value={"#1.output"})
    private void commitSampleToOutput(Track track, long timeUs, int flags, int size, int offset) {
        if (track.trueHdSampleRechunker != null) {
            track.trueHdSampleRechunker.sampleMetadata(track.output, timeUs, flags, size, offset, track.cryptoData);
        } else {
            if (CODEC_ID_SUBRIP.equals(track.codecId) || CODEC_ID_ASS.equals(track.codecId) || CODEC_ID_VTT.equals(track.codecId)) {
                if (this.blockSampleCount > 1) {
                    Log.w((String)TAG, (String)"Skipping subtitle sample in laced block.");
                } else if (this.blockDurationUs == -9223372036854775807L) {
                    Log.w((String)TAG, (String)"Skipping subtitle sample with no duration.");
                } else {
                    MatroskaExtractor.setSubtitleEndTime(track.codecId, this.blockDurationUs, this.subtitleSample.getData());
                    for (int i = this.subtitleSample.getPosition(); i < this.subtitleSample.limit(); ++i) {
                        if (this.subtitleSample.getData()[i] != 0) continue;
                        this.subtitleSample.setLimit(i);
                        break;
                    }
                    track.output.sampleData(this.subtitleSample, this.subtitleSample.limit());
                    size += this.subtitleSample.limit();
                }
            }
            if ((flags & 0x10000000) != 0) {
                if (this.blockSampleCount > 1) {
                    this.supplementalData.reset(0);
                } else {
                    int supplementalDataSize = this.supplementalData.limit();
                    track.output.sampleData(this.supplementalData, supplementalDataSize, 2);
                    size += supplementalDataSize;
                }
            }
            track.output.sampleMetadata(timeUs, flags, size, offset, track.cryptoData);
        }
        this.haveOutputSample = true;
    }

    private void readScratch(ExtractorInput input, int requiredLength) throws IOException {
        if (this.scratch.limit() >= requiredLength) {
            return;
        }
        if (this.scratch.capacity() < requiredLength) {
            this.scratch.ensureCapacity(Math.max(this.scratch.capacity() * 2, requiredLength));
        }
        input.readFully(this.scratch.getData(), this.scratch.limit(), requiredLength - this.scratch.limit());
        this.scratch.setLimit(requiredLength);
    }

    @RequiresNonNull(value={"#2.output"})
    private int writeSampleData(ExtractorInput input, Track track, int size, boolean isBlockGroup) throws IOException {
        if (CODEC_ID_SUBRIP.equals(track.codecId)) {
            this.writeSubtitleSampleData(input, SUBRIP_PREFIX, size);
            return this.finishWriteSampleData();
        }
        if (CODEC_ID_ASS.equals(track.codecId)) {
            this.writeSubtitleSampleData(input, SSA_PREFIX, size);
            return this.finishWriteSampleData();
        }
        if (CODEC_ID_VTT.equals(track.codecId)) {
            this.writeSubtitleSampleData(input, VTT_PREFIX, size);
            return this.finishWriteSampleData();
        }
        TrackOutput output = track.output;
        if (!this.sampleEncodingHandled) {
            if (track.hasContentEncryption) {
                boolean isEncrypted;
                this.blockFlags &= 0xBFFFFFFF;
                if (!this.sampleSignalByteRead) {
                    input.readFully(this.scratch.getData(), 0, 1);
                    ++this.sampleBytesRead;
                    if ((this.scratch.getData()[0] & 0x80) == 128) {
                        throw ParserException.createForMalformedContainer((String)"Extension bit is set in signal byte", null);
                    }
                    this.sampleSignalByte = this.scratch.getData()[0];
                    this.sampleSignalByteRead = true;
                }
                boolean bl = isEncrypted = (this.sampleSignalByte & 1) == 1;
                if (isEncrypted) {
                    boolean hasSubsampleEncryption = (this.sampleSignalByte & 2) == 2;
                    this.blockFlags |= 0x40000000;
                    if (!this.sampleInitializationVectorRead) {
                        input.readFully(this.encryptionInitializationVector.getData(), 0, 8);
                        this.sampleBytesRead += 8;
                        this.sampleInitializationVectorRead = true;
                        this.scratch.getData()[0] = (byte)(8 | (hasSubsampleEncryption ? 128 : 0));
                        this.scratch.setPosition(0);
                        output.sampleData(this.scratch, 1, 1);
                        ++this.sampleBytesWritten;
                        this.encryptionInitializationVector.setPosition(0);
                        output.sampleData(this.encryptionInitializationVector, 8, 1);
                        this.sampleBytesWritten += 8;
                    }
                    if (hasSubsampleEncryption) {
                        if (!this.samplePartitionCountRead) {
                            input.readFully(this.scratch.getData(), 0, 1);
                            ++this.sampleBytesRead;
                            this.scratch.setPosition(0);
                            this.samplePartitionCount = this.scratch.readUnsignedByte();
                            this.samplePartitionCountRead = true;
                        }
                        int samplePartitionDataSize = this.samplePartitionCount * 4;
                        this.scratch.reset(samplePartitionDataSize);
                        input.readFully(this.scratch.getData(), 0, samplePartitionDataSize);
                        this.sampleBytesRead += samplePartitionDataSize;
                        short subsampleCount = (short)(1 + this.samplePartitionCount / 2);
                        int subsampleDataSize = 2 + 6 * subsampleCount;
                        if (this.encryptionSubsampleDataBuffer == null || this.encryptionSubsampleDataBuffer.capacity() < subsampleDataSize) {
                            this.encryptionSubsampleDataBuffer = ByteBuffer.allocate(subsampleDataSize);
                        }
                        this.encryptionSubsampleDataBuffer.position(0);
                        this.encryptionSubsampleDataBuffer.putShort(subsampleCount);
                        int partitionOffset = 0;
                        for (int i = 0; i < this.samplePartitionCount; ++i) {
                            int previousPartitionOffset = partitionOffset;
                            partitionOffset = this.scratch.readUnsignedIntToInt();
                            if (i % 2 == 0) {
                                this.encryptionSubsampleDataBuffer.putShort((short)(partitionOffset - previousPartitionOffset));
                                continue;
                            }
                            this.encryptionSubsampleDataBuffer.putInt(partitionOffset - previousPartitionOffset);
                        }
                        int finalPartitionSize = size - this.sampleBytesRead - partitionOffset;
                        if (this.samplePartitionCount % 2 == 1) {
                            this.encryptionSubsampleDataBuffer.putInt(finalPartitionSize);
                        } else {
                            this.encryptionSubsampleDataBuffer.putShort((short)finalPartitionSize);
                            this.encryptionSubsampleDataBuffer.putInt(0);
                        }
                        this.encryptionSubsampleData.reset(this.encryptionSubsampleDataBuffer.array(), subsampleDataSize);
                        output.sampleData(this.encryptionSubsampleData, subsampleDataSize, 1);
                        this.sampleBytesWritten += subsampleDataSize;
                    }
                }
            } else if (track.sampleStrippedBytes != null) {
                this.sampleStrippedBytes.reset(track.sampleStrippedBytes, track.sampleStrippedBytes.length);
            }
            if (track.samplesHaveSupplementalData(isBlockGroup)) {
                this.blockFlags |= 0x10000000;
                this.supplementalData.reset(0);
                int sampleSize = size + this.sampleStrippedBytes.limit() - this.sampleBytesRead;
                this.scratch.reset(4);
                this.scratch.getData()[0] = (byte)(sampleSize >> 24 & 0xFF);
                this.scratch.getData()[1] = (byte)(sampleSize >> 16 & 0xFF);
                this.scratch.getData()[2] = (byte)(sampleSize >> 8 & 0xFF);
                this.scratch.getData()[3] = (byte)(sampleSize & 0xFF);
                output.sampleData(this.scratch, 4, 2);
                this.sampleBytesWritten += 4;
            }
            this.sampleEncodingHandled = true;
        }
        size += this.sampleStrippedBytes.limit();
        if (CODEC_ID_H264.equals(track.codecId) || CODEC_ID_H265.equals(track.codecId)) {
            byte[] nalLengthData = this.nalLength.getData();
            nalLengthData[0] = 0;
            nalLengthData[1] = 0;
            nalLengthData[2] = 0;
            int nalUnitLengthFieldLength = track.nalUnitLengthFieldLength;
            int nalUnitLengthFieldLengthDiff = 4 - track.nalUnitLengthFieldLength;
            while (this.sampleBytesRead < size) {
                if (this.sampleCurrentNalBytesRemaining == 0) {
                    this.writeToTarget(input, nalLengthData, nalUnitLengthFieldLengthDiff, nalUnitLengthFieldLength);
                    this.sampleBytesRead += nalUnitLengthFieldLength;
                    this.nalLength.setPosition(0);
                    this.sampleCurrentNalBytesRemaining = this.nalLength.readUnsignedIntToInt();
                    this.nalStartCode.setPosition(0);
                    output.sampleData(this.nalStartCode, 4);
                    this.sampleBytesWritten += 4;
                    continue;
                }
                int bytesWritten = this.writeToOutput(input, output, this.sampleCurrentNalBytesRemaining);
                this.sampleBytesRead += bytesWritten;
                this.sampleBytesWritten += bytesWritten;
                this.sampleCurrentNalBytesRemaining -= bytesWritten;
            }
        } else {
            if (track.trueHdSampleRechunker != null) {
                Assertions.checkState((this.sampleStrippedBytes.limit() == 0 ? 1 : 0) != 0);
                track.trueHdSampleRechunker.startSample(input);
            }
            while (this.sampleBytesRead < size) {
                int bytesWritten = this.writeToOutput(input, output, size - this.sampleBytesRead);
                this.sampleBytesRead += bytesWritten;
                this.sampleBytesWritten += bytesWritten;
            }
        }
        if (CODEC_ID_VORBIS.equals(track.codecId)) {
            this.vorbisNumPageSamples.setPosition(0);
            output.sampleData(this.vorbisNumPageSamples, 4);
            this.sampleBytesWritten += 4;
        }
        return this.finishWriteSampleData();
    }

    private int finishWriteSampleData() {
        int sampleSize = this.sampleBytesWritten;
        this.resetWriteSampleData();
        return sampleSize;
    }

    private void resetWriteSampleData() {
        this.sampleBytesRead = 0;
        this.sampleBytesWritten = 0;
        this.sampleCurrentNalBytesRemaining = 0;
        this.sampleEncodingHandled = false;
        this.sampleSignalByteRead = false;
        this.samplePartitionCountRead = false;
        this.samplePartitionCount = 0;
        this.sampleSignalByte = 0;
        this.sampleInitializationVectorRead = false;
        this.sampleStrippedBytes.reset(0);
    }

    private void writeSubtitleSampleData(ExtractorInput input, byte[] samplePrefix, int size) throws IOException {
        int sizeWithPrefix = samplePrefix.length + size;
        if (this.subtitleSample.capacity() < sizeWithPrefix) {
            this.subtitleSample.reset(Arrays.copyOf(samplePrefix, sizeWithPrefix + size));
        } else {
            System.arraycopy(samplePrefix, 0, this.subtitleSample.getData(), 0, samplePrefix.length);
        }
        input.readFully(this.subtitleSample.getData(), samplePrefix.length, size);
        this.subtitleSample.setPosition(0);
        this.subtitleSample.setLimit(sizeWithPrefix);
    }

    private static void setSubtitleEndTime(String codecId, long durationUs, byte[] subtitleData) {
        int endTimecodeOffset;
        byte[] endTimecode;
        switch (codecId) {
            case "S_TEXT/UTF8": {
                endTimecode = MatroskaExtractor.formatSubtitleTimecode(durationUs, SUBRIP_TIMECODE_FORMAT, 1000L);
                endTimecodeOffset = 19;
                break;
            }
            case "S_TEXT/ASS": {
                endTimecode = MatroskaExtractor.formatSubtitleTimecode(durationUs, SSA_TIMECODE_FORMAT, 10000L);
                endTimecodeOffset = 21;
                break;
            }
            case "S_TEXT/WEBVTT": {
                endTimecode = MatroskaExtractor.formatSubtitleTimecode(durationUs, VTT_TIMECODE_FORMAT, 1000L);
                endTimecodeOffset = 25;
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        System.arraycopy(endTimecode, 0, subtitleData, endTimecodeOffset, endTimecode.length);
    }

    private static byte[] formatSubtitleTimecode(long timeUs, String timecodeFormat, long lastTimecodeValueScalingFactor) {
        Assertions.checkArgument((timeUs != -9223372036854775807L ? 1 : 0) != 0);
        int hours = (int)(timeUs / 3600000000L);
        int minutes = (int)((timeUs -= (long)hours * 3600L * 1000000L) / 60000000L);
        int seconds = (int)((timeUs -= (long)minutes * 60L * 1000000L) / 1000000L);
        int lastValue = (int)((timeUs -= (long)seconds * 1000000L) / lastTimecodeValueScalingFactor);
        byte[] timeCodeData = Util.getUtf8Bytes((String)String.format(Locale.US, timecodeFormat, hours, minutes, seconds, lastValue));
        return timeCodeData;
    }

    private void writeToTarget(ExtractorInput input, byte[] target, int offset, int length) throws IOException {
        int pendingStrippedBytes = Math.min(length, this.sampleStrippedBytes.bytesLeft());
        input.readFully(target, offset + pendingStrippedBytes, length - pendingStrippedBytes);
        if (pendingStrippedBytes > 0) {
            this.sampleStrippedBytes.readBytes(target, offset, pendingStrippedBytes);
        }
    }

    private int writeToOutput(ExtractorInput input, TrackOutput output, int length) throws IOException {
        int bytesWritten;
        int strippedBytesLeft = this.sampleStrippedBytes.bytesLeft();
        if (strippedBytesLeft > 0) {
            bytesWritten = Math.min(length, strippedBytesLeft);
            output.sampleData(this.sampleStrippedBytes, bytesWritten);
        } else {
            bytesWritten = output.sampleData(input, length, false);
        }
        return bytesWritten;
    }

    private SeekMap buildSeekMap(@Nullable LongArray cueTimesUs, @Nullable LongArray cueClusterPositions) {
        int i;
        if (this.segmentContentPosition == -1L || this.durationUs == -9223372036854775807L || cueTimesUs == null || cueTimesUs.size() == 0 || cueClusterPositions == null || cueClusterPositions.size() != cueTimesUs.size()) {
            return new SeekMap.Unseekable(this.durationUs);
        }
        int cuePointsSize = cueTimesUs.size();
        int[] sizes = new int[cuePointsSize];
        long[] offsets = new long[cuePointsSize];
        long[] durationsUs = new long[cuePointsSize];
        long[] timesUs = new long[cuePointsSize];
        for (i = 0; i < cuePointsSize; ++i) {
            timesUs[i] = cueTimesUs.get(i);
            offsets[i] = this.segmentContentPosition + cueClusterPositions.get(i);
        }
        for (i = 0; i < cuePointsSize - 1; ++i) {
            sizes[i] = (int)(offsets[i + 1] - offsets[i]);
            durationsUs[i] = timesUs[i + 1] - timesUs[i];
        }
        sizes[cuePointsSize - 1] = (int)(this.segmentContentPosition + this.segmentContentSize - offsets[cuePointsSize - 1]);
        durationsUs[cuePointsSize - 1] = this.durationUs - timesUs[cuePointsSize - 1];
        long lastDurationUs = durationsUs[cuePointsSize - 1];
        if (lastDurationUs <= 0L) {
            Log.w((String)TAG, (String)("Discarding last cue point with unexpected duration: " + lastDurationUs));
            sizes = Arrays.copyOf(sizes, sizes.length - 1);
            offsets = Arrays.copyOf(offsets, offsets.length - 1);
            durationsUs = Arrays.copyOf(durationsUs, durationsUs.length - 1);
            timesUs = Arrays.copyOf(timesUs, timesUs.length - 1);
        }
        return new ChunkIndex(sizes, offsets, durationsUs, timesUs);
    }

    private boolean maybeSeekForCues(PositionHolder seekPosition, long currentPosition) {
        if (this.seekForCues) {
            this.seekPositionAfterBuildingCues = currentPosition;
            seekPosition.position = this.cuesContentPosition;
            this.seekForCues = false;
            return true;
        }
        if (this.sentSeekMap && this.seekPositionAfterBuildingCues != -1L) {
            seekPosition.position = this.seekPositionAfterBuildingCues;
            this.seekPositionAfterBuildingCues = -1L;
            return true;
        }
        return false;
    }

    private long scaleTimecodeToUs(long unscaledTimecode) throws ParserException {
        if (this.timecodeScale == -9223372036854775807L) {
            throw ParserException.createForMalformedContainer((String)"Can't scale timecode prior to timecodeScale being set.", null);
        }
        return Util.scaleLargeTimestamp((long)unscaledTimecode, (long)this.timecodeScale, (long)1000L);
    }

    private static boolean isCodecSupported(String codecId) {
        switch (codecId) {
            case "V_VP8": 
            case "V_VP9": 
            case "V_AV1": 
            case "V_MPEG2": 
            case "V_MPEG4/ISO/SP": 
            case "V_MPEG4/ISO/ASP": 
            case "V_MPEG4/ISO/AP": 
            case "V_MPEG4/ISO/AVC": 
            case "V_MPEGH/ISO/HEVC": 
            case "V_MS/VFW/FOURCC": 
            case "V_THEORA": 
            case "A_OPUS": 
            case "A_VORBIS": 
            case "A_AAC": 
            case "A_MPEG/L2": 
            case "A_MPEG/L3": 
            case "A_AC3": 
            case "A_EAC3": 
            case "A_TRUEHD": 
            case "A_DTS": 
            case "A_DTS/EXPRESS": 
            case "A_DTS/LOSSLESS": 
            case "A_FLAC": 
            case "A_MS/ACM": 
            case "A_PCM/INT/LIT": 
            case "A_PCM/INT/BIG": 
            case "A_PCM/FLOAT/IEEE": 
            case "S_TEXT/UTF8": 
            case "S_TEXT/ASS": 
            case "S_TEXT/WEBVTT": 
            case "S_VOBSUB": 
            case "S_HDMV/PGS": 
            case "S_DVBSUB": {
                return true;
            }
        }
        return false;
    }

    private static int[] ensureArrayCapacity(@Nullable int[] array, int length) {
        if (array == null) {
            return new int[length];
        }
        if (array.length >= length) {
            return array;
        }
        return new int[Math.max(array.length * 2, length)];
    }

    @EnsuresNonNull(value={"extractorOutput"})
    private void assertInitialized() {
        Assertions.checkStateNotNull((Object)this.extractorOutput);
    }

    static {
        HashMap<String, Integer> trackNameToRotationDegrees = new HashMap<String, Integer>();
        trackNameToRotationDegrees.put("htc_video_rotA-000", 0);
        trackNameToRotationDegrees.put("htc_video_rotA-090", 90);
        trackNameToRotationDegrees.put("htc_video_rotA-180", 180);
        trackNameToRotationDegrees.put("htc_video_rotA-270", 270);
        TRACK_NAME_TO_ROTATION_DEGREES = Collections.unmodifiableMap(trackNameToRotationDegrees);
    }

    protected static final class Track {
        private static final int DISPLAY_UNIT_PIXELS = 0;
        private static final int MAX_CHROMATICITY = 50000;
        private static final int DEFAULT_MAX_CLL = 1000;
        private static final int DEFAULT_MAX_FALL = 200;
        public @MonotonicNonNull String name;
        public @MonotonicNonNull String codecId;
        public int number;
        public int type;
        public int defaultSampleDurationNs;
        public int maxBlockAdditionId;
        private int blockAddIdType;
        public boolean hasContentEncryption;
        public byte @MonotonicNonNull [] sampleStrippedBytes;
        public @MonotonicNonNull TrackOutput.CryptoData cryptoData;
        public byte @MonotonicNonNull [] codecPrivate;
        public @MonotonicNonNull DrmInitData drmInitData;
        public int width = -1;
        public int height = -1;
        public int displayWidth = -1;
        public int displayHeight = -1;
        public int displayUnit = 0;
        public int projectionType = -1;
        public float projectionPoseYaw = 0.0f;
        public float projectionPosePitch = 0.0f;
        public float projectionPoseRoll = 0.0f;
        public byte @MonotonicNonNull [] projectionData = null;
        public int stereoMode = -1;
        public boolean hasColorInfo = false;
        public int colorSpace = -1;
        public int colorTransfer = -1;
        public int colorRange = -1;
        public int maxContentLuminance = 1000;
        public int maxFrameAverageLuminance = 200;
        public float primaryRChromaticityX = -1.0f;
        public float primaryRChromaticityY = -1.0f;
        public float primaryGChromaticityX = -1.0f;
        public float primaryGChromaticityY = -1.0f;
        public float primaryBChromaticityX = -1.0f;
        public float primaryBChromaticityY = -1.0f;
        public float whitePointChromaticityX = -1.0f;
        public float whitePointChromaticityY = -1.0f;
        public float maxMasteringLuminance = -1.0f;
        public float minMasteringLuminance = -1.0f;
        public byte @MonotonicNonNull [] dolbyVisionConfigBytes;
        public int channelCount = 1;
        public int audioBitDepth = -1;
        public int sampleRate = 8000;
        public long codecDelayNs = 0L;
        public long seekPreRollNs = 0L;
        public @MonotonicNonNull TrueHdSampleRechunker trueHdSampleRechunker;
        public boolean flagForced;
        public boolean flagDefault = true;
        private String language = "eng";
        public @MonotonicNonNull TrackOutput output;
        public int nalUnitLengthFieldLength;

        protected Track() {
        }

        @RequiresNonNull(value={"codecId"})
        @EnsuresNonNull(value={"this.output"})
        public void initializeOutput(ExtractorOutput output, int trackId) throws ParserException {
            int type;
            DolbyVisionConfig dolbyVisionConfig;
            String mimeType;
            int maxInputSize = -1;
            int pcmEncoding = -1;
            Object initializationData = null;
            String codecs = null;
            switch (this.codecId) {
                case "V_VP8": {
                    mimeType = "video/x-vnd.on2.vp8";
                    break;
                }
                case "V_VP9": {
                    mimeType = "video/x-vnd.on2.vp9";
                    break;
                }
                case "V_AV1": {
                    mimeType = "video/av01";
                    break;
                }
                case "V_MPEG2": {
                    mimeType = "video/mpeg2";
                    break;
                }
                case "V_MPEG4/ISO/SP": 
                case "V_MPEG4/ISO/ASP": 
                case "V_MPEG4/ISO/AP": {
                    mimeType = "video/mp4v-es";
                    initializationData = this.codecPrivate == null ? null : Collections.singletonList(this.codecPrivate);
                    break;
                }
                case "V_MPEG4/ISO/AVC": {
                    mimeType = "video/avc";
                    AvcConfig avcConfig = AvcConfig.parse(new ParsableByteArray(this.getCodecPrivate(this.codecId)));
                    initializationData = avcConfig.initializationData;
                    this.nalUnitLengthFieldLength = avcConfig.nalUnitLengthFieldLength;
                    codecs = avcConfig.codecs;
                    break;
                }
                case "V_MPEGH/ISO/HEVC": {
                    mimeType = "video/hevc";
                    HevcConfig hevcConfig = HevcConfig.parse(new ParsableByteArray(this.getCodecPrivate(this.codecId)));
                    initializationData = hevcConfig.initializationData;
                    this.nalUnitLengthFieldLength = hevcConfig.nalUnitLengthFieldLength;
                    codecs = hevcConfig.codecs;
                    break;
                }
                case "V_MS/VFW/FOURCC": {
                    Pair<String, List<byte[]>> pair = Track.parseFourCcPrivate(new ParsableByteArray(this.getCodecPrivate(this.codecId)));
                    mimeType = (String)pair.first;
                    initializationData = (List)pair.second;
                    break;
                }
                case "V_THEORA": {
                    mimeType = "video/x-unknown";
                    break;
                }
                case "A_VORBIS": {
                    mimeType = "audio/vorbis";
                    maxInputSize = 8192;
                    initializationData = Track.parseVorbisCodecPrivate(this.getCodecPrivate(this.codecId));
                    break;
                }
                case "A_OPUS": {
                    mimeType = "audio/opus";
                    maxInputSize = 5760;
                    initializationData = new ArrayList(3);
                    initializationData.add(this.getCodecPrivate(this.codecId));
                    initializationData.add(ByteBuffer.allocate(8).order(ByteOrder.LITTLE_ENDIAN).putLong(this.codecDelayNs).array());
                    initializationData.add(ByteBuffer.allocate(8).order(ByteOrder.LITTLE_ENDIAN).putLong(this.seekPreRollNs).array());
                    break;
                }
                case "A_AAC": {
                    mimeType = "audio/mp4a-latm";
                    initializationData = Collections.singletonList(this.getCodecPrivate(this.codecId));
                    AacUtil.Config aacConfig = AacUtil.parseAudioSpecificConfig(this.codecPrivate);
                    this.sampleRate = aacConfig.sampleRateHz;
                    this.channelCount = aacConfig.channelCount;
                    codecs = aacConfig.codecs;
                    break;
                }
                case "A_MPEG/L2": {
                    mimeType = "audio/mpeg-L2";
                    maxInputSize = 4096;
                    break;
                }
                case "A_MPEG/L3": {
                    mimeType = "audio/mpeg";
                    maxInputSize = 4096;
                    break;
                }
                case "A_AC3": {
                    mimeType = "audio/ac3";
                    break;
                }
                case "A_EAC3": {
                    mimeType = "audio/eac3";
                    break;
                }
                case "A_TRUEHD": {
                    mimeType = "audio/true-hd";
                    this.trueHdSampleRechunker = new TrueHdSampleRechunker();
                    break;
                }
                case "A_DTS": 
                case "A_DTS/EXPRESS": {
                    mimeType = "audio/vnd.dts";
                    break;
                }
                case "A_DTS/LOSSLESS": {
                    mimeType = "audio/vnd.dts.hd";
                    break;
                }
                case "A_FLAC": {
                    mimeType = "audio/flac";
                    initializationData = Collections.singletonList(this.getCodecPrivate(this.codecId));
                    break;
                }
                case "A_MS/ACM": {
                    mimeType = "audio/raw";
                    if (Track.parseMsAcmCodecPrivate(new ParsableByteArray(this.getCodecPrivate(this.codecId)))) {
                        pcmEncoding = Util.getPcmEncoding((int)this.audioBitDepth);
                        if (pcmEncoding != 0) break;
                        pcmEncoding = -1;
                        mimeType = "audio/x-unknown";
                        Log.w((String)MatroskaExtractor.TAG, (String)("Unsupported PCM bit depth: " + this.audioBitDepth + ". Setting mimeType to " + mimeType));
                        break;
                    }
                    mimeType = "audio/x-unknown";
                    Log.w((String)MatroskaExtractor.TAG, (String)("Non-PCM MS/ACM is unsupported. Setting mimeType to " + mimeType));
                    break;
                }
                case "A_PCM/INT/LIT": {
                    mimeType = "audio/raw";
                    pcmEncoding = Util.getPcmEncoding((int)this.audioBitDepth);
                    if (pcmEncoding != 0) break;
                    pcmEncoding = -1;
                    mimeType = "audio/x-unknown";
                    Log.w((String)MatroskaExtractor.TAG, (String)("Unsupported little endian PCM bit depth: " + this.audioBitDepth + ". Setting mimeType to " + mimeType));
                    break;
                }
                case "A_PCM/INT/BIG": {
                    mimeType = "audio/raw";
                    if (this.audioBitDepth == 8) {
                        pcmEncoding = 3;
                        break;
                    }
                    if (this.audioBitDepth == 16) {
                        pcmEncoding = 0x10000000;
                        break;
                    }
                    pcmEncoding = -1;
                    mimeType = "audio/x-unknown";
                    Log.w((String)MatroskaExtractor.TAG, (String)("Unsupported big endian PCM bit depth: " + this.audioBitDepth + ". Setting mimeType to " + mimeType));
                    break;
                }
                case "A_PCM/FLOAT/IEEE": {
                    mimeType = "audio/raw";
                    if (this.audioBitDepth == 32) {
                        pcmEncoding = 4;
                        break;
                    }
                    pcmEncoding = -1;
                    mimeType = "audio/x-unknown";
                    Log.w((String)MatroskaExtractor.TAG, (String)("Unsupported floating point PCM bit depth: " + this.audioBitDepth + ". Setting mimeType to " + mimeType));
                    break;
                }
                case "S_TEXT/UTF8": {
                    mimeType = "application/x-subrip";
                    break;
                }
                case "S_TEXT/ASS": {
                    mimeType = "text/x-ssa";
                    initializationData = ImmutableList.of((Object)SSA_DIALOGUE_FORMAT, (Object)this.getCodecPrivate(this.codecId));
                    break;
                }
                case "S_TEXT/WEBVTT": {
                    mimeType = "text/vtt";
                    break;
                }
                case "S_VOBSUB": {
                    mimeType = "application/vobsub";
                    initializationData = ImmutableList.of((Object)this.getCodecPrivate(this.codecId));
                    break;
                }
                case "S_HDMV/PGS": {
                    mimeType = "application/pgs";
                    break;
                }
                case "S_DVBSUB": {
                    mimeType = "application/dvbsubs";
                    byte[] initializationDataBytes = new byte[4];
                    System.arraycopy(this.getCodecPrivate(this.codecId), 0, initializationDataBytes, 0, 4);
                    initializationData = ImmutableList.of((Object)initializationDataBytes);
                    break;
                }
                default: {
                    throw ParserException.createForMalformedContainer((String)"Unrecognized codec identifier.", null);
                }
            }
            if (this.dolbyVisionConfigBytes != null && (dolbyVisionConfig = DolbyVisionConfig.parse(new ParsableByteArray(this.dolbyVisionConfigBytes))) != null) {
                codecs = dolbyVisionConfig.codecs;
                mimeType = "video/dolby-vision";
            }
            int selectionFlags = 0;
            selectionFlags |= this.flagDefault ? 1 : 0;
            selectionFlags |= this.flagForced ? 2 : 0;
            Format.Builder formatBuilder = new Format.Builder();
            if (MimeTypes.isAudio((String)mimeType)) {
                type = 1;
                formatBuilder.setChannelCount(this.channelCount).setSampleRate(this.sampleRate).setPcmEncoding(pcmEncoding);
            } else if (MimeTypes.isVideo((String)mimeType)) {
                type = 2;
                if (this.displayUnit == 0) {
                    this.displayWidth = this.displayWidth == -1 ? this.width : this.displayWidth;
                    this.displayHeight = this.displayHeight == -1 ? this.height : this.displayHeight;
                }
                float pixelWidthHeightRatio = -1.0f;
                if (this.displayWidth != -1 && this.displayHeight != -1) {
                    pixelWidthHeightRatio = (float)(this.height * this.displayWidth) / (float)(this.width * this.displayHeight);
                }
                ColorInfo colorInfo = null;
                if (this.hasColorInfo) {
                    byte[] hdrStaticInfo = this.getHdrStaticInfo();
                    colorInfo = new ColorInfo(this.colorSpace, this.colorRange, this.colorTransfer, hdrStaticInfo);
                }
                int rotationDegrees = -1;
                if (this.name != null && TRACK_NAME_TO_ROTATION_DEGREES.containsKey(this.name)) {
                    rotationDegrees = (Integer)TRACK_NAME_TO_ROTATION_DEGREES.get(this.name);
                }
                if (this.projectionType == 0 && Float.compare(this.projectionPoseYaw, 0.0f) == 0 && Float.compare(this.projectionPosePitch, 0.0f) == 0) {
                    if (Float.compare(this.projectionPoseRoll, 0.0f) == 0) {
                        rotationDegrees = 0;
                    } else if (Float.compare(this.projectionPosePitch, 90.0f) == 0) {
                        rotationDegrees = 90;
                    } else if (Float.compare(this.projectionPosePitch, -180.0f) == 0 || Float.compare(this.projectionPosePitch, 180.0f) == 0) {
                        rotationDegrees = 180;
                    } else if (Float.compare(this.projectionPosePitch, -90.0f) == 0) {
                        rotationDegrees = 270;
                    }
                }
                formatBuilder.setWidth(this.width).setHeight(this.height).setPixelWidthHeightRatio(pixelWidthHeightRatio).setRotationDegrees(rotationDegrees).setProjectionData(this.projectionData).setStereoMode(this.stereoMode).setColorInfo(colorInfo);
            } else if ("application/x-subrip".equals(mimeType) || "text/x-ssa".equals(mimeType) || "text/vtt".equals(mimeType) || "application/vobsub".equals(mimeType) || "application/pgs".equals(mimeType) || "application/dvbsubs".equals(mimeType)) {
                type = 3;
            } else {
                throw ParserException.createForMalformedContainer((String)"Unexpected MIME type.", null);
            }
            if (this.name != null && !TRACK_NAME_TO_ROTATION_DEGREES.containsKey(this.name)) {
                formatBuilder.setLabel(this.name);
            }
            Format format = formatBuilder.setId(trackId).setSampleMimeType(mimeType).setMaxInputSize(maxInputSize).setLanguage(this.language).setSelectionFlags(selectionFlags).setInitializationData((List)initializationData).setCodecs(codecs).setDrmInitData(this.drmInitData).build();
            this.output = output.track(this.number, type);
            this.output.format(format);
        }

        @RequiresNonNull(value={"output"})
        public void outputPendingSampleMetadata() {
            if (this.trueHdSampleRechunker != null) {
                this.trueHdSampleRechunker.outputPendingSampleMetadata(this.output, this.cryptoData);
            }
        }

        public void reset() {
            if (this.trueHdSampleRechunker != null) {
                this.trueHdSampleRechunker.reset();
            }
        }

        private boolean samplesHaveSupplementalData(boolean isBlockGroup) {
            if (MatroskaExtractor.CODEC_ID_OPUS.equals(this.codecId)) {
                return isBlockGroup;
            }
            return this.maxBlockAdditionId > 0;
        }

        @Nullable
        private byte[] getHdrStaticInfo() {
            if (this.primaryRChromaticityX == -1.0f || this.primaryRChromaticityY == -1.0f || this.primaryGChromaticityX == -1.0f || this.primaryGChromaticityY == -1.0f || this.primaryBChromaticityX == -1.0f || this.primaryBChromaticityY == -1.0f || this.whitePointChromaticityX == -1.0f || this.whitePointChromaticityY == -1.0f || this.maxMasteringLuminance == -1.0f || this.minMasteringLuminance == -1.0f) {
                return null;
            }
            byte[] hdrStaticInfoData = new byte[25];
            ByteBuffer hdrStaticInfo = ByteBuffer.wrap(hdrStaticInfoData).order(ByteOrder.LITTLE_ENDIAN);
            hdrStaticInfo.put((byte)0);
            hdrStaticInfo.putShort((short)(this.primaryRChromaticityX * 50000.0f + 0.5f));
            hdrStaticInfo.putShort((short)(this.primaryRChromaticityY * 50000.0f + 0.5f));
            hdrStaticInfo.putShort((short)(this.primaryGChromaticityX * 50000.0f + 0.5f));
            hdrStaticInfo.putShort((short)(this.primaryGChromaticityY * 50000.0f + 0.5f));
            hdrStaticInfo.putShort((short)(this.primaryBChromaticityX * 50000.0f + 0.5f));
            hdrStaticInfo.putShort((short)(this.primaryBChromaticityY * 50000.0f + 0.5f));
            hdrStaticInfo.putShort((short)(this.whitePointChromaticityX * 50000.0f + 0.5f));
            hdrStaticInfo.putShort((short)(this.whitePointChromaticityY * 50000.0f + 0.5f));
            hdrStaticInfo.putShort((short)(this.maxMasteringLuminance + 0.5f));
            hdrStaticInfo.putShort((short)(this.minMasteringLuminance + 0.5f));
            hdrStaticInfo.putShort((short)this.maxContentLuminance);
            hdrStaticInfo.putShort((short)this.maxFrameAverageLuminance);
            return hdrStaticInfoData;
        }

        private static Pair<String, @NullableType List<byte[]>> parseFourCcPrivate(ParsableByteArray buffer) throws ParserException {
            try {
                buffer.skipBytes(16);
                long compression = buffer.readLittleEndianUnsignedInt();
                if (compression == 1482049860L) {
                    return new Pair((Object)"video/divx", null);
                }
                if (compression == 859189832L) {
                    return new Pair((Object)"video/3gpp", null);
                }
                if (compression == 826496599L) {
                    int startOffset = buffer.getPosition() + 20;
                    byte[] bufferData = buffer.getData();
                    for (int offset = startOffset; offset < bufferData.length - 4; ++offset) {
                        if (bufferData[offset] != 0 || bufferData[offset + 1] != 0 || bufferData[offset + 2] != 1 || bufferData[offset + 3] != 15) continue;
                        byte[] initializationData = Arrays.copyOfRange(bufferData, offset, bufferData.length);
                        return new Pair((Object)"video/wvc1", Collections.singletonList(initializationData));
                    }
                    throw ParserException.createForMalformedContainer((String)"Failed to find FourCC VC1 initialization data", null);
                }
            }
            catch (ArrayIndexOutOfBoundsException e) {
                throw ParserException.createForMalformedContainer((String)"Error parsing FourCC private data", null);
            }
            Log.w((String)MatroskaExtractor.TAG, (String)"Unknown FourCC. Setting mimeType to video/x-unknown");
            return new Pair((Object)"video/x-unknown", null);
        }

        private static List<byte[]> parseVorbisCodecPrivate(byte[] codecPrivate) throws ParserException {
            try {
                if (codecPrivate[0] != 2) {
                    throw ParserException.createForMalformedContainer((String)"Error parsing vorbis codec private", null);
                }
                int offset = 1;
                int vorbisInfoLength = 0;
                while ((codecPrivate[offset] & 0xFF) == 255) {
                    vorbisInfoLength += 255;
                    ++offset;
                }
                vorbisInfoLength += codecPrivate[offset++] & 0xFF;
                int vorbisSkipLength = 0;
                while ((codecPrivate[offset] & 0xFF) == 255) {
                    vorbisSkipLength += 255;
                    ++offset;
                }
                vorbisSkipLength += codecPrivate[offset++] & 0xFF;
                if (codecPrivate[offset] != 1) {
                    throw ParserException.createForMalformedContainer((String)"Error parsing vorbis codec private", null);
                }
                byte[] vorbisInfo = new byte[vorbisInfoLength];
                System.arraycopy(codecPrivate, offset, vorbisInfo, 0, vorbisInfoLength);
                if (codecPrivate[offset += vorbisInfoLength] != 3) {
                    throw ParserException.createForMalformedContainer((String)"Error parsing vorbis codec private", null);
                }
                if (codecPrivate[offset += vorbisSkipLength] != 5) {
                    throw ParserException.createForMalformedContainer((String)"Error parsing vorbis codec private", null);
                }
                byte[] vorbisBooks = new byte[codecPrivate.length - offset];
                System.arraycopy(codecPrivate, offset, vorbisBooks, 0, codecPrivate.length - offset);
                ArrayList<byte[]> initializationData = new ArrayList<byte[]>(2);
                initializationData.add(vorbisInfo);
                initializationData.add(vorbisBooks);
                return initializationData;
            }
            catch (ArrayIndexOutOfBoundsException e) {
                throw ParserException.createForMalformedContainer((String)"Error parsing vorbis codec private", null);
            }
        }

        private static boolean parseMsAcmCodecPrivate(ParsableByteArray buffer) throws ParserException {
            try {
                int formatTag = buffer.readLittleEndianUnsignedShort();
                if (formatTag == 1) {
                    return true;
                }
                if (formatTag == 65534) {
                    buffer.setPosition(24);
                    return buffer.readLong() == WAVE_SUBFORMAT_PCM.getMostSignificantBits() && buffer.readLong() == WAVE_SUBFORMAT_PCM.getLeastSignificantBits();
                }
                return false;
            }
            catch (ArrayIndexOutOfBoundsException e) {
                throw ParserException.createForMalformedContainer((String)"Error parsing MS/ACM codec private", null);
            }
        }

        @EnsuresNonNull(value={"output"})
        private void assertOutputInitialized() {
            Assertions.checkNotNull((Object)this.output);
        }

        @EnsuresNonNull(value={"codecPrivate"})
        private byte[] getCodecPrivate(String codecId) throws ParserException {
            if (this.codecPrivate == null) {
                throw ParserException.createForMalformedContainer((String)("Missing CodecPrivate for codec " + codecId), null);
            }
            return this.codecPrivate;
        }
    }

    private final class InnerEbmlProcessor
    implements EbmlProcessor {
        private InnerEbmlProcessor() {
        }

        @Override
        public int getElementType(int id) {
            return MatroskaExtractor.this.getElementType(id);
        }

        @Override
        public boolean isLevel1Element(int id) {
            return MatroskaExtractor.this.isLevel1Element(id);
        }

        @Override
        public void startMasterElement(int id, long contentPosition, long contentSize) throws ParserException {
            MatroskaExtractor.this.startMasterElement(id, contentPosition, contentSize);
        }

        @Override
        public void endMasterElement(int id) throws ParserException {
            MatroskaExtractor.this.endMasterElement(id);
        }

        @Override
        public void integerElement(int id, long value) throws ParserException {
            MatroskaExtractor.this.integerElement(id, value);
        }

        @Override
        public void floatElement(int id, double value) throws ParserException {
            MatroskaExtractor.this.floatElement(id, value);
        }

        @Override
        public void stringElement(int id, String value) throws ParserException {
            MatroskaExtractor.this.stringElement(id, value);
        }

        @Override
        public void binaryElement(int id, int contentsSize, ExtractorInput input) throws IOException {
            MatroskaExtractor.this.binaryElement(id, contentsSize, input);
        }
    }

    @Documented
    @Retention(value=RetentionPolicy.SOURCE)
    @Target(value={ElementType.TYPE_USE})
    public static @interface Flags {
    }
}

