/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.extractor.ogg;

import com.google.android.exoplayer2.Format;
import com.google.android.exoplayer2.ParserException;
import com.google.android.exoplayer2.audio.OpusUtil;
import com.google.android.exoplayer2.extractor.VorbisUtil;
import com.google.android.exoplayer2.extractor.ogg.StreamReader;
import com.google.android.exoplayer2.metadata.Metadata;
import com.google.android.exoplayer2.util.Assertions;
import com.google.android.exoplayer2.util.ParsableByteArray;
import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.List;
import org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;

@Deprecated
final class OpusReader
extends StreamReader {
    private static final byte[] OPUS_ID_HEADER_SIGNATURE = new byte[]{79, 112, 117, 115, 72, 101, 97, 100};
    private static final byte[] OPUS_COMMENT_HEADER_SIGNATURE = new byte[]{79, 112, 117, 115, 84, 97, 103, 115};
    private boolean firstCommentHeaderSeen;

    OpusReader() {
    }

    public static boolean verifyBitstreamType(ParsableByteArray data) {
        return OpusReader.peekPacketStartsWith(data, OPUS_ID_HEADER_SIGNATURE);
    }

    @Override
    protected void reset(boolean headerData) {
        super.reset(headerData);
        if (headerData) {
            this.firstCommentHeaderSeen = false;
        }
    }

    @Override
    protected long preparePayload(ParsableByteArray packet) {
        return this.convertTimeToGranule(OpusUtil.getPacketDurationUs(packet.getData()));
    }

    @Override
    @EnsuresNonNullIf(expression={"#3.format"}, result=false)
    protected boolean readHeaders(ParsableByteArray packet, long position, StreamReader.SetupData setupData) throws ParserException {
        if (OpusReader.peekPacketStartsWith(packet, OPUS_ID_HEADER_SIGNATURE)) {
            byte[] headerBytes = Arrays.copyOf(packet.getData(), packet.limit());
            int channelCount = OpusUtil.getChannelCount(headerBytes);
            List<byte[]> initializationData = OpusUtil.buildInitializationData(headerBytes);
            if (setupData.format != null) {
                return true;
            }
            setupData.format = new Format.Builder().setSampleMimeType("audio/opus").setChannelCount(channelCount).setSampleRate(48000).setInitializationData(initializationData).build();
            return true;
        }
        if (OpusReader.peekPacketStartsWith(packet, OPUS_COMMENT_HEADER_SIGNATURE)) {
            Assertions.checkStateNotNull((Object)setupData.format);
            if (this.firstCommentHeaderSeen) {
                return true;
            }
            this.firstCommentHeaderSeen = true;
            packet.skipBytes(OPUS_COMMENT_HEADER_SIGNATURE.length);
            VorbisUtil.CommentHeader commentHeader = VorbisUtil.readVorbisCommentHeader(packet, false, false);
            Metadata vorbisMetadata = VorbisUtil.parseVorbisComments((List<String>)ImmutableList.copyOf((Object[])commentHeader.comments));
            if (vorbisMetadata == null) {
                return true;
            }
            setupData.format = setupData.format.buildUpon().setMetadata(vorbisMetadata.copyWithAppendedEntriesFrom(setupData.format.metadata)).build();
            return true;
        }
        Assertions.checkStateNotNull((Object)setupData.format);
        return false;
    }

    private static boolean peekPacketStartsWith(ParsableByteArray packet, byte[] expectedPrefix) {
        if (packet.bytesLeft() < expectedPrefix.length) {
            return false;
        }
        int startPosition = packet.getPosition();
        byte[] header = new byte[expectedPrefix.length];
        packet.readBytes(header, 0, expectedPrefix.length);
        packet.setPosition(startPosition);
        return Arrays.equals(header, expectedPrefix);
    }
}

