/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast;

import android.os.Bundle;
import android.text.TextUtils;
import com.google.android.gms.common.images.WebImage;
import com.google.android.gms.internal.gt;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.json.JSONException;
import org.json.JSONObject;

public class MediaMetadata {
    public static final int MEDIA_TYPE_GENERIC = 0;
    public static final int MEDIA_TYPE_MOVIE = 1;
    public static final int MEDIA_TYPE_TV_SHOW = 2;
    public static final int MEDIA_TYPE_MUSIC_TRACK = 3;
    public static final int MEDIA_TYPE_PHOTO = 4;
    public static final int MEDIA_TYPE_USER = 100;
    private static final String[] Az = new String[]{null, "String", "int", "double", "ISO-8601 date String"};
    private static final a AA = new a().a("com.google.android.gms.cast.metadata.CREATION_DATE", "creationDateTime", 4).a("com.google.android.gms.cast.metadata.RELEASE_DATE", "releaseDate", 4).a("com.google.android.gms.cast.metadata.BROADCAST_DATE", "originalAirdate", 4).a("com.google.android.gms.cast.metadata.TITLE", "title", 1).a("com.google.android.gms.cast.metadata.SUBTITLE", "subtitle", 1).a("com.google.android.gms.cast.metadata.ARTIST", "artist", 1).a("com.google.android.gms.cast.metadata.ALBUM_ARTIST", "albumArtist", 1).a("com.google.android.gms.cast.metadata.ALBUM_TITLE", "albumName", 1).a("com.google.android.gms.cast.metadata.COMPOSER", "composer", 1).a("com.google.android.gms.cast.metadata.DISC_NUMBER", "discNumber", 2).a("com.google.android.gms.cast.metadata.TRACK_NUMBER", "trackNumber", 2).a("com.google.android.gms.cast.metadata.SEASON_NUMBER", "season", 2).a("com.google.android.gms.cast.metadata.EPISODE_NUMBER", "episode", 2).a("com.google.android.gms.cast.metadata.SERIES_TITLE", "seriesTitle", 1).a("com.google.android.gms.cast.metadata.STUDIO", "studio", 1).a("com.google.android.gms.cast.metadata.WIDTH", "width", 2).a("com.google.android.gms.cast.metadata.HEIGHT", "height", 2).a("com.google.android.gms.cast.metadata.LOCATION_NAME", "location", 1).a("com.google.android.gms.cast.metadata.LOCATION_LATITUDE", "latitude", 3).a("com.google.android.gms.cast.metadata.LOCATION_LONGITUDE", "longitude", 3);
    private final List<WebImage> zN = new ArrayList<WebImage>();
    private final Bundle AB = new Bundle();
    private int AC;
    public static final String KEY_CREATION_DATE = "com.google.android.gms.cast.metadata.CREATION_DATE";
    public static final String KEY_RELEASE_DATE = "com.google.android.gms.cast.metadata.RELEASE_DATE";
    public static final String KEY_BROADCAST_DATE = "com.google.android.gms.cast.metadata.BROADCAST_DATE";
    public static final String KEY_TITLE = "com.google.android.gms.cast.metadata.TITLE";
    public static final String KEY_SUBTITLE = "com.google.android.gms.cast.metadata.SUBTITLE";
    public static final String KEY_ARTIST = "com.google.android.gms.cast.metadata.ARTIST";
    public static final String KEY_ALBUM_ARTIST = "com.google.android.gms.cast.metadata.ALBUM_ARTIST";
    public static final String KEY_ALBUM_TITLE = "com.google.android.gms.cast.metadata.ALBUM_TITLE";
    public static final String KEY_COMPOSER = "com.google.android.gms.cast.metadata.COMPOSER";
    public static final String KEY_DISC_NUMBER = "com.google.android.gms.cast.metadata.DISC_NUMBER";
    public static final String KEY_TRACK_NUMBER = "com.google.android.gms.cast.metadata.TRACK_NUMBER";
    public static final String KEY_SEASON_NUMBER = "com.google.android.gms.cast.metadata.SEASON_NUMBER";
    public static final String KEY_EPISODE_NUMBER = "com.google.android.gms.cast.metadata.EPISODE_NUMBER";
    public static final String KEY_SERIES_TITLE = "com.google.android.gms.cast.metadata.SERIES_TITLE";
    public static final String KEY_STUDIO = "com.google.android.gms.cast.metadata.STUDIO";
    public static final String KEY_WIDTH = "com.google.android.gms.cast.metadata.WIDTH";
    public static final String KEY_HEIGHT = "com.google.android.gms.cast.metadata.HEIGHT";
    public static final String KEY_LOCATION_NAME = "com.google.android.gms.cast.metadata.LOCATION_NAME";
    public static final String KEY_LOCATION_LATITUDE = "com.google.android.gms.cast.metadata.LOCATION_LATITUDE";
    public static final String KEY_LOCATION_LONGITUDE = "com.google.android.gms.cast.metadata.LOCATION_LONGITUDE";

    public MediaMetadata() {
        this(0);
    }

    public MediaMetadata(int mediaType) {
        this.AC = mediaType;
    }

    public int getMediaType() {
        return this.AC;
    }

    public void clear() {
        this.AB.clear();
        this.zN.clear();
    }

    public boolean containsKey(String key) {
        return this.AB.containsKey(key);
    }

    public Set<String> keySet() {
        return this.AB.keySet();
    }

    public void putString(String key, String value) {
        this.d(key, 1);
        this.AB.putString(key, value);
    }

    public String getString(String key) {
        this.d(key, 1);
        return this.AB.getString(key);
    }

    public void putInt(String key, int value) {
        this.d(key, 2);
        this.AB.putInt(key, value);
    }

    public int getInt(String key) {
        this.d(key, 2);
        return this.AB.getInt(key);
    }

    public void putDouble(String key, double value) {
        this.d(key, 3);
        this.AB.putDouble(key, value);
    }

    public double getDouble(String key) {
        this.d(key, 3);
        return this.AB.getDouble(key);
    }

    public void putDate(String key, Calendar value) {
        this.d(key, 4);
        this.AB.putString(key, gt.a(value));
    }

    public Calendar getDate(String key) {
        this.d(key, 4);
        String string2 = this.AB.getString(key);
        return string2 != null ? gt.aq(string2) : null;
    }

    public String getDateAsString(String key) {
        this.d(key, 4);
        return this.AB.getString(key);
    }

    private void d(String string2, int n2) throws IllegalArgumentException {
        if (TextUtils.isEmpty((CharSequence)string2)) {
            throw new IllegalArgumentException("null and empty keys are not allowed");
        }
        int n3 = AA.ag(string2);
        if (n3 != n2 && n3 != 0) {
            throw new IllegalArgumentException("Value for " + string2 + " must be a " + Az[n2]);
        }
    }

    public JSONObject dU() {
        JSONObject jSONObject = new JSONObject();
        try {
            jSONObject.put("metadataType", this.AC);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        gt.a(jSONObject, this.zN);
        switch (this.AC) {
            case 0: {
                this.a(jSONObject, KEY_TITLE, KEY_ARTIST, KEY_SUBTITLE, KEY_RELEASE_DATE);
                break;
            }
            case 1: {
                this.a(jSONObject, KEY_TITLE, KEY_STUDIO, KEY_SUBTITLE, KEY_RELEASE_DATE);
                break;
            }
            case 2: {
                this.a(jSONObject, KEY_TITLE, KEY_SERIES_TITLE, KEY_SEASON_NUMBER, KEY_EPISODE_NUMBER, KEY_BROADCAST_DATE);
                break;
            }
            case 3: {
                this.a(jSONObject, KEY_TITLE, KEY_ARTIST, KEY_ALBUM_TITLE, KEY_ALBUM_ARTIST, KEY_COMPOSER, KEY_TRACK_NUMBER, KEY_DISC_NUMBER, KEY_RELEASE_DATE);
                break;
            }
            case 4: {
                this.a(jSONObject, KEY_TITLE, KEY_ARTIST, KEY_LOCATION_NAME, KEY_LOCATION_LATITUDE, KEY_LOCATION_LONGITUDE, KEY_WIDTH, KEY_HEIGHT, KEY_CREATION_DATE);
                break;
            }
            default: {
                this.a(jSONObject, new String[0]);
            }
        }
        return jSONObject;
    }

    public void b(JSONObject jSONObject) {
        this.clear();
        this.AC = 0;
        try {
            this.AC = jSONObject.getInt("metadataType");
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        gt.a(this.zN, jSONObject);
        switch (this.AC) {
            case 0: {
                this.b(jSONObject, KEY_TITLE, KEY_ARTIST, KEY_SUBTITLE, KEY_RELEASE_DATE);
                break;
            }
            case 1: {
                this.b(jSONObject, KEY_TITLE, KEY_STUDIO, KEY_SUBTITLE, KEY_RELEASE_DATE);
                break;
            }
            case 2: {
                this.b(jSONObject, KEY_TITLE, KEY_SERIES_TITLE, KEY_SEASON_NUMBER, KEY_EPISODE_NUMBER, KEY_BROADCAST_DATE);
                break;
            }
            case 3: {
                this.b(jSONObject, KEY_TITLE, KEY_ALBUM_TITLE, KEY_ARTIST, KEY_ALBUM_ARTIST, KEY_COMPOSER, KEY_TRACK_NUMBER, KEY_DISC_NUMBER, KEY_RELEASE_DATE);
                break;
            }
            case 4: {
                this.b(jSONObject, KEY_TITLE, KEY_ARTIST, KEY_LOCATION_NAME, KEY_LOCATION_LATITUDE, KEY_LOCATION_LONGITUDE, KEY_WIDTH, KEY_HEIGHT, KEY_CREATION_DATE);
                break;
            }
            default: {
                this.b(jSONObject, new String[0]);
            }
        }
    }

    private void a(JSONObject jSONObject, String ... stringArray) {
        try {
            block7: for (String string2 : stringArray) {
                if (!this.AB.containsKey(string2)) continue;
                int n2 = AA.ag(string2);
                switch (n2) {
                    case 1: 
                    case 4: {
                        jSONObject.put(AA.ae(string2), (Object)this.AB.getString(string2));
                        continue block7;
                    }
                    case 2: {
                        jSONObject.put(AA.ae(string2), this.AB.getInt(string2));
                        continue block7;
                    }
                    case 3: {
                        jSONObject.put(AA.ae(string2), this.AB.getDouble(string2));
                        continue block7;
                    }
                }
            }
            for (String string3 : this.AB.keySet()) {
                if (string3.startsWith("com.google.")) continue;
                Object object = this.AB.get(string3);
                if (object instanceof String) {
                    jSONObject.put(string3, object);
                    continue;
                }
                if (object instanceof Integer) {
                    jSONObject.put(string3, object);
                    continue;
                }
                if (!(object instanceof Double)) continue;
                jSONObject.put(string3, object);
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
    }

    private void b(JSONObject jSONObject, String ... stringArray) {
        HashSet<String> hashSet = new HashSet<String>(Arrays.asList(stringArray));
        try {
            Iterator iterator = jSONObject.keys();
            block10: while (iterator.hasNext()) {
                Object object;
                String string2 = (String)iterator.next();
                if ("metadataType".equals(string2)) continue;
                String string3 = AA.af(string2);
                if (string3 != null) {
                    if (!hashSet.contains(string3)) continue;
                    try {
                        object = jSONObject.get(string2);
                        if (object == null) continue;
                        switch (AA.ag(string3)) {
                            case 1: {
                                if (!(object instanceof String)) break;
                                this.AB.putString(string3, (String)object);
                                break;
                            }
                            case 4: {
                                if (!(object instanceof String)) break;
                                Calendar calendar = gt.aq((String)object);
                                if (calendar == null) continue block10;
                                this.AB.putString(string3, (String)object);
                                break;
                            }
                            case 2: {
                                if (!(object instanceof Integer)) break;
                                this.AB.putInt(string3, ((Integer)object).intValue());
                                break;
                            }
                            case 3: {
                                if (!(object instanceof Double)) break;
                                this.AB.putDouble(string3, ((Double)object).doubleValue());
                            }
                        }
                    }
                    catch (JSONException jSONException) {}
                    continue;
                }
                object = jSONObject.get(string2);
                if (object instanceof String) {
                    this.AB.putString(string2, (String)object);
                    continue;
                }
                if (object instanceof Integer) {
                    this.AB.putInt(string2, ((Integer)object).intValue());
                    continue;
                }
                if (!(object instanceof Double)) continue;
                this.AB.putDouble(string2, ((Double)object).doubleValue());
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof MediaMetadata)) {
            return false;
        }
        MediaMetadata mediaMetadata = (MediaMetadata)other;
        return this.a(this.AB, mediaMetadata.AB) && this.zN.equals(mediaMetadata.zN);
    }

    public int hashCode() {
        int n2 = 17;
        Set set = this.AB.keySet();
        for (String string2 : set) {
            n2 = 31 * n2 + this.AB.get(string2).hashCode();
        }
        n2 = 31 * n2 + this.zN.hashCode();
        return n2;
    }

    public List<WebImage> getImages() {
        return this.zN;
    }

    public boolean hasImages() {
        return this.zN != null && !this.zN.isEmpty();
    }

    public void clearImages() {
        this.zN.clear();
    }

    public void addImage(WebImage image) {
        this.zN.add(image);
    }

    private boolean a(Bundle bundle, Bundle bundle2) {
        if (bundle.size() != bundle2.size()) {
            return false;
        }
        Set set = bundle.keySet();
        for (String string2 : set) {
            Object object = bundle.get(string2);
            Object object2 = bundle2.get(string2);
            if (object instanceof Bundle && object2 instanceof Bundle && !this.a((Bundle)object, (Bundle)object2)) {
                return false;
            }
            if (!(object == null ? object2 != null || !bundle2.containsKey(string2) : !object.equals(object2))) continue;
            return false;
        }
        return true;
    }

    private static class a {
        private final Map<String, String> AD = new HashMap<String, String>();
        private final Map<String, String> AE = new HashMap<String, String>();
        private final Map<String, Integer> AF = new HashMap<String, Integer>();

        public a a(String string2, String string3, int n2) {
            this.AD.put(string2, string3);
            this.AE.put(string3, string2);
            this.AF.put(string2, n2);
            return this;
        }

        public String ae(String string2) {
            return this.AD.get(string2);
        }

        public String af(String string2) {
            return this.AE.get(string2);
        }

        public int ag(String string2) {
            Integer n2 = this.AF.get(string2);
            return n2 != null ? n2 : 0;
        }
    }
}

