/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.drive.events;

import android.app.IntentService;
import android.content.Context;
import android.content.Intent;
import android.os.Binder;
import android.os.IBinder;
import android.os.Parcel;
import android.util.Log;
import com.google.android.gms.drive.events.ChangeEvent;
import com.google.android.gms.drive.events.DriveEvent;
import com.google.android.gms.drive.events.FileConflictEvent;
import com.google.android.gms.internal.hn;
import java.util.concurrent.LinkedBlockingDeque;

public abstract class DriveEventService
extends IntentService {
    private static final LinkedBlockingDeque<DriveEvent> Ie = new LinkedBlockingDeque();
    private final String mName;

    protected DriveEventService(String name) {
        super(name);
        this.mName = name;
    }

    protected DriveEventService() {
        this("DriveEventService");
    }

    protected final void onHandleIntent(Intent intent) {
        intent.setExtrasClassLoader(this.getClassLoader());
        DriveEvent driveEvent = (DriveEvent)intent.getParcelableExtra("event");
        if (driveEvent == null) {
            driveEvent = Ie.poll();
        }
        if (driveEvent != null) {
            this.a(driveEvent);
        } else {
            Log.e((String)"DriveEventService", (String)"The event queue is unexpectedly empty.");
        }
    }

    private void a(DriveEvent driveEvent) {
        try {
            switch (driveEvent.getType()) {
                case 1: {
                    hn.a(driveEvent instanceof ChangeEvent, "Unexpected event type: %s", driveEvent);
                    this.onChangeEvent((ChangeEvent)driveEvent);
                    break;
                }
                case 2: {
                    hn.a(driveEvent instanceof FileConflictEvent, "Unexpected event type: %s", driveEvent);
                    this.a((FileConflictEvent)driveEvent);
                    break;
                }
                default: {
                    Log.w((String)this.mName, (String)("Unrecognized event: " + driveEvent));
                    break;
                }
            }
        }
        catch (ClassCastException classCastException) {
            Log.wtf((String)this.mName, (String)("Service does not implement listener for type:" + driveEvent.getType()), (Throwable)classCastException);
        }
        catch (Exception exception) {
            Log.w((String)this.mName, (String)("Error handling event: " + driveEvent), (Throwable)exception);
        }
    }

    public void onChangeEvent(ChangeEvent event) {
        Log.w((String)"DriveEventService", (String)("Unhandled ChangeEvent: " + event));
    }

    public void a(FileConflictEvent fileConflictEvent) {
        Log.w((String)"DriveEventService", (String)("Unhandled FileConflictEvent: " + fileConflictEvent));
    }

    public IBinder onBind(Intent intent) {
        return new Binder(){

            protected boolean onTransact(int code, Parcel in2, Parcel out, int flags) {
                Log.d((String)"DriveEventService", (String)"onTransact");
                DriveEvent driveEvent = (DriveEvent)in2.readParcelable(DriveEventService.this.getClassLoader());
                Ie.add(driveEvent);
                DriveEventService.this.startService(new Intent((Context)DriveEventService.this, ((Object)((Object)DriveEventService.this)).getClass()));
                return true;
            }
        };
    }
}

