/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games;

import android.database.CharArrayBuffer;
import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.games.Player;
import com.google.android.gms.games.PlayerEntityCreator;
import com.google.android.gms.games.PlayerLevelInfo;
import com.google.android.gms.games.internal.GamesDowngradeableSafeParcel;
import com.google.android.gms.games.internal.player.MostRecentGameInfo;
import com.google.android.gms.games.internal.player.MostRecentGameInfoEntity;
import com.google.android.gms.internal.gy;
import com.google.android.gms.internal.hl;
import com.google.android.gms.internal.il;

public final class PlayerEntity
extends GamesDowngradeableSafeParcel
implements Player {
    public static final Parcelable.Creator<PlayerEntity> CREATOR = new PlayerEntityCreatorCompat();
    private final int xJ;
    private final String MP;
    private final String Lk;
    private final Uri Mo;
    private final Uri Mp;
    private final long MQ;
    private final int MR;
    private final long MS;
    private final String Mz;
    private final String MA;
    private final String HV;
    private final MostRecentGameInfoEntity MT;
    private final PlayerLevelInfo MU;
    private final boolean MV;

    public PlayerEntity(Player player) {
        this.xJ = 10;
        this.MP = player.getPlayerId();
        this.Lk = player.getDisplayName();
        this.Mo = player.getIconImageUri();
        this.Mz = player.getIconImageUrl();
        this.Mp = player.getHiResImageUri();
        this.MA = player.getHiResImageUrl();
        this.MQ = player.getRetrievedTimestamp();
        this.MR = player.gN();
        this.MS = player.getLastPlayedWithTimestamp();
        this.HV = player.getTitle();
        this.MV = player.gO();
        MostRecentGameInfo mostRecentGameInfo = player.gP();
        this.MT = mostRecentGameInfo == null ? null : new MostRecentGameInfoEntity(mostRecentGameInfo);
        this.MU = player.getLevelInfo();
        gy.c(this.MP);
        gy.c(this.Lk);
        gy.A(this.MQ > 0L);
    }

    PlayerEntity(int versionCode, String playerId, String displayName, Uri iconImageUri, Uri hiResImageUri, long retrievedTimestamp, int isInCircles, long lastPlayedWithTimestamp, String iconImageUrl, String hiResImageUrl, String title, MostRecentGameInfoEntity mostRecentGameInfo, PlayerLevelInfo playerLevelInfo, boolean hasAllPublic) {
        this.xJ = versionCode;
        this.MP = playerId;
        this.Lk = displayName;
        this.Mo = iconImageUri;
        this.Mz = iconImageUrl;
        this.Mp = hiResImageUri;
        this.MA = hiResImageUrl;
        this.MQ = retrievedTimestamp;
        this.MR = isInCircles;
        this.MS = lastPlayedWithTimestamp;
        this.HV = title;
        this.MV = hasAllPublic;
        this.MT = mostRecentGameInfo;
        this.MU = playerLevelInfo;
    }

    public int getVersionCode() {
        return this.xJ;
    }

    @Override
    public String getPlayerId() {
        return this.MP;
    }

    @Override
    public String getDisplayName() {
        return this.Lk;
    }

    @Override
    public void getDisplayName(CharArrayBuffer dataOut) {
        il.b(this.Lk, dataOut);
    }

    @Override
    public boolean hasIconImage() {
        return this.getIconImageUri() != null;
    }

    @Override
    public Uri getIconImageUri() {
        return this.Mo;
    }

    @Override
    public String getIconImageUrl() {
        return this.Mz;
    }

    @Override
    public boolean hasHiResImage() {
        return this.getHiResImageUri() != null;
    }

    @Override
    public Uri getHiResImageUri() {
        return this.Mp;
    }

    @Override
    public String getHiResImageUrl() {
        return this.MA;
    }

    @Override
    public long getRetrievedTimestamp() {
        return this.MQ;
    }

    @Override
    public long getLastPlayedWithTimestamp() {
        return this.MS;
    }

    @Override
    public int gN() {
        return this.MR;
    }

    @Override
    public boolean gO() {
        return this.MV;
    }

    @Override
    public String getTitle() {
        return this.HV;
    }

    @Override
    public void getTitle(CharArrayBuffer dataOut) {
        il.b(this.HV, dataOut);
    }

    @Override
    public PlayerLevelInfo getLevelInfo() {
        return this.MU;
    }

    @Override
    public MostRecentGameInfo gP() {
        return this.MT;
    }

    @Override
    public Player freeze() {
        return this;
    }

    @Override
    public boolean isDataValid() {
        return true;
    }

    public int hashCode() {
        return PlayerEntity.a(this);
    }

    static int a(Player player) {
        return hl.hashCode(player.getPlayerId(), player.getDisplayName(), player.getIconImageUri(), player.getHiResImageUri(), player.getRetrievedTimestamp(), player.getTitle(), player.getLevelInfo());
    }

    public boolean equals(Object obj) {
        return PlayerEntity.a(this, obj);
    }

    static boolean a(Player player, Object object) {
        if (!(object instanceof Player)) {
            return false;
        }
        if (player == object) {
            return true;
        }
        Player player2 = (Player)object;
        return hl.equal(player2.getPlayerId(), player.getPlayerId()) && hl.equal(player2.getDisplayName(), player.getDisplayName()) && hl.equal(player2.getIconImageUri(), player.getIconImageUri()) && hl.equal(player2.getHiResImageUri(), player.getHiResImageUri()) && hl.equal(player2.getRetrievedTimestamp(), player.getRetrievedTimestamp()) && hl.equal(player2.getTitle(), player.getTitle()) && hl.equal(player2.getLevelInfo(), player.getLevelInfo());
    }

    public String toString() {
        return PlayerEntity.b(this);
    }

    static String b(Player player) {
        return hl.e(player).a("PlayerId", player.getPlayerId()).a("DisplayName", player.getDisplayName()).a("IconImageUri", player.getIconImageUri()).a("IconImageUrl", player.getIconImageUrl()).a("HiResImageUri", player.getHiResImageUri()).a("HiResImageUrl", player.getHiResImageUrl()).a("RetrievedTimestamp", player.getRetrievedTimestamp()).a("Title", player.getTitle()).a("LevelInfo", player.getLevelInfo()).toString();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        if (!this.fm()) {
            PlayerEntityCreator.a(this, dest, flags);
        } else {
            dest.writeString(this.MP);
            dest.writeString(this.Lk);
            dest.writeString(this.Mo == null ? null : this.Mo.toString());
            dest.writeString(this.Mp == null ? null : this.Mp.toString());
            dest.writeLong(this.MQ);
        }
    }

    static final class PlayerEntityCreatorCompat
    extends PlayerEntityCreator {
        PlayerEntityCreatorCompat() {
        }

        @Override
        public PlayerEntity be(Parcel parcel) {
            boolean bl2 = PlayerEntity.c(PlayerEntity.fl());
            if (bl2 || PlayerEntity.aA(PlayerEntity.class.getCanonicalName())) {
                return super.be(parcel);
            }
            String string2 = parcel.readString();
            String string3 = parcel.readString();
            String string4 = parcel.readString();
            String string5 = parcel.readString();
            Uri uri = string4 == null ? null : Uri.parse((String)string4);
            Uri uri2 = string5 == null ? null : Uri.parse((String)string5);
            long l2 = parcel.readLong();
            int n2 = -1;
            long l3 = -1L;
            String string6 = null;
            String string7 = null;
            String string8 = null;
            PlayerLevelInfo playerLevelInfo = null;
            MostRecentGameInfoEntity mostRecentGameInfoEntity = null;
            boolean bl3 = true;
            return new PlayerEntity(10, string2, string3, uri, uri2, l2, n2, l3, string6, string7, string8, mostRecentGameInfoEntity, playerLevelInfo, bl3);
        }

        @Override
        public /* synthetic */ Object createFromParcel(Parcel x0) {
            return this.be(x0);
        }
    }
}

