/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.event;

import android.database.CharArrayBuffer;
import android.net.Uri;
import android.os.Parcel;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.games.Player;
import com.google.android.gms.games.PlayerEntity;
import com.google.android.gms.games.event.Event;
import com.google.android.gms.games.event.EventEntityCreator;
import com.google.android.gms.internal.hl;
import com.google.android.gms.internal.il;

public final class EventEntity
implements SafeParcelable,
Event {
    public static final EventEntityCreator CREATOR = new EventEntityCreator();
    private final int xJ;
    private final String Nf;
    private final String mName;
    private final String Mm;
    private final Uri Mo;
    private final String Mz;
    private final PlayerEntity Ng;
    private final long Nh;
    private final String Ni;
    private final boolean Nj;

    public EventEntity(Event event) {
        this.xJ = 1;
        this.Nf = event.getEventId();
        this.mName = event.getName();
        this.Mm = event.getDescription();
        this.Mo = event.getIconImageUri();
        this.Mz = event.getIconImageUrl();
        this.Ng = (PlayerEntity)event.getPlayer().freeze();
        this.Nh = event.getValue();
        this.Ni = event.getFormattedValue();
        this.Nj = event.isVisible();
    }

    EventEntity(int versionCode, String eventId, String name, String description, Uri iconImageUri, String iconImageUrl, Player player, long value, String formattedValue, boolean isVisible) {
        this.xJ = versionCode;
        this.Nf = eventId;
        this.mName = name;
        this.Mm = description;
        this.Mo = iconImageUri;
        this.Mz = iconImageUrl;
        this.Ng = new PlayerEntity(player);
        this.Nh = value;
        this.Ni = formattedValue;
        this.Nj = isVisible;
    }

    public int getVersionCode() {
        return this.xJ;
    }

    @Override
    public String getEventId() {
        return this.Nf;
    }

    @Override
    public String getName() {
        return this.mName;
    }

    @Override
    public void getName(CharArrayBuffer dataOut) {
        il.b(this.mName, dataOut);
    }

    @Override
    public String getDescription() {
        return this.Mm;
    }

    @Override
    public void getDescription(CharArrayBuffer dataOut) {
        il.b(this.Mm, dataOut);
    }

    @Override
    public Uri getIconImageUri() {
        return this.Mo;
    }

    @Override
    public String getIconImageUrl() {
        return this.Mz;
    }

    @Override
    public Player getPlayer() {
        return this.Ng;
    }

    @Override
    public long getValue() {
        return this.Nh;
    }

    @Override
    public String getFormattedValue() {
        return this.Ni;
    }

    @Override
    public void getFormattedValue(CharArrayBuffer dataOut) {
        il.b(this.Ni, dataOut);
    }

    @Override
    public boolean isVisible() {
        return this.Nj;
    }

    @Override
    public Event freeze() {
        return this;
    }

    @Override
    public boolean isDataValid() {
        return true;
    }

    public int hashCode() {
        return EventEntity.a(this);
    }

    static int a(Event event) {
        return hl.hashCode(event.getEventId(), event.getName(), event.getDescription(), event.getIconImageUri(), event.getIconImageUrl(), event.getPlayer(), event.getValue(), event.getFormattedValue(), event.isVisible());
    }

    public boolean equals(Object obj) {
        return EventEntity.a(this, obj);
    }

    static boolean a(Event event, Object object) {
        if (!(object instanceof Event)) {
            return false;
        }
        if (event == object) {
            return true;
        }
        Event event2 = (Event)object;
        return hl.equal(event2.getEventId(), event.getEventId()) && hl.equal(event2.getName(), event.getName()) && hl.equal(event2.getDescription(), event.getDescription()) && hl.equal(event2.getIconImageUri(), event.getIconImageUri()) && hl.equal(event2.getIconImageUrl(), event.getIconImageUrl()) && hl.equal(event2.getPlayer(), event.getPlayer()) && hl.equal(event2.getValue(), event.getValue()) && hl.equal(event2.getFormattedValue(), event.getFormattedValue()) && hl.equal(event2.isVisible(), event.isVisible());
    }

    public String toString() {
        return EventEntity.b(this);
    }

    static String b(Event event) {
        return hl.e(event).a("Id", event.getEventId()).a("Name", event.getName()).a("Description", event.getDescription()).a("IconImageUri", event.getIconImageUri()).a("IconImageUrl", event.getIconImageUrl()).a("Player", event.getPlayer()).a("Value", event.getValue()).a("FormattedValue", event.getFormattedValue()).a("isVisible", event.isVisible()).toString();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel out, int flags) {
        EventEntityCreator.a(this, out, flags);
    }
}

