/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.internal;

import android.net.LocalSocket;
import android.os.Parcel;
import android.os.ParcelFileDescriptor;
import com.google.android.gms.games.multiplayer.realtime.RealTimeSocket;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

final class RealTimeSocketImpl
implements RealTimeSocket {
    private final LocalSocket Pa;
    private final String On;
    private ParcelFileDescriptor Fg;

    RealTimeSocketImpl(LocalSocket localSocket, String participantId) {
        this.Pa = localSocket;
        this.On = participantId;
    }

    @Override
    public ParcelFileDescriptor getParcelFileDescriptor() throws IOException {
        if (this.Fg == null && !this.isClosed()) {
            Parcel parcel = Parcel.obtain();
            parcel.writeFileDescriptor(this.Pa.getFileDescriptor());
            parcel.setDataPosition(0);
            this.Fg = parcel.readFileDescriptor();
        }
        return this.Fg;
    }

    @Override
    public void close() throws IOException {
        this.Pa.close();
    }

    @Override
    public boolean isClosed() {
        return !this.Pa.isConnected() && !this.Pa.isBound();
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return this.Pa.getInputStream();
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        return this.Pa.getOutputStream();
    }
}

