/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.leaderboard;

import android.database.CharArrayBuffer;
import android.net.Uri;
import com.google.android.gms.common.data.DataHolder;
import com.google.android.gms.common.data.d;
import com.google.android.gms.games.Game;
import com.google.android.gms.games.GameRef;
import com.google.android.gms.games.leaderboard.Leaderboard;
import com.google.android.gms.games.leaderboard.LeaderboardEntity;
import com.google.android.gms.games.leaderboard.LeaderboardVariant;
import com.google.android.gms.games.leaderboard.LeaderboardVariantRef;
import java.util.ArrayList;

public final class LeaderboardRef
extends d
implements Leaderboard {
    private final int RD;
    private final Game Sp;

    LeaderboardRef(DataHolder holder, int dataRow, int numChildren) {
        super(holder, dataRow);
        this.RD = numChildren;
        this.Sp = new GameRef(holder, dataRow);
    }

    @Override
    public String getLeaderboardId() {
        return this.getString("external_leaderboard_id");
    }

    @Override
    public String getDisplayName() {
        return this.getString("name");
    }

    @Override
    public void getDisplayName(CharArrayBuffer dataOut) {
        this.a("name", dataOut);
    }

    @Override
    public Uri getIconImageUri() {
        return this.aw("board_icon_image_uri");
    }

    @Override
    public String getIconImageUrl() {
        return this.getString("board_icon_image_url");
    }

    @Override
    public int getScoreOrder() {
        return this.getInteger("score_order");
    }

    @Override
    public ArrayList<LeaderboardVariant> getVariants() {
        ArrayList<LeaderboardVariant> arrayList = new ArrayList<LeaderboardVariant>(this.RD);
        for (int i2 = 0; i2 < this.RD; ++i2) {
            arrayList.add(new LeaderboardVariantRef(this.DD, this.Ez + i2));
        }
        return arrayList;
    }

    @Override
    public Game getGame() {
        return this.Sp;
    }

    public Leaderboard iu() {
        return new LeaderboardEntity(this);
    }

    @Override
    public int hashCode() {
        return LeaderboardEntity.a(this);
    }

    @Override
    public boolean equals(Object obj) {
        return LeaderboardEntity.a(this, obj);
    }

    public String toString() {
        return LeaderboardEntity.b(this);
    }

    @Override
    public /* synthetic */ Object freeze() {
        return this.iu();
    }
}

