/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.leaderboard;

import android.database.CharArrayBuffer;
import android.net.Uri;
import com.google.android.gms.games.Player;
import com.google.android.gms.games.PlayerEntity;
import com.google.android.gms.games.leaderboard.LeaderboardScore;
import com.google.android.gms.internal.hl;
import com.google.android.gms.internal.hn;
import com.google.android.gms.internal.il;

public final class LeaderboardScoreEntity
implements LeaderboardScore {
    private final long Sr;
    private final String Ss;
    private final String St;
    private final long Su;
    private final long Sv;
    private final String Sw;
    private final Uri Sx;
    private final Uri Sy;
    private final PlayerEntity Sz;
    private final String SA;
    private final String SB;
    private final String SC;

    public LeaderboardScoreEntity(LeaderboardScore score) {
        this.Sr = score.getRank();
        this.Ss = hn.f(score.getDisplayRank());
        this.St = hn.f(score.getDisplayScore());
        this.Su = score.getRawScore();
        this.Sv = score.getTimestampMillis();
        this.Sw = score.getScoreHolderDisplayName();
        this.Sx = score.getScoreHolderIconImageUri();
        this.Sy = score.getScoreHolderHiResImageUri();
        Player player = score.getScoreHolder();
        this.Sz = player == null ? null : (PlayerEntity)player.freeze();
        this.SA = score.getScoreTag();
        this.SB = score.getScoreHolderIconImageUrl();
        this.SC = score.getScoreHolderHiResImageUrl();
    }

    @Override
    public long getRank() {
        return this.Sr;
    }

    @Override
    public String getDisplayRank() {
        return this.Ss;
    }

    @Override
    public void getDisplayRank(CharArrayBuffer dataOut) {
        il.b(this.Ss, dataOut);
    }

    @Override
    public String getDisplayScore() {
        return this.St;
    }

    @Override
    public void getDisplayScore(CharArrayBuffer dataOut) {
        il.b(this.St, dataOut);
    }

    @Override
    public long getRawScore() {
        return this.Su;
    }

    @Override
    public long getTimestampMillis() {
        return this.Sv;
    }

    @Override
    public String getScoreHolderDisplayName() {
        if (this.Sz == null) {
            return this.Sw;
        }
        return this.Sz.getDisplayName();
    }

    @Override
    public void getScoreHolderDisplayName(CharArrayBuffer dataOut) {
        if (this.Sz == null) {
            il.b(this.Sw, dataOut);
            return;
        }
        this.Sz.getDisplayName(dataOut);
    }

    @Override
    public Uri getScoreHolderIconImageUri() {
        if (this.Sz == null) {
            return this.Sx;
        }
        return this.Sz.getIconImageUri();
    }

    @Override
    public String getScoreHolderIconImageUrl() {
        if (this.Sz == null) {
            return this.SB;
        }
        return this.Sz.getIconImageUrl();
    }

    @Override
    public Uri getScoreHolderHiResImageUri() {
        if (this.Sz == null) {
            return this.Sy;
        }
        return this.Sz.getHiResImageUri();
    }

    @Override
    public String getScoreHolderHiResImageUrl() {
        if (this.Sz == null) {
            return this.SC;
        }
        return this.Sz.getHiResImageUrl();
    }

    @Override
    public Player getScoreHolder() {
        return this.Sz;
    }

    @Override
    public String getScoreTag() {
        return this.SA;
    }

    public LeaderboardScore ix() {
        return this;
    }

    @Override
    public boolean isDataValid() {
        return true;
    }

    public int hashCode() {
        return LeaderboardScoreEntity.a(this);
    }

    static int a(LeaderboardScore leaderboardScore) {
        return hl.hashCode(leaderboardScore.getRank(), leaderboardScore.getDisplayRank(), leaderboardScore.getRawScore(), leaderboardScore.getDisplayScore(), leaderboardScore.getTimestampMillis(), leaderboardScore.getScoreHolderDisplayName(), leaderboardScore.getScoreHolderIconImageUri(), leaderboardScore.getScoreHolderHiResImageUri(), leaderboardScore.getScoreHolder());
    }

    public boolean equals(Object obj) {
        return LeaderboardScoreEntity.a(this, obj);
    }

    static boolean a(LeaderboardScore leaderboardScore, Object object) {
        if (!(object instanceof LeaderboardScore)) {
            return false;
        }
        if (leaderboardScore == object) {
            return true;
        }
        LeaderboardScore leaderboardScore2 = (LeaderboardScore)object;
        return hl.equal(leaderboardScore2.getRank(), leaderboardScore.getRank()) && hl.equal(leaderboardScore2.getDisplayRank(), leaderboardScore.getDisplayRank()) && hl.equal(leaderboardScore2.getRawScore(), leaderboardScore.getRawScore()) && hl.equal(leaderboardScore2.getDisplayScore(), leaderboardScore.getDisplayScore()) && hl.equal(leaderboardScore2.getTimestampMillis(), leaderboardScore.getTimestampMillis()) && hl.equal(leaderboardScore2.getScoreHolderDisplayName(), leaderboardScore.getScoreHolderDisplayName()) && hl.equal(leaderboardScore2.getScoreHolderIconImageUri(), leaderboardScore.getScoreHolderIconImageUri()) && hl.equal(leaderboardScore2.getScoreHolderHiResImageUri(), leaderboardScore.getScoreHolderHiResImageUri()) && hl.equal(leaderboardScore2.getScoreHolder(), leaderboardScore.getScoreHolder()) && hl.equal(leaderboardScore2.getScoreTag(), leaderboardScore.getScoreTag());
    }

    public String toString() {
        return LeaderboardScoreEntity.b(this);
    }

    static String b(LeaderboardScore leaderboardScore) {
        return hl.e(leaderboardScore).a("Rank", leaderboardScore.getRank()).a("DisplayRank", leaderboardScore.getDisplayRank()).a("Score", leaderboardScore.getRawScore()).a("DisplayScore", leaderboardScore.getDisplayScore()).a("Timestamp", leaderboardScore.getTimestampMillis()).a("DisplayName", leaderboardScore.getScoreHolderDisplayName()).a("IconImageUri", leaderboardScore.getScoreHolderIconImageUri()).a("IconImageUrl", leaderboardScore.getScoreHolderIconImageUrl()).a("HiResImageUri", leaderboardScore.getScoreHolderHiResImageUri()).a("HiResImageUrl", leaderboardScore.getScoreHolderHiResImageUrl()).a("Player", leaderboardScore.getScoreHolder() == null ? null : leaderboardScore.getScoreHolder()).a("ScoreTag", leaderboardScore.getScoreTag()).toString();
    }

    @Override
    public /* synthetic */ Object freeze() {
        return this.ix();
    }
}

