/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.multiplayer;

import android.database.CharArrayBuffer;
import android.net.Uri;
import android.os.Parcel;
import com.google.android.gms.common.data.DataHolder;
import com.google.android.gms.common.data.d;
import com.google.android.gms.games.Player;
import com.google.android.gms.games.PlayerRef;
import com.google.android.gms.games.multiplayer.Participant;
import com.google.android.gms.games.multiplayer.ParticipantEntity;
import com.google.android.gms.games.multiplayer.ParticipantResult;

public final class ParticipantRef
extends d
implements Participant {
    private final PlayerRef Tb;

    public ParticipantRef(DataHolder holder, int dataRow) {
        super(holder, dataRow);
        this.Tb = new PlayerRef(holder, dataRow);
    }

    @Override
    public Participant freeze() {
        return new ParticipantEntity(this);
    }

    @Override
    public int getStatus() {
        return this.getInteger("player_status");
    }

    @Override
    public String gR() {
        return this.getString("client_address");
    }

    @Override
    public boolean isConnectedToRoom() {
        return this.getInteger("connected") > 0;
    }

    @Override
    public String getDisplayName() {
        if (this.ax("external_player_id")) {
            return this.getString("default_display_name");
        }
        return this.Tb.getDisplayName();
    }

    @Override
    public void getDisplayName(CharArrayBuffer dataOut) {
        if (this.ax("external_player_id")) {
            this.a("default_display_name", dataOut);
            return;
        }
        this.Tb.getDisplayName(dataOut);
    }

    @Override
    public Uri getIconImageUri() {
        if (this.ax("external_player_id")) {
            return this.aw("default_display_image_uri");
        }
        return this.Tb.getIconImageUri();
    }

    @Override
    public String getIconImageUrl() {
        if (this.ax("external_player_id")) {
            return this.getString("default_display_image_url");
        }
        return this.Tb.getIconImageUrl();
    }

    @Override
    public Uri getHiResImageUri() {
        if (this.ax("external_player_id")) {
            return this.aw("default_display_hi_res_image_uri");
        }
        return this.Tb.getHiResImageUri();
    }

    @Override
    public String getHiResImageUrl() {
        if (this.ax("external_player_id")) {
            return this.getString("default_display_hi_res_image_url");
        }
        return this.Tb.getHiResImageUrl();
    }

    @Override
    public String getParticipantId() {
        return this.getString("external_participant_id");
    }

    @Override
    public Player getPlayer() {
        if (this.ax("external_player_id")) {
            return null;
        }
        return this.Tb;
    }

    @Override
    public ParticipantResult getResult() {
        if (this.ax("result_type")) {
            return null;
        }
        int n2 = this.getInteger("result_type");
        int n3 = this.getInteger("placing");
        return new ParticipantResult(this.getParticipantId(), n2, n3);
    }

    @Override
    public int getCapabilities() {
        return this.getInteger("capabilities");
    }

    @Override
    public int hashCode() {
        return ParticipantEntity.a(this);
    }

    @Override
    public boolean equals(Object obj) {
        return ParticipantEntity.a(this, obj);
    }

    public String toString() {
        return ParticipantEntity.b(this);
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        ParticipantEntity participantEntity = (ParticipantEntity)this.freeze();
        participantEntity.writeToParcel(dest, flags);
    }
}

