/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.multiplayer.turnbased;

import android.os.Bundle;
import com.google.android.gms.common.data.DataHolder;
import com.google.android.gms.games.internal.constants.TurnBasedMatchTurnStatus;
import com.google.android.gms.games.multiplayer.InvitationBuffer;
import com.google.android.gms.games.multiplayer.turnbased.TurnBasedMatchBuffer;

public final class LoadMatchesResponse {
    private final InvitationBuffer Ts;
    private final TurnBasedMatchBuffer Tt;
    private final TurnBasedMatchBuffer Tu;
    private final TurnBasedMatchBuffer Tv;

    public LoadMatchesResponse(Bundle matchData) {
        DataHolder dataHolder = LoadMatchesResponse.a(matchData, 0);
        this.Ts = dataHolder != null ? new InvitationBuffer(dataHolder) : null;
        DataHolder dataHolder2 = LoadMatchesResponse.a(matchData, 1);
        this.Tt = dataHolder2 != null ? new TurnBasedMatchBuffer(dataHolder2) : null;
        DataHolder dataHolder3 = LoadMatchesResponse.a(matchData, 2);
        this.Tu = dataHolder3 != null ? new TurnBasedMatchBuffer(dataHolder3) : null;
        DataHolder dataHolder4 = LoadMatchesResponse.a(matchData, 3);
        this.Tv = dataHolder4 != null ? new TurnBasedMatchBuffer(dataHolder4) : null;
    }

    private static DataHolder a(Bundle bundle, int n2) {
        String string2 = TurnBasedMatchTurnStatus.cm(n2);
        if (!bundle.containsKey(string2)) {
            return null;
        }
        return (DataHolder)bundle.getParcelable(string2);
    }

    public InvitationBuffer getInvitations() {
        return this.Ts;
    }

    public TurnBasedMatchBuffer getMyTurnMatches() {
        return this.Tt;
    }

    public TurnBasedMatchBuffer getTheirTurnMatches() {
        return this.Tu;
    }

    public TurnBasedMatchBuffer getCompletedMatches() {
        return this.Tv;
    }

    public void close() {
        if (this.Ts != null) {
            this.Ts.close();
        }
        if (this.Tt != null) {
            this.Tt.close();
        }
        if (this.Tu != null) {
            this.Tu.close();
        }
        if (this.Tv != null) {
            this.Tv.close();
        }
    }

    public boolean hasData() {
        if (this.Ts != null && this.Ts.getCount() > 0) {
            return true;
        }
        if (this.Tt != null && this.Tt.getCount() > 0) {
            return true;
        }
        if (this.Tu != null && this.Tu.getCount() > 0) {
            return true;
        }
        return this.Tv != null && this.Tv.getCount() > 0;
    }
}

