/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.snapshot;

import android.os.Parcel;
import android.os.ParcelFileDescriptor;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.drive.Contents;
import com.google.android.gms.games.internal.GamesLog;
import com.google.android.gms.games.snapshot.Snapshot;
import com.google.android.gms.games.snapshot.SnapshotEntityCreator;
import com.google.android.gms.games.snapshot.SnapshotMetadata;
import com.google.android.gms.games.snapshot.SnapshotMetadataEntity;
import com.google.android.gms.internal.hl;
import com.google.android.gms.internal.hn;
import com.google.android.gms.internal.il;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.channels.FileChannel;

public final class SnapshotEntity
implements SafeParcelable,
Snapshot {
    private static final Object Ub = new Object();
    public static final SnapshotEntityCreator CREATOR = new SnapshotEntityCreator();
    private final int xJ;
    private final SnapshotMetadataEntity Uc;
    private Contents HD;

    public SnapshotEntity(SnapshotMetadata metadata, Contents contents) {
        this(1, metadata, contents);
    }

    SnapshotEntity(int versionCode, SnapshotMetadata metadata, Contents contents) {
        this.xJ = versionCode;
        this.Uc = new SnapshotMetadataEntity(metadata);
        this.HD = contents;
    }

    public int getVersionCode() {
        return this.xJ;
    }

    @Override
    public SnapshotMetadata getMetadata() {
        return this.Uc;
    }

    @Override
    public Contents getContents() {
        return this.HD;
    }

    @Override
    public void iH() {
        this.HD.close();
        this.HD = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] readFully() {
        hn.b(this.HD, (Object)"Must provide a previously opened Snapshot");
        Object object = Ub;
        synchronized (object) {
            ParcelFileDescriptor parcelFileDescriptor = this.HD.getParcelFileDescriptor();
            FileInputStream fileInputStream = new FileInputStream(parcelFileDescriptor.getFileDescriptor());
            BufferedInputStream bufferedInputStream = new BufferedInputStream(fileInputStream);
            try {
                fileInputStream.getChannel().position(0L);
            }
            catch (IOException iOException) {
                GamesLog.a("Snapshot", "Failed to read snapshot data", iOException);
            }
            return il.a(bufferedInputStream, false);
        }
    }

    @Override
    public boolean writeBytes(byte[] content) {
        return this.a(0, content, 0, content.length, true);
    }

    @Override
    public boolean modifyBytes(int dstOffset, byte[] content, int srcOffset, int count) {
        return this.a(dstOffset, content, srcOffset, content.length, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean a(int n2, byte[] byArray, int n3, int n4, boolean bl2) {
        hn.b(this.HD, (Object)"Must provide a previously opened Snapshot");
        Object object = Ub;
        synchronized (object) {
            ParcelFileDescriptor parcelFileDescriptor = this.HD.getParcelFileDescriptor();
            FileOutputStream fileOutputStream = new FileOutputStream(parcelFileDescriptor.getFileDescriptor());
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(fileOutputStream);
            try {
                FileChannel fileChannel = fileOutputStream.getChannel();
                fileChannel.position(n2);
                ((OutputStream)bufferedOutputStream).write(byArray, n3, n4);
                if (bl2) {
                    fileChannel.truncate(byArray.length);
                }
                ((OutputStream)bufferedOutputStream).flush();
            }
            catch (IOException iOException) {
                GamesLog.a("Snapshot", "Failed to write snapshot data", iOException);
                return false;
            }
            return true;
        }
    }

    @Override
    public Snapshot freeze() {
        return this;
    }

    @Override
    public boolean isDataValid() {
        return true;
    }

    public int hashCode() {
        return SnapshotEntity.b(this);
    }

    static int b(Snapshot snapshot) {
        return hl.hashCode(snapshot.getMetadata(), snapshot.getContents());
    }

    public boolean equals(Object obj) {
        return SnapshotEntity.a(this, obj);
    }

    static boolean a(Snapshot snapshot, Object object) {
        if (!(object instanceof Snapshot)) {
            return false;
        }
        if (snapshot == object) {
            return true;
        }
        Snapshot snapshot2 = (Snapshot)object;
        return hl.equal(snapshot2.getMetadata(), snapshot.getMetadata()) && hl.equal(snapshot2.getContents(), snapshot.getContents());
    }

    public String toString() {
        return SnapshotEntity.c(this);
    }

    static String c(Snapshot snapshot) {
        return hl.e(snapshot).a("Metadata", snapshot.getMetadata()).a("HasContents", snapshot.getContents() != null).toString();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel out, int flags) {
        SnapshotEntityCreator.a(this, out, flags);
    }
}

