/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.os.Handler;
import android.os.Looper;
import android.os.SystemClock;
import com.google.android.gms.cast.MediaInfo;
import com.google.android.gms.cast.MediaStatus;
import com.google.android.gms.cast.TextTrackStyle;
import com.google.android.gms.internal.gh;
import com.google.android.gms.internal.gj;
import com.google.android.gms.internal.gr;
import com.google.android.gms.internal.gs;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class gp
extends gh {
    private static final String NAMESPACE = gj.al("com.google.cast.media");
    private static final long Cm = TimeUnit.HOURS.toMillis(24L);
    private static final long Cn = TimeUnit.HOURS.toMillis(24L);
    private static final long Co = TimeUnit.HOURS.toMillis(24L);
    private static final long Cp = TimeUnit.SECONDS.toMillis(1L);
    private long Cq;
    private MediaStatus Cr;
    private final Handler mHandler = new Handler(Looper.getMainLooper());
    private final gs Cs;
    private final gs Ct;
    private final gs Cu;
    private final gs Cv;
    private final gs Cw;
    private final gs Cx;
    private final gs Cy;
    private final gs Cz;
    private final gs CA;
    private final gs CB;
    private final List<gs> CC;
    private final Runnable CD = new a();
    private boolean CE;

    public gp() {
        this(null);
    }

    public gp(String string2) {
        super(NAMESPACE, "MediaControlChannel", string2);
        this.CC = new ArrayList<gs>();
        this.Cs = new gs(Cn);
        this.CC.add(this.Cs);
        this.Ct = new gs(Cm);
        this.CC.add(this.Ct);
        this.Cu = new gs(Cm);
        this.CC.add(this.Cu);
        this.Cv = new gs(Cm);
        this.CC.add(this.Cv);
        this.Cw = new gs(Co);
        this.CC.add(this.Cw);
        this.Cx = new gs(Cm);
        this.CC.add(this.Cx);
        this.Cy = new gs(Cm);
        this.CC.add(this.Cy);
        this.Cz = new gs(Cm);
        this.CC.add(this.Cz);
        this.CA = new gs(Cm);
        this.CC.add(this.CA);
        this.CB = new gs(Cm);
        this.CC.add(this.CB);
        this.eo();
    }

    public long a(gr gr2, MediaInfo mediaInfo, boolean bl2, long l2, JSONObject jSONObject) throws IOException {
        JSONObject jSONObject2 = new JSONObject();
        long l3 = this.dY();
        this.Cs.a(l3, gr2);
        this.z(true);
        try {
            jSONObject2.put("requestId", l3);
            jSONObject2.put("type", (Object)"LOAD");
            jSONObject2.put("media", (Object)mediaInfo.dU());
            jSONObject2.put("autoplay", bl2);
            jSONObject2.put("currentTime", gj.o(l2));
            if (jSONObject != null) {
                jSONObject2.put("customData", (Object)jSONObject);
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        this.a(jSONObject2.toString(), l3, null);
        return l3;
    }

    public long a(gr gr2, JSONObject jSONObject) throws IOException {
        JSONObject jSONObject2 = new JSONObject();
        long l2 = this.dY();
        this.Ct.a(l2, gr2);
        this.z(true);
        try {
            jSONObject2.put("requestId", l2);
            jSONObject2.put("type", (Object)"PAUSE");
            jSONObject2.put("mediaSessionId", this.dV());
            if (jSONObject != null) {
                jSONObject2.put("customData", (Object)jSONObject);
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        this.a(jSONObject2.toString(), l2, null);
        return l2;
    }

    public long b(gr gr2, JSONObject jSONObject) throws IOException {
        JSONObject jSONObject2 = new JSONObject();
        long l2 = this.dY();
        this.Cv.a(l2, gr2);
        this.z(true);
        try {
            jSONObject2.put("requestId", l2);
            jSONObject2.put("type", (Object)"STOP");
            jSONObject2.put("mediaSessionId", this.dV());
            if (jSONObject != null) {
                jSONObject2.put("customData", (Object)jSONObject);
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        this.a(jSONObject2.toString(), l2, null);
        return l2;
    }

    public long c(gr gr2, JSONObject jSONObject) throws IOException, IllegalStateException {
        JSONObject jSONObject2 = new JSONObject();
        long l2 = this.dY();
        this.Cu.a(l2, gr2);
        this.z(true);
        try {
            jSONObject2.put("requestId", l2);
            jSONObject2.put("type", (Object)"PLAY");
            jSONObject2.put("mediaSessionId", this.dV());
            if (jSONObject != null) {
                jSONObject2.put("customData", (Object)jSONObject);
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        this.a(jSONObject2.toString(), l2, null);
        return l2;
    }

    public long a(gr gr2, long l2, int n2, JSONObject jSONObject) throws IOException, IllegalStateException {
        JSONObject jSONObject2 = new JSONObject();
        long l3 = this.dY();
        this.Cw.a(l3, gr2);
        this.z(true);
        try {
            jSONObject2.put("requestId", l3);
            jSONObject2.put("type", (Object)"SEEK");
            jSONObject2.put("mediaSessionId", this.dV());
            jSONObject2.put("currentTime", gj.o(l2));
            if (n2 == 1) {
                jSONObject2.put("resumeState", (Object)"PLAYBACK_START");
            } else if (n2 == 2) {
                jSONObject2.put("resumeState", (Object)"PLAYBACK_PAUSE");
            }
            if (jSONObject != null) {
                jSONObject2.put("customData", (Object)jSONObject);
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        this.a(jSONObject2.toString(), l3, null);
        return l3;
    }

    public long a(gr gr2, double d2, JSONObject jSONObject) throws IOException, IllegalStateException, IllegalArgumentException {
        if (Double.isInfinite(d2) || Double.isNaN(d2)) {
            throw new IllegalArgumentException("Volume cannot be " + d2);
        }
        JSONObject jSONObject2 = new JSONObject();
        long l2 = this.dY();
        this.Cx.a(l2, gr2);
        this.z(true);
        try {
            jSONObject2.put("requestId", l2);
            jSONObject2.put("type", (Object)"SET_VOLUME");
            jSONObject2.put("mediaSessionId", this.dV());
            JSONObject jSONObject3 = new JSONObject();
            jSONObject3.put("level", d2);
            jSONObject2.put("volume", (Object)jSONObject3);
            if (jSONObject != null) {
                jSONObject2.put("customData", (Object)jSONObject);
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        this.a(jSONObject2.toString(), l2, null);
        return l2;
    }

    public long a(gr gr2, boolean bl2, JSONObject jSONObject) throws IOException, IllegalStateException {
        JSONObject jSONObject2 = new JSONObject();
        long l2 = this.dY();
        this.Cy.a(l2, gr2);
        this.z(true);
        try {
            jSONObject2.put("requestId", l2);
            jSONObject2.put("type", (Object)"SET_VOLUME");
            jSONObject2.put("mediaSessionId", this.dV());
            JSONObject jSONObject3 = new JSONObject();
            jSONObject3.put("muted", bl2);
            jSONObject2.put("volume", (Object)jSONObject3);
            if (jSONObject != null) {
                jSONObject2.put("customData", (Object)jSONObject);
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        this.a(jSONObject2.toString(), l2, null);
        return l2;
    }

    public long a(gr gr2) throws IOException {
        JSONObject jSONObject = new JSONObject();
        long l2 = this.dY();
        this.Cz.a(l2, gr2);
        this.z(true);
        try {
            jSONObject.put("requestId", l2);
            jSONObject.put("type", (Object)"GET_STATUS");
            if (this.Cr != null) {
                jSONObject.put("mediaSessionId", this.Cr.dV());
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        this.a(jSONObject.toString(), l2, null);
        return l2;
    }

    public long a(gr gr2, long[] lArray) throws IOException {
        JSONObject jSONObject = new JSONObject();
        long l2 = this.dY();
        this.CA.a(l2, gr2);
        this.z(true);
        try {
            jSONObject.put("requestId", l2);
            jSONObject.put("type", (Object)"EDIT_TRACKS_INFO");
            jSONObject.put("mediaSessionId", this.dV());
            JSONArray jSONArray = new JSONArray();
            for (int i2 = 0; i2 < lArray.length; ++i2) {
                jSONArray.put(i2, lArray[i2]);
            }
            jSONObject.put("activeTrackIds", (Object)jSONArray);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        this.a(jSONObject.toString(), l2, null);
        return l2;
    }

    public long a(gr gr2, TextTrackStyle textTrackStyle) throws IOException {
        JSONObject jSONObject = new JSONObject();
        long l2 = this.dY();
        this.CB.a(l2, gr2);
        this.z(true);
        try {
            jSONObject.put("requestId", l2);
            jSONObject.put("type", (Object)"EDIT_TRACKS_INFO");
            if (textTrackStyle != null) {
                jSONObject.put("textTrackStyle", (Object)textTrackStyle.dU());
            }
            jSONObject.put("mediaSessionId", this.dV());
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        this.a(jSONObject.toString(), l2, null);
        return l2;
    }

    public long getApproximateStreamPosition() {
        MediaInfo mediaInfo = this.getMediaInfo();
        if (mediaInfo == null) {
            return 0L;
        }
        if (this.Cq == 0L) {
            return 0L;
        }
        double d2 = this.Cr.getPlaybackRate();
        long l2 = this.Cr.getStreamPosition();
        int n2 = this.Cr.getPlayerState();
        if (d2 == 0.0 || n2 != 2) {
            return l2;
        }
        long l3 = SystemClock.elapsedRealtime() - this.Cq;
        if (l3 < 0L) {
            l3 = 0L;
        }
        if (l3 == 0L) {
            return l2;
        }
        long l4 = l2 + (long)((double)l3 * d2);
        long l5 = mediaInfo.getStreamDuration();
        if (l4 > l5) {
            l4 = l5;
        } else if (l4 < 0L) {
            l4 = 0L;
        }
        return l4;
    }

    public long getStreamDuration() {
        MediaInfo mediaInfo = this.getMediaInfo();
        return mediaInfo != null ? mediaInfo.getStreamDuration() : 0L;
    }

    public MediaStatus getMediaStatus() {
        return this.Cr;
    }

    public MediaInfo getMediaInfo() {
        return this.Cr == null ? null : this.Cr.getMediaInfo();
    }

    @Override
    public final void ai(String string2) {
        this.BA.b("message received: %s", string2);
        try {
            JSONObject jSONObject = new JSONObject(string2);
            String string3 = jSONObject.getString("type");
            long l2 = jSONObject.optLong("requestId", -1L);
            if (string3.equals("MEDIA_STATUS")) {
                JSONArray jSONArray = jSONObject.getJSONArray("status");
                if (jSONArray.length() > 0) {
                    this.a(l2, jSONArray.getJSONObject(0));
                } else {
                    this.Cr = null;
                    this.onStatusUpdated();
                    this.onMetadataUpdated();
                    this.Cz.c(l2, 0);
                }
            } else if (string3.equals("INVALID_PLAYER_STATE")) {
                this.BA.d("received unexpected error: Invalid Player State.", new Object[0]);
                JSONObject jSONObject2 = jSONObject.optJSONObject("customData");
                for (gs gs2 : this.CC) {
                    gs2.b(l2, 1, jSONObject2);
                }
            } else if (string3.equals("LOAD_FAILED")) {
                JSONObject jSONObject3 = jSONObject.optJSONObject("customData");
                this.Cs.b(l2, 1, jSONObject3);
            } else if (string3.equals("LOAD_CANCELLED")) {
                JSONObject jSONObject4 = jSONObject.optJSONObject("customData");
                this.Cs.b(l2, 2, jSONObject4);
            } else if (string3.equals("INVALID_REQUEST")) {
                this.BA.d("received unexpected error: Invalid Request.", new Object[0]);
                JSONObject jSONObject5 = jSONObject.optJSONObject("customData");
                for (gs gs3 : this.CC) {
                    gs3.b(l2, 1, jSONObject5);
                }
            }
        }
        catch (JSONException jSONException) {
            this.BA.d("Message is malformed (%s); ignoring: %s", jSONException.getMessage(), string2);
        }
    }

    @Override
    public void a(long l2, int n2) {
        for (gs gs2 : this.CC) {
            gs2.c(l2, n2);
        }
    }

    private void a(long l2, JSONObject jSONObject) throws JSONException {
        boolean bl2 = this.Cs.p(l2);
        boolean bl3 = this.Cw.eq() && !this.Cw.p(l2);
        boolean bl4 = this.Cx.eq() && !this.Cx.p(l2) || this.Cy.eq() && !this.Cy.p(l2);
        int n2 = 0;
        if (bl3) {
            n2 |= 2;
        }
        if (bl4) {
            n2 |= 1;
        }
        int n3 = 0;
        if (bl2 || this.Cr == null) {
            this.Cr = new MediaStatus(jSONObject);
            this.Cq = SystemClock.elapsedRealtime();
            n3 = 7;
        } else {
            n3 = this.Cr.a(jSONObject, n2);
        }
        if ((n3 & 1) != 0) {
            this.Cq = SystemClock.elapsedRealtime();
            this.onStatusUpdated();
        }
        if ((n3 & 2) != 0) {
            this.Cq = SystemClock.elapsedRealtime();
            this.onStatusUpdated();
        }
        if ((n3 & 4) != 0) {
            this.onMetadataUpdated();
        }
        for (gs gs2 : this.CC) {
            gs2.c(l2, 0);
        }
    }

    public long dV() throws IllegalStateException {
        if (this.Cr == null) {
            throw new IllegalStateException("No current media session");
        }
        return this.Cr.dV();
    }

    protected void onStatusUpdated() {
    }

    protected void onMetadataUpdated() {
    }

    private void eo() {
        this.z(false);
        this.Cq = 0L;
        this.Cr = null;
        this.Cs.clear();
        this.Cw.clear();
        this.Cx.clear();
    }

    @Override
    public void dZ() {
        this.eo();
    }

    private void z(boolean bl2) {
        if (this.CE != bl2) {
            this.CE = bl2;
            if (bl2) {
                this.mHandler.postDelayed(this.CD, Cp);
            } else {
                this.mHandler.removeCallbacks(this.CD);
            }
        }
    }

    private class a
    implements Runnable {
        private a() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Object object2;
            gp.this.CE = false;
            long l2 = SystemClock.elapsedRealtime();
            for (Object object2 : gp.this.CC) {
                ((gs)object2).d(l2, 3);
            }
            boolean bl2 = false;
            object2 = gs.CK;
            synchronized (object2) {
                for (gs gs2 : gp.this.CC) {
                    if (!gs2.eq()) continue;
                    bl2 = true;
                }
            }
            gp.this.z(bl2);
        }
    }
}

