/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.os.SystemClock;
import com.google.android.gms.internal.iq;

public final class gu
extends Drawable
implements Drawable.Callback {
    private int Fs = 0;
    private long Ft;
    private int Fu;
    private int Fv;
    private int Fw = 255;
    private int Fx;
    private int Fy = 0;
    private boolean Fm = true;
    private boolean Fz;
    private b FA;
    private Drawable FB;
    private Drawable FC;
    private boolean FD;
    private boolean FE;
    private boolean FF;
    private int FG;

    public gu(Drawable drawable2, Drawable drawable3) {
        this(null);
        if (drawable2 == null) {
            drawable2 = a.FH;
        }
        this.FB = drawable2;
        drawable2.setCallback((Drawable.Callback)this);
        this.FA.FK |= drawable2.getChangingConfigurations();
        if (drawable3 == null) {
            drawable3 = a.FH;
        }
        this.FC = drawable3;
        drawable3.setCallback((Drawable.Callback)this);
        this.FA.FK |= drawable3.getChangingConfigurations();
    }

    gu(b b2) {
        this.FA = new b(b2);
    }

    public void invalidateDrawable(Drawable who) {
        Drawable.Callback callback;
        if (iq.fX() && (callback = this.getCallback()) != null) {
            callback.invalidateDrawable((Drawable)this);
        }
    }

    public void scheduleDrawable(Drawable who, Runnable what, long when) {
        Drawable.Callback callback;
        if (iq.fX() && (callback = this.getCallback()) != null) {
            callback.scheduleDrawable((Drawable)this, what, when);
        }
    }

    public void unscheduleDrawable(Drawable who, Runnable what) {
        Drawable.Callback callback;
        if (iq.fX() && (callback = this.getCallback()) != null) {
            callback.unscheduleDrawable((Drawable)this, what);
        }
    }

    public int getChangingConfigurations() {
        return super.getChangingConfigurations() | this.FA.FJ | this.FA.FK;
    }

    public void setAlpha(int alpha) {
        if (this.Fy == this.Fw) {
            this.Fy = alpha;
        }
        this.Fw = alpha;
        this.invalidateSelf();
    }

    public void setColorFilter(ColorFilter cf2) {
        this.FB.setColorFilter(cf2);
        this.FC.setColorFilter(cf2);
    }

    public int getIntrinsicWidth() {
        return Math.max(this.FB.getIntrinsicWidth(), this.FC.getIntrinsicWidth());
    }

    public int getIntrinsicHeight() {
        return Math.max(this.FB.getIntrinsicHeight(), this.FC.getIntrinsicHeight());
    }

    protected void onBoundsChange(Rect bounds) {
        this.FB.setBounds(bounds);
        this.FC.setBounds(bounds);
    }

    public Drawable.ConstantState getConstantState() {
        if (this.canConstantState()) {
            this.FA.FJ = this.getChangingConfigurations();
            return this.FA;
        }
        return null;
    }

    public int getOpacity() {
        if (!this.FF) {
            this.FG = Drawable.resolveOpacity((int)this.FB.getOpacity(), (int)this.FC.getOpacity());
            this.FF = true;
        }
        return this.FG;
    }

    public boolean canConstantState() {
        if (!this.FD) {
            this.FE = this.FB.getConstantState() != null && this.FC.getConstantState() != null;
            this.FD = true;
        }
        return this.FE;
    }

    public Drawable mutate() {
        if (!this.Fz && super.mutate() == this) {
            if (!this.canConstantState()) {
                throw new IllegalStateException("One or more children of this LayerDrawable does not have constant state; this drawable cannot be mutated.");
            }
            this.FB.mutate();
            this.FC.mutate();
            this.Fz = true;
        }
        return this;
    }

    public Drawable fb() {
        return this.FC;
    }

    public void startTransition(int durationMillis) {
        this.Fu = 0;
        this.Fv = this.Fw;
        this.Fy = 0;
        this.Fx = durationMillis;
        this.Fs = 1;
        this.invalidateSelf();
    }

    public void draw(Canvas canvas) {
        boolean bl2 = true;
        switch (this.Fs) {
            case 1: {
                this.Ft = SystemClock.uptimeMillis();
                bl2 = false;
                this.Fs = 2;
                break;
            }
            case 2: {
                if (this.Ft < 0L) break;
                float f2 = (float)(SystemClock.uptimeMillis() - this.Ft) / (float)this.Fx;
                boolean bl3 = bl2 = f2 >= 1.0f;
                if (bl2) {
                    this.Fs = 0;
                }
                f2 = Math.min(f2, 1.0f);
                this.Fy = (int)((float)this.Fu + (float)(this.Fv - this.Fu) * f2);
            }
        }
        int n2 = this.Fy;
        boolean bl4 = this.Fm;
        Drawable drawable2 = this.FB;
        Drawable drawable3 = this.FC;
        if (bl2) {
            if (!bl4 || n2 == 0) {
                drawable2.draw(canvas);
            }
            if (n2 == this.Fw) {
                drawable3.setAlpha(this.Fw);
                drawable3.draw(canvas);
            }
            return;
        }
        if (bl4) {
            drawable2.setAlpha(this.Fw - n2);
        }
        drawable2.draw(canvas);
        if (bl4) {
            drawable2.setAlpha(this.Fw);
        }
        if (n2 > 0) {
            drawable3.setAlpha(n2);
            drawable3.draw(canvas);
            drawable3.setAlpha(this.Fw);
        }
        this.invalidateSelf();
    }

    private static final class com.google.android.gms.internal.gu$a
    extends Drawable {
        private static final com.google.android.gms.internal.gu$a FH = new com.google.android.gms.internal.gu$a();
        private static final a FI = new a();

        private com.google.android.gms.internal.gu$a() {
        }

        public void draw(Canvas canvas) {
        }

        public void setAlpha(int alpha) {
        }

        public void setColorFilter(ColorFilter cf2) {
        }

        public int getOpacity() {
            return -2;
        }

        public Drawable.ConstantState getConstantState() {
            return FI;
        }

        private static final class a
        extends Drawable.ConstantState {
            private a() {
            }

            public Drawable newDrawable() {
                return FH;
            }

            public int getChangingConfigurations() {
                return 0;
            }
        }
    }

    static final class b
    extends Drawable.ConstantState {
        int FJ;
        int FK;

        b(b b2) {
            if (b2 != null) {
                this.FJ = b2.FJ;
                this.FK = b2.FK;
            }
        }

        public Drawable newDrawable() {
            return new gu(this);
        }

        public int getChangingConfigurations() {
            return this.FJ;
        }
    }
}

