/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.maps.model;

import android.os.IBinder;
import android.os.Parcel;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.dynamic.d;
import com.google.android.gms.internal.hn;
import com.google.android.gms.maps.internal.v;
import com.google.android.gms.maps.model.BitmapDescriptor;
import com.google.android.gms.maps.model.GroundOverlayOptionsCreator;
import com.google.android.gms.maps.model.LatLng;
import com.google.android.gms.maps.model.LatLngBounds;
import com.google.android.gms.maps.model.c;

public final class GroundOverlayOptions
implements SafeParcelable {
    public static final GroundOverlayOptionsCreator CREATOR = new GroundOverlayOptionsCreator();
    public static final float NO_DIMENSION = -1.0f;
    private final int xJ;
    private BitmapDescriptor aax;
    private LatLng aay;
    private float aaz;
    private float aaA;
    private LatLngBounds aaB;
    private float aan;
    private float aau;
    private boolean aav = true;
    private float aaC = 0.0f;
    private float aaD = 0.5f;
    private float aaE = 0.5f;

    GroundOverlayOptions(int versionCode, IBinder wrappedImage, LatLng location, float width, float height, LatLngBounds bounds, float bearing, float zIndex, boolean visible, float transparency, float anchorU, float anchorV) {
        this.xJ = versionCode;
        this.aax = new BitmapDescriptor(d.a.ag(wrappedImage));
        this.aay = location;
        this.aaz = width;
        this.aaA = height;
        this.aaB = bounds;
        this.aan = bearing;
        this.aau = zIndex;
        this.aav = visible;
        this.aaC = transparency;
        this.aaD = anchorU;
        this.aaE = anchorV;
    }

    public GroundOverlayOptions() {
        this.xJ = 1;
    }

    public void writeToParcel(Parcel out, int flags) {
        if (v.jG()) {
            c.a(this, out, flags);
        } else {
            GroundOverlayOptionsCreator.a(this, out, flags);
        }
    }

    public int describeContents() {
        return 0;
    }

    IBinder jI() {
        return this.aax.ji().asBinder();
    }

    public GroundOverlayOptions image(BitmapDescriptor image) {
        this.aax = image;
        return this;
    }

    public GroundOverlayOptions anchor(float u2, float v2) {
        this.aaD = u2;
        this.aaE = v2;
        return this;
    }

    public GroundOverlayOptions position(LatLng location, float width) {
        hn.a(this.aaB == null, "Position has already been set using positionFromBounds");
        hn.b(location != null, (Object)"Location must be specified");
        hn.b(width >= 0.0f, (Object)"Width must be non-negative");
        return this.a(location, width, -1.0f);
    }

    public GroundOverlayOptions position(LatLng location, float width, float height) {
        hn.a(this.aaB == null, "Position has already been set using positionFromBounds");
        hn.b(location != null, (Object)"Location must be specified");
        hn.b(width >= 0.0f, (Object)"Width must be non-negative");
        hn.b(height >= 0.0f, (Object)"Height must be non-negative");
        return this.a(location, width, height);
    }

    private GroundOverlayOptions a(LatLng latLng, float f2, float f3) {
        this.aay = latLng;
        this.aaz = f2;
        this.aaA = f3;
        return this;
    }

    public GroundOverlayOptions positionFromBounds(LatLngBounds bounds) {
        hn.a(this.aay == null, "Position has already been set using position: %s", this.aay);
        this.aaB = bounds;
        return this;
    }

    public GroundOverlayOptions bearing(float bearing) {
        this.aan = (bearing % 360.0f + 360.0f) % 360.0f;
        return this;
    }

    public GroundOverlayOptions zIndex(float zIndex) {
        this.aau = zIndex;
        return this;
    }

    public GroundOverlayOptions visible(boolean visible) {
        this.aav = visible;
        return this;
    }

    public GroundOverlayOptions transparency(float transparency) {
        hn.b(transparency >= 0.0f && transparency <= 1.0f, (Object)"Transparency must be in the range [0..1]");
        this.aaC = transparency;
        return this;
    }

    int getVersionCode() {
        return this.xJ;
    }

    public BitmapDescriptor getImage() {
        return this.aax;
    }

    public LatLng getLocation() {
        return this.aay;
    }

    public float getWidth() {
        return this.aaz;
    }

    public float getHeight() {
        return this.aaA;
    }

    public LatLngBounds getBounds() {
        return this.aaB;
    }

    public float getBearing() {
        return this.aan;
    }

    public float getZIndex() {
        return this.aau;
    }

    public float getTransparency() {
        return this.aaC;
    }

    public float getAnchorU() {
        return this.aaD;
    }

    public float getAnchorV() {
        return this.aaE;
    }

    public boolean isVisible() {
        return this.aav;
    }
}

