/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.wallet.fragment;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Parcelable;
import android.os.RemoteException;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentActivity;
import android.support.v4.app.FragmentManager;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.FrameLayout;
import com.google.android.gms.R;
import com.google.android.gms.common.GooglePlayServicesNotAvailableException;
import com.google.android.gms.common.GooglePlayServicesUtil;
import com.google.android.gms.dynamic.LifecycleDelegate;
import com.google.android.gms.dynamic.d;
import com.google.android.gms.dynamic.e;
import com.google.android.gms.dynamic.f;
import com.google.android.gms.dynamic.h;
import com.google.android.gms.internal.ll;
import com.google.android.gms.internal.lm;
import com.google.android.gms.internal.lt;
import com.google.android.gms.wallet.MaskedWallet;
import com.google.android.gms.wallet.MaskedWalletRequest;
import com.google.android.gms.wallet.fragment.WalletFragmentInitParams;
import com.google.android.gms.wallet.fragment.WalletFragmentOptions;
import com.google.android.gms.wallet.fragment.WalletFragmentStyle;

public final class SupportWalletFragment
extends Fragment {
    private b akd;
    private boolean mCreated = false;
    private final h ake = h.a(this);
    private final c akf = new c();
    private a akg = new a(this);
    private final Fragment FS = this;
    private WalletFragmentOptions akh;
    private WalletFragmentInitParams aki;
    private MaskedWalletRequest akj;
    private MaskedWallet akk;
    private Boolean akl;

    public static SupportWalletFragment newInstance(WalletFragmentOptions options) {
        SupportWalletFragment supportWalletFragment = new SupportWalletFragment();
        Bundle bundle = new Bundle();
        bundle.putParcelable("extraWalletFragmentOptions", (Parcelable)options);
        supportWalletFragment.FS.setArguments(bundle);
        return supportWalletFragment;
    }

    public void initialize(WalletFragmentInitParams initParams) {
        if (this.akd != null) {
            this.akd.initialize(initParams);
            this.aki = null;
        } else if (this.aki == null) {
            this.aki = initParams;
            if (this.akj != null) {
                Log.w((String)"SupportWalletFragment", (String)"updateMaskedWalletRequest() was called before initialize()");
            }
            if (this.akk != null) {
                Log.w((String)"SupportWalletFragment", (String)"updateMaskedWallet() was called before initialize()");
            }
        } else {
            Log.w((String)"SupportWalletFragment", (String)"initialize(WalletFragmentInitParams) was called more than once. Ignoring.");
        }
    }

    public void updateMaskedWalletRequest(MaskedWalletRequest request) {
        if (this.akd != null) {
            this.akd.updateMaskedWalletRequest(request);
            this.akj = null;
        } else {
            this.akj = request;
        }
    }

    public void updateMaskedWallet(MaskedWallet maskedWallet) {
        if (this.akd != null) {
            this.akd.updateMaskedWallet(maskedWallet);
            this.akk = null;
        } else {
            this.akk = maskedWallet;
        }
    }

    public void setEnabled(boolean enabled) {
        if (this.akd != null) {
            this.akd.setEnabled(enabled);
            this.akl = null;
        } else {
            this.akl = enabled;
        }
    }

    public void setOnStateChangedListener(OnStateChangedListener listener) {
        this.akg.a(listener);
    }

    public int getState() {
        return this.akd != null ? this.akd.getState() : 0;
    }

    public void onInflate(Activity activity, AttributeSet attrs, Bundle savedInstanceState) {
        super.onInflate(activity, attrs, savedInstanceState);
        if (this.akh == null) {
            this.akh = WalletFragmentOptions.a((Context)activity, attrs);
        }
        Bundle bundle = new Bundle();
        bundle.putParcelable("attrKeyWalletFragmentOptions", (Parcelable)this.akh);
        this.akf.onInflate(activity, bundle, savedInstanceState);
    }

    public void onCreate(Bundle savedInstanceState) {
        WalletFragmentOptions walletFragmentOptions;
        super.onCreate(savedInstanceState);
        if (savedInstanceState != null) {
            savedInstanceState.setClassLoader(WalletFragmentOptions.class.getClassLoader());
            WalletFragmentInitParams walletFragmentInitParams = (WalletFragmentInitParams)savedInstanceState.getParcelable("walletFragmentInitParams");
            if (walletFragmentInitParams != null) {
                if (this.aki != null) {
                    Log.w((String)"SupportWalletFragment", (String)"initialize(WalletFragmentInitParams) was called more than once.Ignoring.");
                }
                this.aki = walletFragmentInitParams;
            }
            if (this.akj == null) {
                this.akj = (MaskedWalletRequest)savedInstanceState.getParcelable("maskedWalletRequest");
            }
            if (this.akk == null) {
                this.akk = (MaskedWallet)savedInstanceState.getParcelable("maskedWallet");
            }
            if (savedInstanceState.containsKey("walletFragmentOptions")) {
                this.akh = (WalletFragmentOptions)savedInstanceState.getParcelable("walletFragmentOptions");
            }
            if (savedInstanceState.containsKey("enabled")) {
                this.akl = savedInstanceState.getBoolean("enabled");
            }
        } else if (this.FS.getArguments() != null && (walletFragmentOptions = (WalletFragmentOptions)this.FS.getArguments().getParcelable("extraWalletFragmentOptions")) != null) {
            walletFragmentOptions.N((Context)this.FS.getActivity());
            this.akh = walletFragmentOptions;
        }
        this.mCreated = true;
        this.akf.onCreate(savedInstanceState);
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        return this.akf.onCreateView(inflater, container, savedInstanceState);
    }

    public void onStart() {
        super.onStart();
        this.akf.onStart();
    }

    public void onResume() {
        super.onResume();
        this.akf.onResume();
        FragmentManager fragmentManager = this.FS.getActivity().getSupportFragmentManager();
        Fragment fragment = fragmentManager.findFragmentByTag("GooglePlayServicesErrorDialog");
        if (fragment != null) {
            fragmentManager.beginTransaction().remove(fragment).commit();
            int n2 = GooglePlayServicesUtil.isGooglePlayServicesAvailable((Context)this.FS.getActivity());
            GooglePlayServicesUtil.showErrorDialogFragment(n2, (Activity)this.FS.getActivity(), -1);
        }
    }

    public void onPause() {
        super.onPause();
        this.akf.onPause();
    }

    public void onStop() {
        super.onStop();
        this.akf.onStop();
    }

    public void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        outState.setClassLoader(WalletFragmentOptions.class.getClassLoader());
        this.akf.onSaveInstanceState(outState);
        if (this.aki != null) {
            outState.putParcelable("walletFragmentInitParams", (Parcelable)this.aki);
            this.aki = null;
        }
        if (this.akj != null) {
            outState.putParcelable("maskedWalletRequest", (Parcelable)this.akj);
            this.akj = null;
        }
        if (this.akk != null) {
            outState.putParcelable("maskedWallet", (Parcelable)this.akk);
            this.akk = null;
        }
        if (this.akh != null) {
            outState.putParcelable("walletFragmentOptions", (Parcelable)this.akh);
            this.akh = null;
        }
        if (this.akl != null) {
            outState.putBoolean("enabled", this.akl.booleanValue());
            this.akl = null;
        }
    }

    public void onDestroy() {
        super.onDestroy();
        this.mCreated = false;
    }

    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        if (this.akd != null) {
            this.akd.onActivityResult(requestCode, resultCode, data);
        }
    }

    public static interface OnStateChangedListener {
        public void onStateChanged(SupportWalletFragment var1, int var2, int var3, Bundle var4);
    }

    static class a
    extends lm.a {
        private OnStateChangedListener akm;
        private final SupportWalletFragment akn;

        a(SupportWalletFragment supportWalletFragment) {
            this.akn = supportWalletFragment;
        }

        @Override
        public void a(int n2, int n3, Bundle bundle) {
            if (this.akm != null) {
                this.akm.onStateChanged(this.akn, n2, n3, bundle);
            }
        }

        public void a(OnStateChangedListener onStateChangedListener) {
            this.akm = onStateChangedListener;
        }
    }

    private static class b
    implements LifecycleDelegate {
        private final ll ako;

        private b(ll ll2) {
            this.ako = ll2;
        }

        private void initialize(WalletFragmentInitParams startParams) {
            try {
                this.ako.initialize(startParams);
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        private void setEnabled(boolean enabled) {
            try {
                this.ako.setEnabled(enabled);
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        private void updateMaskedWalletRequest(MaskedWalletRequest request) {
            try {
                this.ako.updateMaskedWalletRequest(request);
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        private void updateMaskedWallet(MaskedWallet maskedWallet) {
            try {
                this.ako.updateMaskedWallet(maskedWallet);
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        private int getState() {
            try {
                return this.ako.getState();
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        @Override
        public void onInflate(Activity activity, Bundle attrs, Bundle savedInstanceState) {
            WalletFragmentOptions walletFragmentOptions = (WalletFragmentOptions)attrs.getParcelable("extraWalletFragmentOptions");
            try {
                this.ako.a(e.h(activity), walletFragmentOptions, savedInstanceState);
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        @Override
        public void onCreate(Bundle savedInstanceState) {
            try {
                this.ako.onCreate(savedInstanceState);
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        @Override
        public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
            try {
                d d2 = this.ako.onCreateView(e.h(inflater), e.h(container), savedInstanceState);
                return (View)e.e(d2);
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        @Override
        public void onStart() {
            try {
                this.ako.onStart();
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        @Override
        public void onResume() {
            try {
                this.ako.onResume();
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        @Override
        public void onPause() {
            try {
                this.ako.onPause();
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        @Override
        public void onStop() {
            try {
                this.ako.onStop();
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        @Override
        public void onDestroyView() {
        }

        @Override
        public void onDestroy() {
        }

        @Override
        public void onLowMemory() {
        }

        @Override
        public void onSaveInstanceState(Bundle outState) {
            try {
                this.ako.onSaveInstanceState(outState);
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        private void onActivityResult(int requestCode, int resultCode, Intent data) {
            try {
                this.ako.onActivityResult(requestCode, resultCode, data);
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }
    }

    private class c
    extends com.google.android.gms.dynamic.a<b>
    implements View.OnClickListener {
        private c() {
        }

        @Override
        protected void a(f<b> f2) {
            FragmentActivity fragmentActivity = SupportWalletFragment.this.FS.getActivity();
            if (SupportWalletFragment.this.akd == null && SupportWalletFragment.this.mCreated && fragmentActivity != null) {
                try {
                    ll ll2 = lt.a((Activity)fragmentActivity, SupportWalletFragment.this.ake, SupportWalletFragment.this.akh, SupportWalletFragment.this.akg);
                    SupportWalletFragment.this.akd = new b(ll2);
                    SupportWalletFragment.this.akh = null;
                }
                catch (GooglePlayServicesNotAvailableException googlePlayServicesNotAvailableException) {
                    return;
                }
                f2.a(SupportWalletFragment.this.akd);
                if (SupportWalletFragment.this.aki != null) {
                    SupportWalletFragment.this.akd.initialize(SupportWalletFragment.this.aki);
                    SupportWalletFragment.this.aki = null;
                }
                if (SupportWalletFragment.this.akj != null) {
                    SupportWalletFragment.this.akd.updateMaskedWalletRequest(SupportWalletFragment.this.akj);
                    SupportWalletFragment.this.akj = null;
                }
                if (SupportWalletFragment.this.akk != null) {
                    SupportWalletFragment.this.akd.updateMaskedWallet(SupportWalletFragment.this.akk);
                    SupportWalletFragment.this.akk = null;
                }
                if (SupportWalletFragment.this.akl != null) {
                    SupportWalletFragment.this.akd.setEnabled(SupportWalletFragment.this.akl);
                    SupportWalletFragment.this.akl = null;
                }
            }
        }

        @Override
        protected void a(FrameLayout frameLayout) {
            WalletFragmentStyle walletFragmentStyle;
            Button button = new Button((Context)SupportWalletFragment.this.FS.getActivity());
            button.setText(R.string.wallet_buy_button_place_holder);
            int n2 = -1;
            int n3 = -2;
            if (SupportWalletFragment.this.akh != null && (walletFragmentStyle = SupportWalletFragment.this.akh.getFragmentStyle()) != null) {
                DisplayMetrics displayMetrics = SupportWalletFragment.this.FS.getResources().getDisplayMetrics();
                n2 = walletFragmentStyle.a("buyButtonWidth", displayMetrics, n2);
                n3 = walletFragmentStyle.a("buyButtonHeight", displayMetrics, n3);
            }
            button.setLayoutParams(new ViewGroup.LayoutParams(n2, n3));
            button.setOnClickListener((View.OnClickListener)this);
            frameLayout.addView((View)button);
        }

        public void onClick(View view) {
            FragmentActivity fragmentActivity = SupportWalletFragment.this.FS.getActivity();
            int n2 = GooglePlayServicesUtil.isGooglePlayServicesAvailable((Context)fragmentActivity);
            GooglePlayServicesUtil.showErrorDialogFragment(n2, (Activity)fragmentActivity, -1);
        }
    }
}

