/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.wearable;

import android.net.Uri;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import android.util.Log;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.internal.hn;
import com.google.android.gms.wearable.Asset;
import com.google.android.gms.wearable.DataItem;
import com.google.android.gms.wearable.DataItemAsset;
import com.google.android.gms.wearable.e;
import com.google.android.gms.wearable.internal.DataItemAssetParcelable;
import java.security.SecureRandom;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.Set;

public class PutDataRequest
implements SafeParcelable {
    public static final String WEAR_URI_SCHEME = "wear";
    public static final Parcelable.Creator<PutDataRequest> CREATOR = new e();
    private static final Random alk = new SecureRandom();
    final int xJ;
    private final Uri mUri;
    private final Bundle all;
    private byte[] TC;

    PutDataRequest(int versionCode, Uri uri, Bundle assets, byte[] data) {
        this.xJ = versionCode;
        this.mUri = uri;
        this.all = assets;
        this.all.setClassLoader(DataItemAssetParcelable.class.getClassLoader());
        this.TC = data;
    }

    private PutDataRequest(int versionCode, Uri uri) {
        this(versionCode, uri, new Bundle(), null);
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        e.a(this, dest, flags);
    }

    public static PutDataRequest createFromDataItem(DataItem source) {
        PutDataRequest putDataRequest = PutDataRequest.j(source.getUri());
        for (Map.Entry<String, DataItemAsset> entry : source.getAssets().entrySet()) {
            if (entry.getValue().getId() == null) {
                throw new IllegalStateException("Cannot create an asset for a put request without a digest: " + entry.getKey());
            }
            putDataRequest.putAsset(entry.getKey(), Asset.createFromRef(entry.getValue().getId()));
        }
        putDataRequest.setData(source.getData());
        return putDataRequest;
    }

    public static PutDataRequest j(Uri uri) {
        return new PutDataRequest(1, uri);
    }

    public static PutDataRequest createWithAutoAppendedId(String pathPrefix) {
        StringBuilder stringBuilder = new StringBuilder(pathPrefix);
        if (!pathPrefix.endsWith("/")) {
            stringBuilder.append("/");
        }
        stringBuilder.append("PN").append(alk.nextLong());
        Uri uri = PutDataRequest.cx(stringBuilder.toString());
        return new PutDataRequest(1, uri);
    }

    public static PutDataRequest create(String path) {
        Uri uri = PutDataRequest.cx(path);
        return PutDataRequest.j(uri);
    }

    private static Uri cx(String string2) {
        if (TextUtils.isEmpty((CharSequence)string2)) {
            throw new IllegalArgumentException("An empty path was supplied.");
        }
        if (!string2.startsWith("/")) {
            throw new IllegalArgumentException("A path must start with a single / .");
        }
        if (string2.startsWith("//")) {
            throw new IllegalArgumentException("A path must start with a single / .");
        }
        return new Uri.Builder().scheme(WEAR_URI_SCHEME).path(string2).build();
    }

    public Uri getUri() {
        return this.mUri;
    }

    public byte[] getData() {
        return this.TC;
    }

    public PutDataRequest setData(byte[] data) {
        this.TC = data;
        return this;
    }

    public Map<String, Asset> getAssets() {
        HashMap<String, Asset> hashMap = new HashMap<String, Asset>();
        for (String string2 : this.all.keySet()) {
            hashMap.put(string2, (Asset)this.all.getParcelable(string2));
        }
        return Collections.unmodifiableMap(hashMap);
    }

    public Bundle nh() {
        return this.all;
    }

    public Asset getAsset(String key) {
        return (Asset)this.all.getParcelable(key);
    }

    public boolean hasAsset(String key) {
        return this.all.containsKey(key);
    }

    public PutDataRequest putAsset(String key, Asset value) {
        hn.f(key);
        hn.f(value);
        this.all.putParcelable(key, (Parcelable)value);
        return this;
    }

    public PutDataRequest removeAsset(String key) {
        this.all.remove(key);
        return this;
    }

    public String toString() {
        return this.toString(Log.isLoggable((String)"DataMap", (int)3));
    }

    public String toString(boolean verbose) {
        StringBuilder stringBuilder = new StringBuilder("PutDataRequest[");
        stringBuilder.append("dataSz=" + (this.TC == null ? "null" : Integer.valueOf(this.TC.length)));
        stringBuilder.append(", numAssets=" + this.all.size());
        stringBuilder.append(", uri=" + this.mUri);
        if (!verbose) {
            stringBuilder.append("]");
            return stringBuilder.toString();
        }
        stringBuilder.append("]\n  assets: ");
        Set set = this.all.keySet();
        for (String string2 : set) {
            stringBuilder.append("\n    " + string2 + ": " + this.all.getParcelable(string2));
        }
        stringBuilder.append("\n  ]");
        return stringBuilder.toString();
    }
}

