/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import com.google.android.gms.internal.ads.zzbbl;
import com.google.android.gms.internal.ads.zzbbt;
import com.google.android.gms.internal.ads.zzbbu;
import com.google.android.gms.internal.ads.zzbcl;
import com.google.android.gms.internal.ads.zzbcm;
import com.google.android.gms.internal.ads.zzbdf;
import com.google.android.gms.internal.ads.zzbds;
import com.google.android.gms.internal.ads.zzbel;
import com.google.android.gms.internal.ads.zzbfc;
import com.google.android.gms.internal.ads.zzbga;
import com.google.android.gms.internal.ads.zzbgc;
import com.google.android.gms.internal.ads.zzbgg;
import java.io.IOException;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class zzbck
extends zzbbt {
    private static final Logger logger = Logger.getLogger(zzbck.class.getName());
    private static final boolean zzdua = zzbga.zzahm();
    zzbcm zzdub;

    public static zzbck zzq(byte[] byArray) {
        int n = byArray.length;
        byte[] byArray2 = byArray;
        return new zza(byArray2, 0, n);
    }

    public static zzbck zzb(ByteBuffer byteBuffer) {
        if (byteBuffer.hasArray()) {
            return new zzb(byteBuffer);
        }
        if (byteBuffer.isDirect() && !byteBuffer.isReadOnly()) {
            if (zzbga.zzahn()) {
                ByteBuffer byteBuffer2 = byteBuffer;
                return new zze(byteBuffer2);
            }
            ByteBuffer byteBuffer3 = byteBuffer;
            return new zzd(byteBuffer3);
        }
        throw new IllegalArgumentException("ByteBuffer is read-only");
    }

    private zzbck() {
    }

    public abstract void zzl(int var1, int var2) throws IOException;

    public abstract void zzm(int var1, int var2) throws IOException;

    public abstract void zzn(int var1, int var2) throws IOException;

    public final void zzo(int n, int n2) throws IOException {
        this.zzn(n, zzbck.zzcs(n2));
    }

    public abstract void zzp(int var1, int var2) throws IOException;

    public abstract void zza(int var1, long var2) throws IOException;

    public final void zzb(int n, long l) throws IOException {
        this.zza(n, zzbck.zzu(l));
    }

    public abstract void zzc(int var1, long var2) throws IOException;

    public final void zza(int n, float f) throws IOException {
        this.zzp(n, Float.floatToRawIntBits(f));
    }

    public final void zza(int n, double d) throws IOException {
        this.zzc(n, Double.doubleToRawLongBits(d));
    }

    public abstract void zzf(int var1, boolean var2) throws IOException;

    public abstract void zze(int var1, String var2) throws IOException;

    public abstract void zza(int var1, zzbbu var2) throws IOException;

    public abstract void zza(int var1, zzbel var2) throws IOException;

    abstract void zza(int var1, zzbel var2, zzbfc var3) throws IOException;

    public abstract void zzb(int var1, zzbel var2) throws IOException;

    public abstract void zzb(int var1, zzbbu var2) throws IOException;

    public abstract void zzch(int var1) throws IOException;

    public abstract void zzci(int var1) throws IOException;

    public final void zzcj(int n) throws IOException {
        this.zzci(zzbck.zzcs(n));
    }

    public abstract void zzck(int var1) throws IOException;

    public abstract void zzm(long var1) throws IOException;

    public final void zzn(long l) throws IOException {
        this.zzm(zzbck.zzu(l));
    }

    public abstract void zzo(long var1) throws IOException;

    public final void zzc(float f) throws IOException {
        this.zzck(Float.floatToRawIntBits(f));
    }

    public final void zzb(double d) throws IOException {
        this.zzo(Double.doubleToRawLongBits(d));
    }

    public final void zzar(boolean bl) throws IOException {
        this.zzc((byte)(bl ? 1 : 0));
    }

    public abstract void zzes(String var1) throws IOException;

    public abstract void zzan(zzbbu var1) throws IOException;

    public abstract void zze(zzbel var1) throws IOException;

    abstract void zza(zzbel var1, zzbfc var2) throws IOException;

    public abstract void zzc(byte var1) throws IOException;

    public abstract void write(byte[] var1, int var2, int var3) throws IOException;

    public static int zzq(int n, int n2) {
        return zzbck.zzcl(n) + zzbck.zzcm(n2);
    }

    public static int zzr(int n, int n2) {
        return zzbck.zzcl(n) + zzbck.zzcn(n2);
    }

    public static int zzs(int n, int n2) {
        return zzbck.zzcl(n) + zzbck.zzcn(zzbck.zzcs(n2));
    }

    public static int zzt(int n, int n2) {
        return zzbck.zzcl(n) + 4;
    }

    public static int zzu(int n, int n2) {
        return zzbck.zzcl(n) + 4;
    }

    public static int zzd(int n, long l) {
        return zzbck.zzcl(n) + zzbck.zzq(l);
    }

    public static int zze(int n, long l) {
        return zzbck.zzcl(n) + zzbck.zzq(l);
    }

    public static int zzf(int n, long l) {
        return zzbck.zzcl(n) + zzbck.zzq(zzbck.zzu(l));
    }

    public static int zzg(int n, long l) {
        return zzbck.zzcl(n) + 8;
    }

    public static int zzh(int n, long l) {
        return zzbck.zzcl(n) + 8;
    }

    public static int zzb(int n, float f) {
        return zzbck.zzcl(n) + 4;
    }

    public static int zzb(int n, double d) {
        return zzbck.zzcl(n) + 8;
    }

    public static int zzg(int n, boolean bl) {
        return zzbck.zzcl(n) + 1;
    }

    public static int zzv(int n, int n2) {
        return zzbck.zzcl(n) + zzbck.zzcm(n2);
    }

    public static int zzf(int n, String string) {
        return zzbck.zzcl(n) + zzbck.zzet(string);
    }

    public static int zzc(int n, zzbbu zzbbu2) {
        int n2 = zzbbu2.size();
        return zzbck.zzcl(n) + (zzbck.zzcn(n2) + n2);
    }

    public static int zza(int n, zzbds zzbds2) {
        int n2 = zzbds2.zzaet();
        return zzbck.zzcl(n) + (zzbck.zzcn(n2) + n2);
    }

    public static int zzc(int n, zzbel zzbel2) {
        return zzbck.zzcl(n) + zzbck.zzf(zzbel2);
    }

    static int zzb(int n, zzbel zzbel2, zzbfc zzbfc2) {
        return zzbck.zzcl(n) + zzbck.zzb(zzbel2, zzbfc2);
    }

    public static int zzd(int n, zzbel zzbel2) {
        return (zzbck.zzcl(1) << 1) + zzbck.zzr(2, n) + zzbck.zzc(3, zzbel2);
    }

    public static int zzd(int n, zzbbu zzbbu2) {
        return (zzbck.zzcl(1) << 1) + zzbck.zzr(2, n) + zzbck.zzc(3, zzbbu2);
    }

    public static int zzb(int n, zzbds zzbds2) {
        return (zzbck.zzcl(1) << 1) + zzbck.zzr(2, n) + zzbck.zza(3, zzbds2);
    }

    public static int zzcl(int n) {
        return zzbck.zzcn(n << 3);
    }

    public static int zzcm(int n) {
        if (n >= 0) {
            return zzbck.zzcn(n);
        }
        return 10;
    }

    public static int zzcn(int n) {
        if ((n & 0xFFFFFF80) == 0) {
            return 1;
        }
        if ((n & 0xFFFFC000) == 0) {
            return 2;
        }
        if ((n & 0xFFE00000) == 0) {
            return 3;
        }
        if ((n & 0xF0000000) == 0) {
            return 4;
        }
        return 5;
    }

    public static int zzco(int n) {
        return zzbck.zzcn(zzbck.zzcs(n));
    }

    public static int zzcp(int n) {
        return 4;
    }

    public static int zzcq(int n) {
        return 4;
    }

    public static int zzp(long l) {
        return zzbck.zzq(l);
    }

    public static int zzq(long l) {
        if ((l & 0xFFFFFFFFFFFFFF80L) == 0L) {
            return 1;
        }
        if (l < 0L) {
            return 10;
        }
        int n = 2;
        if ((l & 0xFFFFFFF800000000L) != 0L) {
            n += 4;
            l >>>= 28;
        }
        if ((l & 0xFFFFFFFFFFE00000L) != 0L) {
            n += 2;
            l >>>= 14;
        }
        if ((l & 0xFFFFFFFFFFFFC000L) != 0L) {
            ++n;
        }
        return n;
    }

    public static int zzr(long l) {
        return zzbck.zzq(zzbck.zzu(l));
    }

    public static int zzs(long l) {
        return 8;
    }

    public static int zzt(long l) {
        return 8;
    }

    public static int zzd(float f) {
        return 4;
    }

    public static int zzc(double d) {
        return 8;
    }

    public static int zzas(boolean bl) {
        return 1;
    }

    public static int zzcr(int n) {
        return zzbck.zzcm(n);
    }

    public static int zzet(String string) {
        int n;
        try {
            n = zzbgc.zza(string);
        }
        catch (zzbgg zzbgg2) {
            n = string.getBytes(zzbdf.UTF_8).length;
        }
        int n2 = n;
        return zzbck.zzcn(n2) + n2;
    }

    public static int zza(zzbds zzbds2) {
        int n = zzbds2.zzaet();
        return zzbck.zzcn(n) + n;
    }

    public static int zzao(zzbbu zzbbu2) {
        int n = zzbbu2.size();
        return zzbck.zzcn(n) + n;
    }

    public static int zzr(byte[] byArray) {
        int n = byArray.length;
        return zzbck.zzcn(n) + n;
    }

    public static int zzf(zzbel zzbel2) {
        int n = zzbel2.zzaet();
        return zzbck.zzcn(n) + n;
    }

    static int zzb(zzbel zzbel2, zzbfc zzbfc2) {
        zzbfc zzbfc3 = zzbfc2;
        zzbbl zzbbl2 = (zzbbl)zzbel2;
        int n = zzbbl2.zzacq();
        if (n == -1) {
            n = zzbfc3.zzz(zzbbl2);
            zzbbl2.zzbq(n);
        }
        int n2 = n;
        return zzbck.zzcn(n2) + n2;
    }

    private static int zzcs(int n) {
        return n << 1 ^ n >> 31;
    }

    private static long zzu(long l) {
        return l << 1 ^ l >> 63;
    }

    public abstract void flush() throws IOException;

    public abstract int zzaee();

    public final void zzaef() {
        if (this.zzaee() != 0) {
            throw new IllegalStateException("Did not write as much data as expected.");
        }
    }

    abstract void zzg(byte[] var1, int var2, int var3) throws IOException;

    final void zza(String string, zzbgg zzbgg2) throws IOException {
        logger.logp(Level.WARNING, "com.google.protobuf.CodedOutputStream", "inefficientWriteStringNoTag", "Converting ill-formed UTF-16. Your Protocol Buffer will not round trip correctly!", zzbgg2);
        byte[] byArray = string.getBytes(zzbdf.UTF_8);
        try {
            this.zzci(byArray.length);
            this.zzc(byArray, 0, byArray.length);
            return;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new zzc(indexOutOfBoundsException);
        }
        catch (zzc zzc2) {
            throw zzc2;
        }
    }

    @Deprecated
    static int zzc(int n, zzbel zzbel2, zzbfc zzbfc2) {
        zzbfc zzbfc3;
        int n2 = zzbck.zzcl(n) << 1;
        zzbfc zzbfc4 = zzbfc3 = zzbfc2;
        zzbbl zzbbl2 = (zzbbl)zzbel2;
        int n3 = zzbbl2.zzacq();
        if (n3 == -1) {
            n3 = zzbfc4.zzz(zzbbl2);
            zzbbl2.zzbq(n3);
        }
        return n2 + n3;
    }

    @Deprecated
    public static int zzg(zzbel zzbel2) {
        return zzbel2.zzaet();
    }

    @Deprecated
    public static int zzct(int n) {
        return zzbck.zzcn(n);
    }

    /* synthetic */ zzbck(zzbcl zzbcl2) {
        this();
    }

    static final class zze
    extends zzbck {
        private final ByteBuffer zzdue;
        private final ByteBuffer zzduf;
        private final long zzdug;
        private final long zzduh;
        private final long zzdui;
        private final long zzduj;
        private long zzduk;

        zze(ByteBuffer byteBuffer) {
            super(null);
            this.zzdue = byteBuffer;
            this.zzduf = byteBuffer.duplicate().order(ByteOrder.LITTLE_ENDIAN);
            this.zzdug = zzbga.zzc(byteBuffer);
            this.zzduh = this.zzdug + (long)byteBuffer.position();
            this.zzdui = this.zzdug + (long)byteBuffer.limit();
            this.zzduj = this.zzdui - 10L;
            this.zzduk = this.zzduh;
        }

        @Override
        public final void zzl(int n, int n2) throws IOException {
            int n3 = n2;
            ((zzbck)this).zzci(n << 3 | n3);
        }

        @Override
        public final void zzm(int n, int n2) throws IOException {
            ((zzbck)this).zzl(n, 0);
            ((zzbck)this).zzch(n2);
        }

        @Override
        public final void zzn(int n, int n2) throws IOException {
            ((zzbck)this).zzl(n, 0);
            ((zzbck)this).zzci(n2);
        }

        @Override
        public final void zzp(int n, int n2) throws IOException {
            ((zzbck)this).zzl(n, 5);
            ((zzbck)this).zzck(n2);
        }

        @Override
        public final void zza(int n, long l) throws IOException {
            ((zzbck)this).zzl(n, 0);
            ((zzbck)this).zzm(l);
        }

        @Override
        public final void zzc(int n, long l) throws IOException {
            ((zzbck)this).zzl(n, 1);
            ((zzbck)this).zzo(l);
        }

        @Override
        public final void zzf(int n, boolean bl) throws IOException {
            ((zzbck)this).zzl(n, 0);
            ((zzbck)this).zzc((byte)(bl ? 1 : 0));
        }

        @Override
        public final void zze(int n, String string) throws IOException {
            ((zzbck)this).zzl(n, 2);
            ((zzbck)this).zzes(string);
        }

        @Override
        public final void zza(int n, zzbbu zzbbu2) throws IOException {
            ((zzbck)this).zzl(n, 2);
            ((zzbck)this).zzan(zzbbu2);
        }

        @Override
        public final void zza(int n, zzbel zzbel2) throws IOException {
            ((zzbck)this).zzl(n, 2);
            ((zzbck)this).zze(zzbel2);
        }

        @Override
        final void zza(int n, zzbel zzbel2, zzbfc zzbfc2) throws IOException {
            ((zzbck)this).zzl(n, 2);
            ((zzbck)this).zza(zzbel2, zzbfc2);
        }

        @Override
        public final void zzb(int n, zzbel zzbel2) throws IOException {
            ((zzbck)this).zzl(1, 3);
            ((zzbck)this).zzn(2, n);
            ((zzbck)this).zza(3, zzbel2);
            ((zzbck)this).zzl(1, 4);
        }

        @Override
        public final void zzb(int n, zzbbu zzbbu2) throws IOException {
            ((zzbck)this).zzl(1, 3);
            ((zzbck)this).zzn(2, n);
            ((zzbck)this).zza(3, zzbbu2);
            ((zzbck)this).zzl(1, 4);
        }

        @Override
        public final void zze(zzbel zzbel2) throws IOException {
            ((zzbck)this).zzci(zzbel2.zzaet());
            zzbel2.zzb(this);
        }

        @Override
        final void zza(zzbel zzbel2, zzbfc zzbfc2) throws IOException {
            zzbfc zzbfc3 = zzbfc2;
            zzbbl zzbbl2 = (zzbbl)zzbel2;
            int n = zzbbl2.zzacq();
            if (n == -1) {
                n = zzbfc3.zzz(zzbbl2);
                zzbbl2.zzbq(n);
            }
            ((zzbck)this).zzci(n);
            zzbfc2.zza(zzbel2, this.zzdub);
        }

        @Override
        public final void zzc(byte by) throws IOException {
            if (this.zzduk >= this.zzdui) {
                throw new zzc(String.format("Pos: %d, limit: %d, len: %d", this.zzduk, this.zzdui, 1));
            }
            zzbga.zza(this.zzduk++, by);
        }

        @Override
        public final void zzan(zzbbu zzbbu2) throws IOException {
            ((zzbck)this).zzci(zzbbu2.size());
            zzbbu2.zza(this);
        }

        @Override
        public final void zzg(byte[] byArray, int n, int n2) throws IOException {
            ((zzbck)this).zzci(n2);
            ((zzbck)this).write(byArray, 0, n2);
        }

        @Override
        public final void zzch(int n) throws IOException {
            if (n >= 0) {
                ((zzbck)this).zzci(n);
                return;
            }
            ((zzbck)this).zzm(n);
        }

        @Override
        public final void zzci(int n) throws IOException {
            if (this.zzduk <= this.zzduj) {
                while (true) {
                    if ((n & 0xFFFFFF80) == 0) {
                        zzbga.zza(this.zzduk++, (byte)n);
                        return;
                    }
                    zzbga.zza(this.zzduk++, (byte)(n & 0x7F | 0x80));
                    n >>>= 7;
                }
            }
            while (this.zzduk < this.zzdui) {
                if ((n & 0xFFFFFF80) == 0) {
                    zzbga.zza(this.zzduk++, (byte)n);
                    return;
                }
                zzbga.zza(this.zzduk++, (byte)(n & 0x7F | 0x80));
                n >>>= 7;
            }
            throw new zzc(String.format("Pos: %d, limit: %d, len: %d", this.zzduk, this.zzdui, 1));
        }

        @Override
        public final void zzck(int n) throws IOException {
            long l = this.zzduk;
            zze zze2 = this;
            this.zzduf.putInt((int)(l - zze2.zzdug), n);
            this.zzduk += 4L;
        }

        @Override
        public final void zzm(long l) throws IOException {
            if (this.zzduk <= this.zzduj) {
                while (true) {
                    if ((l & 0xFFFFFFFFFFFFFF80L) == 0L) {
                        zzbga.zza(this.zzduk++, (byte)l);
                        return;
                    }
                    zzbga.zza(this.zzduk++, (byte)((int)l & 0x7F | 0x80));
                    l >>>= 7;
                }
            }
            while (this.zzduk < this.zzdui) {
                if ((l & 0xFFFFFFFFFFFFFF80L) == 0L) {
                    zzbga.zza(this.zzduk++, (byte)l);
                    return;
                }
                zzbga.zza(this.zzduk++, (byte)((int)l & 0x7F | 0x80));
                l >>>= 7;
            }
            throw new zzc(String.format("Pos: %d, limit: %d, len: %d", this.zzduk, this.zzdui, 1));
        }

        @Override
        public final void zzo(long l) throws IOException {
            long l2 = this.zzduk;
            zze zze2 = this;
            this.zzduf.putLong((int)(l2 - zze2.zzdug), l);
            this.zzduk += 8L;
        }

        @Override
        public final void write(byte[] byArray, int n, int n2) throws IOException {
            if (byArray == null || n < 0 || n2 < 0 || byArray.length - n2 < n || this.zzdui - (long)n2 < this.zzduk) {
                if (byArray == null) {
                    throw new NullPointerException("value");
                }
                throw new zzc(String.format("Pos: %d, limit: %d, len: %d", this.zzduk, this.zzdui, n2));
            }
            zzbga.zza(byArray, n, this.zzduk, n2);
            this.zzduk += (long)n2;
        }

        @Override
        public final void zzc(byte[] byArray, int n, int n2) throws IOException {
            ((zzbck)this).write(byArray, n, n2);
        }

        @Override
        public final void zzes(String string) throws IOException {
            long l = this.zzduk;
            try {
                int n = zze.zzcn(string.length() * 3);
                int n2 = zze.zzcn(string.length());
                if (n2 == n) {
                    long l2 = this.zzduk;
                    zze zze2 = this;
                    int n3 = (int)(l2 - zze2.zzdug) + n2;
                    this.zzduf.position(n3);
                    zzbgc.zza(string, this.zzduf);
                    int n4 = this.zzduf.position() - n3;
                    ((zzbck)this).zzci(n4);
                    this.zzduk += (long)n4;
                    return;
                }
                int n5 = zzbgc.zza(string);
                ((zzbck)this).zzci(n5);
                this.zzv(this.zzduk);
                zzbgc.zza(string, this.zzduf);
                this.zzduk += (long)n5;
                return;
            }
            catch (zzbgg zzbgg2) {
                this.zzduk = l;
                this.zzv(this.zzduk);
                this.zza(string, zzbgg2);
                return;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new zzc(illegalArgumentException);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new zzc(indexOutOfBoundsException);
            }
        }

        @Override
        public final void flush() {
            long l = this.zzduk;
            zze zze2 = this;
            this.zzdue.position((int)(l - zze2.zzdug));
        }

        @Override
        public final int zzaee() {
            return (int)(this.zzdui - this.zzduk);
        }

        private final void zzv(long l) {
            long l2 = l;
            zze zze2 = this;
            this.zzduf.position((int)(l2 - zze2.zzdug));
        }
    }

    static final class zzd
    extends zzbck {
        private final ByteBuffer zzdue;
        private final ByteBuffer zzduf;
        private final int zzdud;

        zzd(ByteBuffer byteBuffer) {
            super(null);
            this.zzdue = byteBuffer;
            this.zzduf = byteBuffer.duplicate().order(ByteOrder.LITTLE_ENDIAN);
            this.zzdud = byteBuffer.position();
        }

        @Override
        public final void zzl(int n, int n2) throws IOException {
            int n3 = n2;
            ((zzbck)this).zzci(n << 3 | n3);
        }

        @Override
        public final void zzm(int n, int n2) throws IOException {
            ((zzbck)this).zzl(n, 0);
            ((zzbck)this).zzch(n2);
        }

        @Override
        public final void zzn(int n, int n2) throws IOException {
            ((zzbck)this).zzl(n, 0);
            ((zzbck)this).zzci(n2);
        }

        @Override
        public final void zzp(int n, int n2) throws IOException {
            ((zzbck)this).zzl(n, 5);
            ((zzbck)this).zzck(n2);
        }

        @Override
        public final void zza(int n, long l) throws IOException {
            ((zzbck)this).zzl(n, 0);
            ((zzbck)this).zzm(l);
        }

        @Override
        public final void zzc(int n, long l) throws IOException {
            ((zzbck)this).zzl(n, 1);
            ((zzbck)this).zzo(l);
        }

        @Override
        public final void zzf(int n, boolean bl) throws IOException {
            ((zzbck)this).zzl(n, 0);
            ((zzbck)this).zzc((byte)(bl ? 1 : 0));
        }

        @Override
        public final void zze(int n, String string) throws IOException {
            ((zzbck)this).zzl(n, 2);
            ((zzbck)this).zzes(string);
        }

        @Override
        public final void zza(int n, zzbbu zzbbu2) throws IOException {
            ((zzbck)this).zzl(n, 2);
            ((zzbck)this).zzan(zzbbu2);
        }

        @Override
        public final void zza(int n, zzbel zzbel2) throws IOException {
            ((zzbck)this).zzl(n, 2);
            ((zzbck)this).zze(zzbel2);
        }

        @Override
        final void zza(int n, zzbel zzbel2, zzbfc zzbfc2) throws IOException {
            ((zzbck)this).zzl(n, 2);
            ((zzbck)this).zza(zzbel2, zzbfc2);
        }

        @Override
        public final void zzb(int n, zzbel zzbel2) throws IOException {
            ((zzbck)this).zzl(1, 3);
            ((zzbck)this).zzn(2, n);
            ((zzbck)this).zza(3, zzbel2);
            ((zzbck)this).zzl(1, 4);
        }

        @Override
        public final void zzb(int n, zzbbu zzbbu2) throws IOException {
            ((zzbck)this).zzl(1, 3);
            ((zzbck)this).zzn(2, n);
            ((zzbck)this).zza(3, zzbbu2);
            ((zzbck)this).zzl(1, 4);
        }

        @Override
        public final void zze(zzbel zzbel2) throws IOException {
            ((zzbck)this).zzci(zzbel2.zzaet());
            zzbel2.zzb(this);
        }

        @Override
        final void zza(zzbel zzbel2, zzbfc zzbfc2) throws IOException {
            zzbfc zzbfc3 = zzbfc2;
            zzbbl zzbbl2 = (zzbbl)zzbel2;
            int n = zzbbl2.zzacq();
            if (n == -1) {
                n = zzbfc3.zzz(zzbbl2);
                zzbbl2.zzbq(n);
            }
            ((zzbck)this).zzci(n);
            zzbfc2.zza(zzbel2, this.zzdub);
        }

        @Override
        public final void zzc(byte by) throws IOException {
            try {
                this.zzduf.put(by);
                return;
            }
            catch (BufferOverflowException bufferOverflowException) {
                throw new zzc(bufferOverflowException);
            }
        }

        @Override
        public final void zzan(zzbbu zzbbu2) throws IOException {
            ((zzbck)this).zzci(zzbbu2.size());
            zzbbu2.zza(this);
        }

        @Override
        public final void zzg(byte[] byArray, int n, int n2) throws IOException {
            ((zzbck)this).zzci(n2);
            ((zzbck)this).write(byArray, 0, n2);
        }

        @Override
        public final void zzch(int n) throws IOException {
            if (n >= 0) {
                ((zzbck)this).zzci(n);
                return;
            }
            ((zzbck)this).zzm(n);
        }

        @Override
        public final void zzci(int n) throws IOException {
            try {
                while (true) {
                    if ((n & 0xFFFFFF80) == 0) {
                        this.zzduf.put((byte)n);
                        return;
                    }
                    this.zzduf.put((byte)(n & 0x7F | 0x80));
                    n >>>= 7;
                }
            }
            catch (BufferOverflowException bufferOverflowException) {
                throw new zzc(bufferOverflowException);
            }
        }

        @Override
        public final void zzck(int n) throws IOException {
            try {
                this.zzduf.putInt(n);
                return;
            }
            catch (BufferOverflowException bufferOverflowException) {
                throw new zzc(bufferOverflowException);
            }
        }

        @Override
        public final void zzm(long l) throws IOException {
            try {
                while (true) {
                    if ((l & 0xFFFFFFFFFFFFFF80L) == 0L) {
                        this.zzduf.put((byte)l);
                        return;
                    }
                    this.zzduf.put((byte)((int)l & 0x7F | 0x80));
                    l >>>= 7;
                }
            }
            catch (BufferOverflowException bufferOverflowException) {
                throw new zzc(bufferOverflowException);
            }
        }

        @Override
        public final void zzo(long l) throws IOException {
            try {
                this.zzduf.putLong(l);
                return;
            }
            catch (BufferOverflowException bufferOverflowException) {
                throw new zzc(bufferOverflowException);
            }
        }

        @Override
        public final void write(byte[] byArray, int n, int n2) throws IOException {
            try {
                this.zzduf.put(byArray, n, n2);
                return;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new zzc(indexOutOfBoundsException);
            }
            catch (BufferOverflowException bufferOverflowException) {
                throw new zzc(bufferOverflowException);
            }
        }

        @Override
        public final void zzc(byte[] byArray, int n, int n2) throws IOException {
            ((zzbck)this).write(byArray, n, n2);
        }

        @Override
        public final void zzes(String string) throws IOException {
            int n = this.zzduf.position();
            try {
                int n2 = zzd.zzcn(string.length() * 3);
                int n3 = zzd.zzcn(string.length());
                if (n3 == n2) {
                    int n4 = this.zzduf.position() + n3;
                    this.zzduf.position(n4);
                    this.zzeu(string);
                    int n5 = this.zzduf.position();
                    this.zzduf.position(n);
                    ((zzbck)this).zzci(n5 - n4);
                    this.zzduf.position(n5);
                    return;
                }
                int n6 = zzbgc.zza(string);
                ((zzbck)this).zzci(n6);
                this.zzeu(string);
                return;
            }
            catch (zzbgg zzbgg2) {
                this.zzduf.position(n);
                this.zza(string, zzbgg2);
                return;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new zzc(illegalArgumentException);
            }
        }

        @Override
        public final void flush() {
            this.zzdue.position(this.zzduf.position());
        }

        @Override
        public final int zzaee() {
            return this.zzduf.remaining();
        }

        private final void zzeu(String string) throws IOException {
            try {
                zzbgc.zza(string, this.zzduf);
                return;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new zzc(indexOutOfBoundsException);
            }
        }
    }

    static final class zzb
    extends zza {
        private final ByteBuffer zzduc;
        private int zzdud;

        zzb(ByteBuffer byteBuffer) {
            super(byteBuffer.array(), byteBuffer.arrayOffset() + byteBuffer.position(), byteBuffer.remaining());
            this.zzduc = byteBuffer;
            this.zzdud = byteBuffer.position();
        }

        @Override
        public final void flush() {
            this.zzduc.position(this.zzdud + this.zzaeh());
        }
    }

    static class zza
    extends zzbck {
        private final byte[] buffer;
        private final int offset;
        private final int limit;
        private int position;

        zza(byte[] byArray, int n, int n2) {
            super(null);
            if (byArray == null) {
                throw new NullPointerException("buffer");
            }
            if ((n | n2 | byArray.length - (n + n2)) < 0) {
                throw new IllegalArgumentException(String.format("Array range is invalid. Buffer.length=%d, offset=%d, length=%d", byArray.length, n, n2));
            }
            this.buffer = byArray;
            this.offset = n;
            this.position = n;
            this.limit = n + n2;
        }

        @Override
        public final void zzl(int n, int n2) throws IOException {
            int n3 = n2;
            ((zzbck)this).zzci(n << 3 | n3);
        }

        @Override
        public final void zzm(int n, int n2) throws IOException {
            ((zzbck)this).zzl(n, 0);
            ((zzbck)this).zzch(n2);
        }

        @Override
        public final void zzn(int n, int n2) throws IOException {
            ((zzbck)this).zzl(n, 0);
            ((zzbck)this).zzci(n2);
        }

        @Override
        public final void zzp(int n, int n2) throws IOException {
            ((zzbck)this).zzl(n, 5);
            ((zzbck)this).zzck(n2);
        }

        @Override
        public final void zza(int n, long l) throws IOException {
            ((zzbck)this).zzl(n, 0);
            ((zzbck)this).zzm(l);
        }

        @Override
        public final void zzc(int n, long l) throws IOException {
            ((zzbck)this).zzl(n, 1);
            ((zzbck)this).zzo(l);
        }

        @Override
        public final void zzf(int n, boolean bl) throws IOException {
            ((zzbck)this).zzl(n, 0);
            ((zzbck)this).zzc((byte)(bl ? 1 : 0));
        }

        @Override
        public final void zze(int n, String string) throws IOException {
            ((zzbck)this).zzl(n, 2);
            ((zzbck)this).zzes(string);
        }

        @Override
        public final void zza(int n, zzbbu zzbbu2) throws IOException {
            ((zzbck)this).zzl(n, 2);
            ((zzbck)this).zzan(zzbbu2);
        }

        @Override
        public final void zzan(zzbbu zzbbu2) throws IOException {
            ((zzbck)this).zzci(zzbbu2.size());
            zzbbu2.zza(this);
        }

        @Override
        public final void zzg(byte[] byArray, int n, int n2) throws IOException {
            ((zzbck)this).zzci(n2);
            ((zzbck)this).write(byArray, 0, n2);
        }

        @Override
        public final void zza(int n, zzbel zzbel2) throws IOException {
            ((zzbck)this).zzl(n, 2);
            ((zzbck)this).zze(zzbel2);
        }

        @Override
        final void zza(int n, zzbel zzbel2, zzbfc zzbfc2) throws IOException {
            ((zzbck)this).zzl(n, 2);
            zzbfc zzbfc3 = zzbfc2;
            zzbbl zzbbl2 = (zzbbl)zzbel2;
            int n2 = zzbbl2.zzacq();
            if (n2 == -1) {
                n2 = zzbfc3.zzz(zzbbl2);
                zzbbl2.zzbq(n2);
            }
            ((zzbck)this).zzci(n2);
            zzbfc2.zza(zzbel2, this.zzdub);
        }

        @Override
        public final void zzb(int n, zzbel zzbel2) throws IOException {
            ((zzbck)this).zzl(1, 3);
            ((zzbck)this).zzn(2, n);
            ((zzbck)this).zza(3, zzbel2);
            ((zzbck)this).zzl(1, 4);
        }

        @Override
        public final void zzb(int n, zzbbu zzbbu2) throws IOException {
            ((zzbck)this).zzl(1, 3);
            ((zzbck)this).zzn(2, n);
            ((zzbck)this).zza(3, zzbbu2);
            ((zzbck)this).zzl(1, 4);
        }

        @Override
        public final void zze(zzbel zzbel2) throws IOException {
            ((zzbck)this).zzci(zzbel2.zzaet());
            zzbel2.zzb(this);
        }

        @Override
        final void zza(zzbel zzbel2, zzbfc zzbfc2) throws IOException {
            zzbfc zzbfc3 = zzbfc2;
            zzbbl zzbbl2 = (zzbbl)zzbel2;
            int n = zzbbl2.zzacq();
            if (n == -1) {
                n = zzbfc3.zzz(zzbbl2);
                zzbbl2.zzbq(n);
            }
            ((zzbck)this).zzci(n);
            zzbfc2.zza(zzbel2, this.zzdub);
        }

        @Override
        public final void zzc(byte by) throws IOException {
            try {
                this.buffer[this.position++] = by;
                return;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new zzc(String.format("Pos: %d, limit: %d, len: %d", this.position, this.limit, 1), indexOutOfBoundsException);
            }
        }

        @Override
        public final void zzch(int n) throws IOException {
            if (n >= 0) {
                ((zzbck)this).zzci(n);
                return;
            }
            ((zzbck)this).zzm(n);
        }

        @Override
        public final void zzci(int n) throws IOException {
            if (zzdua && ((zzbck)this).zzaee() >= 10) {
                while (true) {
                    if ((n & 0xFFFFFF80) == 0) {
                        zzbga.zza(this.buffer, (long)this.position++, (byte)n);
                        return;
                    }
                    zzbga.zza(this.buffer, (long)this.position++, (byte)(n & 0x7F | 0x80));
                    n >>>= 7;
                }
            }
            try {
                while (true) {
                    if ((n & 0xFFFFFF80) == 0) {
                        this.buffer[this.position++] = (byte)n;
                        return;
                    }
                    this.buffer[this.position++] = (byte)(n & 0x7F | 0x80);
                    n >>>= 7;
                }
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new zzc(String.format("Pos: %d, limit: %d, len: %d", this.position, this.limit, 1), indexOutOfBoundsException);
            }
        }

        @Override
        public final void zzck(int n) throws IOException {
            try {
                this.buffer[this.position++] = (byte)n;
                this.buffer[this.position++] = (byte)(n >> 8);
                this.buffer[this.position++] = (byte)(n >> 16);
                this.buffer[this.position++] = n >> 24;
                return;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new zzc(String.format("Pos: %d, limit: %d, len: %d", this.position, this.limit, 1), indexOutOfBoundsException);
            }
        }

        @Override
        public final void zzm(long l) throws IOException {
            if (zzdua && ((zzbck)this).zzaee() >= 10) {
                while (true) {
                    if ((l & 0xFFFFFFFFFFFFFF80L) == 0L) {
                        zzbga.zza(this.buffer, (long)this.position++, (byte)l);
                        return;
                    }
                    zzbga.zza(this.buffer, (long)this.position++, (byte)((int)l & 0x7F | 0x80));
                    l >>>= 7;
                }
            }
            try {
                while (true) {
                    if ((l & 0xFFFFFFFFFFFFFF80L) == 0L) {
                        this.buffer[this.position++] = (byte)l;
                        return;
                    }
                    this.buffer[this.position++] = (byte)((int)l & 0x7F | 0x80);
                    l >>>= 7;
                }
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new zzc(String.format("Pos: %d, limit: %d, len: %d", this.position, this.limit, 1), indexOutOfBoundsException);
            }
        }

        @Override
        public final void zzo(long l) throws IOException {
            try {
                this.buffer[this.position++] = (byte)l;
                this.buffer[this.position++] = (byte)(l >> 8);
                this.buffer[this.position++] = (byte)(l >> 16);
                this.buffer[this.position++] = (byte)(l >> 24);
                this.buffer[this.position++] = (byte)(l >> 32);
                this.buffer[this.position++] = (byte)(l >> 40);
                this.buffer[this.position++] = (byte)(l >> 48);
                this.buffer[this.position++] = (byte)(l >> 56);
                return;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new zzc(String.format("Pos: %d, limit: %d, len: %d", this.position, this.limit, 1), indexOutOfBoundsException);
            }
        }

        @Override
        public final void write(byte[] byArray, int n, int n2) throws IOException {
            try {
                System.arraycopy(byArray, n, this.buffer, this.position, n2);
                this.position += n2;
                return;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new zzc(String.format("Pos: %d, limit: %d, len: %d", this.position, this.limit, n2), indexOutOfBoundsException);
            }
        }

        @Override
        public final void zzc(byte[] byArray, int n, int n2) throws IOException {
            ((zzbck)this).write(byArray, n, n2);
        }

        @Override
        public final void zzes(String string) throws IOException {
            int n = this.position;
            try {
                int n2 = zza.zzcn(string.length() * 3);
                int n3 = zza.zzcn(string.length());
                if (n3 == n2) {
                    this.position = n + n3;
                    int n4 = zzbgc.zza(string, this.buffer, this.position, ((zzbck)this).zzaee());
                    this.position = n;
                    int n5 = n4 - n - n3;
                    ((zzbck)this).zzci(n5);
                    this.position = n4;
                    return;
                }
                int n6 = zzbgc.zza(string);
                ((zzbck)this).zzci(n6);
                this.position = zzbgc.zza(string, this.buffer, this.position, ((zzbck)this).zzaee());
                return;
            }
            catch (zzbgg zzbgg2) {
                this.position = n;
                this.zza(string, zzbgg2);
                return;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new zzc(indexOutOfBoundsException);
            }
        }

        @Override
        public void flush() {
        }

        @Override
        public final int zzaee() {
            return this.limit - this.position;
        }

        public final int zzaeh() {
            return this.position - this.offset;
        }
    }

    public static final class zzc
    extends IOException {
        zzc() {
            super("CodedOutputStream was writing to a flat byte array and ran out of space.");
        }

        zzc(String string) {
            String string2 = String.valueOf("CodedOutputStream was writing to a flat byte array and ran out of space.: ");
            String string3 = String.valueOf(string);
            super(string3.length() != 0 ? string2.concat(string3) : new String(string2));
        }

        zzc(Throwable throwable) {
            super("CodedOutputStream was writing to a flat byte array and ran out of space.", throwable);
        }

        zzc(String string, Throwable throwable) {
            String string2 = String.valueOf("CodedOutputStream was writing to a flat byte array and ran out of space.: ");
            String string3 = String.valueOf(string);
            super(string3.length() != 0 ? string2.concat(string3) : new String(string2), throwable);
        }
    }
}

