/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import com.google.android.gms.internal.ads.zzbpl;
import com.google.android.gms.internal.ads.zzbpt;
import com.google.android.gms.internal.ads.zzbpu;
import com.google.android.gms.internal.ads.zzbql;
import com.google.android.gms.internal.ads.zzbqm;
import com.google.android.gms.internal.ads.zzbrf;
import com.google.android.gms.internal.ads.zzbrs;
import com.google.android.gms.internal.ads.zzbsl;
import com.google.android.gms.internal.ads.zzbtc;
import com.google.android.gms.internal.ads.zzbua;
import com.google.android.gms.internal.ads.zzbuc;
import com.google.android.gms.internal.ads.zzbug;
import java.io.IOException;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class zzbqk
extends zzbpt {
    private static final Logger logger = Logger.getLogger(zzbqk.class.getName());
    private static final boolean zzfme = zzbua.zzapc();
    zzbqm zzfmf;

    public static zzbqk zzt(byte[] byArray) {
        int n = byArray.length;
        byte[] byArray2 = byArray;
        return new zza(byArray2, 0, n);
    }

    public static zzbqk zzn(ByteBuffer byteBuffer) {
        if (byteBuffer.hasArray()) {
            return new zzb(byteBuffer);
        }
        if (byteBuffer.isDirect() && !byteBuffer.isReadOnly()) {
            if (zzbua.zzapd()) {
                ByteBuffer byteBuffer2 = byteBuffer;
                return new zze(byteBuffer2);
            }
            ByteBuffer byteBuffer3 = byteBuffer;
            return new zzd(byteBuffer3);
        }
        throw new IllegalArgumentException("ByteBuffer is read-only");
    }

    private zzbqk() {
    }

    public abstract void zzu(int var1, int var2) throws IOException;

    public abstract void zzv(int var1, int var2) throws IOException;

    public abstract void zzw(int var1, int var2) throws IOException;

    public final void zzx(int n, int n2) throws IOException {
        this.zzw(n, zzbqk.zzfk(n2));
    }

    public abstract void zzy(int var1, int var2) throws IOException;

    public abstract void zzj(int var1, long var2) throws IOException;

    public final void zzk(int n, long l) throws IOException {
        this.zzj(n, zzbqk.zzbg(l));
    }

    public abstract void zzl(int var1, long var2) throws IOException;

    public final void zza(int n, float f) throws IOException {
        this.zzy(n, Float.floatToRawIntBits(f));
    }

    public final void zzb(int n, double d) throws IOException {
        this.zzl(n, Double.doubleToRawLongBits(d));
    }

    public abstract void zzj(int var1, boolean var2) throws IOException;

    public abstract void zzf(int var1, String var2) throws IOException;

    public abstract void zza(int var1, zzbpu var2) throws IOException;

    public abstract void zza(int var1, zzbsl var2) throws IOException;

    abstract void zza(int var1, zzbsl var2, zzbtc var3) throws IOException;

    public abstract void zzb(int var1, zzbsl var2) throws IOException;

    public abstract void zzb(int var1, zzbpu var2) throws IOException;

    public abstract void zzez(int var1) throws IOException;

    public abstract void zzfa(int var1) throws IOException;

    public final void zzfb(int n) throws IOException {
        this.zzfa(zzbqk.zzfk(n));
    }

    public abstract void zzfc(int var1) throws IOException;

    public abstract void zzay(long var1) throws IOException;

    public final void zzaz(long l) throws IOException {
        this.zzay(zzbqk.zzbg(l));
    }

    public abstract void zzba(long var1) throws IOException;

    public final void zzf(float f) throws IOException {
        this.zzfc(Float.floatToRawIntBits(f));
    }

    public final void zzb(double d) throws IOException {
        this.zzba(Double.doubleToRawLongBits(d));
    }

    public final void zzbd(boolean bl) throws IOException {
        this.zzd((byte)(bl ? 1 : 0));
    }

    public abstract void zzfx(String var1) throws IOException;

    public abstract void zzan(zzbpu var1) throws IOException;

    public abstract void zze(zzbsl var1) throws IOException;

    abstract void zza(zzbsl var1, zzbtc var2) throws IOException;

    public abstract void zzd(byte var1) throws IOException;

    public abstract void write(byte[] var1, int var2, int var3) throws IOException;

    public static int zzz(int n, int n2) {
        return zzbqk.zzfd(n) + zzbqk.zzfe(n2);
    }

    public static int zzaa(int n, int n2) {
        return zzbqk.zzfd(n) + zzbqk.zzff(n2);
    }

    public static int zzab(int n, int n2) {
        return zzbqk.zzfd(n) + zzbqk.zzff(zzbqk.zzfk(n2));
    }

    public static int zzac(int n, int n2) {
        return zzbqk.zzfd(n) + 4;
    }

    public static int zzad(int n, int n2) {
        return zzbqk.zzfd(n) + 4;
    }

    public static int zzm(int n, long l) {
        return zzbqk.zzfd(n) + zzbqk.zzbc(l);
    }

    public static int zzn(int n, long l) {
        return zzbqk.zzfd(n) + zzbqk.zzbc(l);
    }

    public static int zzo(int n, long l) {
        return zzbqk.zzfd(n) + zzbqk.zzbc(zzbqk.zzbg(l));
    }

    public static int zzp(int n, long l) {
        return zzbqk.zzfd(n) + 8;
    }

    public static int zzq(int n, long l) {
        return zzbqk.zzfd(n) + 8;
    }

    public static int zzb(int n, float f) {
        return zzbqk.zzfd(n) + 4;
    }

    public static int zzc(int n, double d) {
        return zzbqk.zzfd(n) + 8;
    }

    public static int zzk(int n, boolean bl) {
        return zzbqk.zzfd(n) + 1;
    }

    public static int zzae(int n, int n2) {
        return zzbqk.zzfd(n) + zzbqk.zzfe(n2);
    }

    public static int zzg(int n, String string) {
        return zzbqk.zzfd(n) + zzbqk.zzfy(string);
    }

    public static int zzc(int n, zzbpu zzbpu2) {
        int n2 = zzbpu2.size();
        return zzbqk.zzfd(n) + (zzbqk.zzff(n2) + n2);
    }

    public static int zza(int n, zzbrs zzbrs2) {
        int n2 = zzbrs2.zzamj();
        return zzbqk.zzfd(n) + (zzbqk.zzff(n2) + n2);
    }

    public static int zzc(int n, zzbsl zzbsl2) {
        return zzbqk.zzfd(n) + zzbqk.zzf(zzbsl2);
    }

    static int zzb(int n, zzbsl zzbsl2, zzbtc zzbtc2) {
        return zzbqk.zzfd(n) + zzbqk.zzb(zzbsl2, zzbtc2);
    }

    public static int zzd(int n, zzbsl zzbsl2) {
        return (zzbqk.zzfd(1) << 1) + zzbqk.zzaa(2, n) + zzbqk.zzc(3, zzbsl2);
    }

    public static int zzd(int n, zzbpu zzbpu2) {
        return (zzbqk.zzfd(1) << 1) + zzbqk.zzaa(2, n) + zzbqk.zzc(3, zzbpu2);
    }

    public static int zzb(int n, zzbrs zzbrs2) {
        return (zzbqk.zzfd(1) << 1) + zzbqk.zzaa(2, n) + zzbqk.zza(3, zzbrs2);
    }

    public static int zzfd(int n) {
        return zzbqk.zzff(n << 3);
    }

    public static int zzfe(int n) {
        if (n >= 0) {
            return zzbqk.zzff(n);
        }
        return 10;
    }

    public static int zzff(int n) {
        if ((n & 0xFFFFFF80) == 0) {
            return 1;
        }
        if ((n & 0xFFFFC000) == 0) {
            return 2;
        }
        if ((n & 0xFFE00000) == 0) {
            return 3;
        }
        if ((n & 0xF0000000) == 0) {
            return 4;
        }
        return 5;
    }

    public static int zzfg(int n) {
        return zzbqk.zzff(zzbqk.zzfk(n));
    }

    public static int zzfh(int n) {
        return 4;
    }

    public static int zzfi(int n) {
        return 4;
    }

    public static int zzbb(long l) {
        return zzbqk.zzbc(l);
    }

    public static int zzbc(long l) {
        if ((l & 0xFFFFFFFFFFFFFF80L) == 0L) {
            return 1;
        }
        if (l < 0L) {
            return 10;
        }
        int n = 2;
        if ((l & 0xFFFFFFF800000000L) != 0L) {
            n += 4;
            l >>>= 28;
        }
        if ((l & 0xFFFFFFFFFFE00000L) != 0L) {
            n += 2;
            l >>>= 14;
        }
        if ((l & 0xFFFFFFFFFFFFC000L) != 0L) {
            ++n;
        }
        return n;
    }

    public static int zzbd(long l) {
        return zzbqk.zzbc(zzbqk.zzbg(l));
    }

    public static int zzbe(long l) {
        return 8;
    }

    public static int zzbf(long l) {
        return 8;
    }

    public static int zzg(float f) {
        return 4;
    }

    public static int zzc(double d) {
        return 8;
    }

    public static int zzbe(boolean bl) {
        return 1;
    }

    public static int zzfj(int n) {
        return zzbqk.zzfe(n);
    }

    public static int zzfy(String string) {
        int n;
        try {
            n = zzbuc.zza(string);
        }
        catch (zzbug zzbug2) {
            n = string.getBytes(zzbrf.UTF_8).length;
        }
        int n2 = n;
        return zzbqk.zzff(n2) + n2;
    }

    public static int zza(zzbrs zzbrs2) {
        int n = zzbrs2.zzamj();
        return zzbqk.zzff(n) + n;
    }

    public static int zzao(zzbpu zzbpu2) {
        int n = zzbpu2.size();
        return zzbqk.zzff(n) + n;
    }

    public static int zzu(byte[] byArray) {
        int n = byArray.length;
        return zzbqk.zzff(n) + n;
    }

    public static int zzf(zzbsl zzbsl2) {
        int n = zzbsl2.zzamj();
        return zzbqk.zzff(n) + n;
    }

    static int zzb(zzbsl zzbsl2, zzbtc zzbtc2) {
        zzbtc zzbtc3 = zzbtc2;
        zzbpl zzbpl2 = (zzbpl)zzbsl2;
        int n = zzbpl2.zzakg();
        if (n == -1) {
            n = zzbtc3.zzac(zzbpl2);
            zzbpl2.zzei(n);
        }
        int n2 = n;
        return zzbqk.zzff(n2) + n2;
    }

    private static int zzfk(int n) {
        return n << 1 ^ n >> 31;
    }

    private static long zzbg(long l) {
        return l << 1 ^ l >> 63;
    }

    public abstract void flush() throws IOException;

    public abstract int zzalu();

    public final void zzalv() {
        if (this.zzalu() != 0) {
            throw new IllegalStateException("Did not write as much data as expected.");
        }
    }

    abstract void zzl(byte[] var1, int var2, int var3) throws IOException;

    final void zza(String string, zzbug zzbug2) throws IOException {
        logger.logp(Level.WARNING, "com.google.protobuf.CodedOutputStream", "inefficientWriteStringNoTag", "Converting ill-formed UTF-16. Your Protocol Buffer will not round trip correctly!", zzbug2);
        byte[] byArray = string.getBytes(zzbrf.UTF_8);
        try {
            this.zzfa(byArray.length);
            this.zzh(byArray, 0, byArray.length);
            return;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new zzc(indexOutOfBoundsException);
        }
        catch (zzc zzc2) {
            throw zzc2;
        }
    }

    @Deprecated
    static int zzc(int n, zzbsl zzbsl2, zzbtc zzbtc2) {
        zzbtc zzbtc3;
        int n2 = zzbqk.zzfd(n) << 1;
        zzbtc zzbtc4 = zzbtc3 = zzbtc2;
        zzbpl zzbpl2 = (zzbpl)zzbsl2;
        int n3 = zzbpl2.zzakg();
        if (n3 == -1) {
            n3 = zzbtc4.zzac(zzbpl2);
            zzbpl2.zzei(n3);
        }
        return n2 + n3;
    }

    @Deprecated
    public static int zzg(zzbsl zzbsl2) {
        return zzbsl2.zzamj();
    }

    @Deprecated
    public static int zzfl(int n) {
        return zzbqk.zzff(n);
    }

    /* synthetic */ zzbqk(zzbql zzbql2) {
        this();
    }

    static final class zze
    extends zzbqk {
        private final ByteBuffer zzfmi;
        private final ByteBuffer zzaep;
        private final long zzfmj;
        private final long zzfmk;
        private final long zzfml;
        private final long zzfmm;
        private long zzaha;

        zze(ByteBuffer byteBuffer) {
            super(null);
            this.zzfmi = byteBuffer;
            this.zzaep = byteBuffer.duplicate().order(ByteOrder.LITTLE_ENDIAN);
            this.zzfmj = zzbua.zzo(byteBuffer);
            this.zzfmk = this.zzfmj + (long)byteBuffer.position();
            this.zzfml = this.zzfmj + (long)byteBuffer.limit();
            this.zzfmm = this.zzfml - 10L;
            this.zzaha = this.zzfmk;
        }

        @Override
        public final void zzu(int n, int n2) throws IOException {
            int n3 = n2;
            ((zzbqk)this).zzfa(n << 3 | n3);
        }

        @Override
        public final void zzv(int n, int n2) throws IOException {
            ((zzbqk)this).zzu(n, 0);
            ((zzbqk)this).zzez(n2);
        }

        @Override
        public final void zzw(int n, int n2) throws IOException {
            ((zzbqk)this).zzu(n, 0);
            ((zzbqk)this).zzfa(n2);
        }

        @Override
        public final void zzy(int n, int n2) throws IOException {
            ((zzbqk)this).zzu(n, 5);
            ((zzbqk)this).zzfc(n2);
        }

        @Override
        public final void zzj(int n, long l) throws IOException {
            ((zzbqk)this).zzu(n, 0);
            ((zzbqk)this).zzay(l);
        }

        @Override
        public final void zzl(int n, long l) throws IOException {
            ((zzbqk)this).zzu(n, 1);
            ((zzbqk)this).zzba(l);
        }

        @Override
        public final void zzj(int n, boolean bl) throws IOException {
            ((zzbqk)this).zzu(n, 0);
            ((zzbqk)this).zzd((byte)(bl ? 1 : 0));
        }

        @Override
        public final void zzf(int n, String string) throws IOException {
            ((zzbqk)this).zzu(n, 2);
            ((zzbqk)this).zzfx(string);
        }

        @Override
        public final void zza(int n, zzbpu zzbpu2) throws IOException {
            ((zzbqk)this).zzu(n, 2);
            ((zzbqk)this).zzan(zzbpu2);
        }

        @Override
        public final void zza(int n, zzbsl zzbsl2) throws IOException {
            ((zzbqk)this).zzu(n, 2);
            ((zzbqk)this).zze(zzbsl2);
        }

        @Override
        final void zza(int n, zzbsl zzbsl2, zzbtc zzbtc2) throws IOException {
            ((zzbqk)this).zzu(n, 2);
            ((zzbqk)this).zza(zzbsl2, zzbtc2);
        }

        @Override
        public final void zzb(int n, zzbsl zzbsl2) throws IOException {
            ((zzbqk)this).zzu(1, 3);
            ((zzbqk)this).zzw(2, n);
            ((zzbqk)this).zza(3, zzbsl2);
            ((zzbqk)this).zzu(1, 4);
        }

        @Override
        public final void zzb(int n, zzbpu zzbpu2) throws IOException {
            ((zzbqk)this).zzu(1, 3);
            ((zzbqk)this).zzw(2, n);
            ((zzbqk)this).zza(3, zzbpu2);
            ((zzbqk)this).zzu(1, 4);
        }

        @Override
        public final void zze(zzbsl zzbsl2) throws IOException {
            ((zzbqk)this).zzfa(zzbsl2.zzamj());
            zzbsl2.zzb(this);
        }

        @Override
        final void zza(zzbsl zzbsl2, zzbtc zzbtc2) throws IOException {
            zzbtc zzbtc3 = zzbtc2;
            zzbpl zzbpl2 = (zzbpl)zzbsl2;
            int n = zzbpl2.zzakg();
            if (n == -1) {
                n = zzbtc3.zzac(zzbpl2);
                zzbpl2.zzei(n);
            }
            ((zzbqk)this).zzfa(n);
            zzbtc2.zza(zzbsl2, this.zzfmf);
        }

        @Override
        public final void zzd(byte by) throws IOException {
            if (this.zzaha >= this.zzfml) {
                throw new zzc(String.format("Pos: %d, limit: %d, len: %d", this.zzaha, this.zzfml, 1));
            }
            zzbua.zza(this.zzaha++, by);
        }

        @Override
        public final void zzan(zzbpu zzbpu2) throws IOException {
            ((zzbqk)this).zzfa(zzbpu2.size());
            zzbpu2.zza(this);
        }

        @Override
        public final void zzl(byte[] byArray, int n, int n2) throws IOException {
            ((zzbqk)this).zzfa(n2);
            ((zzbqk)this).write(byArray, 0, n2);
        }

        @Override
        public final void zzez(int n) throws IOException {
            if (n >= 0) {
                ((zzbqk)this).zzfa(n);
                return;
            }
            ((zzbqk)this).zzay(n);
        }

        @Override
        public final void zzfa(int n) throws IOException {
            if (this.zzaha <= this.zzfmm) {
                while (true) {
                    if ((n & 0xFFFFFF80) == 0) {
                        zzbua.zza(this.zzaha++, (byte)n);
                        return;
                    }
                    zzbua.zza(this.zzaha++, (byte)(n & 0x7F | 0x80));
                    n >>>= 7;
                }
            }
            while (this.zzaha < this.zzfml) {
                if ((n & 0xFFFFFF80) == 0) {
                    zzbua.zza(this.zzaha++, (byte)n);
                    return;
                }
                zzbua.zza(this.zzaha++, (byte)(n & 0x7F | 0x80));
                n >>>= 7;
            }
            throw new zzc(String.format("Pos: %d, limit: %d, len: %d", this.zzaha, this.zzfml, 1));
        }

        @Override
        public final void zzfc(int n) throws IOException {
            long l = this.zzaha;
            zze zze2 = this;
            this.zzaep.putInt((int)(l - zze2.zzfmj), n);
            this.zzaha += 4L;
        }

        @Override
        public final void zzay(long l) throws IOException {
            if (this.zzaha <= this.zzfmm) {
                while (true) {
                    if ((l & 0xFFFFFFFFFFFFFF80L) == 0L) {
                        zzbua.zza(this.zzaha++, (byte)l);
                        return;
                    }
                    zzbua.zza(this.zzaha++, (byte)((int)l & 0x7F | 0x80));
                    l >>>= 7;
                }
            }
            while (this.zzaha < this.zzfml) {
                if ((l & 0xFFFFFFFFFFFFFF80L) == 0L) {
                    zzbua.zza(this.zzaha++, (byte)l);
                    return;
                }
                zzbua.zza(this.zzaha++, (byte)((int)l & 0x7F | 0x80));
                l >>>= 7;
            }
            throw new zzc(String.format("Pos: %d, limit: %d, len: %d", this.zzaha, this.zzfml, 1));
        }

        @Override
        public final void zzba(long l) throws IOException {
            long l2 = this.zzaha;
            zze zze2 = this;
            this.zzaep.putLong((int)(l2 - zze2.zzfmj), l);
            this.zzaha += 8L;
        }

        @Override
        public final void write(byte[] byArray, int n, int n2) throws IOException {
            if (byArray == null || n < 0 || n2 < 0 || byArray.length - n2 < n || this.zzfml - (long)n2 < this.zzaha) {
                if (byArray == null) {
                    throw new NullPointerException("value");
                }
                throw new zzc(String.format("Pos: %d, limit: %d, len: %d", this.zzaha, this.zzfml, n2));
            }
            zzbua.zza(byArray, n, this.zzaha, n2);
            this.zzaha += (long)n2;
        }

        @Override
        public final void zzh(byte[] byArray, int n, int n2) throws IOException {
            ((zzbqk)this).write(byArray, n, n2);
        }

        @Override
        public final void zzfx(String string) throws IOException {
            long l = this.zzaha;
            try {
                int n = zze.zzff(string.length() * 3);
                int n2 = zze.zzff(string.length());
                if (n2 == n) {
                    long l2 = this.zzaha;
                    zze zze2 = this;
                    int n3 = (int)(l2 - zze2.zzfmj) + n2;
                    this.zzaep.position(n3);
                    zzbuc.zza(string, this.zzaep);
                    int n4 = this.zzaep.position() - n3;
                    ((zzbqk)this).zzfa(n4);
                    this.zzaha += (long)n4;
                    return;
                }
                int n5 = zzbuc.zza(string);
                ((zzbqk)this).zzfa(n5);
                this.zzbh(this.zzaha);
                zzbuc.zza(string, this.zzaep);
                this.zzaha += (long)n5;
                return;
            }
            catch (zzbug zzbug2) {
                this.zzaha = l;
                this.zzbh(this.zzaha);
                this.zza(string, zzbug2);
                return;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new zzc(illegalArgumentException);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new zzc(indexOutOfBoundsException);
            }
        }

        @Override
        public final void flush() {
            long l = this.zzaha;
            zze zze2 = this;
            this.zzfmi.position((int)(l - zze2.zzfmj));
        }

        @Override
        public final int zzalu() {
            return (int)(this.zzfml - this.zzaha);
        }

        private final void zzbh(long l) {
            long l2 = l;
            zze zze2 = this;
            this.zzaep.position((int)(l2 - zze2.zzfmj));
        }
    }

    static final class zzd
    extends zzbqk {
        private final ByteBuffer zzfmi;
        private final ByteBuffer zzaep;
        private final int zzfmh;

        zzd(ByteBuffer byteBuffer) {
            super(null);
            this.zzfmi = byteBuffer;
            this.zzaep = byteBuffer.duplicate().order(ByteOrder.LITTLE_ENDIAN);
            this.zzfmh = byteBuffer.position();
        }

        @Override
        public final void zzu(int n, int n2) throws IOException {
            int n3 = n2;
            ((zzbqk)this).zzfa(n << 3 | n3);
        }

        @Override
        public final void zzv(int n, int n2) throws IOException {
            ((zzbqk)this).zzu(n, 0);
            ((zzbqk)this).zzez(n2);
        }

        @Override
        public final void zzw(int n, int n2) throws IOException {
            ((zzbqk)this).zzu(n, 0);
            ((zzbqk)this).zzfa(n2);
        }

        @Override
        public final void zzy(int n, int n2) throws IOException {
            ((zzbqk)this).zzu(n, 5);
            ((zzbqk)this).zzfc(n2);
        }

        @Override
        public final void zzj(int n, long l) throws IOException {
            ((zzbqk)this).zzu(n, 0);
            ((zzbqk)this).zzay(l);
        }

        @Override
        public final void zzl(int n, long l) throws IOException {
            ((zzbqk)this).zzu(n, 1);
            ((zzbqk)this).zzba(l);
        }

        @Override
        public final void zzj(int n, boolean bl) throws IOException {
            ((zzbqk)this).zzu(n, 0);
            ((zzbqk)this).zzd((byte)(bl ? 1 : 0));
        }

        @Override
        public final void zzf(int n, String string) throws IOException {
            ((zzbqk)this).zzu(n, 2);
            ((zzbqk)this).zzfx(string);
        }

        @Override
        public final void zza(int n, zzbpu zzbpu2) throws IOException {
            ((zzbqk)this).zzu(n, 2);
            ((zzbqk)this).zzan(zzbpu2);
        }

        @Override
        public final void zza(int n, zzbsl zzbsl2) throws IOException {
            ((zzbqk)this).zzu(n, 2);
            ((zzbqk)this).zze(zzbsl2);
        }

        @Override
        final void zza(int n, zzbsl zzbsl2, zzbtc zzbtc2) throws IOException {
            ((zzbqk)this).zzu(n, 2);
            ((zzbqk)this).zza(zzbsl2, zzbtc2);
        }

        @Override
        public final void zzb(int n, zzbsl zzbsl2) throws IOException {
            ((zzbqk)this).zzu(1, 3);
            ((zzbqk)this).zzw(2, n);
            ((zzbqk)this).zza(3, zzbsl2);
            ((zzbqk)this).zzu(1, 4);
        }

        @Override
        public final void zzb(int n, zzbpu zzbpu2) throws IOException {
            ((zzbqk)this).zzu(1, 3);
            ((zzbqk)this).zzw(2, n);
            ((zzbqk)this).zza(3, zzbpu2);
            ((zzbqk)this).zzu(1, 4);
        }

        @Override
        public final void zze(zzbsl zzbsl2) throws IOException {
            ((zzbqk)this).zzfa(zzbsl2.zzamj());
            zzbsl2.zzb(this);
        }

        @Override
        final void zza(zzbsl zzbsl2, zzbtc zzbtc2) throws IOException {
            zzbtc zzbtc3 = zzbtc2;
            zzbpl zzbpl2 = (zzbpl)zzbsl2;
            int n = zzbpl2.zzakg();
            if (n == -1) {
                n = zzbtc3.zzac(zzbpl2);
                zzbpl2.zzei(n);
            }
            ((zzbqk)this).zzfa(n);
            zzbtc2.zza(zzbsl2, this.zzfmf);
        }

        @Override
        public final void zzd(byte by) throws IOException {
            try {
                this.zzaep.put(by);
                return;
            }
            catch (BufferOverflowException bufferOverflowException) {
                throw new zzc(bufferOverflowException);
            }
        }

        @Override
        public final void zzan(zzbpu zzbpu2) throws IOException {
            ((zzbqk)this).zzfa(zzbpu2.size());
            zzbpu2.zza(this);
        }

        @Override
        public final void zzl(byte[] byArray, int n, int n2) throws IOException {
            ((zzbqk)this).zzfa(n2);
            ((zzbqk)this).write(byArray, 0, n2);
        }

        @Override
        public final void zzez(int n) throws IOException {
            if (n >= 0) {
                ((zzbqk)this).zzfa(n);
                return;
            }
            ((zzbqk)this).zzay(n);
        }

        @Override
        public final void zzfa(int n) throws IOException {
            try {
                while (true) {
                    if ((n & 0xFFFFFF80) == 0) {
                        this.zzaep.put((byte)n);
                        return;
                    }
                    this.zzaep.put((byte)(n & 0x7F | 0x80));
                    n >>>= 7;
                }
            }
            catch (BufferOverflowException bufferOverflowException) {
                throw new zzc(bufferOverflowException);
            }
        }

        @Override
        public final void zzfc(int n) throws IOException {
            try {
                this.zzaep.putInt(n);
                return;
            }
            catch (BufferOverflowException bufferOverflowException) {
                throw new zzc(bufferOverflowException);
            }
        }

        @Override
        public final void zzay(long l) throws IOException {
            try {
                while (true) {
                    if ((l & 0xFFFFFFFFFFFFFF80L) == 0L) {
                        this.zzaep.put((byte)l);
                        return;
                    }
                    this.zzaep.put((byte)((int)l & 0x7F | 0x80));
                    l >>>= 7;
                }
            }
            catch (BufferOverflowException bufferOverflowException) {
                throw new zzc(bufferOverflowException);
            }
        }

        @Override
        public final void zzba(long l) throws IOException {
            try {
                this.zzaep.putLong(l);
                return;
            }
            catch (BufferOverflowException bufferOverflowException) {
                throw new zzc(bufferOverflowException);
            }
        }

        @Override
        public final void write(byte[] byArray, int n, int n2) throws IOException {
            try {
                this.zzaep.put(byArray, n, n2);
                return;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new zzc(indexOutOfBoundsException);
            }
            catch (BufferOverflowException bufferOverflowException) {
                throw new zzc(bufferOverflowException);
            }
        }

        @Override
        public final void zzh(byte[] byArray, int n, int n2) throws IOException {
            ((zzbqk)this).write(byArray, n, n2);
        }

        @Override
        public final void zzfx(String string) throws IOException {
            int n = this.zzaep.position();
            try {
                int n2 = zzd.zzff(string.length() * 3);
                int n3 = zzd.zzff(string.length());
                if (n3 == n2) {
                    int n4 = this.zzaep.position() + n3;
                    this.zzaep.position(n4);
                    this.zzfz(string);
                    int n5 = this.zzaep.position();
                    this.zzaep.position(n);
                    ((zzbqk)this).zzfa(n5 - n4);
                    this.zzaep.position(n5);
                    return;
                }
                int n6 = zzbuc.zza(string);
                ((zzbqk)this).zzfa(n6);
                this.zzfz(string);
                return;
            }
            catch (zzbug zzbug2) {
                this.zzaep.position(n);
                this.zza(string, zzbug2);
                return;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new zzc(illegalArgumentException);
            }
        }

        @Override
        public final void flush() {
            this.zzfmi.position(this.zzaep.position());
        }

        @Override
        public final int zzalu() {
            return this.zzaep.remaining();
        }

        private final void zzfz(String string) throws IOException {
            try {
                zzbuc.zza(string, this.zzaep);
                return;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new zzc(indexOutOfBoundsException);
            }
        }
    }

    static final class zzb
    extends zza {
        private final ByteBuffer zzfmg;
        private int zzfmh;

        zzb(ByteBuffer byteBuffer) {
            super(byteBuffer.array(), byteBuffer.arrayOffset() + byteBuffer.position(), byteBuffer.remaining());
            this.zzfmg = byteBuffer;
            this.zzfmh = byteBuffer.position();
        }

        @Override
        public final void flush() {
            this.zzfmg.position(this.zzfmh + this.zzalx());
        }
    }

    static class zza
    extends zzbqk {
        private final byte[] buffer;
        private final int offset;
        private final int limit;
        private int position;

        zza(byte[] byArray, int n, int n2) {
            super(null);
            if (byArray == null) {
                throw new NullPointerException("buffer");
            }
            if ((n | n2 | byArray.length - (n + n2)) < 0) {
                throw new IllegalArgumentException(String.format("Array range is invalid. Buffer.length=%d, offset=%d, length=%d", byArray.length, n, n2));
            }
            this.buffer = byArray;
            this.offset = n;
            this.position = n;
            this.limit = n + n2;
        }

        @Override
        public final void zzu(int n, int n2) throws IOException {
            int n3 = n2;
            ((zzbqk)this).zzfa(n << 3 | n3);
        }

        @Override
        public final void zzv(int n, int n2) throws IOException {
            ((zzbqk)this).zzu(n, 0);
            ((zzbqk)this).zzez(n2);
        }

        @Override
        public final void zzw(int n, int n2) throws IOException {
            ((zzbqk)this).zzu(n, 0);
            ((zzbqk)this).zzfa(n2);
        }

        @Override
        public final void zzy(int n, int n2) throws IOException {
            ((zzbqk)this).zzu(n, 5);
            ((zzbqk)this).zzfc(n2);
        }

        @Override
        public final void zzj(int n, long l) throws IOException {
            ((zzbqk)this).zzu(n, 0);
            ((zzbqk)this).zzay(l);
        }

        @Override
        public final void zzl(int n, long l) throws IOException {
            ((zzbqk)this).zzu(n, 1);
            ((zzbqk)this).zzba(l);
        }

        @Override
        public final void zzj(int n, boolean bl) throws IOException {
            ((zzbqk)this).zzu(n, 0);
            ((zzbqk)this).zzd((byte)(bl ? 1 : 0));
        }

        @Override
        public final void zzf(int n, String string) throws IOException {
            ((zzbqk)this).zzu(n, 2);
            ((zzbqk)this).zzfx(string);
        }

        @Override
        public final void zza(int n, zzbpu zzbpu2) throws IOException {
            ((zzbqk)this).zzu(n, 2);
            ((zzbqk)this).zzan(zzbpu2);
        }

        @Override
        public final void zzan(zzbpu zzbpu2) throws IOException {
            ((zzbqk)this).zzfa(zzbpu2.size());
            zzbpu2.zza(this);
        }

        @Override
        public final void zzl(byte[] byArray, int n, int n2) throws IOException {
            ((zzbqk)this).zzfa(n2);
            ((zzbqk)this).write(byArray, 0, n2);
        }

        @Override
        public final void zza(int n, zzbsl zzbsl2) throws IOException {
            ((zzbqk)this).zzu(n, 2);
            ((zzbqk)this).zze(zzbsl2);
        }

        @Override
        final void zza(int n, zzbsl zzbsl2, zzbtc zzbtc2) throws IOException {
            ((zzbqk)this).zzu(n, 2);
            zzbtc zzbtc3 = zzbtc2;
            zzbpl zzbpl2 = (zzbpl)zzbsl2;
            int n2 = zzbpl2.zzakg();
            if (n2 == -1) {
                n2 = zzbtc3.zzac(zzbpl2);
                zzbpl2.zzei(n2);
            }
            ((zzbqk)this).zzfa(n2);
            zzbtc2.zza(zzbsl2, this.zzfmf);
        }

        @Override
        public final void zzb(int n, zzbsl zzbsl2) throws IOException {
            ((zzbqk)this).zzu(1, 3);
            ((zzbqk)this).zzw(2, n);
            ((zzbqk)this).zza(3, zzbsl2);
            ((zzbqk)this).zzu(1, 4);
        }

        @Override
        public final void zzb(int n, zzbpu zzbpu2) throws IOException {
            ((zzbqk)this).zzu(1, 3);
            ((zzbqk)this).zzw(2, n);
            ((zzbqk)this).zza(3, zzbpu2);
            ((zzbqk)this).zzu(1, 4);
        }

        @Override
        public final void zze(zzbsl zzbsl2) throws IOException {
            ((zzbqk)this).zzfa(zzbsl2.zzamj());
            zzbsl2.zzb(this);
        }

        @Override
        final void zza(zzbsl zzbsl2, zzbtc zzbtc2) throws IOException {
            zzbtc zzbtc3 = zzbtc2;
            zzbpl zzbpl2 = (zzbpl)zzbsl2;
            int n = zzbpl2.zzakg();
            if (n == -1) {
                n = zzbtc3.zzac(zzbpl2);
                zzbpl2.zzei(n);
            }
            ((zzbqk)this).zzfa(n);
            zzbtc2.zza(zzbsl2, this.zzfmf);
        }

        @Override
        public final void zzd(byte by) throws IOException {
            try {
                this.buffer[this.position++] = by;
                return;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new zzc(String.format("Pos: %d, limit: %d, len: %d", this.position, this.limit, 1), indexOutOfBoundsException);
            }
        }

        @Override
        public final void zzez(int n) throws IOException {
            if (n >= 0) {
                ((zzbqk)this).zzfa(n);
                return;
            }
            ((zzbqk)this).zzay(n);
        }

        @Override
        public final void zzfa(int n) throws IOException {
            if (zzfme && ((zzbqk)this).zzalu() >= 10) {
                while (true) {
                    if ((n & 0xFFFFFF80) == 0) {
                        zzbua.zza(this.buffer, (long)this.position++, (byte)n);
                        return;
                    }
                    zzbua.zza(this.buffer, (long)this.position++, (byte)(n & 0x7F | 0x80));
                    n >>>= 7;
                }
            }
            try {
                while (true) {
                    if ((n & 0xFFFFFF80) == 0) {
                        this.buffer[this.position++] = (byte)n;
                        return;
                    }
                    this.buffer[this.position++] = (byte)(n & 0x7F | 0x80);
                    n >>>= 7;
                }
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new zzc(String.format("Pos: %d, limit: %d, len: %d", this.position, this.limit, 1), indexOutOfBoundsException);
            }
        }

        @Override
        public final void zzfc(int n) throws IOException {
            try {
                this.buffer[this.position++] = (byte)n;
                this.buffer[this.position++] = (byte)(n >> 8);
                this.buffer[this.position++] = (byte)(n >> 16);
                this.buffer[this.position++] = (byte)(n >>> 24);
                return;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new zzc(String.format("Pos: %d, limit: %d, len: %d", this.position, this.limit, 1), indexOutOfBoundsException);
            }
        }

        @Override
        public final void zzay(long l) throws IOException {
            if (zzfme && ((zzbqk)this).zzalu() >= 10) {
                while (true) {
                    if ((l & 0xFFFFFFFFFFFFFF80L) == 0L) {
                        zzbua.zza(this.buffer, (long)this.position++, (byte)l);
                        return;
                    }
                    zzbua.zza(this.buffer, (long)this.position++, (byte)((int)l & 0x7F | 0x80));
                    l >>>= 7;
                }
            }
            try {
                while (true) {
                    if ((l & 0xFFFFFFFFFFFFFF80L) == 0L) {
                        this.buffer[this.position++] = (byte)l;
                        return;
                    }
                    this.buffer[this.position++] = (byte)((int)l & 0x7F | 0x80);
                    l >>>= 7;
                }
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new zzc(String.format("Pos: %d, limit: %d, len: %d", this.position, this.limit, 1), indexOutOfBoundsException);
            }
        }

        @Override
        public final void zzba(long l) throws IOException {
            try {
                this.buffer[this.position++] = (byte)l;
                this.buffer[this.position++] = (byte)(l >> 8);
                this.buffer[this.position++] = (byte)(l >> 16);
                this.buffer[this.position++] = (byte)(l >> 24);
                this.buffer[this.position++] = (byte)(l >> 32);
                this.buffer[this.position++] = (byte)(l >> 40);
                this.buffer[this.position++] = (byte)(l >> 48);
                this.buffer[this.position++] = (byte)(l >> 56);
                return;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new zzc(String.format("Pos: %d, limit: %d, len: %d", this.position, this.limit, 1), indexOutOfBoundsException);
            }
        }

        @Override
        public final void write(byte[] byArray, int n, int n2) throws IOException {
            try {
                System.arraycopy(byArray, n, this.buffer, this.position, n2);
                this.position += n2;
                return;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new zzc(String.format("Pos: %d, limit: %d, len: %d", this.position, this.limit, n2), indexOutOfBoundsException);
            }
        }

        @Override
        public final void zzh(byte[] byArray, int n, int n2) throws IOException {
            ((zzbqk)this).write(byArray, n, n2);
        }

        @Override
        public final void zzfx(String string) throws IOException {
            int n = this.position;
            try {
                int n2 = zza.zzff(string.length() * 3);
                int n3 = zza.zzff(string.length());
                if (n3 == n2) {
                    this.position = n + n3;
                    int n4 = zzbuc.zza(string, this.buffer, this.position, ((zzbqk)this).zzalu());
                    this.position = n;
                    int n5 = n4 - n - n3;
                    ((zzbqk)this).zzfa(n5);
                    this.position = n4;
                    return;
                }
                int n6 = zzbuc.zza(string);
                ((zzbqk)this).zzfa(n6);
                this.position = zzbuc.zza(string, this.buffer, this.position, ((zzbqk)this).zzalu());
                return;
            }
            catch (zzbug zzbug2) {
                this.position = n;
                this.zza(string, zzbug2);
                return;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new zzc(indexOutOfBoundsException);
            }
        }

        @Override
        public void flush() {
        }

        @Override
        public final int zzalu() {
            return this.limit - this.position;
        }

        public final int zzalx() {
            return this.position - this.offset;
        }
    }

    public static final class zzc
    extends IOException {
        zzc() {
            super("CodedOutputStream was writing to a flat byte array and ran out of space.");
        }

        zzc(String string) {
            String string2 = String.valueOf("CodedOutputStream was writing to a flat byte array and ran out of space.: ");
            String string3 = String.valueOf(string);
            super(string3.length() != 0 ? string2.concat(string3) : new String(string2));
        }

        zzc(Throwable throwable) {
            super("CodedOutputStream was writing to a flat byte array and ran out of space.", throwable);
        }

        zzc(String string, Throwable throwable) {
            String string2 = String.valueOf("CodedOutputStream was writing to a flat byte array and ran out of space.: ");
            String string3 = String.valueOf(string);
            super(string3.length() != 0 ? string2.concat(string3) : new String(string2), throwable);
        }
    }
}

