/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import com.google.android.gms.internal.ads.zzdml;
import com.google.android.gms.internal.ads.zzdod;
import com.google.android.gms.internal.ads.zzdoj;
import com.google.android.gms.internal.ads.zzdpw;
import java.util.Arrays;
import java.util.Collection;
import java.util.RandomAccess;

final class zzdny
extends zzdml<Float>
implements zzdoj<Float>,
zzdpw,
RandomAccess {
    private static final zzdny zzhgz = new zzdny(new float[0], 0);
    private float[] zzhha;
    private int size;

    zzdny() {
        this(new float[10], 0);
    }

    private zzdny(float[] fArray, int n) {
        this.zzhha = fArray;
        this.size = n;
    }

    @Override
    protected final void removeRange(int n, int n2) {
        this.zzavk();
        if (n2 < n) {
            throw new IndexOutOfBoundsException("toIndex < fromIndex");
        }
        System.arraycopy(this.zzhha, n2, this.zzhha, n, this.size - n2);
        this.size -= n2 - n;
        ++this.modCount;
    }

    @Override
    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof zzdny)) {
            return super.equals(object);
        }
        zzdny zzdny2 = (zzdny)object;
        if (this.size != zzdny2.size) {
            return false;
        }
        float[] fArray = zzdny2.zzhha;
        for (int i = 0; i < this.size; ++i) {
            if (Float.floatToIntBits(this.zzhha[i]) == Float.floatToIntBits(fArray[i])) continue;
            return false;
        }
        return true;
    }

    @Override
    public final int hashCode() {
        int n = 1;
        for (int i = 0; i < this.size; ++i) {
            n = n * 31 + Float.floatToIntBits(this.zzhha[i]);
        }
        return n;
    }

    @Override
    public final int size() {
        return this.size;
    }

    public final void zzi(float f) {
        this.zzc(this.size, f);
    }

    private final void zzc(int n, float f) {
        this.zzavk();
        if (n < 0 || n > this.size) {
            throw new IndexOutOfBoundsException(this.zzfk(n));
        }
        if (this.size < this.zzhha.length) {
            System.arraycopy(this.zzhha, n, this.zzhha, n + 1, this.size - n);
        } else {
            float[] fArray = new float[this.size * 3 / 2 + 1];
            System.arraycopy(this.zzhha, 0, fArray, 0, n);
            System.arraycopy(this.zzhha, n, fArray, n + 1, this.size - n);
            this.zzhha = fArray;
        }
        this.zzhha[n] = f;
        ++this.size;
        ++this.modCount;
    }

    @Override
    public final boolean addAll(Collection<? extends Float> collection) {
        this.zzavk();
        zzdod.checkNotNull(collection);
        if (!(collection instanceof zzdny)) {
            return super.addAll(collection);
        }
        zzdny zzdny2 = (zzdny)collection;
        if (zzdny2.size == 0) {
            return false;
        }
        if (Integer.MAX_VALUE - this.size < zzdny2.size) {
            throw new OutOfMemoryError();
        }
        int n = this.size + zzdny2.size;
        if (n > this.zzhha.length) {
            this.zzhha = Arrays.copyOf(this.zzhha, n);
        }
        System.arraycopy(zzdny2.zzhha, 0, this.zzhha, this.size, zzdny2.size);
        this.size = n;
        ++this.modCount;
        return true;
    }

    @Override
    public final boolean remove(Object object) {
        this.zzavk();
        for (int i = 0; i < this.size; ++i) {
            if (!object.equals(Float.valueOf(this.zzhha[i]))) continue;
            System.arraycopy(this.zzhha, i + 1, this.zzhha, i, this.size - i - 1);
            --this.size;
            ++this.modCount;
            return true;
        }
        return false;
    }

    private final void zzfj(int n) {
        if (n < 0 || n >= this.size) {
            throw new IndexOutOfBoundsException(this.zzfk(n));
        }
    }

    private final String zzfk(int n) {
        int n2 = this.size;
        return new StringBuilder(35).append("Index:").append(n).append(", Size:").append(n2).toString();
    }

    @Override
    public final /* synthetic */ Object set(int n, Object object) {
        Float f = (Float)object;
        float f2 = f.floatValue();
        zzdny zzdny2 = this;
        zzdny2.zzavk();
        zzdny2.zzfj(n);
        float f3 = zzdny2.zzhha[n];
        zzdny2.zzhha[n] = f2;
        return Float.valueOf(f3);
    }

    @Override
    public final /* synthetic */ Object remove(int n) {
        zzdny zzdny2 = this;
        zzdny2.zzavk();
        zzdny2.zzfj(n);
        float f = zzdny2.zzhha[n];
        if (n < zzdny2.size - 1) {
            System.arraycopy(zzdny2.zzhha, n + 1, zzdny2.zzhha, n, zzdny2.size - n - 1);
        }
        --zzdny2.size;
        ++zzdny2.modCount;
        return Float.valueOf(f);
    }

    @Override
    public final /* synthetic */ void add(int n, Object object) {
        Float f = (Float)object;
        this.zzc(n, f.floatValue());
    }

    @Override
    public final /* synthetic */ zzdoj zzfl(int n) {
        int n2 = n;
        zzdny zzdny2 = this;
        if (n2 < zzdny2.size) {
            throw new IllegalArgumentException();
        }
        return new zzdny(Arrays.copyOf(zzdny2.zzhha, n2), zzdny2.size);
    }

    @Override
    public final /* synthetic */ Object get(int n) {
        zzdny zzdny2 = this;
        zzdny2.zzfj(n);
        return Float.valueOf(zzdny2.zzhha[n]);
    }

    static {
        zzhgz.zzavj();
    }
}

