/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import com.google.android.gms.internal.ads.zzdok;
import com.google.android.gms.internal.ads.zzdoo;
import com.google.android.gms.internal.ads.zzdor;
import com.google.android.gms.internal.ads.zzdos;
import com.google.android.gms.internal.ads.zzdpj;
import com.google.android.gms.internal.ads.zzdpl;
import com.google.android.gms.internal.ads.zzdqc;
import com.google.android.gms.internal.ads.zzdqq;
import com.google.android.gms.internal.ads.zzdrl;
import com.google.android.gms.internal.ads.zzdsa;
import com.google.android.gms.internal.ads.zzdsy;
import com.google.android.gms.internal.ads.zzdtb;
import com.google.android.gms.internal.ads.zzdte;
import java.io.IOException;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class zzdpk
extends zzdos {
    private static final Logger logger = Logger.getLogger(zzdpk.class.getName());
    private static final boolean zzhgj = zzdsy.zzbbv();
    zzdpl zzhgk;

    public static zzdpk zzaa(byte[] byArray) {
        int n = byArray.length;
        byte[] byArray2 = byArray;
        return new zzb(byArray2, 0, n);
    }

    public static zzdpk zzm(ByteBuffer byteBuffer) {
        if (byteBuffer.hasArray()) {
            return new zza(byteBuffer);
        }
        if (byteBuffer.isDirect() && !byteBuffer.isReadOnly()) {
            if (zzdsy.zzbbw()) {
                ByteBuffer byteBuffer2 = byteBuffer;
                return new zze(byteBuffer2);
            }
            ByteBuffer byteBuffer3 = byteBuffer;
            return new zzc(byteBuffer3);
        }
        throw new IllegalArgumentException("ByteBuffer is read-only");
    }

    private zzdpk() {
    }

    public abstract void zzz(int var1, int var2) throws IOException;

    public abstract void zzaa(int var1, int var2) throws IOException;

    public abstract void zzab(int var1, int var2) throws IOException;

    public final void zzac(int n, int n2) throws IOException {
        this.zzab(n, zzdpk.zzgl(n2));
    }

    public abstract void zzad(int var1, int var2) throws IOException;

    public abstract void zzg(int var1, long var2) throws IOException;

    public final void zzh(int n, long l) throws IOException {
        this.zzg(n, zzdpk.zzfi(l));
    }

    public abstract void zzi(int var1, long var2) throws IOException;

    public final void zza(int n, float f) throws IOException {
        this.zzad(n, Float.floatToRawIntBits(f));
    }

    public final void zzb(int n, double d) throws IOException {
        this.zzi(n, Double.doubleToRawLongBits(d));
    }

    public abstract void zzh(int var1, boolean var2) throws IOException;

    public abstract void zzg(int var1, String var2) throws IOException;

    public abstract void zza(int var1, zzdor var2) throws IOException;

    public abstract void zza(int var1, zzdrl var2) throws IOException;

    abstract void zza(int var1, zzdrl var2, zzdsa var3) throws IOException;

    public abstract void zzb(int var1, zzdrl var2) throws IOException;

    public abstract void zzb(int var1, zzdor var2) throws IOException;

    public abstract void zzga(int var1) throws IOException;

    public abstract void zzgb(int var1) throws IOException;

    public final void zzgc(int n) throws IOException {
        this.zzgb(zzdpk.zzgl(n));
    }

    public abstract void zzgd(int var1) throws IOException;

    public abstract void zzfa(long var1) throws IOException;

    public final void zzfb(long l) throws IOException {
        this.zzfa(zzdpk.zzfi(l));
    }

    public abstract void zzfc(long var1) throws IOException;

    public final void zzf(float f) throws IOException {
        this.zzgd(Float.floatToRawIntBits(f));
    }

    public final void zzb(double d) throws IOException {
        this.zzfc(Double.doubleToRawLongBits(d));
    }

    public final void zzbh(boolean bl) throws IOException {
        this.zzd((byte)(bl ? 1 : 0));
    }

    public abstract void zzhi(String var1) throws IOException;

    public abstract void zzcz(zzdor var1) throws IOException;

    public abstract void zzj(zzdrl var1) throws IOException;

    abstract void zza(zzdrl var1, zzdsa var2) throws IOException;

    public abstract void zzd(byte var1) throws IOException;

    public abstract void write(byte[] var1, int var2, int var3) throws IOException;

    public static int zzae(int n, int n2) {
        return zzdpk.zzge(n) + zzdpk.zzgf(n2);
    }

    public static int zzaf(int n, int n2) {
        return zzdpk.zzge(n) + zzdpk.zzgg(n2);
    }

    public static int zzag(int n, int n2) {
        return zzdpk.zzge(n) + zzdpk.zzgg(zzdpk.zzgl(n2));
    }

    public static int zzah(int n, int n2) {
        return zzdpk.zzge(n) + 4;
    }

    public static int zzai(int n, int n2) {
        return zzdpk.zzge(n) + 4;
    }

    public static int zzj(int n, long l) {
        return zzdpk.zzge(n) + zzdpk.zzfe(l);
    }

    public static int zzk(int n, long l) {
        return zzdpk.zzge(n) + zzdpk.zzfe(l);
    }

    public static int zzl(int n, long l) {
        return zzdpk.zzge(n) + zzdpk.zzfe(zzdpk.zzfi(l));
    }

    public static int zzm(int n, long l) {
        return zzdpk.zzge(n) + 8;
    }

    public static int zzn(int n, long l) {
        return zzdpk.zzge(n) + 8;
    }

    public static int zzb(int n, float f) {
        return zzdpk.zzge(n) + 4;
    }

    public static int zzc(int n, double d) {
        return zzdpk.zzge(n) + 8;
    }

    public static int zzi(int n, boolean bl) {
        return zzdpk.zzge(n) + 1;
    }

    public static int zzaj(int n, int n2) {
        return zzdpk.zzge(n) + zzdpk.zzgf(n2);
    }

    public static int zzh(int n, String string) {
        return zzdpk.zzge(n) + zzdpk.zzhj(string);
    }

    public static int zzc(int n, zzdor zzdor2) {
        int n2 = zzdor2.size();
        return zzdpk.zzge(n) + (zzdpk.zzgg(n2) + n2);
    }

    public static int zza(int n, zzdqq zzdqq2) {
        int n2 = zzdqq2.zzazp();
        return zzdpk.zzge(n) + (zzdpk.zzgg(n2) + n2);
    }

    public static int zzc(int n, zzdrl zzdrl2) {
        return zzdpk.zzge(n) + zzdpk.zzk(zzdrl2);
    }

    static int zzb(int n, zzdrl zzdrl2, zzdsa zzdsa2) {
        return zzdpk.zzge(n) + zzdpk.zzb(zzdrl2, zzdsa2);
    }

    public static int zzd(int n, zzdrl zzdrl2) {
        return (zzdpk.zzge(1) << 1) + zzdpk.zzaf(2, n) + zzdpk.zzc(3, zzdrl2);
    }

    public static int zzd(int n, zzdor zzdor2) {
        return (zzdpk.zzge(1) << 1) + zzdpk.zzaf(2, n) + zzdpk.zzc(3, zzdor2);
    }

    public static int zzb(int n, zzdqq zzdqq2) {
        return (zzdpk.zzge(1) << 1) + zzdpk.zzaf(2, n) + zzdpk.zza(3, zzdqq2);
    }

    public static int zzge(int n) {
        return zzdpk.zzgg(n << 3);
    }

    public static int zzgf(int n) {
        if (n >= 0) {
            return zzdpk.zzgg(n);
        }
        return 10;
    }

    public static int zzgg(int n) {
        if ((n & 0xFFFFFF80) == 0) {
            return 1;
        }
        if ((n & 0xFFFFC000) == 0) {
            return 2;
        }
        if ((n & 0xFFE00000) == 0) {
            return 3;
        }
        if ((n & 0xF0000000) == 0) {
            return 4;
        }
        return 5;
    }

    public static int zzgh(int n) {
        return zzdpk.zzgg(zzdpk.zzgl(n));
    }

    public static int zzgi(int n) {
        return 4;
    }

    public static int zzgj(int n) {
        return 4;
    }

    public static int zzfd(long l) {
        return zzdpk.zzfe(l);
    }

    public static int zzfe(long l) {
        if ((l & 0xFFFFFFFFFFFFFF80L) == 0L) {
            return 1;
        }
        if (l < 0L) {
            return 10;
        }
        int n = 2;
        if ((l & 0xFFFFFFF800000000L) != 0L) {
            n += 4;
            l >>>= 28;
        }
        if ((l & 0xFFFFFFFFFFE00000L) != 0L) {
            n += 2;
            l >>>= 14;
        }
        if ((l & 0xFFFFFFFFFFFFC000L) != 0L) {
            ++n;
        }
        return n;
    }

    public static int zzff(long l) {
        return zzdpk.zzfe(zzdpk.zzfi(l));
    }

    public static int zzfg(long l) {
        return 8;
    }

    public static int zzfh(long l) {
        return 8;
    }

    public static int zzg(float f) {
        return 4;
    }

    public static int zzc(double d) {
        return 8;
    }

    public static int zzbi(boolean bl) {
        return 1;
    }

    public static int zzgk(int n) {
        return zzdpk.zzgf(n);
    }

    public static int zzhj(String string) {
        int n;
        try {
            n = zzdtb.zza(string);
        }
        catch (zzdte zzdte2) {
            n = string.getBytes(zzdqc.UTF_8).length;
        }
        int n2 = n;
        return zzdpk.zzgg(n2) + n2;
    }

    public static int zza(zzdqq zzdqq2) {
        int n = zzdqq2.zzazp();
        return zzdpk.zzgg(n) + n;
    }

    public static int zzda(zzdor zzdor2) {
        int n = zzdor2.size();
        return zzdpk.zzgg(n) + n;
    }

    public static int zzab(byte[] byArray) {
        int n = byArray.length;
        return zzdpk.zzgg(n) + n;
    }

    public static int zzk(zzdrl zzdrl2) {
        int n = zzdrl2.zzazp();
        return zzdpk.zzgg(n) + n;
    }

    static int zzb(zzdrl zzdrl2, zzdsa zzdsa2) {
        zzdsa zzdsa3 = zzdsa2;
        zzdok zzdok2 = (zzdok)zzdrl2;
        int n = zzdok2.zzaxc();
        if (n == -1) {
            n = zzdsa3.zzau(zzdok2);
            zzdok2.zzfj(n);
        }
        int n2 = n;
        return zzdpk.zzgg(n2) + n2;
    }

    private static int zzgl(int n) {
        return n << 1 ^ n >> 31;
    }

    private static long zzfi(long l) {
        return l << 1 ^ l >> 63;
    }

    public abstract void flush() throws IOException;

    public abstract int zzayp();

    public final void zzayq() {
        if (this.zzayp() != 0) {
            throw new IllegalStateException("Did not write as much data as expected.");
        }
    }

    abstract void zzk(byte[] var1, int var2, int var3) throws IOException;

    final void zza(String string, zzdte zzdte2) throws IOException {
        logger.logp(Level.WARNING, "com.google.protobuf.CodedOutputStream", "inefficientWriteStringNoTag", "Converting ill-formed UTF-16. Your Protocol Buffer will not round trip correctly!", zzdte2);
        byte[] byArray = string.getBytes(zzdqc.UTF_8);
        try {
            this.zzgb(byArray.length);
            this.zzi(byArray, 0, byArray.length);
            return;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new zzd(indexOutOfBoundsException);
        }
        catch (zzd zzd2) {
            throw zzd2;
        }
    }

    @Deprecated
    static int zzc(int n, zzdrl zzdrl2, zzdsa zzdsa2) {
        zzdsa zzdsa3;
        int n2 = zzdpk.zzge(n) << 1;
        zzdsa zzdsa4 = zzdsa3 = zzdsa2;
        zzdok zzdok2 = (zzdok)zzdrl2;
        int n3 = zzdok2.zzaxc();
        if (n3 == -1) {
            n3 = zzdsa4.zzau(zzdok2);
            zzdok2.zzfj(n3);
        }
        return n2 + n3;
    }

    @Deprecated
    public static int zzl(zzdrl zzdrl2) {
        return zzdrl2.zzazp();
    }

    @Deprecated
    public static int zzgm(int n) {
        return zzdpk.zzgg(n);
    }

    /* synthetic */ zzdpk(zzdpj zzdpj2) {
        this();
    }

    static final class zze
    extends zzdpk {
        private final ByteBuffer zzhgn;
        private final ByteBuffer zzakh;
        private final long zzhgo;
        private final long zzhgp;
        private final long zzhgq;
        private final long zzhgr;
        private long zzams;

        zze(ByteBuffer byteBuffer) {
            super(null);
            this.zzhgn = byteBuffer;
            this.zzakh = byteBuffer.duplicate().order(ByteOrder.LITTLE_ENDIAN);
            this.zzhgo = zzdsy.zzn(byteBuffer);
            this.zzhgp = this.zzhgo + (long)byteBuffer.position();
            this.zzhgq = this.zzhgo + (long)byteBuffer.limit();
            this.zzhgr = this.zzhgq - 10L;
            this.zzams = this.zzhgp;
        }

        @Override
        public final void zzz(int n, int n2) throws IOException {
            int n3 = n2;
            ((zzdpk)this).zzgb(n << 3 | n3);
        }

        @Override
        public final void zzaa(int n, int n2) throws IOException {
            ((zzdpk)this).zzz(n, 0);
            ((zzdpk)this).zzga(n2);
        }

        @Override
        public final void zzab(int n, int n2) throws IOException {
            ((zzdpk)this).zzz(n, 0);
            ((zzdpk)this).zzgb(n2);
        }

        @Override
        public final void zzad(int n, int n2) throws IOException {
            ((zzdpk)this).zzz(n, 5);
            ((zzdpk)this).zzgd(n2);
        }

        @Override
        public final void zzg(int n, long l) throws IOException {
            ((zzdpk)this).zzz(n, 0);
            ((zzdpk)this).zzfa(l);
        }

        @Override
        public final void zzi(int n, long l) throws IOException {
            ((zzdpk)this).zzz(n, 1);
            ((zzdpk)this).zzfc(l);
        }

        @Override
        public final void zzh(int n, boolean bl) throws IOException {
            ((zzdpk)this).zzz(n, 0);
            ((zzdpk)this).zzd((byte)(bl ? 1 : 0));
        }

        @Override
        public final void zzg(int n, String string) throws IOException {
            ((zzdpk)this).zzz(n, 2);
            ((zzdpk)this).zzhi(string);
        }

        @Override
        public final void zza(int n, zzdor zzdor2) throws IOException {
            ((zzdpk)this).zzz(n, 2);
            ((zzdpk)this).zzcz(zzdor2);
        }

        @Override
        public final void zza(int n, zzdrl zzdrl2) throws IOException {
            ((zzdpk)this).zzz(n, 2);
            ((zzdpk)this).zzj(zzdrl2);
        }

        @Override
        final void zza(int n, zzdrl zzdrl2, zzdsa zzdsa2) throws IOException {
            ((zzdpk)this).zzz(n, 2);
            ((zzdpk)this).zza(zzdrl2, zzdsa2);
        }

        @Override
        public final void zzb(int n, zzdrl zzdrl2) throws IOException {
            ((zzdpk)this).zzz(1, 3);
            ((zzdpk)this).zzab(2, n);
            ((zzdpk)this).zza(3, zzdrl2);
            ((zzdpk)this).zzz(1, 4);
        }

        @Override
        public final void zzb(int n, zzdor zzdor2) throws IOException {
            ((zzdpk)this).zzz(1, 3);
            ((zzdpk)this).zzab(2, n);
            ((zzdpk)this).zza(3, zzdor2);
            ((zzdpk)this).zzz(1, 4);
        }

        @Override
        public final void zzj(zzdrl zzdrl2) throws IOException {
            ((zzdpk)this).zzgb(zzdrl2.zzazp());
            zzdrl2.zzb(this);
        }

        @Override
        final void zza(zzdrl zzdrl2, zzdsa zzdsa2) throws IOException {
            zzdsa zzdsa3 = zzdsa2;
            zzdok zzdok2 = (zzdok)zzdrl2;
            int n = zzdok2.zzaxc();
            if (n == -1) {
                n = zzdsa3.zzau(zzdok2);
                zzdok2.zzfj(n);
            }
            ((zzdpk)this).zzgb(n);
            zzdsa2.zza(zzdrl2, this.zzhgk);
        }

        @Override
        public final void zzd(byte by) throws IOException {
            if (this.zzams >= this.zzhgq) {
                throw new zzd(String.format("Pos: %d, limit: %d, len: %d", this.zzams, this.zzhgq, 1));
            }
            zzdsy.zza(this.zzams++, by);
        }

        @Override
        public final void zzcz(zzdor zzdor2) throws IOException {
            ((zzdpk)this).zzgb(zzdor2.size());
            zzdor2.zza(this);
        }

        @Override
        public final void zzk(byte[] byArray, int n, int n2) throws IOException {
            ((zzdpk)this).zzgb(n2);
            ((zzdpk)this).write(byArray, 0, n2);
        }

        @Override
        public final void zzga(int n) throws IOException {
            if (n >= 0) {
                ((zzdpk)this).zzgb(n);
                return;
            }
            ((zzdpk)this).zzfa(n);
        }

        @Override
        public final void zzgb(int n) throws IOException {
            if (this.zzams <= this.zzhgr) {
                while (true) {
                    if ((n & 0xFFFFFF80) == 0) {
                        zzdsy.zza(this.zzams++, (byte)n);
                        return;
                    }
                    zzdsy.zza(this.zzams++, (byte)(n & 0x7F | 0x80));
                    n >>>= 7;
                }
            }
            while (this.zzams < this.zzhgq) {
                if ((n & 0xFFFFFF80) == 0) {
                    zzdsy.zza(this.zzams++, (byte)n);
                    return;
                }
                zzdsy.zza(this.zzams++, (byte)(n & 0x7F | 0x80));
                n >>>= 7;
            }
            throw new zzd(String.format("Pos: %d, limit: %d, len: %d", this.zzams, this.zzhgq, 1));
        }

        @Override
        public final void zzgd(int n) throws IOException {
            long l = this.zzams;
            zze zze2 = this;
            this.zzakh.putInt((int)(l - zze2.zzhgo), n);
            this.zzams += 4L;
        }

        @Override
        public final void zzfa(long l) throws IOException {
            if (this.zzams <= this.zzhgr) {
                while (true) {
                    if ((l & 0xFFFFFFFFFFFFFF80L) == 0L) {
                        zzdsy.zza(this.zzams++, (byte)l);
                        return;
                    }
                    zzdsy.zza(this.zzams++, (byte)((int)l & 0x7F | 0x80));
                    l >>>= 7;
                }
            }
            while (this.zzams < this.zzhgq) {
                if ((l & 0xFFFFFFFFFFFFFF80L) == 0L) {
                    zzdsy.zza(this.zzams++, (byte)l);
                    return;
                }
                zzdsy.zza(this.zzams++, (byte)((int)l & 0x7F | 0x80));
                l >>>= 7;
            }
            throw new zzd(String.format("Pos: %d, limit: %d, len: %d", this.zzams, this.zzhgq, 1));
        }

        @Override
        public final void zzfc(long l) throws IOException {
            long l2 = this.zzams;
            zze zze2 = this;
            this.zzakh.putLong((int)(l2 - zze2.zzhgo), l);
            this.zzams += 8L;
        }

        @Override
        public final void write(byte[] byArray, int n, int n2) throws IOException {
            if (byArray == null || n < 0 || n2 < 0 || byArray.length - n2 < n || this.zzhgq - (long)n2 < this.zzams) {
                if (byArray == null) {
                    throw new NullPointerException("value");
                }
                throw new zzd(String.format("Pos: %d, limit: %d, len: %d", this.zzams, this.zzhgq, n2));
            }
            zzdsy.zza(byArray, n, this.zzams, n2);
            this.zzams += (long)n2;
        }

        @Override
        public final void zzi(byte[] byArray, int n, int n2) throws IOException {
            ((zzdpk)this).write(byArray, n, n2);
        }

        @Override
        public final void zzhi(String string) throws IOException {
            long l = this.zzams;
            try {
                int n = zze.zzgg(string.length() * 3);
                int n2 = zze.zzgg(string.length());
                if (n2 == n) {
                    long l2 = this.zzams;
                    zze zze2 = this;
                    int n3 = (int)(l2 - zze2.zzhgo) + n2;
                    this.zzakh.position(n3);
                    zzdtb.zza(string, this.zzakh);
                    int n4 = this.zzakh.position() - n3;
                    ((zzdpk)this).zzgb(n4);
                    this.zzams += (long)n4;
                    return;
                }
                int n5 = zzdtb.zza(string);
                ((zzdpk)this).zzgb(n5);
                this.zzfj(this.zzams);
                zzdtb.zza(string, this.zzakh);
                this.zzams += (long)n5;
                return;
            }
            catch (zzdte zzdte2) {
                this.zzams = l;
                this.zzfj(this.zzams);
                this.zza(string, zzdte2);
                return;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new zzd(illegalArgumentException);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new zzd(indexOutOfBoundsException);
            }
        }

        @Override
        public final void flush() {
            long l = this.zzams;
            zze zze2 = this;
            this.zzhgn.position((int)(l - zze2.zzhgo));
        }

        @Override
        public final int zzayp() {
            return (int)(this.zzhgq - this.zzams);
        }

        private final void zzfj(long l) {
            long l2 = l;
            zze zze2 = this;
            this.zzakh.position((int)(l2 - zze2.zzhgo));
        }
    }

    static final class zzc
    extends zzdpk {
        private final ByteBuffer zzhgn;
        private final ByteBuffer zzakh;
        private final int zzhgm;

        zzc(ByteBuffer byteBuffer) {
            super(null);
            this.zzhgn = byteBuffer;
            this.zzakh = byteBuffer.duplicate().order(ByteOrder.LITTLE_ENDIAN);
            this.zzhgm = byteBuffer.position();
        }

        @Override
        public final void zzz(int n, int n2) throws IOException {
            int n3 = n2;
            ((zzdpk)this).zzgb(n << 3 | n3);
        }

        @Override
        public final void zzaa(int n, int n2) throws IOException {
            ((zzdpk)this).zzz(n, 0);
            ((zzdpk)this).zzga(n2);
        }

        @Override
        public final void zzab(int n, int n2) throws IOException {
            ((zzdpk)this).zzz(n, 0);
            ((zzdpk)this).zzgb(n2);
        }

        @Override
        public final void zzad(int n, int n2) throws IOException {
            ((zzdpk)this).zzz(n, 5);
            ((zzdpk)this).zzgd(n2);
        }

        @Override
        public final void zzg(int n, long l) throws IOException {
            ((zzdpk)this).zzz(n, 0);
            ((zzdpk)this).zzfa(l);
        }

        @Override
        public final void zzi(int n, long l) throws IOException {
            ((zzdpk)this).zzz(n, 1);
            ((zzdpk)this).zzfc(l);
        }

        @Override
        public final void zzh(int n, boolean bl) throws IOException {
            ((zzdpk)this).zzz(n, 0);
            ((zzdpk)this).zzd((byte)(bl ? 1 : 0));
        }

        @Override
        public final void zzg(int n, String string) throws IOException {
            ((zzdpk)this).zzz(n, 2);
            ((zzdpk)this).zzhi(string);
        }

        @Override
        public final void zza(int n, zzdor zzdor2) throws IOException {
            ((zzdpk)this).zzz(n, 2);
            ((zzdpk)this).zzcz(zzdor2);
        }

        @Override
        public final void zza(int n, zzdrl zzdrl2) throws IOException {
            ((zzdpk)this).zzz(n, 2);
            ((zzdpk)this).zzj(zzdrl2);
        }

        @Override
        final void zza(int n, zzdrl zzdrl2, zzdsa zzdsa2) throws IOException {
            ((zzdpk)this).zzz(n, 2);
            ((zzdpk)this).zza(zzdrl2, zzdsa2);
        }

        @Override
        public final void zzb(int n, zzdrl zzdrl2) throws IOException {
            ((zzdpk)this).zzz(1, 3);
            ((zzdpk)this).zzab(2, n);
            ((zzdpk)this).zza(3, zzdrl2);
            ((zzdpk)this).zzz(1, 4);
        }

        @Override
        public final void zzb(int n, zzdor zzdor2) throws IOException {
            ((zzdpk)this).zzz(1, 3);
            ((zzdpk)this).zzab(2, n);
            ((zzdpk)this).zza(3, zzdor2);
            ((zzdpk)this).zzz(1, 4);
        }

        @Override
        public final void zzj(zzdrl zzdrl2) throws IOException {
            ((zzdpk)this).zzgb(zzdrl2.zzazp());
            zzdrl2.zzb(this);
        }

        @Override
        final void zza(zzdrl zzdrl2, zzdsa zzdsa2) throws IOException {
            zzdsa zzdsa3 = zzdsa2;
            zzdok zzdok2 = (zzdok)zzdrl2;
            int n = zzdok2.zzaxc();
            if (n == -1) {
                n = zzdsa3.zzau(zzdok2);
                zzdok2.zzfj(n);
            }
            ((zzdpk)this).zzgb(n);
            zzdsa2.zza(zzdrl2, this.zzhgk);
        }

        @Override
        public final void zzd(byte by) throws IOException {
            try {
                this.zzakh.put(by);
                return;
            }
            catch (BufferOverflowException bufferOverflowException) {
                throw new zzd(bufferOverflowException);
            }
        }

        @Override
        public final void zzcz(zzdor zzdor2) throws IOException {
            ((zzdpk)this).zzgb(zzdor2.size());
            zzdor2.zza(this);
        }

        @Override
        public final void zzk(byte[] byArray, int n, int n2) throws IOException {
            ((zzdpk)this).zzgb(n2);
            ((zzdpk)this).write(byArray, 0, n2);
        }

        @Override
        public final void zzga(int n) throws IOException {
            if (n >= 0) {
                ((zzdpk)this).zzgb(n);
                return;
            }
            ((zzdpk)this).zzfa(n);
        }

        @Override
        public final void zzgb(int n) throws IOException {
            try {
                while (true) {
                    if ((n & 0xFFFFFF80) == 0) {
                        this.zzakh.put((byte)n);
                        return;
                    }
                    this.zzakh.put((byte)(n & 0x7F | 0x80));
                    n >>>= 7;
                }
            }
            catch (BufferOverflowException bufferOverflowException) {
                throw new zzd(bufferOverflowException);
            }
        }

        @Override
        public final void zzgd(int n) throws IOException {
            try {
                this.zzakh.putInt(n);
                return;
            }
            catch (BufferOverflowException bufferOverflowException) {
                throw new zzd(bufferOverflowException);
            }
        }

        @Override
        public final void zzfa(long l) throws IOException {
            try {
                while (true) {
                    if ((l & 0xFFFFFFFFFFFFFF80L) == 0L) {
                        this.zzakh.put((byte)l);
                        return;
                    }
                    this.zzakh.put((byte)((int)l & 0x7F | 0x80));
                    l >>>= 7;
                }
            }
            catch (BufferOverflowException bufferOverflowException) {
                throw new zzd(bufferOverflowException);
            }
        }

        @Override
        public final void zzfc(long l) throws IOException {
            try {
                this.zzakh.putLong(l);
                return;
            }
            catch (BufferOverflowException bufferOverflowException) {
                throw new zzd(bufferOverflowException);
            }
        }

        @Override
        public final void write(byte[] byArray, int n, int n2) throws IOException {
            try {
                this.zzakh.put(byArray, n, n2);
                return;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new zzd(indexOutOfBoundsException);
            }
            catch (BufferOverflowException bufferOverflowException) {
                throw new zzd(bufferOverflowException);
            }
        }

        @Override
        public final void zzi(byte[] byArray, int n, int n2) throws IOException {
            ((zzdpk)this).write(byArray, n, n2);
        }

        @Override
        public final void zzhi(String string) throws IOException {
            int n = this.zzakh.position();
            try {
                int n2 = zzc.zzgg(string.length() * 3);
                int n3 = zzc.zzgg(string.length());
                if (n3 == n2) {
                    int n4 = this.zzakh.position() + n3;
                    this.zzakh.position(n4);
                    this.zzhk(string);
                    int n5 = this.zzakh.position();
                    this.zzakh.position(n);
                    ((zzdpk)this).zzgb(n5 - n4);
                    this.zzakh.position(n5);
                    return;
                }
                int n6 = zzdtb.zza(string);
                ((zzdpk)this).zzgb(n6);
                this.zzhk(string);
                return;
            }
            catch (zzdte zzdte2) {
                this.zzakh.position(n);
                this.zza(string, zzdte2);
                return;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new zzd(illegalArgumentException);
            }
        }

        @Override
        public final void flush() {
            this.zzhgn.position(this.zzakh.position());
        }

        @Override
        public final int zzayp() {
            return this.zzakh.remaining();
        }

        private final void zzhk(String string) throws IOException {
            try {
                zzdtb.zza(string, this.zzakh);
                return;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new zzd(indexOutOfBoundsException);
            }
        }
    }

    static final class zza
    extends zzb {
        private final ByteBuffer zzhgl;
        private int zzhgm;

        zza(ByteBuffer byteBuffer) {
            super(byteBuffer.array(), byteBuffer.arrayOffset() + byteBuffer.position(), byteBuffer.remaining());
            this.zzhgl = byteBuffer;
            this.zzhgm = byteBuffer.position();
        }

        @Override
        public final void flush() {
            this.zzhgl.position(this.zzhgm + this.zzays());
        }
    }

    static class zzb
    extends zzdpk {
        private final byte[] buffer;
        private final int offset;
        private final int limit;
        private int position;

        zzb(byte[] byArray, int n, int n2) {
            super(null);
            if (byArray == null) {
                throw new NullPointerException("buffer");
            }
            if ((n | n2 | byArray.length - (n + n2)) < 0) {
                throw new IllegalArgumentException(String.format("Array range is invalid. Buffer.length=%d, offset=%d, length=%d", byArray.length, n, n2));
            }
            this.buffer = byArray;
            this.offset = n;
            this.position = n;
            this.limit = n + n2;
        }

        @Override
        public final void zzz(int n, int n2) throws IOException {
            int n3 = n2;
            ((zzdpk)this).zzgb(n << 3 | n3);
        }

        @Override
        public final void zzaa(int n, int n2) throws IOException {
            ((zzdpk)this).zzz(n, 0);
            ((zzdpk)this).zzga(n2);
        }

        @Override
        public final void zzab(int n, int n2) throws IOException {
            ((zzdpk)this).zzz(n, 0);
            ((zzdpk)this).zzgb(n2);
        }

        @Override
        public final void zzad(int n, int n2) throws IOException {
            ((zzdpk)this).zzz(n, 5);
            ((zzdpk)this).zzgd(n2);
        }

        @Override
        public final void zzg(int n, long l) throws IOException {
            ((zzdpk)this).zzz(n, 0);
            ((zzdpk)this).zzfa(l);
        }

        @Override
        public final void zzi(int n, long l) throws IOException {
            ((zzdpk)this).zzz(n, 1);
            ((zzdpk)this).zzfc(l);
        }

        @Override
        public final void zzh(int n, boolean bl) throws IOException {
            ((zzdpk)this).zzz(n, 0);
            ((zzdpk)this).zzd((byte)(bl ? 1 : 0));
        }

        @Override
        public final void zzg(int n, String string) throws IOException {
            ((zzdpk)this).zzz(n, 2);
            ((zzdpk)this).zzhi(string);
        }

        @Override
        public final void zza(int n, zzdor zzdor2) throws IOException {
            ((zzdpk)this).zzz(n, 2);
            ((zzdpk)this).zzcz(zzdor2);
        }

        @Override
        public final void zzcz(zzdor zzdor2) throws IOException {
            ((zzdpk)this).zzgb(zzdor2.size());
            zzdor2.zza(this);
        }

        @Override
        public final void zzk(byte[] byArray, int n, int n2) throws IOException {
            ((zzdpk)this).zzgb(n2);
            ((zzdpk)this).write(byArray, 0, n2);
        }

        @Override
        public final void zza(int n, zzdrl zzdrl2) throws IOException {
            ((zzdpk)this).zzz(n, 2);
            ((zzdpk)this).zzj(zzdrl2);
        }

        @Override
        final void zza(int n, zzdrl zzdrl2, zzdsa zzdsa2) throws IOException {
            ((zzdpk)this).zzz(n, 2);
            zzdsa zzdsa3 = zzdsa2;
            zzdok zzdok2 = (zzdok)zzdrl2;
            int n2 = zzdok2.zzaxc();
            if (n2 == -1) {
                n2 = zzdsa3.zzau(zzdok2);
                zzdok2.zzfj(n2);
            }
            ((zzdpk)this).zzgb(n2);
            zzdsa2.zza(zzdrl2, this.zzhgk);
        }

        @Override
        public final void zzb(int n, zzdrl zzdrl2) throws IOException {
            ((zzdpk)this).zzz(1, 3);
            ((zzdpk)this).zzab(2, n);
            ((zzdpk)this).zza(3, zzdrl2);
            ((zzdpk)this).zzz(1, 4);
        }

        @Override
        public final void zzb(int n, zzdor zzdor2) throws IOException {
            ((zzdpk)this).zzz(1, 3);
            ((zzdpk)this).zzab(2, n);
            ((zzdpk)this).zza(3, zzdor2);
            ((zzdpk)this).zzz(1, 4);
        }

        @Override
        public final void zzj(zzdrl zzdrl2) throws IOException {
            ((zzdpk)this).zzgb(zzdrl2.zzazp());
            zzdrl2.zzb(this);
        }

        @Override
        final void zza(zzdrl zzdrl2, zzdsa zzdsa2) throws IOException {
            zzdsa zzdsa3 = zzdsa2;
            zzdok zzdok2 = (zzdok)zzdrl2;
            int n = zzdok2.zzaxc();
            if (n == -1) {
                n = zzdsa3.zzau(zzdok2);
                zzdok2.zzfj(n);
            }
            ((zzdpk)this).zzgb(n);
            zzdsa2.zza(zzdrl2, this.zzhgk);
        }

        @Override
        public final void zzd(byte by) throws IOException {
            try {
                this.buffer[this.position++] = by;
                return;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new zzd(String.format("Pos: %d, limit: %d, len: %d", this.position, this.limit, 1), indexOutOfBoundsException);
            }
        }

        @Override
        public final void zzga(int n) throws IOException {
            if (n >= 0) {
                ((zzdpk)this).zzgb(n);
                return;
            }
            ((zzdpk)this).zzfa(n);
        }

        @Override
        public final void zzgb(int n) throws IOException {
            if (zzhgj && !zzdoo.zzaxg() && ((zzdpk)this).zzayp() >= 5) {
                if ((n & 0xFFFFFF80) == 0) {
                    zzdsy.zza(this.buffer, (long)this.position++, (byte)n);
                    return;
                }
                zzdsy.zza(this.buffer, (long)this.position++, (byte)(n | 0x80));
                if (((n >>>= 7) & 0xFFFFFF80) == 0) {
                    zzdsy.zza(this.buffer, (long)this.position++, (byte)n);
                    return;
                }
                zzdsy.zza(this.buffer, (long)this.position++, (byte)(n | 0x80));
                if (((n >>>= 7) & 0xFFFFFF80) == 0) {
                    zzdsy.zza(this.buffer, (long)this.position++, (byte)n);
                    return;
                }
                zzdsy.zza(this.buffer, (long)this.position++, (byte)(n | 0x80));
                if (((n >>>= 7) & 0xFFFFFF80) == 0) {
                    zzdsy.zza(this.buffer, (long)this.position++, (byte)n);
                    return;
                }
                zzdsy.zza(this.buffer, (long)this.position++, (byte)(n | 0x80));
                zzdsy.zza(this.buffer, (long)this.position++, (byte)(n >>>= 7));
                return;
            }
            try {
                while (true) {
                    if ((n & 0xFFFFFF80) == 0) {
                        this.buffer[this.position++] = (byte)n;
                        return;
                    }
                    this.buffer[this.position++] = (byte)(n & 0x7F | 0x80);
                    n >>>= 7;
                }
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new zzd(String.format("Pos: %d, limit: %d, len: %d", this.position, this.limit, 1), indexOutOfBoundsException);
            }
        }

        @Override
        public final void zzgd(int n) throws IOException {
            try {
                this.buffer[this.position++] = (byte)n;
                this.buffer[this.position++] = (byte)(n >> 8);
                this.buffer[this.position++] = (byte)(n >> 16);
                this.buffer[this.position++] = (byte)(n >>> 24);
                return;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new zzd(String.format("Pos: %d, limit: %d, len: %d", this.position, this.limit, 1), indexOutOfBoundsException);
            }
        }

        @Override
        public final void zzfa(long l) throws IOException {
            if (zzhgj && ((zzdpk)this).zzayp() >= 10) {
                while (true) {
                    if ((l & 0xFFFFFFFFFFFFFF80L) == 0L) {
                        zzdsy.zza(this.buffer, (long)this.position++, (byte)l);
                        return;
                    }
                    zzdsy.zza(this.buffer, (long)this.position++, (byte)((int)l & 0x7F | 0x80));
                    l >>>= 7;
                }
            }
            try {
                while (true) {
                    if ((l & 0xFFFFFFFFFFFFFF80L) == 0L) {
                        this.buffer[this.position++] = (byte)l;
                        return;
                    }
                    this.buffer[this.position++] = (byte)((int)l & 0x7F | 0x80);
                    l >>>= 7;
                }
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new zzd(String.format("Pos: %d, limit: %d, len: %d", this.position, this.limit, 1), indexOutOfBoundsException);
            }
        }

        @Override
        public final void zzfc(long l) throws IOException {
            try {
                this.buffer[this.position++] = (byte)l;
                this.buffer[this.position++] = (byte)(l >> 8);
                this.buffer[this.position++] = (byte)(l >> 16);
                this.buffer[this.position++] = (byte)(l >> 24);
                this.buffer[this.position++] = (byte)(l >> 32);
                this.buffer[this.position++] = (byte)(l >> 40);
                this.buffer[this.position++] = (byte)(l >> 48);
                this.buffer[this.position++] = (byte)(l >> 56);
                return;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new zzd(String.format("Pos: %d, limit: %d, len: %d", this.position, this.limit, 1), indexOutOfBoundsException);
            }
        }

        @Override
        public final void write(byte[] byArray, int n, int n2) throws IOException {
            try {
                System.arraycopy(byArray, n, this.buffer, this.position, n2);
                this.position += n2;
                return;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new zzd(String.format("Pos: %d, limit: %d, len: %d", this.position, this.limit, n2), indexOutOfBoundsException);
            }
        }

        @Override
        public final void zzi(byte[] byArray, int n, int n2) throws IOException {
            ((zzdpk)this).write(byArray, n, n2);
        }

        @Override
        public final void zzhi(String string) throws IOException {
            int n = this.position;
            try {
                int n2 = zzb.zzgg(string.length() * 3);
                int n3 = zzb.zzgg(string.length());
                if (n3 == n2) {
                    this.position = n + n3;
                    int n4 = zzdtb.zza(string, this.buffer, this.position, ((zzdpk)this).zzayp());
                    this.position = n;
                    int n5 = n4 - n - n3;
                    ((zzdpk)this).zzgb(n5);
                    this.position = n4;
                    return;
                }
                int n6 = zzdtb.zza(string);
                ((zzdpk)this).zzgb(n6);
                this.position = zzdtb.zza(string, this.buffer, this.position, ((zzdpk)this).zzayp());
                return;
            }
            catch (zzdte zzdte2) {
                this.position = n;
                this.zza(string, zzdte2);
                return;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new zzd(indexOutOfBoundsException);
            }
        }

        @Override
        public void flush() {
        }

        @Override
        public final int zzayp() {
            return this.limit - this.position;
        }

        public final int zzays() {
            return this.position - this.offset;
        }
    }

    public static final class zzd
    extends IOException {
        zzd() {
            super("CodedOutputStream was writing to a flat byte array and ran out of space.");
        }

        zzd(String string) {
            String string2 = String.valueOf("CodedOutputStream was writing to a flat byte array and ran out of space.: ");
            String string3 = String.valueOf(string);
            super(string3.length() != 0 ? string2.concat(string3) : new String(string2));
        }

        zzd(Throwable throwable) {
            super("CodedOutputStream was writing to a flat byte array and ran out of space.", throwable);
        }

        zzd(String string, Throwable throwable) {
            String string2 = String.valueOf("CodedOutputStream was writing to a flat byte array and ran out of space.: ");
            String string3 = String.valueOf(string);
            super(string3.length() != 0 ? string2.concat(string3) : new String(string2), throwable);
        }
    }
}

