/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import com.google.android.gms.internal.ads.zzdol;
import com.google.android.gms.internal.ads.zzdqc;
import com.google.android.gms.internal.ads.zzdqi;
import com.google.android.gms.internal.ads.zzdrx;
import java.util.Arrays;
import java.util.Collection;
import java.util.RandomAccess;

final class zzdpn
extends zzdol<Double>
implements zzdqi<Double>,
zzdrx,
RandomAccess {
    private static final zzdpn zzhgs = new zzdpn(new double[0], 0);
    private double[] zzhgt;
    private int size;

    zzdpn() {
        this(new double[10], 0);
    }

    private zzdpn(double[] dArray, int n) {
        this.zzhgt = dArray;
        this.size = n;
    }

    @Override
    protected final void removeRange(int n, int n2) {
        this.zzaxf();
        if (n2 < n) {
            throw new IndexOutOfBoundsException("toIndex < fromIndex");
        }
        System.arraycopy(this.zzhgt, n2, this.zzhgt, n, this.size - n2);
        this.size -= n2 - n;
        ++this.modCount;
    }

    @Override
    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof zzdpn)) {
            return super.equals(object);
        }
        zzdpn zzdpn2 = (zzdpn)object;
        if (this.size != zzdpn2.size) {
            return false;
        }
        double[] dArray = zzdpn2.zzhgt;
        for (int i = 0; i < this.size; ++i) {
            if (Double.doubleToLongBits(this.zzhgt[i]) == Double.doubleToLongBits(dArray[i])) continue;
            return false;
        }
        return true;
    }

    @Override
    public final int hashCode() {
        int n = 1;
        for (int i = 0; i < this.size; ++i) {
            long l = Double.doubleToLongBits(this.zzhgt[i]);
            n = n * 31 + zzdqc.zzfk(l);
        }
        return n;
    }

    @Override
    public final int size() {
        return this.size;
    }

    public final void zzd(double d) {
        this.zzd(this.size, d);
    }

    private final void zzd(int n, double d) {
        this.zzaxf();
        if (n < 0 || n > this.size) {
            throw new IndexOutOfBoundsException(this.zzfl(n));
        }
        if (this.size < this.zzhgt.length) {
            System.arraycopy(this.zzhgt, n, this.zzhgt, n + 1, this.size - n);
        } else {
            double[] dArray = new double[this.size * 3 / 2 + 1];
            System.arraycopy(this.zzhgt, 0, dArray, 0, n);
            System.arraycopy(this.zzhgt, n, dArray, n + 1, this.size - n);
            this.zzhgt = dArray;
        }
        this.zzhgt[n] = d;
        ++this.size;
        ++this.modCount;
    }

    @Override
    public final boolean addAll(Collection<? extends Double> collection) {
        this.zzaxf();
        zzdqc.checkNotNull(collection);
        if (!(collection instanceof zzdpn)) {
            return super.addAll(collection);
        }
        zzdpn zzdpn2 = (zzdpn)collection;
        if (zzdpn2.size == 0) {
            return false;
        }
        if (Integer.MAX_VALUE - this.size < zzdpn2.size) {
            throw new OutOfMemoryError();
        }
        int n = this.size + zzdpn2.size;
        if (n > this.zzhgt.length) {
            this.zzhgt = Arrays.copyOf(this.zzhgt, n);
        }
        System.arraycopy(zzdpn2.zzhgt, 0, this.zzhgt, this.size, zzdpn2.size);
        this.size = n;
        ++this.modCount;
        return true;
    }

    @Override
    public final boolean remove(Object object) {
        this.zzaxf();
        for (int i = 0; i < this.size; ++i) {
            if (!object.equals(this.zzhgt[i])) continue;
            System.arraycopy(this.zzhgt, i + 1, this.zzhgt, i, this.size - i - 1);
            --this.size;
            ++this.modCount;
            return true;
        }
        return false;
    }

    private final void zzfk(int n) {
        if (n < 0 || n >= this.size) {
            throw new IndexOutOfBoundsException(this.zzfl(n));
        }
    }

    private final String zzfl(int n) {
        int n2 = this.size;
        return new StringBuilder(35).append("Index:").append(n).append(", Size:").append(n2).toString();
    }

    @Override
    public final /* synthetic */ Object set(int n, Object object) {
        Double d = (Double)object;
        double d2 = d;
        zzdpn zzdpn2 = this;
        zzdpn2.zzaxf();
        zzdpn2.zzfk(n);
        double d3 = zzdpn2.zzhgt[n];
        zzdpn2.zzhgt[n] = d2;
        return d3;
    }

    @Override
    public final /* synthetic */ Object remove(int n) {
        zzdpn zzdpn2 = this;
        zzdpn2.zzaxf();
        zzdpn2.zzfk(n);
        double d = zzdpn2.zzhgt[n];
        if (n < zzdpn2.size - 1) {
            System.arraycopy(zzdpn2.zzhgt, n + 1, zzdpn2.zzhgt, n, zzdpn2.size - n - 1);
        }
        --zzdpn2.size;
        ++zzdpn2.modCount;
        return d;
    }

    @Override
    public final /* synthetic */ void add(int n, Object object) {
        Double d = (Double)object;
        this.zzd(n, d);
    }

    @Override
    public final /* synthetic */ zzdqi zzfm(int n) {
        int n2 = n;
        zzdpn zzdpn2 = this;
        if (n2 < zzdpn2.size) {
            throw new IllegalArgumentException();
        }
        return new zzdpn(Arrays.copyOf(zzdpn2.zzhgt, n2), zzdpn2.size);
    }

    @Override
    public final /* synthetic */ Object get(int n) {
        zzdpn zzdpn2 = this;
        zzdpn2.zzfk(n);
        return zzdpn2.zzhgt[n];
    }

    static {
        zzhgs.zzaxe();
    }
}

