/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import com.google.android.gms.internal.ads.zzdon;
import com.google.android.gms.internal.ads.zzdqe;
import com.google.android.gms.internal.ads.zzdqk;
import com.google.android.gms.internal.ads.zzdrz;
import java.util.Arrays;
import java.util.Collection;
import java.util.RandomAccess;

final class zzdpp
extends zzdon<Double>
implements zzdqk<Double>,
zzdrz,
RandomAccess {
    private static final zzdpp zzhgs = new zzdpp(new double[0], 0);
    private double[] zzhgt;
    private int size;

    zzdpp() {
        this(new double[10], 0);
    }

    private zzdpp(double[] dArray, int n) {
        this.zzhgt = dArray;
        this.size = n;
    }

    @Override
    protected final void removeRange(int n, int n2) {
        this.zzaxf();
        if (n2 < n) {
            throw new IndexOutOfBoundsException("toIndex < fromIndex");
        }
        System.arraycopy(this.zzhgt, n2, this.zzhgt, n, this.size - n2);
        this.size -= n2 - n;
        ++this.modCount;
    }

    @Override
    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof zzdpp)) {
            return super.equals(object);
        }
        zzdpp zzdpp2 = (zzdpp)object;
        if (this.size != zzdpp2.size) {
            return false;
        }
        double[] dArray = zzdpp2.zzhgt;
        for (int i = 0; i < this.size; ++i) {
            if (Double.doubleToLongBits(this.zzhgt[i]) == Double.doubleToLongBits(dArray[i])) continue;
            return false;
        }
        return true;
    }

    @Override
    public final int hashCode() {
        int n = 1;
        for (int i = 0; i < this.size; ++i) {
            long l = Double.doubleToLongBits(this.zzhgt[i]);
            n = n * 31 + zzdqe.zzfk(l);
        }
        return n;
    }

    @Override
    public final int size() {
        return this.size;
    }

    public final void zzd(double d) {
        this.zzd(this.size, d);
    }

    private final void zzd(int n, double d) {
        this.zzaxf();
        if (n < 0 || n > this.size) {
            throw new IndexOutOfBoundsException(this.zzfl(n));
        }
        if (this.size < this.zzhgt.length) {
            System.arraycopy(this.zzhgt, n, this.zzhgt, n + 1, this.size - n);
        } else {
            double[] dArray = new double[this.size * 3 / 2 + 1];
            System.arraycopy(this.zzhgt, 0, dArray, 0, n);
            System.arraycopy(this.zzhgt, n, dArray, n + 1, this.size - n);
            this.zzhgt = dArray;
        }
        this.zzhgt[n] = d;
        ++this.size;
        ++this.modCount;
    }

    @Override
    public final boolean addAll(Collection<? extends Double> collection) {
        this.zzaxf();
        zzdqe.checkNotNull(collection);
        if (!(collection instanceof zzdpp)) {
            return super.addAll(collection);
        }
        zzdpp zzdpp2 = (zzdpp)collection;
        if (zzdpp2.size == 0) {
            return false;
        }
        if (Integer.MAX_VALUE - this.size < zzdpp2.size) {
            throw new OutOfMemoryError();
        }
        int n = this.size + zzdpp2.size;
        if (n > this.zzhgt.length) {
            this.zzhgt = Arrays.copyOf(this.zzhgt, n);
        }
        System.arraycopy(zzdpp2.zzhgt, 0, this.zzhgt, this.size, zzdpp2.size);
        this.size = n;
        ++this.modCount;
        return true;
    }

    @Override
    public final boolean remove(Object object) {
        this.zzaxf();
        for (int i = 0; i < this.size; ++i) {
            if (!object.equals(this.zzhgt[i])) continue;
            System.arraycopy(this.zzhgt, i + 1, this.zzhgt, i, this.size - i - 1);
            --this.size;
            ++this.modCount;
            return true;
        }
        return false;
    }

    private final void zzfk(int n) {
        if (n < 0 || n >= this.size) {
            throw new IndexOutOfBoundsException(this.zzfl(n));
        }
    }

    private final String zzfl(int n) {
        int n2 = this.size;
        return new StringBuilder(35).append("Index:").append(n).append(", Size:").append(n2).toString();
    }

    @Override
    public final /* synthetic */ Object set(int n, Object object) {
        Double d = (Double)object;
        double d2 = d;
        zzdpp zzdpp2 = this;
        zzdpp2.zzaxf();
        zzdpp2.zzfk(n);
        double d3 = zzdpp2.zzhgt[n];
        zzdpp2.zzhgt[n] = d2;
        return d3;
    }

    @Override
    public final /* synthetic */ Object remove(int n) {
        zzdpp zzdpp2 = this;
        zzdpp2.zzaxf();
        zzdpp2.zzfk(n);
        double d = zzdpp2.zzhgt[n];
        if (n < zzdpp2.size - 1) {
            System.arraycopy(zzdpp2.zzhgt, n + 1, zzdpp2.zzhgt, n, zzdpp2.size - n - 1);
        }
        --zzdpp2.size;
        ++zzdpp2.modCount;
        return d;
    }

    @Override
    public final /* synthetic */ void add(int n, Object object) {
        Double d = (Double)object;
        this.zzd(n, d);
    }

    @Override
    public final /* synthetic */ zzdqk zzfm(int n) {
        int n2 = n;
        zzdpp zzdpp2 = this;
        if (n2 < zzdpp2.size) {
            throw new IllegalArgumentException();
        }
        return new zzdpp(Arrays.copyOf(zzdpp2.zzhgt, n2), zzdpp2.size);
    }

    @Override
    public final /* synthetic */ Object get(int n) {
        zzdpp zzdpp2 = this;
        zzdpp2.zzfk(n);
        return zzdpp2.zzhgt[n];
    }

    static {
        zzhgs.zzaxe();
    }
}

