/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import com.google.android.gms.internal.ads.zzdon;
import com.google.android.gms.internal.ads.zzdqe;
import com.google.android.gms.internal.ads.zzdqk;
import com.google.android.gms.internal.ads.zzdrz;
import java.util.Arrays;
import java.util.Collection;
import java.util.RandomAccess;

final class zzdpz
extends zzdon<Float>
implements zzdqk<Float>,
zzdrz,
RandomAccess {
    private static final zzdpz zzhjq = new zzdpz(new float[0], 0);
    private float[] zzhjr;
    private int size;

    zzdpz() {
        this(new float[10], 0);
    }

    private zzdpz(float[] fArray, int n) {
        this.zzhjr = fArray;
        this.size = n;
    }

    @Override
    protected final void removeRange(int n, int n2) {
        this.zzaxf();
        if (n2 < n) {
            throw new IndexOutOfBoundsException("toIndex < fromIndex");
        }
        System.arraycopy(this.zzhjr, n2, this.zzhjr, n, this.size - n2);
        this.size -= n2 - n;
        ++this.modCount;
    }

    @Override
    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof zzdpz)) {
            return super.equals(object);
        }
        zzdpz zzdpz2 = (zzdpz)object;
        if (this.size != zzdpz2.size) {
            return false;
        }
        float[] fArray = zzdpz2.zzhjr;
        for (int i = 0; i < this.size; ++i) {
            if (Float.floatToIntBits(this.zzhjr[i]) == Float.floatToIntBits(fArray[i])) continue;
            return false;
        }
        return true;
    }

    @Override
    public final int hashCode() {
        int n = 1;
        for (int i = 0; i < this.size; ++i) {
            n = n * 31 + Float.floatToIntBits(this.zzhjr[i]);
        }
        return n;
    }

    @Override
    public final int size() {
        return this.size;
    }

    public final void zzh(float f) {
        this.zzc(this.size, f);
    }

    private final void zzc(int n, float f) {
        this.zzaxf();
        if (n < 0 || n > this.size) {
            throw new IndexOutOfBoundsException(this.zzfl(n));
        }
        if (this.size < this.zzhjr.length) {
            System.arraycopy(this.zzhjr, n, this.zzhjr, n + 1, this.size - n);
        } else {
            float[] fArray = new float[this.size * 3 / 2 + 1];
            System.arraycopy(this.zzhjr, 0, fArray, 0, n);
            System.arraycopy(this.zzhjr, n, fArray, n + 1, this.size - n);
            this.zzhjr = fArray;
        }
        this.zzhjr[n] = f;
        ++this.size;
        ++this.modCount;
    }

    @Override
    public final boolean addAll(Collection<? extends Float> collection) {
        this.zzaxf();
        zzdqe.checkNotNull(collection);
        if (!(collection instanceof zzdpz)) {
            return super.addAll(collection);
        }
        zzdpz zzdpz2 = (zzdpz)collection;
        if (zzdpz2.size == 0) {
            return false;
        }
        if (Integer.MAX_VALUE - this.size < zzdpz2.size) {
            throw new OutOfMemoryError();
        }
        int n = this.size + zzdpz2.size;
        if (n > this.zzhjr.length) {
            this.zzhjr = Arrays.copyOf(this.zzhjr, n);
        }
        System.arraycopy(zzdpz2.zzhjr, 0, this.zzhjr, this.size, zzdpz2.size);
        this.size = n;
        ++this.modCount;
        return true;
    }

    @Override
    public final boolean remove(Object object) {
        this.zzaxf();
        for (int i = 0; i < this.size; ++i) {
            if (!object.equals(Float.valueOf(this.zzhjr[i]))) continue;
            System.arraycopy(this.zzhjr, i + 1, this.zzhjr, i, this.size - i - 1);
            --this.size;
            ++this.modCount;
            return true;
        }
        return false;
    }

    private final void zzfk(int n) {
        if (n < 0 || n >= this.size) {
            throw new IndexOutOfBoundsException(this.zzfl(n));
        }
    }

    private final String zzfl(int n) {
        int n2 = this.size;
        return new StringBuilder(35).append("Index:").append(n).append(", Size:").append(n2).toString();
    }

    @Override
    public final /* synthetic */ Object set(int n, Object object) {
        Float f = (Float)object;
        float f2 = f.floatValue();
        zzdpz zzdpz2 = this;
        zzdpz2.zzaxf();
        zzdpz2.zzfk(n);
        float f3 = zzdpz2.zzhjr[n];
        zzdpz2.zzhjr[n] = f2;
        return Float.valueOf(f3);
    }

    @Override
    public final /* synthetic */ Object remove(int n) {
        zzdpz zzdpz2 = this;
        zzdpz2.zzaxf();
        zzdpz2.zzfk(n);
        float f = zzdpz2.zzhjr[n];
        if (n < zzdpz2.size - 1) {
            System.arraycopy(zzdpz2.zzhjr, n + 1, zzdpz2.zzhjr, n, zzdpz2.size - n - 1);
        }
        --zzdpz2.size;
        ++zzdpz2.modCount;
        return Float.valueOf(f);
    }

    @Override
    public final /* synthetic */ void add(int n, Object object) {
        Float f = (Float)object;
        this.zzc(n, f.floatValue());
    }

    @Override
    public final /* synthetic */ zzdqk zzfm(int n) {
        int n2 = n;
        zzdpz zzdpz2 = this;
        if (n2 < zzdpz2.size) {
            throw new IllegalArgumentException();
        }
        return new zzdpz(Arrays.copyOf(zzdpz2.zzhjr, n2), zzdpz2.size);
    }

    @Override
    public final /* synthetic */ Object get(int n) {
        zzdpz zzdpz2 = this;
        zzdpz2.zzfk(n);
        return Float.valueOf(zzdpz2.zzhjr[n]);
    }

    static {
        zzhjq.zzaxe();
    }
}

