/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import com.google.android.gms.internal.ads.zzdpf;
import com.google.android.gms.internal.ads.zzdpj;
import com.google.android.gms.internal.ads.zzdpm;
import com.google.android.gms.internal.ads.zzdpn;
import com.google.android.gms.internal.ads.zzdqe;
import com.google.android.gms.internal.ads.zzdqg;
import com.google.android.gms.internal.ads.zzdqx;
import com.google.android.gms.internal.ads.zzdrl;
import com.google.android.gms.internal.ads.zzdsg;
import com.google.android.gms.internal.ads.zzdsv;
import com.google.android.gms.internal.ads.zzdtt;
import com.google.android.gms.internal.ads.zzdtw;
import com.google.android.gms.internal.ads.zzdtz;
import java.io.IOException;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class zzdqf
extends zzdpn {
    private static final Logger logger = Logger.getLogger(zzdqf.class.getName());
    private static final boolean zzhgx = zzdtt.zzbca();
    zzdqg zzhgy;

    public static zzdqf zzaa(byte[] byArray) {
        int n = byArray.length;
        byte[] byArray2 = byArray;
        return new zzb(byArray2, 0, n);
    }

    public static zzdqf zzm(ByteBuffer byteBuffer) {
        if (byteBuffer.hasArray()) {
            return new zza(byteBuffer);
        }
        if (byteBuffer.isDirect() && !byteBuffer.isReadOnly()) {
            if (zzdtt.zzbcb()) {
                ByteBuffer byteBuffer2 = byteBuffer;
                return new zze(byteBuffer2);
            }
            ByteBuffer byteBuffer3 = byteBuffer;
            return new zzc(byteBuffer3);
        }
        throw new IllegalArgumentException("ByteBuffer is read-only");
    }

    private zzdqf() {
    }

    public abstract void zzz(int var1, int var2) throws IOException;

    public abstract void zzaa(int var1, int var2) throws IOException;

    public abstract void zzab(int var1, int var2) throws IOException;

    public final void zzac(int n, int n2) throws IOException {
        this.zzab(n, zzdqf.zzgk(n2));
    }

    public abstract void zzad(int var1, int var2) throws IOException;

    public abstract void zzg(int var1, long var2) throws IOException;

    public final void zzh(int n, long l) throws IOException {
        this.zzg(n, zzdqf.zzfi(l));
    }

    public abstract void zzi(int var1, long var2) throws IOException;

    public final void zza(int n, float f) throws IOException {
        this.zzad(n, Float.floatToRawIntBits(f));
    }

    public final void zzb(int n, double d) throws IOException {
        this.zzi(n, Double.doubleToRawLongBits(d));
    }

    public abstract void zzg(int var1, boolean var2) throws IOException;

    public abstract void zzg(int var1, String var2) throws IOException;

    public abstract void zza(int var1, zzdpm var2) throws IOException;

    public abstract void zza(int var1, zzdsg var2) throws IOException;

    abstract void zza(int var1, zzdsg var2, zzdsv var3) throws IOException;

    public abstract void zzb(int var1, zzdsg var2) throws IOException;

    public abstract void zzb(int var1, zzdpm var2) throws IOException;

    public abstract void zzfz(int var1) throws IOException;

    public abstract void zzga(int var1) throws IOException;

    public final void zzgb(int n) throws IOException {
        this.zzga(zzdqf.zzgk(n));
    }

    public abstract void zzgc(int var1) throws IOException;

    public abstract void zzfa(long var1) throws IOException;

    public final void zzfb(long l) throws IOException {
        this.zzfa(zzdqf.zzfi(l));
    }

    public abstract void zzfc(long var1) throws IOException;

    public final void zzf(float f) throws IOException {
        this.zzgc(Float.floatToRawIntBits(f));
    }

    public final void zzb(double d) throws IOException {
        this.zzfc(Double.doubleToRawLongBits(d));
    }

    public final void zzbh(boolean bl) throws IOException {
        this.zzd((byte)(bl ? 1 : 0));
    }

    public abstract void zzhi(String var1) throws IOException;

    public abstract void zzcz(zzdpm var1) throws IOException;

    public abstract void zzj(zzdsg var1) throws IOException;

    abstract void zza(zzdsg var1, zzdsv var2) throws IOException;

    public abstract void zzd(byte var1) throws IOException;

    public abstract void write(byte[] var1, int var2, int var3) throws IOException;

    public static int zzae(int n, int n2) {
        return zzdqf.zzgd(n) + zzdqf.zzge(n2);
    }

    public static int zzaf(int n, int n2) {
        return zzdqf.zzgd(n) + zzdqf.zzgf(n2);
    }

    public static int zzag(int n, int n2) {
        return zzdqf.zzgd(n) + zzdqf.zzgf(zzdqf.zzgk(n2));
    }

    public static int zzah(int n, int n2) {
        return zzdqf.zzgd(n) + 4;
    }

    public static int zzai(int n, int n2) {
        return zzdqf.zzgd(n) + 4;
    }

    public static int zzj(int n, long l) {
        return zzdqf.zzgd(n) + zzdqf.zzfe(l);
    }

    public static int zzk(int n, long l) {
        return zzdqf.zzgd(n) + zzdqf.zzfe(l);
    }

    public static int zzl(int n, long l) {
        return zzdqf.zzgd(n) + zzdqf.zzfe(zzdqf.zzfi(l));
    }

    public static int zzm(int n, long l) {
        return zzdqf.zzgd(n) + 8;
    }

    public static int zzn(int n, long l) {
        return zzdqf.zzgd(n) + 8;
    }

    public static int zzb(int n, float f) {
        return zzdqf.zzgd(n) + 4;
    }

    public static int zzc(int n, double d) {
        return zzdqf.zzgd(n) + 8;
    }

    public static int zzh(int n, boolean bl) {
        return zzdqf.zzgd(n) + 1;
    }

    public static int zzaj(int n, int n2) {
        return zzdqf.zzgd(n) + zzdqf.zzge(n2);
    }

    public static int zzh(int n, String string) {
        return zzdqf.zzgd(n) + zzdqf.zzhj(string);
    }

    public static int zzc(int n, zzdpm zzdpm2) {
        int n2 = zzdpm2.size();
        return zzdqf.zzgd(n) + (zzdqf.zzgf(n2) + n2);
    }

    public static int zza(int n, zzdrl zzdrl2) {
        int n2 = zzdrl2.zzazu();
        return zzdqf.zzgd(n) + (zzdqf.zzgf(n2) + n2);
    }

    public static int zzc(int n, zzdsg zzdsg2) {
        return zzdqf.zzgd(n) + zzdqf.zzk(zzdsg2);
    }

    static int zzb(int n, zzdsg zzdsg2, zzdsv zzdsv2) {
        return zzdqf.zzgd(n) + zzdqf.zzb(zzdsg2, zzdsv2);
    }

    public static int zzd(int n, zzdsg zzdsg2) {
        return (zzdqf.zzgd(1) << 1) + zzdqf.zzaf(2, n) + zzdqf.zzc(3, zzdsg2);
    }

    public static int zzd(int n, zzdpm zzdpm2) {
        return (zzdqf.zzgd(1) << 1) + zzdqf.zzaf(2, n) + zzdqf.zzc(3, zzdpm2);
    }

    public static int zzb(int n, zzdrl zzdrl2) {
        return (zzdqf.zzgd(1) << 1) + zzdqf.zzaf(2, n) + zzdqf.zza(3, zzdrl2);
    }

    public static int zzgd(int n) {
        return zzdqf.zzgf(n << 3);
    }

    public static int zzge(int n) {
        if (n >= 0) {
            return zzdqf.zzgf(n);
        }
        return 10;
    }

    public static int zzgf(int n) {
        if ((n & 0xFFFFFF80) == 0) {
            return 1;
        }
        if ((n & 0xFFFFC000) == 0) {
            return 2;
        }
        if ((n & 0xFFE00000) == 0) {
            return 3;
        }
        if ((n & 0xF0000000) == 0) {
            return 4;
        }
        return 5;
    }

    public static int zzgg(int n) {
        return zzdqf.zzgf(zzdqf.zzgk(n));
    }

    public static int zzgh(int n) {
        return 4;
    }

    public static int zzgi(int n) {
        return 4;
    }

    public static int zzfd(long l) {
        return zzdqf.zzfe(l);
    }

    public static int zzfe(long l) {
        if ((l & 0xFFFFFFFFFFFFFF80L) == 0L) {
            return 1;
        }
        if (l < 0L) {
            return 10;
        }
        int n = 2;
        if ((l & 0xFFFFFFF800000000L) != 0L) {
            n += 4;
            l >>>= 28;
        }
        if ((l & 0xFFFFFFFFFFE00000L) != 0L) {
            n += 2;
            l >>>= 14;
        }
        if ((l & 0xFFFFFFFFFFFFC000L) != 0L) {
            ++n;
        }
        return n;
    }

    public static int zzff(long l) {
        return zzdqf.zzfe(zzdqf.zzfi(l));
    }

    public static int zzfg(long l) {
        return 8;
    }

    public static int zzfh(long l) {
        return 8;
    }

    public static int zzg(float f) {
        return 4;
    }

    public static int zzc(double d) {
        return 8;
    }

    public static int zzbi(boolean bl) {
        return 1;
    }

    public static int zzgj(int n) {
        return zzdqf.zzge(n);
    }

    public static int zzhj(String string) {
        int n;
        try {
            n = zzdtw.zza(string);
        }
        catch (zzdtz zzdtz2) {
            n = string.getBytes(zzdqx.UTF_8).length;
        }
        int n2 = n;
        return zzdqf.zzgf(n2) + n2;
    }

    public static int zza(zzdrl zzdrl2) {
        int n = zzdrl2.zzazu();
        return zzdqf.zzgf(n) + n;
    }

    public static int zzda(zzdpm zzdpm2) {
        int n = zzdpm2.size();
        return zzdqf.zzgf(n) + n;
    }

    public static int zzab(byte[] byArray) {
        int n = byArray.length;
        return zzdqf.zzgf(n) + n;
    }

    public static int zzk(zzdsg zzdsg2) {
        int n = zzdsg2.zzazu();
        return zzdqf.zzgf(n) + n;
    }

    static int zzb(zzdsg zzdsg2, zzdsv zzdsv2) {
        zzdsv zzdsv3 = zzdsv2;
        zzdpf zzdpf2 = (zzdpf)zzdsg2;
        int n = zzdpf2.zzaxh();
        if (n == -1) {
            n = zzdsv3.zzau(zzdpf2);
            zzdpf2.zzfi(n);
        }
        int n2 = n;
        return zzdqf.zzgf(n2) + n2;
    }

    private static int zzgk(int n) {
        return n << 1 ^ n >> 31;
    }

    private static long zzfi(long l) {
        return l << 1 ^ l >> 63;
    }

    public abstract void flush() throws IOException;

    public abstract int zzayu();

    public final void zzayv() {
        if (this.zzayu() != 0) {
            throw new IllegalStateException("Did not write as much data as expected.");
        }
    }

    abstract void zzk(byte[] var1, int var2, int var3) throws IOException;

    final void zza(String string, zzdtz zzdtz2) throws IOException {
        logger.logp(Level.WARNING, "com.google.protobuf.CodedOutputStream", "inefficientWriteStringNoTag", "Converting ill-formed UTF-16. Your Protocol Buffer will not round trip correctly!", zzdtz2);
        byte[] byArray = string.getBytes(zzdqx.UTF_8);
        try {
            this.zzga(byArray.length);
            this.zzi(byArray, 0, byArray.length);
            return;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new zzd(indexOutOfBoundsException);
        }
        catch (zzd zzd2) {
            throw zzd2;
        }
    }

    @Deprecated
    static int zzc(int n, zzdsg zzdsg2, zzdsv zzdsv2) {
        zzdsv zzdsv3;
        int n2 = zzdqf.zzgd(n) << 1;
        zzdsv zzdsv4 = zzdsv3 = zzdsv2;
        zzdpf zzdpf2 = (zzdpf)zzdsg2;
        int n3 = zzdpf2.zzaxh();
        if (n3 == -1) {
            n3 = zzdsv4.zzau(zzdpf2);
            zzdpf2.zzfi(n3);
        }
        return n2 + n3;
    }

    @Deprecated
    public static int zzl(zzdsg zzdsg2) {
        return zzdsg2.zzazu();
    }

    @Deprecated
    public static int zzgl(int n) {
        return zzdqf.zzgf(n);
    }

    /* synthetic */ zzdqf(zzdqe zzdqe2) {
        this();
    }

    static final class zze
    extends zzdqf {
        private final ByteBuffer zzhhb;
        private final ByteBuffer zzakm;
        private final long zzhhc;
        private final long zzhhd;
        private final long zzhhe;
        private final long zzhhf;
        private long zzamq;

        zze(ByteBuffer byteBuffer) {
            super(null);
            this.zzhhb = byteBuffer;
            this.zzakm = byteBuffer.duplicate().order(ByteOrder.LITTLE_ENDIAN);
            this.zzhhc = zzdtt.zzn(byteBuffer);
            this.zzhhd = this.zzhhc + (long)byteBuffer.position();
            this.zzhhe = this.zzhhc + (long)byteBuffer.limit();
            this.zzhhf = this.zzhhe - 10L;
            this.zzamq = this.zzhhd;
        }

        @Override
        public final void zzz(int n, int n2) throws IOException {
            int n3 = n2;
            ((zzdqf)this).zzga(n << 3 | n3);
        }

        @Override
        public final void zzaa(int n, int n2) throws IOException {
            ((zzdqf)this).zzz(n, 0);
            ((zzdqf)this).zzfz(n2);
        }

        @Override
        public final void zzab(int n, int n2) throws IOException {
            ((zzdqf)this).zzz(n, 0);
            ((zzdqf)this).zzga(n2);
        }

        @Override
        public final void zzad(int n, int n2) throws IOException {
            ((zzdqf)this).zzz(n, 5);
            ((zzdqf)this).zzgc(n2);
        }

        @Override
        public final void zzg(int n, long l) throws IOException {
            ((zzdqf)this).zzz(n, 0);
            ((zzdqf)this).zzfa(l);
        }

        @Override
        public final void zzi(int n, long l) throws IOException {
            ((zzdqf)this).zzz(n, 1);
            ((zzdqf)this).zzfc(l);
        }

        @Override
        public final void zzg(int n, boolean bl) throws IOException {
            ((zzdqf)this).zzz(n, 0);
            ((zzdqf)this).zzd((byte)(bl ? 1 : 0));
        }

        @Override
        public final void zzg(int n, String string) throws IOException {
            ((zzdqf)this).zzz(n, 2);
            ((zzdqf)this).zzhi(string);
        }

        @Override
        public final void zza(int n, zzdpm zzdpm2) throws IOException {
            ((zzdqf)this).zzz(n, 2);
            ((zzdqf)this).zzcz(zzdpm2);
        }

        @Override
        public final void zza(int n, zzdsg zzdsg2) throws IOException {
            ((zzdqf)this).zzz(n, 2);
            ((zzdqf)this).zzj(zzdsg2);
        }

        @Override
        final void zza(int n, zzdsg zzdsg2, zzdsv zzdsv2) throws IOException {
            ((zzdqf)this).zzz(n, 2);
            ((zzdqf)this).zza(zzdsg2, zzdsv2);
        }

        @Override
        public final void zzb(int n, zzdsg zzdsg2) throws IOException {
            ((zzdqf)this).zzz(1, 3);
            ((zzdqf)this).zzab(2, n);
            ((zzdqf)this).zza(3, zzdsg2);
            ((zzdqf)this).zzz(1, 4);
        }

        @Override
        public final void zzb(int n, zzdpm zzdpm2) throws IOException {
            ((zzdqf)this).zzz(1, 3);
            ((zzdqf)this).zzab(2, n);
            ((zzdqf)this).zza(3, zzdpm2);
            ((zzdqf)this).zzz(1, 4);
        }

        @Override
        public final void zzj(zzdsg zzdsg2) throws IOException {
            ((zzdqf)this).zzga(zzdsg2.zzazu());
            zzdsg2.zzb(this);
        }

        @Override
        final void zza(zzdsg zzdsg2, zzdsv zzdsv2) throws IOException {
            zzdsv zzdsv3 = zzdsv2;
            zzdpf zzdpf2 = (zzdpf)zzdsg2;
            int n = zzdpf2.zzaxh();
            if (n == -1) {
                n = zzdsv3.zzau(zzdpf2);
                zzdpf2.zzfi(n);
            }
            ((zzdqf)this).zzga(n);
            zzdsv2.zza(zzdsg2, this.zzhgy);
        }

        @Override
        public final void zzd(byte by) throws IOException {
            if (this.zzamq >= this.zzhhe) {
                throw new zzd(String.format("Pos: %d, limit: %d, len: %d", this.zzamq, this.zzhhe, 1));
            }
            zzdtt.zza(this.zzamq++, by);
        }

        @Override
        public final void zzcz(zzdpm zzdpm2) throws IOException {
            ((zzdqf)this).zzga(zzdpm2.size());
            zzdpm2.zza(this);
        }

        @Override
        public final void zzk(byte[] byArray, int n, int n2) throws IOException {
            ((zzdqf)this).zzga(n2);
            ((zzdqf)this).write(byArray, 0, n2);
        }

        @Override
        public final void zzfz(int n) throws IOException {
            if (n >= 0) {
                ((zzdqf)this).zzga(n);
                return;
            }
            ((zzdqf)this).zzfa(n);
        }

        @Override
        public final void zzga(int n) throws IOException {
            if (this.zzamq <= this.zzhhf) {
                while (true) {
                    if ((n & 0xFFFFFF80) == 0) {
                        zzdtt.zza(this.zzamq++, (byte)n);
                        return;
                    }
                    zzdtt.zza(this.zzamq++, (byte)(n & 0x7F | 0x80));
                    n >>>= 7;
                }
            }
            while (this.zzamq < this.zzhhe) {
                if ((n & 0xFFFFFF80) == 0) {
                    zzdtt.zza(this.zzamq++, (byte)n);
                    return;
                }
                zzdtt.zza(this.zzamq++, (byte)(n & 0x7F | 0x80));
                n >>>= 7;
            }
            throw new zzd(String.format("Pos: %d, limit: %d, len: %d", this.zzamq, this.zzhhe, 1));
        }

        @Override
        public final void zzgc(int n) throws IOException {
            long l = this.zzamq;
            zze zze2 = this;
            this.zzakm.putInt((int)(l - zze2.zzhhc), n);
            this.zzamq += 4L;
        }

        @Override
        public final void zzfa(long l) throws IOException {
            if (this.zzamq <= this.zzhhf) {
                while (true) {
                    if ((l & 0xFFFFFFFFFFFFFF80L) == 0L) {
                        zzdtt.zza(this.zzamq++, (byte)l);
                        return;
                    }
                    zzdtt.zza(this.zzamq++, (byte)((int)l & 0x7F | 0x80));
                    l >>>= 7;
                }
            }
            while (this.zzamq < this.zzhhe) {
                if ((l & 0xFFFFFFFFFFFFFF80L) == 0L) {
                    zzdtt.zza(this.zzamq++, (byte)l);
                    return;
                }
                zzdtt.zza(this.zzamq++, (byte)((int)l & 0x7F | 0x80));
                l >>>= 7;
            }
            throw new zzd(String.format("Pos: %d, limit: %d, len: %d", this.zzamq, this.zzhhe, 1));
        }

        @Override
        public final void zzfc(long l) throws IOException {
            long l2 = this.zzamq;
            zze zze2 = this;
            this.zzakm.putLong((int)(l2 - zze2.zzhhc), l);
            this.zzamq += 8L;
        }

        @Override
        public final void write(byte[] byArray, int n, int n2) throws IOException {
            if (byArray == null || n < 0 || n2 < 0 || byArray.length - n2 < n || this.zzhhe - (long)n2 < this.zzamq) {
                if (byArray == null) {
                    throw new NullPointerException("value");
                }
                throw new zzd(String.format("Pos: %d, limit: %d, len: %d", this.zzamq, this.zzhhe, n2));
            }
            zzdtt.zza(byArray, n, this.zzamq, n2);
            this.zzamq += (long)n2;
        }

        @Override
        public final void zzi(byte[] byArray, int n, int n2) throws IOException {
            ((zzdqf)this).write(byArray, n, n2);
        }

        @Override
        public final void zzhi(String string) throws IOException {
            long l = this.zzamq;
            try {
                int n = zze.zzgf(string.length() * 3);
                int n2 = zze.zzgf(string.length());
                if (n2 == n) {
                    long l2 = this.zzamq;
                    zze zze2 = this;
                    int n3 = (int)(l2 - zze2.zzhhc) + n2;
                    this.zzakm.position(n3);
                    zzdtw.zza(string, this.zzakm);
                    int n4 = this.zzakm.position() - n3;
                    ((zzdqf)this).zzga(n4);
                    this.zzamq += (long)n4;
                    return;
                }
                int n5 = zzdtw.zza(string);
                ((zzdqf)this).zzga(n5);
                this.zzfj(this.zzamq);
                zzdtw.zza(string, this.zzakm);
                this.zzamq += (long)n5;
                return;
            }
            catch (zzdtz zzdtz2) {
                this.zzamq = l;
                this.zzfj(this.zzamq);
                this.zza(string, zzdtz2);
                return;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new zzd(illegalArgumentException);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new zzd(indexOutOfBoundsException);
            }
        }

        @Override
        public final void flush() {
            long l = this.zzamq;
            zze zze2 = this;
            this.zzhhb.position((int)(l - zze2.zzhhc));
        }

        @Override
        public final int zzayu() {
            return (int)(this.zzhhe - this.zzamq);
        }

        private final void zzfj(long l) {
            long l2 = l;
            zze zze2 = this;
            this.zzakm.position((int)(l2 - zze2.zzhhc));
        }
    }

    static final class zzc
    extends zzdqf {
        private final ByteBuffer zzhhb;
        private final ByteBuffer zzakm;
        private final int zzhha;

        zzc(ByteBuffer byteBuffer) {
            super(null);
            this.zzhhb = byteBuffer;
            this.zzakm = byteBuffer.duplicate().order(ByteOrder.LITTLE_ENDIAN);
            this.zzhha = byteBuffer.position();
        }

        @Override
        public final void zzz(int n, int n2) throws IOException {
            int n3 = n2;
            ((zzdqf)this).zzga(n << 3 | n3);
        }

        @Override
        public final void zzaa(int n, int n2) throws IOException {
            ((zzdqf)this).zzz(n, 0);
            ((zzdqf)this).zzfz(n2);
        }

        @Override
        public final void zzab(int n, int n2) throws IOException {
            ((zzdqf)this).zzz(n, 0);
            ((zzdqf)this).zzga(n2);
        }

        @Override
        public final void zzad(int n, int n2) throws IOException {
            ((zzdqf)this).zzz(n, 5);
            ((zzdqf)this).zzgc(n2);
        }

        @Override
        public final void zzg(int n, long l) throws IOException {
            ((zzdqf)this).zzz(n, 0);
            ((zzdqf)this).zzfa(l);
        }

        @Override
        public final void zzi(int n, long l) throws IOException {
            ((zzdqf)this).zzz(n, 1);
            ((zzdqf)this).zzfc(l);
        }

        @Override
        public final void zzg(int n, boolean bl) throws IOException {
            ((zzdqf)this).zzz(n, 0);
            ((zzdqf)this).zzd((byte)(bl ? 1 : 0));
        }

        @Override
        public final void zzg(int n, String string) throws IOException {
            ((zzdqf)this).zzz(n, 2);
            ((zzdqf)this).zzhi(string);
        }

        @Override
        public final void zza(int n, zzdpm zzdpm2) throws IOException {
            ((zzdqf)this).zzz(n, 2);
            ((zzdqf)this).zzcz(zzdpm2);
        }

        @Override
        public final void zza(int n, zzdsg zzdsg2) throws IOException {
            ((zzdqf)this).zzz(n, 2);
            ((zzdqf)this).zzj(zzdsg2);
        }

        @Override
        final void zza(int n, zzdsg zzdsg2, zzdsv zzdsv2) throws IOException {
            ((zzdqf)this).zzz(n, 2);
            ((zzdqf)this).zza(zzdsg2, zzdsv2);
        }

        @Override
        public final void zzb(int n, zzdsg zzdsg2) throws IOException {
            ((zzdqf)this).zzz(1, 3);
            ((zzdqf)this).zzab(2, n);
            ((zzdqf)this).zza(3, zzdsg2);
            ((zzdqf)this).zzz(1, 4);
        }

        @Override
        public final void zzb(int n, zzdpm zzdpm2) throws IOException {
            ((zzdqf)this).zzz(1, 3);
            ((zzdqf)this).zzab(2, n);
            ((zzdqf)this).zza(3, zzdpm2);
            ((zzdqf)this).zzz(1, 4);
        }

        @Override
        public final void zzj(zzdsg zzdsg2) throws IOException {
            ((zzdqf)this).zzga(zzdsg2.zzazu());
            zzdsg2.zzb(this);
        }

        @Override
        final void zza(zzdsg zzdsg2, zzdsv zzdsv2) throws IOException {
            zzdsv zzdsv3 = zzdsv2;
            zzdpf zzdpf2 = (zzdpf)zzdsg2;
            int n = zzdpf2.zzaxh();
            if (n == -1) {
                n = zzdsv3.zzau(zzdpf2);
                zzdpf2.zzfi(n);
            }
            ((zzdqf)this).zzga(n);
            zzdsv2.zza(zzdsg2, this.zzhgy);
        }

        @Override
        public final void zzd(byte by) throws IOException {
            try {
                this.zzakm.put(by);
                return;
            }
            catch (BufferOverflowException bufferOverflowException) {
                throw new zzd(bufferOverflowException);
            }
        }

        @Override
        public final void zzcz(zzdpm zzdpm2) throws IOException {
            ((zzdqf)this).zzga(zzdpm2.size());
            zzdpm2.zza(this);
        }

        @Override
        public final void zzk(byte[] byArray, int n, int n2) throws IOException {
            ((zzdqf)this).zzga(n2);
            ((zzdqf)this).write(byArray, 0, n2);
        }

        @Override
        public final void zzfz(int n) throws IOException {
            if (n >= 0) {
                ((zzdqf)this).zzga(n);
                return;
            }
            ((zzdqf)this).zzfa(n);
        }

        @Override
        public final void zzga(int n) throws IOException {
            try {
                while (true) {
                    if ((n & 0xFFFFFF80) == 0) {
                        this.zzakm.put((byte)n);
                        return;
                    }
                    this.zzakm.put((byte)(n & 0x7F | 0x80));
                    n >>>= 7;
                }
            }
            catch (BufferOverflowException bufferOverflowException) {
                throw new zzd(bufferOverflowException);
            }
        }

        @Override
        public final void zzgc(int n) throws IOException {
            try {
                this.zzakm.putInt(n);
                return;
            }
            catch (BufferOverflowException bufferOverflowException) {
                throw new zzd(bufferOverflowException);
            }
        }

        @Override
        public final void zzfa(long l) throws IOException {
            try {
                while (true) {
                    if ((l & 0xFFFFFFFFFFFFFF80L) == 0L) {
                        this.zzakm.put((byte)l);
                        return;
                    }
                    this.zzakm.put((byte)((int)l & 0x7F | 0x80));
                    l >>>= 7;
                }
            }
            catch (BufferOverflowException bufferOverflowException) {
                throw new zzd(bufferOverflowException);
            }
        }

        @Override
        public final void zzfc(long l) throws IOException {
            try {
                this.zzakm.putLong(l);
                return;
            }
            catch (BufferOverflowException bufferOverflowException) {
                throw new zzd(bufferOverflowException);
            }
        }

        @Override
        public final void write(byte[] byArray, int n, int n2) throws IOException {
            try {
                this.zzakm.put(byArray, n, n2);
                return;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new zzd(indexOutOfBoundsException);
            }
            catch (BufferOverflowException bufferOverflowException) {
                throw new zzd(bufferOverflowException);
            }
        }

        @Override
        public final void zzi(byte[] byArray, int n, int n2) throws IOException {
            ((zzdqf)this).write(byArray, n, n2);
        }

        @Override
        public final void zzhi(String string) throws IOException {
            int n = this.zzakm.position();
            try {
                int n2 = zzc.zzgf(string.length() * 3);
                int n3 = zzc.zzgf(string.length());
                if (n3 == n2) {
                    int n4 = this.zzakm.position() + n3;
                    this.zzakm.position(n4);
                    this.zzhk(string);
                    int n5 = this.zzakm.position();
                    this.zzakm.position(n);
                    ((zzdqf)this).zzga(n5 - n4);
                    this.zzakm.position(n5);
                    return;
                }
                int n6 = zzdtw.zza(string);
                ((zzdqf)this).zzga(n6);
                this.zzhk(string);
                return;
            }
            catch (zzdtz zzdtz2) {
                this.zzakm.position(n);
                this.zza(string, zzdtz2);
                return;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new zzd(illegalArgumentException);
            }
        }

        @Override
        public final void flush() {
            this.zzhhb.position(this.zzakm.position());
        }

        @Override
        public final int zzayu() {
            return this.zzakm.remaining();
        }

        private final void zzhk(String string) throws IOException {
            try {
                zzdtw.zza(string, this.zzakm);
                return;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new zzd(indexOutOfBoundsException);
            }
        }
    }

    static final class zza
    extends zzb {
        private final ByteBuffer zzhgz;
        private int zzhha;

        zza(ByteBuffer byteBuffer) {
            super(byteBuffer.array(), byteBuffer.arrayOffset() + byteBuffer.position(), byteBuffer.remaining());
            this.zzhgz = byteBuffer;
            this.zzhha = byteBuffer.position();
        }

        @Override
        public final void flush() {
            this.zzhgz.position(this.zzhha + this.zzayx());
        }
    }

    static class zzb
    extends zzdqf {
        private final byte[] buffer;
        private final int offset;
        private final int limit;
        private int position;

        zzb(byte[] byArray, int n, int n2) {
            super(null);
            if (byArray == null) {
                throw new NullPointerException("buffer");
            }
            if ((n | n2 | byArray.length - (n + n2)) < 0) {
                throw new IllegalArgumentException(String.format("Array range is invalid. Buffer.length=%d, offset=%d, length=%d", byArray.length, n, n2));
            }
            this.buffer = byArray;
            this.offset = n;
            this.position = n;
            this.limit = n + n2;
        }

        @Override
        public final void zzz(int n, int n2) throws IOException {
            int n3 = n2;
            ((zzdqf)this).zzga(n << 3 | n3);
        }

        @Override
        public final void zzaa(int n, int n2) throws IOException {
            ((zzdqf)this).zzz(n, 0);
            ((zzdqf)this).zzfz(n2);
        }

        @Override
        public final void zzab(int n, int n2) throws IOException {
            ((zzdqf)this).zzz(n, 0);
            ((zzdqf)this).zzga(n2);
        }

        @Override
        public final void zzad(int n, int n2) throws IOException {
            ((zzdqf)this).zzz(n, 5);
            ((zzdqf)this).zzgc(n2);
        }

        @Override
        public final void zzg(int n, long l) throws IOException {
            ((zzdqf)this).zzz(n, 0);
            ((zzdqf)this).zzfa(l);
        }

        @Override
        public final void zzi(int n, long l) throws IOException {
            ((zzdqf)this).zzz(n, 1);
            ((zzdqf)this).zzfc(l);
        }

        @Override
        public final void zzg(int n, boolean bl) throws IOException {
            ((zzdqf)this).zzz(n, 0);
            ((zzdqf)this).zzd((byte)(bl ? 1 : 0));
        }

        @Override
        public final void zzg(int n, String string) throws IOException {
            ((zzdqf)this).zzz(n, 2);
            ((zzdqf)this).zzhi(string);
        }

        @Override
        public final void zza(int n, zzdpm zzdpm2) throws IOException {
            ((zzdqf)this).zzz(n, 2);
            ((zzdqf)this).zzcz(zzdpm2);
        }

        @Override
        public final void zzcz(zzdpm zzdpm2) throws IOException {
            ((zzdqf)this).zzga(zzdpm2.size());
            zzdpm2.zza(this);
        }

        @Override
        public final void zzk(byte[] byArray, int n, int n2) throws IOException {
            ((zzdqf)this).zzga(n2);
            ((zzdqf)this).write(byArray, 0, n2);
        }

        @Override
        public final void zza(int n, zzdsg zzdsg2) throws IOException {
            ((zzdqf)this).zzz(n, 2);
            ((zzdqf)this).zzj(zzdsg2);
        }

        @Override
        final void zza(int n, zzdsg zzdsg2, zzdsv zzdsv2) throws IOException {
            ((zzdqf)this).zzz(n, 2);
            zzdsv zzdsv3 = zzdsv2;
            zzdpf zzdpf2 = (zzdpf)zzdsg2;
            int n2 = zzdpf2.zzaxh();
            if (n2 == -1) {
                n2 = zzdsv3.zzau(zzdpf2);
                zzdpf2.zzfi(n2);
            }
            ((zzdqf)this).zzga(n2);
            zzdsv2.zza(zzdsg2, this.zzhgy);
        }

        @Override
        public final void zzb(int n, zzdsg zzdsg2) throws IOException {
            ((zzdqf)this).zzz(1, 3);
            ((zzdqf)this).zzab(2, n);
            ((zzdqf)this).zza(3, zzdsg2);
            ((zzdqf)this).zzz(1, 4);
        }

        @Override
        public final void zzb(int n, zzdpm zzdpm2) throws IOException {
            ((zzdqf)this).zzz(1, 3);
            ((zzdqf)this).zzab(2, n);
            ((zzdqf)this).zza(3, zzdpm2);
            ((zzdqf)this).zzz(1, 4);
        }

        @Override
        public final void zzj(zzdsg zzdsg2) throws IOException {
            ((zzdqf)this).zzga(zzdsg2.zzazu());
            zzdsg2.zzb(this);
        }

        @Override
        final void zza(zzdsg zzdsg2, zzdsv zzdsv2) throws IOException {
            zzdsv zzdsv3 = zzdsv2;
            zzdpf zzdpf2 = (zzdpf)zzdsg2;
            int n = zzdpf2.zzaxh();
            if (n == -1) {
                n = zzdsv3.zzau(zzdpf2);
                zzdpf2.zzfi(n);
            }
            ((zzdqf)this).zzga(n);
            zzdsv2.zza(zzdsg2, this.zzhgy);
        }

        @Override
        public final void zzd(byte by) throws IOException {
            try {
                this.buffer[this.position++] = by;
                return;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new zzd(String.format("Pos: %d, limit: %d, len: %d", this.position, this.limit, 1), indexOutOfBoundsException);
            }
        }

        @Override
        public final void zzfz(int n) throws IOException {
            if (n >= 0) {
                ((zzdqf)this).zzga(n);
                return;
            }
            ((zzdqf)this).zzfa(n);
        }

        @Override
        public final void zzga(int n) throws IOException {
            if (zzhgx && !zzdpj.zzaxl() && ((zzdqf)this).zzayu() >= 5) {
                if ((n & 0xFFFFFF80) == 0) {
                    zzdtt.zza(this.buffer, (long)this.position++, (byte)n);
                    return;
                }
                zzdtt.zza(this.buffer, (long)this.position++, (byte)(n | 0x80));
                if (((n >>>= 7) & 0xFFFFFF80) == 0) {
                    zzdtt.zza(this.buffer, (long)this.position++, (byte)n);
                    return;
                }
                zzdtt.zza(this.buffer, (long)this.position++, (byte)(n | 0x80));
                if (((n >>>= 7) & 0xFFFFFF80) == 0) {
                    zzdtt.zza(this.buffer, (long)this.position++, (byte)n);
                    return;
                }
                zzdtt.zza(this.buffer, (long)this.position++, (byte)(n | 0x80));
                if (((n >>>= 7) & 0xFFFFFF80) == 0) {
                    zzdtt.zza(this.buffer, (long)this.position++, (byte)n);
                    return;
                }
                zzdtt.zza(this.buffer, (long)this.position++, (byte)(n | 0x80));
                zzdtt.zza(this.buffer, (long)this.position++, (byte)(n >>>= 7));
                return;
            }
            try {
                while (true) {
                    if ((n & 0xFFFFFF80) == 0) {
                        this.buffer[this.position++] = (byte)n;
                        return;
                    }
                    this.buffer[this.position++] = (byte)(n & 0x7F | 0x80);
                    n >>>= 7;
                }
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new zzd(String.format("Pos: %d, limit: %d, len: %d", this.position, this.limit, 1), indexOutOfBoundsException);
            }
        }

        @Override
        public final void zzgc(int n) throws IOException {
            try {
                this.buffer[this.position++] = (byte)n;
                this.buffer[this.position++] = (byte)(n >> 8);
                this.buffer[this.position++] = (byte)(n >> 16);
                this.buffer[this.position++] = (byte)(n >>> 24);
                return;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new zzd(String.format("Pos: %d, limit: %d, len: %d", this.position, this.limit, 1), indexOutOfBoundsException);
            }
        }

        @Override
        public final void zzfa(long l) throws IOException {
            if (zzhgx && ((zzdqf)this).zzayu() >= 10) {
                while (true) {
                    if ((l & 0xFFFFFFFFFFFFFF80L) == 0L) {
                        zzdtt.zza(this.buffer, (long)this.position++, (byte)l);
                        return;
                    }
                    zzdtt.zza(this.buffer, (long)this.position++, (byte)((int)l & 0x7F | 0x80));
                    l >>>= 7;
                }
            }
            try {
                while (true) {
                    if ((l & 0xFFFFFFFFFFFFFF80L) == 0L) {
                        this.buffer[this.position++] = (byte)l;
                        return;
                    }
                    this.buffer[this.position++] = (byte)((int)l & 0x7F | 0x80);
                    l >>>= 7;
                }
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new zzd(String.format("Pos: %d, limit: %d, len: %d", this.position, this.limit, 1), indexOutOfBoundsException);
            }
        }

        @Override
        public final void zzfc(long l) throws IOException {
            try {
                this.buffer[this.position++] = (byte)l;
                this.buffer[this.position++] = (byte)(l >> 8);
                this.buffer[this.position++] = (byte)(l >> 16);
                this.buffer[this.position++] = (byte)(l >> 24);
                this.buffer[this.position++] = (byte)(l >> 32);
                this.buffer[this.position++] = (byte)(l >> 40);
                this.buffer[this.position++] = (byte)(l >> 48);
                this.buffer[this.position++] = (byte)(l >> 56);
                return;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new zzd(String.format("Pos: %d, limit: %d, len: %d", this.position, this.limit, 1), indexOutOfBoundsException);
            }
        }

        @Override
        public final void write(byte[] byArray, int n, int n2) throws IOException {
            try {
                System.arraycopy(byArray, n, this.buffer, this.position, n2);
                this.position += n2;
                return;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new zzd(String.format("Pos: %d, limit: %d, len: %d", this.position, this.limit, n2), indexOutOfBoundsException);
            }
        }

        @Override
        public final void zzi(byte[] byArray, int n, int n2) throws IOException {
            ((zzdqf)this).write(byArray, n, n2);
        }

        @Override
        public final void zzhi(String string) throws IOException {
            int n = this.position;
            try {
                int n2 = zzb.zzgf(string.length() * 3);
                int n3 = zzb.zzgf(string.length());
                if (n3 == n2) {
                    this.position = n + n3;
                    int n4 = zzdtw.zza(string, this.buffer, this.position, ((zzdqf)this).zzayu());
                    this.position = n;
                    int n5 = n4 - n - n3;
                    ((zzdqf)this).zzga(n5);
                    this.position = n4;
                    return;
                }
                int n6 = zzdtw.zza(string);
                ((zzdqf)this).zzga(n6);
                this.position = zzdtw.zza(string, this.buffer, this.position, ((zzdqf)this).zzayu());
                return;
            }
            catch (zzdtz zzdtz2) {
                this.position = n;
                this.zza(string, zzdtz2);
                return;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new zzd(indexOutOfBoundsException);
            }
        }

        @Override
        public void flush() {
        }

        @Override
        public final int zzayu() {
            return this.limit - this.position;
        }

        public final int zzayx() {
            return this.position - this.offset;
        }
    }

    public static final class zzd
    extends IOException {
        zzd() {
            super("CodedOutputStream was writing to a flat byte array and ran out of space.");
        }

        zzd(String string) {
            String string2 = String.valueOf("CodedOutputStream was writing to a flat byte array and ran out of space.: ");
            String string3 = String.valueOf(string);
            super(string3.length() != 0 ? string2.concat(string3) : new String(string2));
        }

        zzd(Throwable throwable) {
            super("CodedOutputStream was writing to a flat byte array and ran out of space.", throwable);
        }

        zzd(String string, Throwable throwable) {
            String string2 = String.valueOf("CodedOutputStream was writing to a flat byte array and ran out of space.: ");
            String string3 = String.valueOf(string);
            super(string3.length() != 0 ? string2.concat(string3) : new String(string2), throwable);
        }
    }
}

