/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import com.google.android.gms.internal.ads.zzdpg;
import com.google.android.gms.internal.ads.zzdqx;
import com.google.android.gms.internal.ads.zzdrb;
import com.google.android.gms.internal.ads.zzdrd;
import com.google.android.gms.internal.ads.zzdss;
import java.util.Arrays;
import java.util.Collection;
import java.util.RandomAccess;

final class zzdqy
extends zzdpg<Integer>
implements zzdrb,
zzdss,
RandomAccess {
    private static final zzdqy zzhlm = new zzdqy(new int[0], 0);
    private int[] zzhln;
    private int size;

    public static zzdqy zzbab() {
        return zzhlm;
    }

    zzdqy() {
        this(new int[10], 0);
    }

    private zzdqy(int[] nArray, int n) {
        this.zzhln = nArray;
        this.size = n;
    }

    @Override
    protected final void removeRange(int n, int n2) {
        this.zzaxk();
        if (n2 < n) {
            throw new IndexOutOfBoundsException("toIndex < fromIndex");
        }
        System.arraycopy(this.zzhln, n2, this.zzhln, n, this.size - n2);
        this.size -= n2 - n;
        ++this.modCount;
    }

    @Override
    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof zzdqy)) {
            return super.equals(object);
        }
        zzdqy zzdqy2 = (zzdqy)object;
        if (this.size != zzdqy2.size) {
            return false;
        }
        int[] nArray = zzdqy2.zzhln;
        for (int i = 0; i < this.size; ++i) {
            if (this.zzhln[i] == nArray[i]) continue;
            return false;
        }
        return true;
    }

    @Override
    public final int hashCode() {
        int n = 1;
        for (int i = 0; i < this.size; ++i) {
            n = n * 31 + this.zzhln[i];
        }
        return n;
    }

    @Override
    public final zzdrb zzgo(int n) {
        if (n < this.size) {
            throw new IllegalArgumentException();
        }
        return new zzdqy(Arrays.copyOf(this.zzhln, n), this.size);
    }

    public final int getInt(int n) {
        this.zzfj(n);
        return this.zzhln[n];
    }

    @Override
    public final int size() {
        return this.size;
    }

    @Override
    public final void zzgp(int n) {
        this.zzaxk();
        if (this.size == this.zzhln.length) {
            int[] nArray = new int[this.size * 3 / 2 + 1];
            System.arraycopy(this.zzhln, 0, nArray, 0, this.size);
            this.zzhln = nArray;
        }
        this.zzhln[this.size++] = n;
    }

    @Override
    public final boolean addAll(Collection<? extends Integer> collection) {
        this.zzaxk();
        zzdqx.checkNotNull(collection);
        if (!(collection instanceof zzdqy)) {
            return super.addAll(collection);
        }
        zzdqy zzdqy2 = (zzdqy)collection;
        if (zzdqy2.size == 0) {
            return false;
        }
        if (Integer.MAX_VALUE - this.size < zzdqy2.size) {
            throw new OutOfMemoryError();
        }
        int n = this.size + zzdqy2.size;
        if (n > this.zzhln.length) {
            this.zzhln = Arrays.copyOf(this.zzhln, n);
        }
        System.arraycopy(zzdqy2.zzhln, 0, this.zzhln, this.size, zzdqy2.size);
        this.size = n;
        ++this.modCount;
        return true;
    }

    @Override
    public final boolean remove(Object object) {
        this.zzaxk();
        for (int i = 0; i < this.size; ++i) {
            if (!object.equals(this.zzhln[i])) continue;
            System.arraycopy(this.zzhln, i + 1, this.zzhln, i, this.size - i - 1);
            --this.size;
            ++this.modCount;
            return true;
        }
        return false;
    }

    private final void zzfj(int n) {
        if (n < 0 || n >= this.size) {
            throw new IndexOutOfBoundsException(this.zzfk(n));
        }
    }

    private final String zzfk(int n) {
        int n2 = this.size;
        return new StringBuilder(35).append("Index:").append(n).append(", Size:").append(n2).toString();
    }

    @Override
    public final /* synthetic */ Object set(int n, Object object) {
        Integer n2 = (Integer)object;
        int n3 = n2;
        zzdqy zzdqy2 = this;
        zzdqy2.zzaxk();
        zzdqy2.zzfj(n);
        int n4 = zzdqy2.zzhln[n];
        zzdqy2.zzhln[n] = n3;
        return n4;
    }

    @Override
    public final /* synthetic */ Object remove(int n) {
        zzdqy zzdqy2 = this;
        zzdqy2.zzaxk();
        zzdqy2.zzfj(n);
        int n2 = zzdqy2.zzhln[n];
        if (n < zzdqy2.size - 1) {
            System.arraycopy(zzdqy2.zzhln, n + 1, zzdqy2.zzhln, n, zzdqy2.size - n - 1);
        }
        --zzdqy2.size;
        ++zzdqy2.modCount;
        return n2;
    }

    @Override
    public final /* synthetic */ void add(int n, Object object) {
        Integer n2 = (Integer)object;
        int n3 = n2;
        zzdqy zzdqy2 = this;
        zzdqy2.zzaxk();
        if (n < 0 || n > zzdqy2.size) {
            throw new IndexOutOfBoundsException(zzdqy2.zzfk(n));
        }
        if (zzdqy2.size < zzdqy2.zzhln.length) {
            System.arraycopy(zzdqy2.zzhln, n, zzdqy2.zzhln, n + 1, zzdqy2.size - n);
        } else {
            int[] nArray = new int[zzdqy2.size * 3 / 2 + 1];
            System.arraycopy(zzdqy2.zzhln, 0, nArray, 0, n);
            System.arraycopy(zzdqy2.zzhln, n, nArray, n + 1, zzdqy2.size - n);
            zzdqy2.zzhln = nArray;
        }
        zzdqy2.zzhln[n] = n3;
        ++zzdqy2.size;
        ++zzdqy2.modCount;
    }

    @Override
    public final /* synthetic */ boolean add(Object object) {
        Integer n = (Integer)object;
        this.zzgp(n);
        return true;
    }

    @Override
    public final /* synthetic */ zzdrd zzfl(int n) {
        return this.zzgo(n);
    }

    @Override
    public final /* synthetic */ Object get(int n) {
        return this.getInt(n);
    }

    static {
        zzhlm.zzaxj();
    }
}

