/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import com.google.android.gms.internal.ads.zzdpg;
import com.google.android.gms.internal.ads.zzdqx;
import com.google.android.gms.internal.ads.zzdrd;
import com.google.android.gms.internal.ads.zzdss;
import java.util.Arrays;
import java.util.Collection;
import java.util.RandomAccess;

final class zzdru
extends zzdpg<Long>
implements zzdrd<Long>,
zzdss,
RandomAccess {
    private static final zzdru zzhmq = new zzdru(new long[0], 0);
    private long[] zzhmr;
    private int size;

    zzdru() {
        this(new long[10], 0);
    }

    private zzdru(long[] lArray, int n) {
        this.zzhmr = lArray;
        this.size = n;
    }

    @Override
    protected final void removeRange(int n, int n2) {
        this.zzaxk();
        if (n2 < n) {
            throw new IndexOutOfBoundsException("toIndex < fromIndex");
        }
        System.arraycopy(this.zzhmr, n2, this.zzhmr, n, this.size - n2);
        this.size -= n2 - n;
        ++this.modCount;
    }

    @Override
    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof zzdru)) {
            return super.equals(object);
        }
        zzdru zzdru2 = (zzdru)object;
        if (this.size != zzdru2.size) {
            return false;
        }
        long[] lArray = zzdru2.zzhmr;
        for (int i = 0; i < this.size; ++i) {
            if (this.zzhmr[i] == lArray[i]) continue;
            return false;
        }
        return true;
    }

    @Override
    public final int hashCode() {
        int n = 1;
        for (int i = 0; i < this.size; ++i) {
            n = n * 31 + zzdqx.zzfk(this.zzhmr[i]);
        }
        return n;
    }

    public final long getLong(int n) {
        this.zzfj(n);
        return this.zzhmr[n];
    }

    @Override
    public final int size() {
        return this.size;
    }

    public final void zzfl(long l) {
        this.zzaxk();
        if (this.size == this.zzhmr.length) {
            long[] lArray = new long[this.size * 3 / 2 + 1];
            System.arraycopy(this.zzhmr, 0, lArray, 0, this.size);
            this.zzhmr = lArray;
        }
        this.zzhmr[this.size++] = l;
    }

    @Override
    public final boolean addAll(Collection<? extends Long> collection) {
        this.zzaxk();
        zzdqx.checkNotNull(collection);
        if (!(collection instanceof zzdru)) {
            return super.addAll(collection);
        }
        zzdru zzdru2 = (zzdru)collection;
        if (zzdru2.size == 0) {
            return false;
        }
        if (Integer.MAX_VALUE - this.size < zzdru2.size) {
            throw new OutOfMemoryError();
        }
        int n = this.size + zzdru2.size;
        if (n > this.zzhmr.length) {
            this.zzhmr = Arrays.copyOf(this.zzhmr, n);
        }
        System.arraycopy(zzdru2.zzhmr, 0, this.zzhmr, this.size, zzdru2.size);
        this.size = n;
        ++this.modCount;
        return true;
    }

    @Override
    public final boolean remove(Object object) {
        this.zzaxk();
        for (int i = 0; i < this.size; ++i) {
            if (!object.equals(this.zzhmr[i])) continue;
            System.arraycopy(this.zzhmr, i + 1, this.zzhmr, i, this.size - i - 1);
            --this.size;
            ++this.modCount;
            return true;
        }
        return false;
    }

    private final void zzfj(int n) {
        if (n < 0 || n >= this.size) {
            throw new IndexOutOfBoundsException(this.zzfk(n));
        }
    }

    private final String zzfk(int n) {
        int n2 = this.size;
        return new StringBuilder(35).append("Index:").append(n).append(", Size:").append(n2).toString();
    }

    @Override
    public final /* synthetic */ Object set(int n, Object object) {
        Long l = (Long)object;
        long l2 = l;
        zzdru zzdru2 = this;
        zzdru2.zzaxk();
        zzdru2.zzfj(n);
        long l3 = zzdru2.zzhmr[n];
        zzdru2.zzhmr[n] = l2;
        return l3;
    }

    @Override
    public final /* synthetic */ Object remove(int n) {
        zzdru zzdru2 = this;
        zzdru2.zzaxk();
        zzdru2.zzfj(n);
        long l = zzdru2.zzhmr[n];
        if (n < zzdru2.size - 1) {
            System.arraycopy(zzdru2.zzhmr, n + 1, zzdru2.zzhmr, n, zzdru2.size - n - 1);
        }
        --zzdru2.size;
        ++zzdru2.modCount;
        return l;
    }

    @Override
    public final /* synthetic */ void add(int n, Object object) {
        Long l = (Long)object;
        long l2 = l;
        zzdru zzdru2 = this;
        zzdru2.zzaxk();
        if (n < 0 || n > zzdru2.size) {
            throw new IndexOutOfBoundsException(zzdru2.zzfk(n));
        }
        if (zzdru2.size < zzdru2.zzhmr.length) {
            System.arraycopy(zzdru2.zzhmr, n, zzdru2.zzhmr, n + 1, zzdru2.size - n);
        } else {
            long[] lArray = new long[zzdru2.size * 3 / 2 + 1];
            System.arraycopy(zzdru2.zzhmr, 0, lArray, 0, n);
            System.arraycopy(zzdru2.zzhmr, n, lArray, n + 1, zzdru2.size - n);
            zzdru2.zzhmr = lArray;
        }
        zzdru2.zzhmr[n] = l2;
        ++zzdru2.size;
        ++zzdru2.modCount;
    }

    @Override
    public final /* synthetic */ boolean add(Object object) {
        Long l = (Long)object;
        this.zzfl(l);
        return true;
    }

    @Override
    public final /* synthetic */ zzdrd zzfl(int n) {
        int n2 = n;
        zzdru zzdru2 = this;
        if (n2 < zzdru2.size) {
            throw new IllegalArgumentException();
        }
        return new zzdru(Arrays.copyOf(zzdru2.zzhmr, n2), zzdru2.size);
    }

    @Override
    public final /* synthetic */ Object get(int n) {
        return this.getLong(n);
    }

    static {
        zzhmq.zzaxj();
    }
}

